/*----------------------------------------
   EZTEST2.C -- EZFONT Test Program # 2
                (c) Charles Petzold, 1994
  ----------------------------------------*/

#include <windows.h>
#include <string.h>
#include "ezfont.h"

char szClass [] = "EzTest2" ;
char szTitle [] = "EzTest2:  EZFONT Test Program # 2" ;

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     CHAR       szBuffer [64] ;
     HFONT      hFont ;
     INT        y, iDeciPtHeight ;
     TEXTMETRIC tm ;

     SetBkMode (hdc, TRANSPARENT) ;
     SetMapMode (hdc, MM_TWIPS) ;
     SetViewportOrgEx (hdc, 0, cyArea, NULL) ;
     SetTextAlign (hdc, TA_LEFT | TA_BOTTOM) ;

     y = 0 ;

     for (iDeciPtHeight = 120 ; iDeciPtHeight <= 140 ; iDeciPtHeight ++)
          {
          hFont = EzCreateFont (hdc, "Times New Roman Bold",
                                iDeciPtHeight, 0, 0, TRUE) ;

          SelectObject (hdc, hFont) ;

          GetTextMetrics (hdc, &tm) ;

          wsprintf (szBuffer, "This %d.%d point font is %d twips high",
                    iDeciPtHeight / 10, iDeciPtHeight % 10,
                    tm.tmHeight - tm.tmInternalLeading) ;

          TextOut (hdc, 0, y, szBuffer, strlen (szBuffer)) ;

          SelectObject (hdc, GetStockObject (SYSTEM_FONT)) ;
          DeleteObject (hFont) ;

          y += tm.tmHeight - tm.tmInternalLeading ;
          }
     }
