;[]-----------------------------------------------------------------[]
;|      FPINIT.ASM -- Pre/post code for WIN87EM                      |
;[]-----------------------------------------------------------------[]

;  Modifications by Danny Thorpe
;  Copyright (c) 1993 by Danny Thorpe
;  All Rights Reserved.

;  Based on code Copyright (c) 1987, 1992 by Borland International
;  Used with permission

;This module is memory model indepedent

                include RULES.ASI

                extrn GETWINFLAGS:far
                extrn LOADLIBRARY:far
                extrn GETPROCADDRESS:far
                extrn FREELIBRARY:far
                extrn __fperr:far
                extrn __turboFloat
                extrn __turboCvt
                extrn __FPVector:dword
                extrn __LockWIN87EM:word

                public  FIDRQQ          ; wait, esc
                public  FIARQQ          ; wait, DS:
                public  FICRQQ          ; wait, CS:
                public  FIERQQ          ; wait, ES:
                public  FISRQQ          ; wait, SS:
                public  FIWRQQ          ; nop, wait
                public  FJARQQ          ; Esc nn -> DS:nn
                public  FJCRQQ          ; Esc nn -> CS:nn
                public  FJSRQQ          ; Esc nn -> ES:nn

FIDRQQ          equ     05C32h
FIARQQ          equ     0FE32h
FICRQQ          equ     00E32h
FIERQQ          equ     01632h
FISRQQ          equ     00632h
FIWRQQ          equ     0A23Dh
FJARQQ          equ     04000h
FJCRQQ          equ     0C000h
FJSRQQ          equ     08000h

SIGFPE          equ     8
SIG_DFL         equ     0

                public __windowsFloat
__windowsFloat  equ     0

                public  __cvtfak
__cvtfak        equ     0

_DATA           segment
LibName         db  'WIN87EM', 0
LibHandle       dw  0
                ends

_TEXT           segment
                assume cs:_TEXT,ds:DGROUP

__exitfp:
                mov     ax,LibHandle
                or      ax,ax
                jz      Win87NotLoaded
                mov     bx,2                    ; close WIN87EM
                call    dword ptr __FPVector
                mov     ax,LibHandle
                push    ax
                call    FREELIBRARY
Win87NotLoaded:
                ret

__initfp:       call    GETWINFLAGS
                and     dh,080h                 ; Running in Dos protected mode?
                jz      InWindows
                xor     ax,ax                   ; Yes, don't load WIN87EM.DLL
                mov     word ptr __FPVector,ax
                mov     word ptr __FPVector+2,ax
                ret
InWindows:                                      ; Running in Windows,
                push    ds                      ; Load WIN87EM.DLL
                lea     ax, LibName
                push    ax
                call    LOADLIBRARY
                mov     LibHandle, ax           ; no error checking...
                                                ; Get the function addr of FPMATH
                push    ax                      ; Module handle
                xor     ax,ax
                push    ax
                inc     ax                      ; Get function by index, #1
                push    ax
                call    GETPROCADDRESS

                mov     word ptr __FPVector,ax
                mov     word ptr __FPVector+2,dx

                xor     bx,bx                   ; init WIN87EM
                call    dword ptr __FPVector

                mov     bx, 3                   ; set exception handler
                mov     dx, seg    __fperr
                mov     ax, offset __fperr
                call    dword ptr __FPVector
                ret
                ends

_INIT_          segment word public 'INITDATA'
                db      0                       ; near call
                db      1                       ; priority 1
                dw      offset __initfp
                dw      ?
                ends

_EXIT_          segment word public 'EXITDATA'
                db      0                       ; near call
                db      1                       ; priority 1
                dw      offset __exitfp
                dw      ?
                ends

                end
