*****************************************************************
*  Program:  IsDir
*  Purpose:  Determines if parameter DIRNAME is a valid directory
*            name or drive designator.  Similar to FILE().
*  Example:  ? DIR('C:\DOS') or ? DIR('Z:')
*  Systems:  FoxPro, dBASE IV
*****************************************************************
FUNCTION IsDir
PARAMETER dirname
PRIVATE dirname, result

IF .NOT. FILE('.\NUL')
    ? 'DIR() does not work on this PC.'
    RETURN .F.
ENDIF

IF RIGHT(dirname,1) = '\'
    result = FILE(dirname+'NUL')
ELSE
    result = FILE(dirname+'\NUL')
ENDIF
RETURN ( result )
