********************************************************************
* UpdateGet( cGetName, uValue ) or                    Clipper 5.01
* UpdateGet( cGetName )
*
* This function will update the value of a GET currently
* displayed on the screen and redisplay the GET.
*
* cGetName is is the name of the GET to update.  The name
* must be specified exactly as it was when the get was issued.
* For example, if a get is issued as item->quantity and you
* try the statement:
*
*     UpdateGet( "quantity", 5 )
*
* it will fail. In this case, you must specify the complete
* alias as it was specified in the @ GET statement,
* item->quantity. The name specified is NOT case sensitive.
*
* uValue is the new value to place in the get.
*
* Returns .T. if the get was found and the value set,
*  .F. otherwise.
********************************************************************
FUNCTION UpdateGet( cGetName, uValue )
LOCAL oGet, nPos
IF ( nPos := ASCAN( GetList, { | e | UPPER( e:name ) == ;
     UPPER( cGetName ) } ) ) > 0
   oGet := GetList[ nPos ]           // Access the GET object
   IF PCOUNT() > 1
     oGet:VARPUT( uValue )           // Send it the update msg
   ENDIF
   oGet:DISPLAY()                    // Send it the display msg
ENDIF
RETURN ( nPos > 0 )                  // .T. if found, otherwise .F.

********************************************************************
* UpdateGets()                                       Clipper 5.01
* Display the current values of all GETS in GetList
********************************************************************
FUNCTION UpdateGets()
AEVAL( GetList, {|oGet| oGet:DISPLAY() } )
RETURN NIL
