UNIT OString;
(**) INTERFACE (**)
USES WObjects, Strings;
TYPE
  HexStr = ARRAY[0..2] OF Char;
{***- Object Class :  TOString -**************************}
  { Declare TOString }
  POstring = ^TOstring;
  TOstring = OBJECT(TObject)
    vPChar  : Pchar;
    MaxSize : Word;
    CONSTRUCTOR Init(WMaxSize : Word);
    DESTRUCTOR Done; Virtual;
    PROCEDURE AddPChar(P : PChar); Virtual;
    PROCEDURE AddString(S : String); Virtual;
    PROCEDURE AddOString(S : TOString); Virtual;
    PROCEDURE AddInteger(I, FieldSize : Integer);
      Virtual;
    PROCEDURE AddReal(R : Real;  FieldSize, Decimals :
      Integer); Virtual;
    PROCEDURE AddHexByte(B : Byte); Virtual;
    PROCEDURE AddHexWord(W : Word); Virtual;
    PROCEDURE Clear; Virtual;
    FUNCTION Len : Word; Virtual;
    PROCEDURE NewLine; Virtual;
    FUNCTION GetPChar : Pchar; Virtual;
(**) PRIVATE (**)
    FUNCTION Hex(b : Byte; VAR H : HexStr) : PChar;
  END;

(**) IMPLEMENTATION (**)

FUNCTION TOstring.Hex(b : Byte; VAR H : HexStr) : PChar;
CONST
  HexDigit :  Array [0..15] of Char = '0123456789ABCDEF';
BEGIN
  H[0] := HexDigit[b SHR 4];
  H[1] := HexDigit[b AND $0F];
  H[2] := #0;
  Hex  := H;
END;

CONSTRUCTOR TOstring.Init(WMaxSize : Word);
BEGIN
  GetMem(vPChar, WMaxSize+1);
  MaxSize := WMaxSize;
  vPChar[0] := #0; {Put a null at the start of the string}
END;

DESTRUCTOR TOstring.Done;
BEGIN
  FreeMem(vPChar, MaxSize+1);
END;

PROCEDURE TOstring.AddPChar(P : PChar);
BEGIN
  StrLCat(vPChar, P, MaxSize);
END;

PROCEDURE TOstring.AddString(S : String);
VAR P : PChar;
BEGIN
  GetMem(P, 256);
  StrPCopy(P, S);
  AddPChar(P);
  FreeMem(P, 256);
END;

PROCEDURE TOstring.AddOString(S : TOString);
BEGIN
  AddPChar(S.vPChar);
END;

PROCEDURE TOstring.AddInteger(I, FieldSize : Integer);
VAR S : String;
BEGIN
  Str(I:FieldSize, S);
  AddString(S);
END;

PROCEDURE TOstring.AddReal(R : Real;  FieldSize,
  Decimals : Integer);
VAR S : String;
BEGIN
  Str(R:FieldSize:Decimals,S);
  AddString(S);
END;

PROCEDURE TOstring.AddHexByte(B : Byte);
VAR H : HexStr;
BEGIN
  AddPChar(Hex(B, H));
END;

PROCEDURE TOstring.AddHexWord(W : Word);
BEGIN
  AddHexByte(Hi(W));
  AddHexByte(Lo(W));
END;

PROCEDURE TOString.Clear;
BEGIN
  vPChar[0] := #0; {Put a null at the start of the string}
END;

FUNCTION TOstring.Len : Word;
BEGIN
  Len := StrLen(vPChar);
END;

PROCEDURE TOstring.NewLine;
BEGIN
  AddString(#13#10);
END;

FUNCTION TOString.GetPChar : PChar;
BEGIN
  GetPChar := vPChar;
END;

END.
