PROGRAM FileDlg;
USES WinTypes, WinProcs, WObjects, Strings, StdDlgs;
{$R FileDlg}
CONST
  AppName : PChar = 'FileDlg';
  NewOpen : PChar = 'Wow, Like, Open A File, Man!';
  NewSave : PChar = 'Save My File, Please!';
  Cm_1 = 101;
  Cm_2 = 102;
  Cm_3 = 103;
  Cm_4 = 104;
TYPE
  TMyApplication = object(TApplication)
    PROCEDURE InitMainWindow; virtual;
  END;

  PTestWindow = ^TTestWindow;
  TTestWindow = OBJECT(TWindow)
    B : ARRAY[0..144] OF Char;
    CONSTRUCTOR Init(AParent : PWindowsObject; AName : PChar);
    PROCEDURE Cmd1(VAR Msg : TMessage); Virtual cm_First + Cm_1;
    PROCEDURE Cmd2(VAR Msg : TMessage); Virtual cm_First + Cm_2;
    PROCEDURE Cmd3(VAR Msg : TMessage); Virtual cm_First + Cm_3;
    PROCEDURE Cmd4(VAR Msg : TMessage); Virtual cm_First + Cm_4;
  END;

  PNuFileDialog = ^TNuFileDialog;
  TNuFileDialog = OBJECT(TFileDialog)
    CONSTRUCTOR Init(AParent: PWindowsObject; AName, AFilePath,
      ACaption : PChar);
  END;

{--------------------------------------------------}
{ TNuFileDialog's methods                          }
{--------------------------------------------------}
  CONSTRUCTOR TNuFileDialog.Init(AParent: PWindowsObject;
    AName, AFilePath, ACaption : PChar);
  BEGIN
    TFileDialog.Init(AParent, AName, AFilePath);
    Caption := ACaption;
  END;

{--------------------------------------------------}
{ TTestWindow's methods                            }
{--------------------------------------------------}
  CONSTRUCTOR TTestWindow.Init(AParent : PWindowsObject;
    AName : PChar);
  VAR H : hMenu;
  BEGIN
    TWindow.Init(AParent, AName);
    Attr.Menu := LoadMenu(hInstance, AppName);
    StrCopy(B, '*.*');
  END;

  PROCEDURE TTestWindow.Cmd1(VAR Msg : TMessage);
  BEGIN
    Application^.ExecDialog(New(PFileDialog,
      Init(@Self, PChar(sd_FileOpen), B)));
  END;

  PROCEDURE TTestWindow.Cmd2(VAR Msg : TMessage);
  BEGIN
    Application^.ExecDialog(New(PFileDialog,
      Init(@Self, PChar(sd_FileSave), B)));
  END;

  PROCEDURE TTestWindow.Cmd3(VAR Msg : TMessage);
  BEGIN
    Application^.ExecDialog(New(PNuFileDialog,
      Init(@Self, PChar(sd_FileOpen), B, NewOpen)));
  END;

  PROCEDURE TTestWindow.Cmd4(VAR Msg : TMessage);
  BEGIN
    Application^.ExecDialog(New(PNuFileDialog,
      Init(@Self, PChar(sd_FileSave), B, NewSave)));
  END;

{--------------------------------------------------}
{ TMyApplication's method implementations:         }
{--------------------------------------------------}
  PROCEDURE TMyApplication.InitMainWindow;
  BEGIN
    MainWindow := New(PTestWindow, Init(Nil, AppName));
  END;

{--------------------------------------------------}
{ Main program:                                    }
{--------------------------------------------------}
VAR MyApp: TMyApplication;
BEGIN
  MyApp.Init(AppName);
  MyApp.Run;
  MyApp.Done;
END.
