;  COMPR.SC - PAL script to compress current table and reclaim
;  disk space lost to deleted records.

;  Make sure there is a current table
IF NIMAGES() = 0 THEN
    MESSAGE "No table to compress!"
    BEEP SLEEP 5000
    QUIT
ENDIF

;  Complete any pending operation and return to MAIN mode
IF SYSMODE() <> "Main" THEN
    DO_IT!
ENDIF

;  Save size of current table
OldSize = FILESIZE(TABLE()+".DB")

;  Restructure table with no changes to recover disk space
MENU {Modify} {Restructure} SELECT TABLE() TYPEIN TABLE() {DO-IT!}

;  Report on disk space saved by compression
NewSize = FILESIZE(TABLE()+".DB")
MESSAGE STRVAL(OldSize - NewSize) + " bytes saved!"
BEEP SLEEP 5000
