
// WinMode 1.0 for Windows 3.1
// Copyright (c) 1988-92 Finnegan O'Malley & Company Inc.
// All Rights Reserved.
// First Published in PC Magazine, May 12, 1992.

// developed under Microsoft C 5.1

#include <dos.h>
#include <stdio.h>
#include <stdlib.h>

#define INT_MULTIPLEX   0x2F

#define MODE_DOS                        0
#define MODE_DOS_TASK_SWITCHER          1       // TS
#define MODE_WINDOWS_3_XX_STANDARD      2       // TS
#define MODE_WINDOWS_386_2_XX           3       // VM
#define MODE_WINDOWS_X_XX_386_ENHANCED  4       // VM

extern  int             main(int argc, char **argv);

////////////////////////////////////////////////////////

extern  int             main(int argc, char **argv)
{
auto    struct   SREGS  Seg;  // segment registers

static  union    REGS   Reg;  // general registers

if (argc != 1)
    printf("%s 1.0 for Windows 3.1\n"
            "Copyright (c) 1988-92 Finnegan O'Malley"
            " & Company Inc.  All Rights Reserved.\n"
            "First Published in PC Magazine,"
            " May 12, 1992.\n\n", argv[0]);

segread(&Seg);  // initialize the segment registers

Reg.x.ax = 0x1600;      // in 386 Enhanced mode?
int86x(INT_MULTIPLEX, &Reg, &Reg, &Seg);
switch (Reg.h.al)
    {
    case 0x00:  // not in 386 Enhanced mode
    case 0x80:  // not in 386 Enhanced mode
        break;

    case 0x01:  // Windows/386 2.xx is running
    case 0xFF:  // Windows/386 2.xx is running
        printf("Windows/386 2.xx is running (%d)\n",
                MODE_WINDOWS_386_2_XX);
        return  MODE_WINDOWS_386_2_XX;

    default:    // in 386 Enhanced mode, where:
                //  AL: major version (3., 4., ...)
                //  AH: minor version (00, 10, ...)
        printf("Windows %d.%02d is running in 386 Enhanced"
                " mode (%d)\n", Reg.h.al, Reg.h.ah,
                MODE_WINDOWS_X_XX_386_ENHANCED);
        return  MODE_WINDOWS_X_XX_386_ENHANCED;
    }

Reg.x.ax = 0x4680;      // in plain vanilla DOS mode?
int86x(INT_MULTIPLEX, &Reg, &Reg, &Seg);
if (Reg.h.al == 0x80)   // not in DOS Task Switcher,
    {                   //  Real or Standard mode
    printf("Windows is not running, nor is the DOS"
            " Task Switcher (%d)\n",
            MODE_DOS);
    return  MODE_DOS;
    }

if (getenv("windir")    // in Real or Standard mode?
||  getenv("WINDIR"))   // (in case it goes upper case)
    {
    printf("Windows 3.xx is running in Real or Standard"
            " mode (%d)\n",
            MODE_WINDOWS_3_XX_STANDARD);
    return  MODE_WINDOWS_3_XX_STANDARD;
    }

// otherwise, the DOS MS-DOS Shell is running
printf("The DOS Task Switcher is running (%d)\n",
        MODE_DOS_TASK_SWITCHER);
return  MODE_DOS_TASK_SWITCHER;
}

