'FIELD.BAS - demonstrates opening, reading, and writing using FIELD

DECLARE SUB OpenFile (FileName$, RecLen%, Dat$(), FldLen%(), FileNum%)
DECLARE SUB ReadFile (FileNum%, RecordNumber%)
DECLARE SUB WriteFile (FileNum%, RecordNumber%)

CONST Max% = 5                  'we'll use five data fields
FileName$ = "FIELD.DAT"         'this is the file name to open
REDIM Contents$(1 TO Max%)      'this holds the file data contents
REDIM Lengths%(1 TO Max%)       'this holds the field lengths

RecLength% = 0                  'this accumulates the total record length
FOR X% = 1 TO Max%              'read the array of field lengths
  READ Lengths%(X%)
  RecLength% = RecLength% + Lengths%(X%)
NEXT

'----- open the data file and assign some sample data
CALL OpenFile(FileName$, RecLength%, Contents$(), Lengths%(), FileNumber%)
FOR X% = 1 TO Max%
  READ Temp$
  LSET Contents$(X%) = Temp$
NEXT

RecNumber% = 1
CALL WriteFile(FileNumber%, RecNumber%) 'write the data to record number 1
CALL ReadFile(FileNumber%, RecNumber%)  'read the data back again

FOR X% = 1 TO Max%                      'display the data to prove it worked
  PRINT "{"; Contents$(X%); "}"
NEXT

CLOSE #FileNumber%                      'close the file


DATA 20, 25, 17, 20, 2
DATA Tony Smith, Abco Corporation, 2200 Baxter Place, Atlanta, GA

SUB OpenFile (FileName$, RecLen%, Dat$(), FldLen%(), FileNum%) STATIC
  FileNum% = FREEFILE                   'get the next available file number
  OPEN FileName$ FOR RANDOM AS #FileNum% LEN = RecLen%    'open the data file
  NumFields% = UBOUND(FldLen%)          'see how many fields there are
  Pad = 0                               'accumulates the padding needed
  FOR X% = 1 TO NumFields%
    ThisLen% = FldLen%(X%)              'see how long this field is
    FIELD #FileNum%, Pad AS Dummy$, ThisLen% AS Dat$(X%)  'field it
    Pad = Pad + ThisLen%                                  'advance the pad
  NEXT
END SUB

SUB ReadFile (FileNum%, RecordNumber%) STATIC
  GET #FileNum%, RecordNumber%
END SUB

SUB WriteFile (FileNum%, RecordNumber%) STATIC
  PUT #FileNum%, RecordNumber%
END SUB

