//  PCDICT.C    The PCDICT.DLL sample Pen Windows dictionary
//              module is used with DEMO5.EXE to demonstrate
//              validation of user input and input completion
//              by prefix matching.
//  Copyright (C) 1991 Ray Duncan

#define WIN31
#define NOCOMM

#include <windows.h>
#include <penwin.h>
#include <string.h>
#include "pcdict.h"

#define cbMaxLen 256                        // max string size to process

#define dim(x) (sizeof(x) / sizeof(x[0]))   // returns no. of elements

char * szDesc = "PC Dictionary";

//
// Hardwired wordlist of State names.  In a production dictionary,
// the wordlist(s) would be loaded from a file specified by the 
// client application program.
//
char * States[] = {
    "Alabama",
    "Alaska",
    "Arizona",
    "Arkansas",
    "California",
    "Colorado",
    "Connecticut",
    "Delaware",
    "Florida",
    "Georgia",
    "Hawaii",
    "Idaho",
    "Illinois",
    "Indiana",
    "Iowa",
    "Kansas",
    "Kentucky",
    "Louisiana",
    "Maine",
    "Maryland",
    "Massachusetts",
    "Michigan",
    "Minnesota",
    "Mississippi",
    "Missouri",
    "Montana",
    "Nebraska",
    "Nevada",
    "New Hampshire",
    "New Jersey",
    "New Mexico",
    "New York",
    "North Carolina",
    "North Dakota",
    "Ohio",
    "Oklahoma",
    "Oregon",
    "Pennsylvania",
    "Rhode Island",
    "South Carolina",
    "South Dakota",
    "Tennessee",
    "Texas",
    "Utah",
    "Vermont",
    "Virginia",
    "Washington",
    "West Virginia",
    "Wisconsin",
    "Wyoming" };

//
// Table of dictionary commands supported by this DLL
// and the functions which correspond to each command.
//
struct {                                    
    int cmd_code;                       
    int (*cmd_fxn)(int, LPVOID, LPVOID, int, LONG, LONG);
    } commands[] = {
    DIRQ_CLOSE, DictClose,
    DIRQ_DESCRIPTION, DictDescription,
    DIRQ_OPEN, DictOpen,
    DIRQ_QUERY, DictQuery,
    DIRQ_SETWORDLISTS, DictSetWordLists,
    DIRQ_STRING, DictString,
    DIRQ_SUGGEST, DictSuggest, } ;

//
// LibMain -- Initialization routine for dynamic link library.
// 
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, 
                       WORD wHeapSize, LPSTR lpszCmdLine)
{
    if (wHeapSize > 0)
        UnlockData(0);

    return(TRUE);
}

//
// WEP -- called when use count for dynamic link library has
//        reached zero and library is about to be unloaded.
//
int FAR PASCAL WEP(int nParam)
{
    return(TRUE);
}

//
// DictionaryProc -- Entry point to dictionary module for 
//                   RC Manager and client programs.
//
int FAR PASCAL DictionaryProc(int dirq, LPVOID lpIn, LPVOID lpOut, 
                              int cbMax, LONG lContext, LONG lData)
{
    int i;

    for(i = 0; i < dim(commands); i++)
    {   
        if(dirq == commands[i].cmd_code)
            return((*commands[i].cmd_fxn)(dirq, lpIn, lpOut, cbMax, 
                                          lContext, lData));
    }
    return(FALSE);
}

//
// DictClose -- function to process DIRQ_CLOSE messages.
//
int DictClose(int dirq, LPVOID lpIn, LPVOID lpOut, int cbMax, 
              LONG lContext, LONG lData)
{
    return(TRUE);                           // stubbed out for now
}

//
// DictDescription -- function to process DIRQ_DESCRIPTION messages.
//
int DictDescription(int dirq, LPVOID lpIn, LPVOID lpOut, int cbMax, 
                    LONG lContext, LONG lData)
{                                           // return name of module
    _fstrncpy((LPSTR) lpOut, (LPSTR) szDesc, min(cbMax-1, sizeof(szDesc)));
    return(TRUE);
}

//
// DictOpen -- function to process DIRQ_OPEN messages.
//
int DictOpen(int dirq, LPVOID lpIn, LPVOID lpOut, int cbMax, 
             LONG lContext, LONG lData)
{
    *(int far *) lpOut = TRUE;              // set dummy wordlist handle
    return(TRUE);                           // return success
}

//
// DictQuery -- function to process DIRQ_QUERY messages.
//
int DictQuery(int dirq, LPVOID lpIn, LPVOID lpOut, int cbMax, 
              LONG lContext, LONG lData)
{
    int i;

    for(i = 0; i < dim(commands); i++)      // check if command supported
    {   
        if(*(int far *) lpIn == commands[i].cmd_code)
            return(TRUE);                   // yep, found it in table
    }
    return(FALSE);                          // nope, not supported
}

//
// DictSetWordLists -- function to process DIRQ_SETWORDLISTS messages.
//
int DictSetWordLists(int dirq, LPVOID lpIn, LPVOID lpOut, int cbMax, 
                     LONG lContext, LONG lData)
{
    return(TRUE);                           // stubbed out for now
}

//
// DictString -- function to process DIRQ_STRING messages.
//
int DictString(int dirq, LPVOID lpIn, LPVOID lpOut, int cbMax, 
               LONG lContext, LONG lData)
{
    int i;
    char InStr[cbMaxLen+1];                 // receives input string

    if (lpIn)                               // any symbol string provided?
    {                                       // translate it to char string
        SymbolToCharacter((LPSYV)lpIn, cbMaxLen, InStr, NULL);

        for (i=0; i < dim(States); i++)     // perform case-insensitive
        {                                   // match against States wordlist
            if (! lstrcmpi((LPSTR) States[i], (LPSTR) InStr))
                return(CharacterToSymbol(States[i], lstrlen(States[i]), lpOut));
        }   
    }
    return(FALSE);                          
}

//
// DictSuggest -- function to process DIRQ_SUGGEST messages.
//
int DictSuggest(int dirq, LPVOID lpIn, LPVOID lpOut, int cbMax, 
                LONG lContext, LONG lData)
{
    int i;
    char InStr[cbMaxLen+1];                 // receives input string

    if (lpIn)                               // any symbol string provided?
    {                                       // translate it to char string
        SymbolToCharacter((LPSYV)lpIn, cbMaxLen, InStr, NULL);

        for (i=0; i < dim(States); i++)     // perform prefix matching
        {                                   // against States wordlist
            if(! _fstrnicmp(States[i], InStr, lstrlen(InStr)))
                return(CharacterToSymbol(States[i], lstrlen(States[i]), lpOut));
        }
    }
    return(FALSE);
}


