        title   TRYITRIG - Demonstration Program for ITRIG Module
        page    55,132

; TRYITOA.ASM --- Simple Interactive Demo of ITRIG Module
; Copyright (C) 1991 Ray Duncan
;
; To build:     MAKE TRYITRIG

stdin   equ     0                       ; standard input handle
stdout  equ     1                       ; standard output handle

cr      equ     0dh                     ; ASCII carriage return
lf      equ     0ah                     ; ASCII line feed

DGROUP  group   _DATA

_TEXT   segment word public 'CODE'

        assume  cs:_TEXT,ds:_DATA

        extrn   lcvt:near
        extrn   atoi:near
        extrn   sine:near
        extrn   cosine:near

main    proc    near

        mov     ax,_DATA                ; make our data segment
        mov     ds,ax                   ; addressable...
        mov     es,ax
        
main1:  mov     dx,offset prompt        ; display a prompt
        mov     cx,p_len                ; to the user...
        mov     bx,stdout               ; "Enter degrees: " 
        mov     ah,40h
        int     21h

        mov     dx,offset inbuff        ; read keyboard entry
        mov     cx,80                   ; from the user...
        mov     bx,stdin
        mov     ah,3fh
        int     21h
        jc      main2                   ; if error, just exit

        cmp     ax,2                    ; did he enter anything?
        je      main2                   ; empty line, exit

        mov     dx,offset msg1          ; display "The sine is: "
        mov     cx,msg1_len             ; to the user...
        mov     bx,stdout
        mov     ah,40h
        int     21h
        
        mov     si,offset inbuff        ; convert convert user's 
        call    atoi                    ; input to binary in AX

        push    ax                      ; save copy of angle    
        call    sine                    ; get sine of angle
                                        
                                        ; convert sine for output
        cwd                             ; DX:AX = sine
        mov     bh,4                    ; decimal places
        mov     bl,10                   ; field width
        mov     cx,0                    ; special formatting
        mov     si,offset outbuff       ; DS:SI = output buffer
        call    lcvt

        mov     cx,ax                   ; CX = string length
        mov     dx,si                   ; DS:DX = string address 
        mov     bx,stdout               ; now display converted
        mov     ah,40h                  ; ASCII string...
        int     21h                     ; 

        mov     dx,offset msg2          ; display "The cosine is: "
        mov     cx,msg2_len             ; to the user...
        mov     bx,stdout
        mov     ah,40h
        int     21h
        
        pop     ax                      ; get copy of angle     
        call    cosine                  ; get cosine of angle
                                        
                                        ; convert cosine for output
        cwd                             ; DX:AX = cosine
        mov     bh,4                    ; decimal places
        mov     bl,10                   ; field width
        mov     cx,0                    ; special formatting
        mov     si,offset outbuff       ; DS:SI = output buffer
        call    lcvt

        mov     cx,ax                   ; CX = string length
        mov     dx,si                   ; DS:DX = string address 
        mov     bx,stdout               ; now display converted
        mov     ah,40h                  ; ASCII string...
        int     21h                     ; 
        jc      main2                   ; if error, just exit

        jmp     main1                   ; do it again...


main2:  mov     ax,4c00h                ; final exit to MS-DOS
        int     21h

main    endp

_TEXT   ends


_DATA   segment word public 'DATA'

prompt  db      cr,lf,lf,'Enter angle:   '
p_len   equ     $-prompt

msg1    db      cr,'The sine is:   '
msg1_len equ    $-msg1

msg2    db      cr,lf,'The cosine is: '
msg2_len equ    $-msg2

inbuff  db      80 dup (?)

outbuff db      10 dup (?)

_DATA   ends


STACK   segment para stack 'STACK'
        
        db      128 dup (?)

STACK   ends

        end     main

