***********************************************************************
* DATES2.PRG
* Demonstrates STOD and EOM functions for Clipper
***********************************************************************
CLEAR SCREEN
? "Enter No Date to Quit ..."
?
DO WHILE .T.
   ACCEPT "Date > " TO mdate         && Get date
   IF EMPTY(mdate)                   && Nothing means quit
      RETURN
   ENDIF

   mdate=CTOD(mdate)                 && Convert to date type
   IF EMPTY(mdate)                   && If conversion failed
      ? "Bad Date!"                  && Date is not valid
      LOOP                           && Try another
   ENDIF

   mdate = EOM(mdate)                && Get last date of month
   ? "Last Date of Month:",mdate
   ? "Number of Days in Month:",DAY(mdate)
ENDDO

***********************************************************************
* Function STOD - String to date conversion (reverse of DTOS())
*
* Usage: d = STOD(dstr)
*
* dstr = A character string that holds a date in DTOS format: YYYYMMDD
*        (Clipper's DTOS() function creates such a string)
*
* Returns d, which is dstr converted to a date value
*
* This is the complement to Clipper's DTOS() Function.
***********************************************************************
FUNCTION stod
PARAMETERS dstr
RETURN CTOD(SUBSTR(dstr,5,2)+"/"+SUBSTR(dstr,7,2)+"/"+LEFT(dstr,4))

***********************************************************************
* Function EOM - Return the last date of the month
*
* Usage: d = EOM(mdate)
*        mdate = Any valid date
*
* Returns d, a date variable containing the last valid date of the
* month
***********************************************************************
FUNCTION eom
PARAMETERS pdate
pdate = LEFT(DTOS(pdate),6) + "31"      && Start with the 31st
DO WHILE EMPTY(STOD(pdate))             && If not valid, back up one
   pdate = LEFT(pdate,6) + STR(VAL(RIGHT(pdate,2))-1,2)
ENDDO
RETURN STOD(pdate)                      && Return a date variable

