// video.c

#include    <stdio.h>
#include    <conio.h>

extern char _video;                             // declare external variable

#define TextColor(foreground,background)    (foreground+(background<<4))
#define CRLF    "\n\r"

void display_textinfo(struct text_info *t);

void main(void)
    {
    struct text_info textinfo, *viddata = (struct text_info *)&_video;

    window(10,5,70,22);                         // set window size
    textattr(TextColor(BLACK,CYAN));            // set text colors
    clrscr();                                   // clear screen
    gettextinfo(&textinfo);                     // TC function

    cprintf(CRLF "Data returned by gettextinfo():" CRLF);
    display_textinfo(&textinfo);

    cprintf(CRLF "Data acquired via _video and direct memory access:" CRLF);
    display_textinfo(viddata);

    cprintf(CRLF CRLF CRLF "Press any key to continue...");
    getch();

    window(1,1,80,25);
    textattr(TextColor(LIGHTGRAY,BLACK));
    clrscr();
    }


void display_textinfo(struct text_info *t)
    {
    cprintf("Window parameters: left=%d top=%d right=%d bottom=%d" CRLF,
        t->winleft,t->wintop,
        t->winright,t->winbottom);
    cprintf("Current Text Attribute:%d  Normal attribute:%d" CRLF,
        t->attribute,
        t->normattr);
    cprintf("Video mode:%d" CRLF,t->currmode);
    cprintf("Screen dimensions (width x height): %dx%d" CRLF,
        t->screenwidth,
        t->screenheight);
    cprintf("Cursor Position: X=%d Y=%d" CRLF,t->curx, t->cury);
    }
