
DECLARE FUNCTION CalcDelay& ()
DECLARE SUB DoDelay (MSecs%, Factor&)
 
Factor& = CalcDelay&
INPUT "Enter a delay period in milliseconds: ", MSecs%
PRINT "Stand by ..."
CALL DoDelay(MSecs%, Factor&)
PRINT "Done!"
 
FUNCTION CalcDelay& STATIC
 
    Fudge& = 0                       'clear the "fudge factor" accumulator
    DEF SEG = 0                      'look at the timer bytes in low memory
 
    Start% = PEEK(&H46C)             'look at the current low-byte count
    DO                               'wait until that byte just changes
    LOOP WHILE PEEK(&H46C) = Start%  '  (up to 1/18th second)
    Start% = PEEK(&H46C)             'get the new low-byte count again
 
    DO                               'now we're synced up with the start of
       Fudge& = Fudge& + 1           '  a new, full 1/18th second period
    LOOP WHILE PEEK(&H46C) = Start%  'accumulate the count for 1/18th second
 
    CalcDelay& = Fudge&              'assign the function output
    DEF SEG                          'restore BASIC's original segment
 
END FUNCTION
 
SUB DoDelay (MSecs%, Factor&)
 
    FOR X% = 1 TO MSecs%
        LoopTime& = Factor& \ 40
        DO
           LoopTime& = LoopTime& - 1
        LOOP WHILE LoopTime&
    NEXT
 
END SUB
