@ECHO OFF
IF '%3'=='' GOTO usage
CLS
ECHO CHANGE.BAT
ECHO.
ECHO File to change: "%1"
ECHO Search for    : "%2"
ECHO Replace with  : "%3"
ECHO.
IF NOT EXIST %1 GOTO filenotfound
ECHO The two strings should be the same length.  Are they?
ECHO.
ECHO To abort the process, press Ctrl-C.  Otherwise...
PAUSE
ECHO Let me make sure everything's correct and ready...

     :@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@:
     :@  Set up the necessary environment vars.     @:
     :@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@:

SET length=XXXX
SET address=XXXX:XXXX
SET oversize=XXXX
SET times=XX
  REM -------------------------------------------
  REM   Check that there was enough environment space
  REM -------------------------------------------
IF NOT '%times%'=='XX' GOTO environment

     :@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@:
     :@  Make sure the file isn't EXE or HEX        @:
     :@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@:

ATTRIB %1 | FIND ".EXE" > TEMP01.CHG
ATTRIB %1 | FIND ".HEX" >> TEMP01.CHG
COPY TEMP01.CHG TEMP02.CHG > NUL
DEL TEMP01.CHG
  REM -------------------------------------------
  REM   If the file is NOT an EXE or HEX file, TEMP01.CHG will be a
  REM   zero-length file.  COPY will not copy a zero-length file.
  REM   So if TEMP02.CHG does NOT exist, all is well.
  REM -------------------------------------------
IF EXIST TEMP02.CHG GOTO EXEorHEX

     :@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@:
     :@  Check that the file is 64K or smaller      @:
     :@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@:

ECHO RBX>SCRIPT00.CHG
ECHO. >> SCRIPT00.CHG
ECHO Q >> SCRIPT00.CHG
  REM -------------------------------------------
  REM  Running SCRIPT00.CHG creates batch file CHANGE00.BAT.  It will
  REM  contains a single line of the form "BX ####", where #### is
  REM  the number of full 64K segments in the file.
  REM -------------------------------------------
DEBUG %1 < SCRIPT00.CHG | FIND "BX " | FIND /V "RBX" > CHANGE00.BAT
  REM -------------------------------------------
  REM   Create BX.BAT -- CHANGE00.BAT will run BX.BAT
  REM -------------------------------------------
ECHO @SET oversize=%%1>BX.BAT
  REM -------------------------------------------
  REM   Call CHANGE00.BAT, which runs BX.BAT, which puts the
  REM   number of full 64K segments into the e-var "oversize"
  REM -------------------------------------------
CALL CHANGE00
IF NOT '%oversize%'=='0000' GOTO toobig
ECHO OK, looks good, now to patch the file...

     :@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@:
     :@  Get the file's size into an e-var          @:
     :@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@:

ECHO RCX> SCRIPT01.CHG
ECHO. >> SCRIPT01.CHG
ECHO Q >> SCRIPT01.CHG
  REM -------------------------------------------
  REM  Running SCRIPT01.CHG creates batch file CHANGE01.BAT.  It will
  REM  contains a single line of the form "CX ####", where #### is
  REM  the size of the file.
  REM -------------------------------------------
DEBUG %1 < SCRIPT01.CHG | FIND "CX " | FIND /V "RCX" > CHANGE01.BAT
  REM -------------------------------------------
  REM   Create CX.BAT -- CHANGE01.BAT executes CX.BAT
  REM -------------------------------------------
ECHO @SET length=%%1>CX.BAT
  REM -------------------------------------------
  REM   Call CHANGE01, which calls CX.BAT, which puts the file length
  REM   into the environment variable "length
  REM -------------------------------------------
CALL CHANGE01

     :@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@:
     :@  Create several useful temporary files      @:
     :@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@:

  REM -------------------------------------------
  REM   Create DEBUG script that gets the address of the search
  REM   string.  It _may_ get multiple addresses -- that's OK.
  REM -------------------------------------------
ECHO S CS:100 L %length% '%2' > SCRIPT02.CHG
ECHO Q >> SCRIPT02.CHG
  REM -------------------------------------------
  REM   Create --------.BAT, which is called by CHANGE04.BAT to get
  REM   the number of times the file appears into e-var "times"
  REM -------------------------------------------
ECHO @SET times=%%2>--------.BAT
  REM -------------------------------------------
  REM   Create and run a DEBUG script.  When run, it produces the file
  REM   DATA01.CHG, containing the string "CHANGE07 " with no carriage
  REM   return or line feed.
  REM -------------------------------------------
ECHO NDATA01.CHG>CHANGE04.SCR
ECHO E 100 'CHANGE07 '>>CHANGE04.SCR
ECHO RCX>>CHANGE04.SCR
ECHO 9>>CHANGE04.SCR
ECHO W>>CHANGE04.SCR
ECHO Q>>CHANGE04.SCR
DEBUG < CHANGE04.SCR > NUL
  REM -------------------------------------------
  REM   Create CHANGE07, which is called by CHANGE02 to get the address
  REM   of first occurrence of search string into e-var "address".
  REM -------------------------------------------
ECHO @SET address=%%1 > CHANGE07.BAT

     :@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@:
     :@  Finally, create and run a script that      @:
     :@  performs the replacement.                  @:
     :@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@:

:notfirst

  REM -------------------------------------------
  REM   Running SCRIPT02.CHG finds address(es) of search string
  REM -------------------------------------------
DEBUG %1 < SCRIPT02.CHG | FIND /V "%2" | FIND ":" > TEMP03.CHG
  REM -------------------------------------------
  REM   FIND with the /C (for Count) switch produces output of
  REM   the form "---------- TEMPO3.CHG: #", where # is the 
  REM   number of times the search string occurs in the file.
  REM -------------------------------------------
FIND /C ":" TEMP03.CHG > CHANGE04.BAT
  REM -------------------------------------------
  REM   Call CHANGE04, which calls --------.BAT
  REM -------------------------------------------
CALL CHANGE04
  REM -------------------------------------------
  REM   If the search string is not present, get out!
  REM -------------------------------------------
IF '%times%'=='0' GOTO notfound
  REM -------------------------------------------
  REM   Pre-pend DATA01.CHG to the first line of the file of addresses
  REM   to create CHANGE02.BAT.  Running CHANGE02.BAT puts the address
  REM   of the first occurrence of the search string into an e-var.
  REM -------------------------------------------
COPY DATA01.CHG + TEMP03.CHG CHANGE02.BAT > NUL
CALL CHANGE02
  REM -------------------------------------------
  REM   Create DEBUG script that overwrites the data at the address
  REM   of the search string with the replace string.
  REM -------------------------------------------
ECHO E %address% '%3' > SCRIPT03.CHG
ECHO W >> SCRIPT03.CHG
ECHO Q >> SCRIPT03.CHG
  REM -------------------------------------------
  REM   Perform the replacement and look for errors.
  REM -------------------------------------------
DEBUG %1 < SCRIPT03.CHG | FIND "Error" > TEMP04.CHG
COPY TEMP04.CHG TEMP05.CHG > NUL
DEL TEMP04.CHG
  REM -------------------------------------------
  REM   If there were no errors, TEMP04.CHG is a zero-length file.
  REM   DOS will not copy a zero-length file.  So if the copy does
  REM   NOT create TEMP05.CHG, all is well.
  REM -------------------------------------------
IF EXIST TEMP05.CHG GOTO trouble

     :@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@:
     :@  If the search string occurred more than    :
     :@  once, repeat the process.                  @:
     :@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@:

IF '%times%'=='1' GOTO success
ECHO The string "%2" appears in the file %1 %times% times.
ECHO Replacing next occurrence...
GOTO notfirst

     :@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@:
     :@  Here is the code for ending the batch      @:
     :@  file, successfully or otherwise.           @:
     :@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@:

:success
ECHO.
ECHO I have successfully patched the file %1 to replace all
ECHO occurrences of "%2" with "%3".  I will now delete all
ECHO of the temporary files created in the process.
:cleanup
IF EXIST SCRIPT0?.CHG DEL SCRIPT0?.CHG > NUL
IF EXIST TEMP0?.CHG   DEL TEMP0?.CHG > NUL
IF EXIST CHANGE0?.*   DEL CHANGE0?.* > NUL
IF EXIST CX.BAT       DEL CX.BAT > NUL
IF EXIST BX.BAT       DEL BX.BAT > NUL
IF EXIST --------.BAT DEL --------.BAT > NUL
IF EXIST DATA01.CHG   DEL DATA01.CHG > NUL
FOR %%v IN (length address times oversize) DO SET %%v=
GOTO end

:filenotfound
ECHO You're asking me to change the file "%1", but I don't
ECHO SEE any file with that name!
GOTO end

:toobig
ECHO Sorry, CHANGE.BAT only works on files 64K or smaller
:GOTO cleanup
:notfound
ECHO Sorry, the file %1 does not contain the string "%2".
GOTO cleanup
:usage
ECHO USAGE: CHANGE filename searchstring replacestring
ECHO.
ECHO The file to be changed must be 64K or less in size, and it
ECHO must not have an EXE or HEX extension.  Also, the search string
ECHO and the replace string should be the same size.
GOTO end

:EXEorHEX
ECHO Sorry, you cannot use CHANGE on a .EXE or .HEX file.
ECHO to have another extension before running CHANGE.
GOTO cleanup

:environment
ECHO Sorry, you do not have enough available environment space
ECHO to run CHANGE.BAT.
GOTO cleanup

:trouble
DEL TEMP05.CHG
ECHO There was trouble in the final DEBUG process.  Examine the
ECHO files created by CHANGE.BAT to see where the problem started.
ECHO Also, type SET and look at environment variables "oversize", 
ECHO "address", "length", and "times".

:end
