/*-----------------------------------------------------------------
   BOUNCE.C -- Palette Animation Using Windows 3.0 Palette Manager
               (c) Charles Petzold, 1990
  -----------------------------------------------------------------*/

#include <windows.h>

long FAR PASCAL WndProc (HWND, WORD, WORD, LONG) ;

#define ID_TIMER    1

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
     {
     char     szAppName [] = "Bounce" ;
     HWND     hwnd ;
     MSG      msg ;
     WNDCLASS wndclass ;

     if (!hPrevInstance) 
          {
          wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = NULL ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = szAppName ;
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
          }

     hwnd = CreateWindow (szAppName, "Bounce: Palette Animation",
                          WS_OVERLAPPEDWINDOW,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          NULL, NULL, hInstance, NULL) ;

     ShowWindow (hwnd, nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg, NULL, 0, 0))
          {
          TranslateMessage (&msg) ;
          DispatchMessage (&msg) ;
          }

     return msg.wParam ;
     }

long FAR PASCAL WndProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
     {
     static BOOL        bLeftToRight = TRUE ;
     static HPALETTE    hPal ;
     static LOCALHANDLE hLocalMem ;
     static LOGPALETTE  *plp ;
     static short       cxClient, cyClient, iBall = 0 ;
     BOOL               bPalSupport ;
     HBRUSH             hBrush ;
     HDC                hdc ;
     int                x1, x2, y1, y2 ;
     long               i ;
     PAINTSTRUCT        ps ;
     RECT               rc ;

     switch (message)
          {
          case WM_CREATE:

                    // Check for palette support

               hdc = GetDC (hwnd) ;

               bPalSupport = (RC_PALETTE & GetDeviceCaps (hdc, RASTERCAPS)) &&
                             (GetDeviceCaps (hdc, SIZEPALETTE) -
                              GetDeviceCaps (hdc, NUMRESERVED) > 34) ;

               ReleaseDC (hwnd, hdc) ;

               if (!bPalSupport)
                    {
                    MessageBox (hwnd, "Program requires palette support",
                                "Bounce", MB_ICONEXCLAMATION | MB_OK) ;

                    DestroyWindow (hwnd) ;
                    return 0 ;
                    }

                    // Allocate memory for LOGPALETTE structure and lock it

               hLocalMem = LocalAlloc (LMEM_MOVEABLE, sizeof (LOGPALETTE) +
                                                 33 * sizeof (PALETTEENTRY)) ;

               plp = (LOGPALETTE *) LocalLock (hLocalMem) ;

                    // Initialize the fields of the LOGPALETTE structure

               plp->palVersion    = 0x300 ;
               plp->palNumEntries = 34 ;

               for (i = 0 ; i < 34 ; i++)
                    {
                    plp->palPalEntry[i].peRed   = 255 ;
                    plp->palPalEntry[i].peGreen = (i ==  0 ? 0 : 255) ;
                    plp->palPalEntry[i].peBlue  = (i ==  0 ? 0 : 255) ;
                    plp->palPalEntry[i].peFlags = (i == 33 ? 0 : PC_RESERVED) ;
                    }

                    // Create the logical palette & unlock the memory block

               hPal = CreatePalette (plp) ;
               LocalUnlock (hLocalMem) ;

                    // Set the timer for 50 msec

               SetTimer (hwnd, ID_TIMER, 50, NULL) ;
               return 0 ;

          case WM_SIZE:
               cxClient = LOWORD (lParam) ;
               cyClient = HIWORD (lParam) ;
               return 0 ;

          case WM_TIMER:
               plp = (LOGPALETTE *) LocalLock (hLocalMem) ;

                    // Set old ball color to white

               plp->palPalEntry[iBall].peGreen = 255 ;
               plp->palPalEntry[iBall].peBlue  = 255 ;

               iBall += (bLeftToRight ? 1 : -1) ;

               if (iBall == (bLeftToRight ? 33 : -1))
                    {
                    iBall = (bLeftToRight ? 31 : 1) ;
                    bLeftToRight ^= TRUE ;
                    }

                    // Set new ball color to red

               plp->palPalEntry[iBall].peGreen = 0 ;
               plp->palPalEntry[iBall].peBlue  = 0 ;

                    // Animate the palette

               AnimatePalette (hPal, 0, 33, plp->palPalEntry) ;

               LocalUnlock (hLocalMem) ;
               return 0 ;

          case WM_PAINT:
               hdc = BeginPaint (hwnd, &ps) ;

               SelectPalette (hdc, hPal, FALSE) ;
               RealizePalette (hdc) ;

                    // Draw window background using palette index 33

               GetWindowRect (hwnd, &rc) ;
               hBrush = CreateSolidBrush (PALETTEINDEX (33)) ;
               FillRect (hdc, &rc, hBrush) ;
               DeleteObject (hBrush) ;

               SelectObject (hdc, GetStockObject (NULL_PEN)) ;

                    // Draw the 33 balls

               for (i = 0 ; i < 33 ; i++)
                    {
                    x1 =  i      * cxClient / 33 ;
                    x2 = (i + 1) * cxClient / 33 ;

                    if (i < 9)
                         {
                         y1 =  i      * cyClient / 9 ;
                         y2 = (i + 1) * cyClient / 9 ;
                         }
                    else if (i < 17)
                         {
                         y1 = (16 - i) * cyClient / 9 ;
                         y2 = (17 - i) * cyClient / 9 ;
                         }
                    else if (i < 25)
                         {
                         y1 = (i - 16) * cyClient / 9 ;
                         y2 = (i - 15) * cyClient / 9 ;
                         }
                    else
                         {
                         y1 = (32 - i) * cyClient / 9 ;
                         y2 = (33 - i) * cyClient / 9 ;
                         }

                    hBrush = CreateSolidBrush (PALETTEINDEX (i)) ;
                    SelectObject (hdc, hBrush) ;

                    Ellipse (hdc, x1, y1, x2, y2) ;

                    DeleteObject (SelectObject (hdc,
                                  GetStockObject (BLACK_BRUSH))) ;
                    }

               EndPaint (hwnd, &ps) ;
               return 0 ;

          case WM_QUERYNEWPALETTE:
               hdc = GetDC (hwnd) ;

               SelectPalette (hdc, hPal, FALSE) ;

               if (RealizePalette (hdc) > 0)
                    {
                    ReleaseDC (hwnd, hdc) ;
                    InvalidateRect (hwnd, NULL, FALSE) ;
                    return TRUE ;
                    }
               else
                    {
                    ReleaseDC (hwnd, hdc) ;
                    return FALSE ;
                    }
               break ;

          case WM_PALETTECHANGED:
               if (wParam != hwnd)
                    {
                    hdc = GetDC (hwnd) ;

                    SelectPalette (hdc, hPal, FALSE) ;

                    if (RealizePalette (hdc) > 0)
                         {
                         InvalidateRect (hwnd, NULL, FALSE) ;
                         }

                    ReleaseDC (hwnd, hdc) ;
                    }
               return 0 ;

          case WM_DESTROY :
               KillTimer (hwnd, ID_TIMER) ;
               LocalFree (hLocalMem) ;
               DeleteObject (hPal) ;
               PostQuitMessage (0) ;
               return 0 ;
          }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }
