/*
 * MultiMail offline mail reader
 * mmail class

 Copyright (c) 1996 Toth Istvan <stoty@vma.bme.hu>
 Copyright (c) 1998 William McBrine <wmcbrine@clark.net>

 Distributed under the GNU General Public License.
 For details, see the file COPYING in the parent directory. */

#ifndef MMAIL_H 
#define MMAIL_H

#include "misc.h"
#include "resource.h"

#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <sys/types.h>

// Number of the Reply area
#define REPLY_AREA 0

// Area types
#define COLLECTION 1
#define REPLYAREA 2
#define ACTIVE 4
#define ALIAS 8
#define NETMAIL 16
#define INTERNET 32

// Mail statuses -- bit f.
#define MS_NONE		0
#define MS_READ		1
#define MS_REPLIED	2 
#define MS_MARKED	4

// for letter_list::sort
#define LS_SUBJ     1
#define LS_NAME     2 // not implemented yet
#define LS_MSGNUM   3 // -||- 

// Some of the functions normally used by MultiMail don't exist in EMX,
// but are available under other names:

#ifdef __EMX__
# define strcasecmp stricmp
# define strncasecmp strnicmp
extern "C" {
int _chdir2(__const__ char *);
char *_getcwd2(char *, int);
}
# define mychdir _chdir2
# define mygetcwd _getcwd2
#else
# define mychdir chdir
# define mygetcwd getcwd
#endif

class mmail;
class resource;
class file_header;
class file_list;
class area_header;
class area_list;
class letter_header;
class letter_list;
class specific_driver;
class reply_driver;
class driver_list;
class read_class;

class net_address
{
 public:
	int zone, net, node, point;

	const char *text();
	void init(const char *);
};
 
class mmail
{
 public:
	resource *resourceObject;
	file_list *workList;
	driver_list *driverList;
	area_list *areaList;

	mmail();
	~mmail();
	void selectPacket(const char *);
	void Delete();
	void saveRead();
};	

class file_header
{
	char *name;
	time_t date;
	off_t size;
 public:
	file_header(char *, time_t, off_t);
	~file_header();
 	const char *getName();
	time_t getDate();
	off_t getSize();
	file_header *next;
};

class file_list
{
	file_header **files;
	int noOfFiles, activeFile;

	void initFiles(const char *);
	void fileqsort(int, int);
 public:
	file_list(const char *);
	~file_list();
	int getNoOfFiles();
	void gotoFile(int);
	const char *getName();
	const char *exists(const char *);
	const char *getNext(const char *);
	FILE *ftryopen(const char *, const char *);
	time_t getDate();
	off_t getSize();
};

class area_header
{
	mmail *mm;
	specific_driver *driver;
	const char *shortName, *name, *description, *areaType;
	int noOfLetters, noOfPersonal, num, type;
 public:
	area_header(mmail *, int, const char *, const char *, const char *,
		const char *, int, int, int);
	const char *getShortName();
	const char *getName();
	const char *getDescription();
	const char *getAreaType();
 	int getNoOfLetters();
	int getNoOfUnread();
	int getNoOfPersonal();
	int getUseAlias();
	int isCollection();
	int isReplyArea();
	int isActive();
	int isNetmail();
};

class area_list
{
	mmail *mm;
	specific_driver *actDriver;
	area_header **areaHeader;
	int *activeHeader;
	letter_list *actLetterList;
	int no, noActive, current, shortlist;

	void refreshArea();
 public:
	area_list(mmail *);
	~area_list();
	void relist();
	const char *getShortName();
	const char *getName();
	const char *getName(int);
	const char *getDescription();
	const char *getDescription(int);
	const char *getAreaType();
	int getNoOfLetters();
	int getNoOfUnread();
	int getNoOfPersonal();
	letter_list *getLetterList();
	void enterLetter(int, char *, char *, char *, int, int,
			net_address *, char *, int);
	void killLetter(int);
	void makeReply();
	void gotoArea(int);
	void gotoActive(int);
	int getAreaNo();
	int getActive();
	int noOfAreas();	
	int noOfActive();
	int getUseAlias();
	int isCollection();
	int isReplyArea();
	int isNetmail();
};

class letter_header
{
	driver_list *dl;
	read_class *readO;
	specific_driver *driver;
	char *subject, *to, *from, *date;
	int replyTo, LetterID, AreaID, privat, length, msgNum;
	net_address netAddr;
 public:
	letter_header(mmail *, const char *, const char *, const char *,
		const char *, int, int, int, int, int, int, specific_driver *,
		net_address *);
	~letter_header();				
	const char *getSubject();
	const char *getTo();
	const char *getFrom();
	const char *getDate();
	int getReplyTo();
	int getLetterID();
	int getAreaID();
	int getPrivate();
	const char *getBody();
	int getLength();
	specific_driver *getDriver();
	int getMsgNum();
	net_address *getNetAddr();

	int getRead();
	void setRead();
	int getStatus();
	void setStatus(int);
};

class letter_list
{ 
	driver_list *dl;
	specific_driver *driver;
	read_class *readO;
	letter_header **letterHeader;
	int noOfLetters, areaNumber, currentLetter, isColl;
	
	void init();
	void cleanup();
	void lettqsort(int, int);
	//void sort(int);
 public:
	letter_list(mmail *, int, int);
	~letter_list();

	const char *getSubject();
	const char *getTo();
	const char *getFrom();
	const char *getDate();
	int getReplyTo();
	int getMsgNum();
	int getAreaID();
	int getPrivate();
	const char *getBody();
	int getLength();
	int noOfLetter();
	net_address *getNetAddr();

	int getStatus();
	void setStatus(int);
	int getRead();
	void setRead();
	
	void rrefresh();
	void gotoLetter(int);
	int getCurrent();
};

class driver_list
{
	struct driver_struct {
		specific_driver *driver;
		read_class *read;
		int offset;
	} driverList[2];

	int noOfDrivers, attributes;
 public:
	driver_list(mmail *);
	~driver_list();
	int getNoOfDrivers();
	specific_driver *getDriver(int);
	reply_driver *getReplyDriver();
	read_class *getReadObject(specific_driver *);
	int getOffset(specific_driver *);
	int hasPersonal();
	int useTearline();
};

class read_class
{
 public:
	read_class() {};
	virtual ~read_class() {};
	virtual void setRead(int, int, int) = 0;
	virtual int getRead(int, int) = 0;
	virtual void setStatus(int, int, int) = 0;
	virtual int getStatus(int, int) = 0;
	virtual int getNoOfUnread(int) = 0;
	virtual void saveAll() = 0;
};

class main_read_class : public read_class
{
	resource *ro;
	int noOfAreas, **readStore, *noOfLetters;
 public:
	main_read_class(mmail *, specific_driver *);
	~main_read_class();
	void setRead(int, int, int);
	int getRead(int, int);
	void setStatus(int, int, int);
	int getStatus(int, int);
	int getNoOfUnread(int);
	void saveAll();
	char *readFilePath(const char *);
};

class reply_read_class: public read_class
{
 public:
	reply_read_class(mmail *, specific_driver *);
	~reply_read_class();
	void setRead(int, int, int);
	int getRead(int, int);
	void setStatus(int, int, int);
	int getStatus(int, int);
	int getNoOfUnread(int);
	void saveAll();
};	

struct bodytype
{
	long pointer, msgLength;
};

class specific_driver
{
 public:
	virtual ~specific_driver() {};
	virtual int getNoOfAreas() = 0;
	virtual void resetAll() = 0;
	virtual area_header *getNextArea() = 0;
	virtual void selectArea(int) = 0;
	virtual int getNoOfLetters() = 0;
	virtual void resetLetters() = 0;
	virtual letter_header *getNextLetter() = 0;
	virtual char *getBody(int, int) = 0;
};

class reply_driver : public specific_driver
{
 public:	
	virtual ~reply_driver() {};
	virtual void enterLetter(letter_header *, char *, int) = 0;
	virtual void killLetter(int) = 0;
	virtual area_header *refreshArea() = 0;
	virtual void makeReply() = 0;
};

#endif
