/*
 * MultiMail offline mail reader
 * message list

 Copyright (c) 1996 Kolossvary Tamas <thomas@tvnet.hu>
 Copyright (c) 1997 John Zero <john@graphisoft.hu>
 Copyright (c) 1998 William McBrine <wmcbrine@clark.net>

 Distributed under the GNU General Public License.
 For details, see the file COPYING in the parent directory. */

#include "interfac.h"
#include "isoconv.h"
#include "mysystem.h"

extern mmail		mm;
extern AreaListWindow	areas;
extern HelpWindow	helpwindow;
extern letter_list	*letterList;

void LetterListWindow::NextUnread()
{
	do {
		Move(DOWN);
		letterList->gotoLetter(active);
	} while (letterList->getRead() && ((active + 1) < NumOfItems()));
	Draw();
}

void LetterListWindow::FirstUnread()
{
	position = 0;
	active = -1;
	NextUnread();
}

void LetterListWindow::PrevUnread()
{
	do {
		Move(UP);
		letterList->gotoLetter(active);
	} while (letterList->getRead() && (active > 0));
	Draw();
}

int LetterListWindow::NumOfItems()
{
	return mm.areaList->getNoOfLetters();
}

void LetterListWindow::oneLine(int i)
{
	const char *origArea;
	char stat[4], *p = lineBuf;
	int st;

	letterList->gotoLetter(position + i);

	wattrset(list->info, C_LISTWIN | A_NORMAL);

	strcpy(stat, "   ");
	st = letterList->getStatus();
	if (st & MS_READ)
		stat[2] = '*';
	else
		wattron(list->info, A_BOLD);
	if (st & MS_REPLIED)
		stat[1] = '~';
	if (st & MS_MARKED)
		stat[0] = 'M';

	if (position + i == active)
		wstandout(list->info);

	p += sprintf(p, format, stat, letterList->getMsgNum(),
		letterList->getFrom(), letterList->getTo(),
			letterList->getSubject());

	if (mm.areaList->isCollection()) {
		origArea = mm.areaList->
			getDescription(letterList->getAreaID());
		if (origArea) {
			p -= 15;
			sprintf(p, " %-13.13s ", origArea);
		}
	}

	charconv_in(lineBuf);
	mvwaddstr(list->info, i, 0, lineBuf);
}

void LetterListWindow::MakeActive()
{
	char topline[72];
	int tot, maxFromLen, maxToLen, maxSubjLen;

	oldPos = oldActive = -100;
	tot = COLS - 19;
	maxSubjLen = tot / 2;
	tot -= maxSubjLen;
	maxToLen = tot / 2;
	maxFromLen = tot - maxToLen;

	sprintf(format, "%%s%%6d  %%-%d.%ds %%-%d.%ds %%-%d.%ds",
		maxFromLen, maxFromLen, maxToLen, maxToLen,
			maxSubjLen, maxSubjLen);

	areas.Select();
	list_max_y = (NumOfItems() < LINES - 11) ? NumOfItems() : LINES - 11;

	list = new InfoWin(list_max_y + 3, COLS - 4, 2, 2, C_LLBBORD, 1);
	mvwaddch(list->win, 0, 2, ACS_RTEE);
	wattrset(list->win, C_LLTOPTEXT1);
	waddstr(list->win, "Letters in ");
	wattrset(list->win, C_LLTOPTEXT2);
	sprintf(topline, "%.71s", mm.areaList->getDescription());
	charconv_in(topline);
	waddstr(list->win, topline);
	wattrset(list->win, C_LLBBORD);
	waddch(list->win, ACS_LTEE);
	wattrset(list->win, C_LLHEAD);
	sprintf(topline, "   Msg#  %%-%d.%ds %%-%d.%ds %%-%d.%ds",
		maxFromLen, maxFromLen, maxToLen, maxToLen,
			maxSubjLen, maxSubjLen);
	mvwprintw(list->win, 1, 3, topline, "From", "To", "Subject");

	if (mm.areaList->isCollection())
		mvwaddstr(list->win, 1, COLS - 19, "Area");
	list->touch();

	if (mm.areaList->isReplyArea())
		helpwindow.reply_area_letterlist();
	else
		helpwindow.letterlist();

	lineBuf = new char[COLS - 5];
}

void LetterListWindow::Select()
{
	letterList->gotoLetter(active);
}

void LetterListWindow::Delete()
{
	delete lineBuf;
	delete list;
	helpwindow.Delete();
}
