;noun.lex  16-Apr-91
;INCLUDE file for english.lex

;Copyright (C) 1991, Summer Institute of Linguistics, Inc.
;All rights reserved
;See ENGLEX.DOC for fair use policy.

;edit history
;18-Nov-91	version 0.9
;26-Nov-91	version 1.0

;File Contents
;LEXICON NOUN
;irregular plurals
;   plural in -os or -oes
;   final z
;   final quy
;   f ~ v plurals
;   mutation plurals
;   man/woman compounds
;   -en plurals
;   misc odd plurals
;   foreign plurals
;   zero plurals
;   equivocal number
;   invariable plurals
;      summation plurals
;      pluralia tantum
;      unmarked plural nouns
;Final_y nouns

;regular plurals
;  Greek alphabet

LEXICON NOUN
;irregular plurals
;plural in -os or -oes
;Epenthesis rule handles these
archi`pelago	N	"N"
avo`cado	N	"N"
`banjo	N	"N"
`bongo	N	"N"
`buffalo	N	"N"
`calico	N	"N"
ca`lypso	N	"N"
`cameo	N	"N"
`cargo	N	"N"
com`mando	N	"N"
cres`cendo	N	"N"
despe`rado	N	"N"
`dingo	N	"N"
`dodo	N	"N"
`domino	N	"N"
em`bargo	N-to-V	"N"
fi`asco	N	"N"
fla`mingo	N	"N"
far`rago	N	"N"
`fresco	N	"N"
`gecko	N	"N"
`ghetto	N	"N"
`gingko	N	"N"
`ginkgo	N	"N"
`grotto	N	"N"
`halo	N	"N"
`hero	N	"N"
`hobo	N	"N"
innu`endo	N	"N"
`junco	N	"N"
las`so	N-to-V	"N"
`lingo	N	"N"
`mango	N	"N"
mani`festo	N	"N"
me`mento	N	"N"
mos`quito	N	"N"
`motto	N	"N"
mu`latto	N	"N"
`negro	N	"N"
pal`metto	N	"N"
po`litico	N	"N"
`portico	N	"N"
po`tato	N	"N"
pro`viso	N	"N"
`quarto	N	"N"
`ratio	N	"N"
`salvo	N	"N"
sti`letto	N	"N"
`stucco	N-to-V	"N"
to`mato	N	"N"
tor`nado	N	"N"
tor`pedo	N-to-V	"N"
tuxedo	N	"N"
`veto	N-to-V	"N"
vi`rago	N	"N"
vol`cano	N	"N"
;`zero	N	"N" ;see LEXICON CARDINALS

;final z
`fez	N	"N"
`fezzes	Number	"N(`fez)+PL"
`quiz	N-to-V	"N"
`quizzes	Number	"V(`quiz).NR0+PL"
`quizzer	N	"V(`quiz)+NR19"

;final quy
`colloquy	N	"N"
`colloquies	Number	"N(`colloquy)+PL"
`obloquy	N	"N"
`obloquies	Number	"N(`obloquy)+PL"
`obsequy	N	"N"
`obsequies	Number	"N(`obsequy)+PL"
so`liloquy	N	"N"
so`liloquies	Number	"N(so`liloquy)+PL"

;f ~ v plurals
`alewife	N	"N"
`alewives	Number	"N(`alewife)+PL"
`bookshelf	N	"N"
`bookshelves	Number	"N(`bookshelf)+PL"
`calf	N	"N"
`calves	Number	"N(`calf)+PL"
`dwarf	N-to-V	"N"
`dwarves	Number	"N(`dwarf)+PL"
`elf	N	"N"
`elves	Number	"N(`elf)+PL"
`half	N	"N"
`halves	Number	"N(`half)+PL"
`halflife	N	"N"
`halflives	Number	"N(`halflife)+PL"
`hoof	N	"N"
`hooves	Number	"N(`hoof)+PL"
`housewife	N	"N"
`housewives	Number	"N(`housewife)+PL"
`knife	N	"N"
`knives	Number	"N(`knife)+PL"
`leaf	N	"N"
`leaves	Number	"N(`leaf)+PL"
`life	N	"N"
`lives	Number	"N(`life)+PL"
`loaf	N	"N"
`loaves	Number	"N(`loaf)+PL"
`midwife	N	"N"
`midwives	Number	"N(`midwife)+PL"
`scarf	N	"N"
`scarves	Number	"N(`scarf)+PL"
`self	N	"N"
`selves	Number	"N(`self)+PL"
`sheaf	N	"N"
`sheaves	Number	"N(`sheaf)+PL"
`shelf	N	"N"
`shelves	Number	"N(`shelf)+PL"
`staff	N	"N"
`staves	Number	"N(`staff1)+PL"
`thief	N	"N"
`thieves	Number	"N(`thief)+PL"
`turf	N	"N"
`turves	Number	"N(`turf)+PL"
`werewolf	N	"N"
`werewolves	Number	"N(`werewolf)+PL"
`wharf	N	"N"
`wharves	Number	"N(`wharf)+PL"
`wife	N	"N"
`wives	Number	"N(`wife)+PL"
`wolf	N	"N"
`wolves	Number	"N(`wolf)+PL"

;mutation plurals
`dormouse	N	"N"
`dormice	Number	"N(`dormouse).PL"
`foot	N	"N"
`feet	Number	"N(`foot).PL"
`goose	N	"N"
`geese	Number	"N(`goose).PL"
`louse	N	"N"
`lice	Number	"N(`louse).PL"
`man	N-to-V	"N"
`men	Number	"N(`man).PL"
`mongoose	N	"N"
`mongeese	Number	"N(`mongoose).PL"
`mouse	N	"N"
`mice	Number	"N(`mouse).PL"
`tooth	N	"N"
`teeth	Number	"N(`tooth).PL"
`woman	N	"N"
`women	Number	"N(`woman).PL"

;man/woman compounds
;try using +man, +woman as suffixes
;`airman	N	"N"
;`airmen	Number	"N(`airman).PL"
`alderman	N	"N"
`aldermen	Number	"N(`alderman).PL"
;`baseman	N	"N"
;`basemen	Number	"N(`baseman).PL"
;`boatman	N	"N"
;`boatmen	Number	"N(`boatman).PL"
`bogeyman	N	"N"
`bogeymen	Number	"N(`bogeyman).PL"
`bondsman	N	"N"
`bondsmen	Number	"N(`bondsman).PL"
`brakeman	N	"N"
`brakemen	Number	"N(`brakeman).PL"
;`businessman	N	"N"
;`businessmen	Number	"N(`businessman).PL"
;`cameraman	N	"N"
;`cameramen	Number	"N(`cameraman).PL"
;`cattleman	N	"N"
;`cattlemen	Number	"N(`cattleman).PL"
;`caveman	N	"N"
;`cavemen	Number	"N(`caveman).PL"
;`chairman	N	"N"
;`chairmen	Number	"N(`chairman).PL"
;`chairwoman	N	"N"
;`chairwomen	Number	"N(`chairwoman).PL"
;`churchman	N	"N"
;`churchmen	Number	"N(`churchman).PL"
;`churchwoman	N	"N"
;`churchwomen	Number	"N(`churchwoman).PL"
;`clergyman	N	"N"
;`clergymen	Number	"N(`clergyman).PL"
;`coachman	N	"N"
;`coachmen	Number	"N(`coachman).PL"
;com`mitteeman	N	"N"
;com`mitteemen	Number	"N(com`mitteeman).PL"
;com`mitteewoman	N	"N"
;com`mitteewomen	Number	"N(com`mitteewoman).PL"
;`congressman	N	"N"
;`congressmen	Number	"N(`congressman).PL"
;`congresswoman	N	"N"
;`congresswomen	Number	"N(`congresswoman).PL"
;`corpsman	N	"N"
;`corpsmen	Number	"N(`corpsman).PL"
;`councilman	N	"N"
;`councilmen	Number	"N(`councilman).PL"
;`councilwoman	N	"N"
;`councilwomen	Number	"N(`councilwoman).PL"
;`countryman	N	"N"
;`countrymen	Number	"N(`countryman).PL"
;`cowman	N	"N"
;`cowmen	Number	"N(`cowman).PL"
`craftsman	N	"N"
`craftsmen	Number	"N(`craftsman).PL"
;`crewman	N	"N"
;`crewmen	Number	"N(`crewman).PL"
;`dairyman	N	"N"
;`dairymen	Number	"N(`dairyman).PL"
;`doorman	N	"N"
;`doormen	Number	"N(`doorman).PL"
`draftsman	N	"N"
`draftsmen	Number	"N(`draftsman).PL"
;`earthman	N	"N"
;`earthmen	Number	"N(`earthman).PL"
;`fireman	N	"N"
;`firemen	Number	"N(`fireman).PL"
`fisherman	N	"N"
`fishermen	Number	"N(`fisherman).PL"
`footman	N	"N"
`footmen	Number	"N(`footman).PL"
`freedmen	Number	"N(`freedman).PL"
`freeman	N	"N"
`freemen	Number	"N(`freeman).PL"
`freewoman	N	"N"
`freewomen	Number	"N(`freewoman).PL"
`freshman	N	"N"
`freshmen	Number	"N(`freshman).PL"
fron`tiersman	N	"N"
fron`tiersmen	Number	"N(fron`tiersman).PL"
`gamesman	N	"N"
`gamesmen	Number	"N(`gamesman).PL"
;`gunman	N	"N"
;`gunmen	Number	"N(`gunman).PL"
`gentleman	N	"N"
`gentlemen	Number	"N(`gentleman).PL"
`guardsman	N	"N"
`guardsmen	Number	"N(`guardsman).PL"
`handyman	N	"N"
`handymen	Number	"N(`handyman).PL"
`hangman	N	"N"
`hangmen	Number	"N(`hangman).PL"
`headsman	N	"N"
`headsmen	Number	"N(`headsman).PL"
`helmsman	N	"N"
`helmsmen	Number	"N(`helmsman).PL"
`henchman	N	"N"
`henchmen	Number	"N(`henchman).PL"
`herdsman	N	"N"
`herdsmen	Number	"N(`herdsman).PL"
;`highwayman	N	"N"
;`highwaymen	Number	"N(`highwayman).PL"
;`horseman	N	"N"
;`horsemen	Number	"N(`horseman).PL"
;`horsewoman	N	"N"
;`horsewomen	Number	"N(`horsewoman).PL"
`husbandman	N	"N"
`husbandmen	Number	"N(`husbandman).PL"
;`infantryman	N	"N"
;`infantrymen	Number	"N(`infantryman).PL"
`journeyman	N	"N"
`journeymen	Number	"N(`journeyman).PL"
;`juryman	N	"N"
;`jurymen	Number	"N(`juryman).PL"
`klansman	N	"N"
`klansmen	Number	"N(`klansman).PL"
`kinsman	N	"N"
`kinsmen	Number	"N(`kinsman).PL"
`landsman	N	"N"
`landsmen	Number	"N(`landsman).PL"
`layman	N	"N"
`laymen	Number	"N(`layman).PL"
`leadsman	N	"N"
`leadsmen	Number	"N(`leadsman).PL"
;`lineman	N	"N"
;`linemen	Number	"N(`lineman).PL"
;`lumberman	N	"N"
;`lumbermen	Number	"N(`lumberman).PL"
`madman	N	"N"
`madmen	Number	"N(`madman).PL"
;`mailman	N	"N"
;`mailmen	Number	"N(`mailman).PL"
`marksman	N	"N"
`marksmen	Number	"N(`marksman).PL"
`merman	N	"N"
`mermen	Number	"N(`merman).PL"
`middleman	N	"N"
`middlemen	Number	"N(`middleman).PL"
;mi`litiaman	N	"N"
;mi`litiamen	Number	"N(mi`litiaman).PL"
;`minuteman	N	"N"
;`minutemen	Number	"N(`minuteman).PL"
;`newsman	N	"N"
;`newsmen	Number	"N(`newsman).PL"
;`newspaperman	N	"N"
;`newspapermen	Number	"N(`newspaperman).PL"
`nobleman	N	"N"
`noblemen	Number	"N(`nobleman).PL"
`oarsman	N	"N"
`oarsmen	Number	"N(`oarsman).PL"
;`oilman	N	"N"
;`oilmen	Number	"N(`oilman).PL"
`ombudsman	N	"N"
`ombudsmen	Number	"N(`ombudsman).PL"
;pa`trolman	N	"N"
;pa`trolmen	Number	"N(pa`trolman).PL"
;`penman	N	"N"
;`penmen	Number	"N(`penman).PL"
;`plowman	N	"N"
;`plowmen	Number	"N(`plowman).PL"
;po`liceman	N	"N"
;pol`icemen	Number	"N(po`liceman).PL"
;po`licewoman	N	"N"
;pol`icewomen	Number	"N(po`licewoman).PL"
;`postman	N	"N"
;`postmen	Number	"N(`postman).PL"
;`quarryman	N	"N"
;`quarrymen	Number	"N(`quarryman).PL"
re`pairman	N	"N"
re`pairmen	Number	"N(re`pairman).PL"
;`rifleman	N	"N"
;`riflemen	Number	"N(`rifleman).PL"
`salesman	N	"N"
`salesmen	Number	"N(`salesman).PL"
;`seaman	N	"N"
;`seamen	Number	"N(`seaman).PL"
`selectman	N	"N"
`selectmen	Number	"N(`selectman).PL"
;`serviceman	N	"N"
;`servicemen	Number	"N(`serviceman).PL"
;`shipman	N	"N"
;`shipmen	Number	"N(`shipman).PL"
;`showman	N	"N"
;`showmen	Number	"N(`showman).PL"
`swordsman	N	"N"
`swordsmen	Number	"N(`swordsman).PL"
`spokesman	N	"N"
`spokesmen	Number	"N(`spokesman).PL"
`spokeswoman	N	"N"
`spokeswomen	Number	"N(`spokeswoman).PL"
;`sportsman	N	"N"
;`sportsmen	Number	"N(`sportsman).PL"
;`stableman	N	"N"
;`stablemen	Number	"N(`stableman).PL"
`statesman	N	"N"
`statesmen	Number	"N(`statesman).PL"
`strongman	N	"N"
`strongmen	Number	"N(`strongman).PL"
`swordsman	N	"N"
`swordsmen	Number	"N(`swordsman).PL"
`tradesman	N	"N"
`tradesmen	Number	"N(`tradesman).PL"
;`trainman	N	"N"
;`trainmen	Number	"N(`trainman).PL"
`tribesman	N	"N"
`tribesmen	Number	"N(`tribesman).PL"
under`classman	N	"N"
under`classmen	Number	"N(under`classman).PL"
upper`classman	N	"N"
upper`classmen	Number	"N(upper`classman).PL"
`watchman	N	"N"
`watchmen	Number	"N(`watchman).PL"
;`wingman	N	"N"
;`wingmen	Number	"N(`wingman).PL"
;`wireman	N	"N"
;`wiremen	Number	"N(`wireman).PL"
;`workman	N	"N"
;`workmen	Number	"N(`workman).PL"
`yachtsman	N	"N"
`yachtsmen	Number	"N(`yachtsman).PL"

;-en plurals
`brother	N	"N"
`brethren	Number	"N(`brother).PL"
`brainchild	N	"N"
`brainchildren	Number	"N(`brainchild).PL"
`child	N	"N"
`children	Number	"N(`child).PL"
`godchild	N	"N"
`godchildren	Number	"N(`godchild).PL"
`grandchild	N	"N"
`grandchildren	Number	"N(`grandchild).PL"
`ox	N	"N"
`oxen	Number	"N(`ox).PL"
`muskox	N	"N"
`muskoxen	Number	"N(N(`muskox).PL)"

;misc odd plurals
abc	N	"N"
abc's	N	"N(abc)+PL"
`die	N	"N"
`dice	Number	"N(`die).SG/PL"
passer`by	N	"N"
passers`by	Number	"N(passer`by).PL"
`penny	N	"N"
`pence	Number	"N(`penny).PL"

;foreign plurals
`abacus	N	"N"
`abaci	Number	"N(`abacus).PL"
ab`scissa	N	"N"
ab`scissae	Number	"N(ab`scissa).PL"
ad`dendum	N	"N"
ad`denda	Number	"N(ad`dendum).PL"
a`dieu	N	"N"
a`dieux	Number	"N(a`dieu).PL"
`alga	N	"N"
`algae	Number	"N(`alga).PL"
a`lumna	N	"N"
a`lumnae	Number	"N(a`lumna).PL"
a`lumnus	N	"N"
a`lumni	Number	"N(a`lumnus).PL"
alve`olus	N	"N"
alve`oli	Number	"N(alve`olus).PL"
amanu`ensis	N	"N"
amanu`enses	Number	"N(amanu`ensis).PL"
a`moeba	N	"N"
a`moebae	Number	"N(a`moeba).PL"
a`nalysis	N	"N"
a`nalyses	Number	"N(a`nalysis).PL"
`annulus	N	"N"
`annuli	Number	"N(`annulus).PL"
an`tenna	N	"N"
an`tennae	Number	"N(an`tenna).PL"
an`tithesis	N	"N"
an`titheses	Number	"N(an`tithesis).PL"
ap`pendix	N	"N"
ap`pendices	Number	"N(ap`pendix).PL"
`apex	N	"N"
`apices	Number	"N(`apex).PL"
a`quarium	N	"N"
a`quaria	Number	"N(a`quarium).PL"
`atrium	N	"N"
`atria	Number	"N(`atrium).PL"
au`tomaton	N	"N"
au`tomata	Number	"N(au`tomaton).PL"
`axis	N	"N"
`axes	Number	"N(`axis).PL"
baccha`nalia	N	"N"
baccha`nalia	Number	"N(baccha`nalia).PL"
ba`cillus	N	"N"
ba`cilli	Number	"N(ba`cillus).PL"
bac`terium	N	"N"
bac`teria	Number	"N(bac`terium).PL"
`basis	N	"N"
`bases	Number	"N(`basis).PL"
`basso	N	"N"
`bassi	Number	"N(`basso).PL"
ba`teau	N	"N"
ba`teaux	Number	"N(ba`teau).PL"
`beau	N	"N"
`beaux	Number	"N(`beau).PL"
`bronchus	N	"N"
`bronchi	Number	"N(`bronchus).PL"
`bursa	N	"N"
`bursae	Number	"N(`bursa).PL"
`cactus	N	"N"
`cacti	Number	"N(`cactus).PL"
`calculus	N	"N"
`calculi	Number	"N(`calculus).PL"
cande`labrum	N	"N"
cande`labra	Number	"N(cande`labrum).PL"
`cervix	N	"N"
`cervices	Number	"N(`cervix).PL"
cha`teau	N	"N"
cha`teaux	Number	"N(cha`teau).PL"
`cherub	N	"N"
`cherubim	Number	"N(`cherub).PL"
`cicatrix	N	"N"
cica`trices	Number	"N(`cicatrix).PL"
`cilium	N	"N"
`cilia	Number	"N(`cilium).PL"
`codex	N	"N"
`codices	Number	"N(`codex).PL"
col`loquium	N	"N"
col`loquia	Number	"N(col`loquium).PL"
`colossus	N	"N"
`colossi	Number	"N(`colossus).PL"
com`pendium	N	"N"
com`pendia	Number	"N(com`pendium).PL"
con`certo	N	"N"
con`certi	Number	"N(con`certo).PL"
con`tinuum	N	"N"
con`tinua	Number	"N(con`tinuum).PL"
`corpus	N	"N"
`corpora	Number	"N(`corpus).PL"
corri`gendum	N	"N"
corri`genda	Number	"N(corri`gendum).PL"
`cortex	N	"N"
`cortices	Number	"N(`cortex).PL"
`cranium	N	"N"
`crania	Number	"N(`cranium).PL"
`crisis	N	"N"
`crises	Number	"N(`crisis).PL"
cri`terion	N	"N"
cri`teria	Number	"N(cri`terion).PL"
`crocus	N	"N"
`croci	Number	"N(`crocus).PL"
cur`riculum	N	"N"
cur`ricula	Number	"N(cur`riculum).PL"
`datum	N	"N"
`data	Number	"N(`datum).SG/PL"
deside`ratum	N	"N"
deside`rata	Number	"N(deside`ratum).PL"
di`aeresis	N	"N"
di`aereses	Number	"N(di`aeresis).PL"
di`eresis	N	"N"
di`ereses	Number	"N(di`eresis).PL"
diag`nosis	N	"N"
diag`noses	Number	"N(diag`nosis).PL"
`dictum	N	"N"
`dicta	Number	"N(`dictum).PL"
di`rectrix	N	"N"
di`rectrices	Number	"N(di`rectrix).PL"
dodeca`hedron	N	"N"
dodeca`hedra	Number	"N(dodeca`hedron).PL"
ef`fluvium	N	"N"
ef`fluvia	Number	"N(ef`fluvium).PL"
el`lipsis	N	"N"
el`lipses	Number	"N(el`lipsis).PL"
`emphasis	N	"N"
`emphases	Number	"N(`emphasis).PL"
en`comium	N	"N"
en`comia	Number	"N(en`comium).PL"
e`phemeris	N	"N"
e`phemerides	Number	"N(e`phemeris).PL"
equi`librium	N	"N"
equi`libria	Number	"N(equi`librium).PL"
er`ratum	N	"N"
er`rata	Number	"N(er`ratum).PL"
e`sophagus	N	"N"
e`sophagi	Number	"N(e`sophagus).PL"
ex`tremum	N	"N"
ex`trema	Number	"N(ex`tremum).PL"
fas`ciculus	N	"N"
fas`ciculi	Number	"N(fas`ciculus).PL"
`focus	N-to-V	"N"
`foci	Number	"N(`focus).PL"
`formula	N	"N"
`formulae	Number	"N(`formula).PL"
`forum	N	"N"
`fora	Number	"N(`forum).PL"
`fovea	N	"N"
`foveae	Number	"N(`fovea).PL"
`frustum	N	"N"
`frusta	Number	"N(`frustum).PL"
`fungus	N	"N"
`fungi	Number	"N(`fungus).PL"
`ganglion	N	"N"
`ganglia	Number	"N(`ganglion).PL"
`genius	N	"N"
`genii	Number	"N(`genius).PL"
`genus	N	"N"
`genera	Number	"N(`genus).PL"
`goy	N	"N"
`goyim	Number	"N(`goy).PL"
graf`fito	N	"N"
graf`fiti	Number	"N(graf`fito).PL"
`hilum	N	"N"
`hila	Number	"N(`hilum).PL"
hippo`potamus	N	"N"
hippo`potami	Number	"N(hippo`potamus).PL"
hono`rarium	N	"N"
hono`raria	Number	"N(hono`rarium).PL"
hy`perbola	N	"N"
hy`perbolae	Number	"N(hy`perbola).PL"
hy`pothesis	N	"N"
hy`potheses	Number	"N(hy`pothesis).PL"
`incubus	N	"N"
`incubi	Number	"N(`incubus).PL"
`index	N-to-V	"N"
`indices	Number	"N(`index).PL"
inter`regnum	N	"N"
inter`regnna	Number	"N(inter`regnum).PL"
`isthmus	N	"N"
`isthmi	Number	"N(`isthmus).PL"
kib`butz	N	"N"
kib`butzim	Number	"N(kib`butz).PL"
la`cuna	N	"N"
la`cunae	Number	"N(la`cuna).PL"
la`mella	N	"N"
la`mellae	Number	"N(la`mella).PL"
`lamina	N	"N"
`laminae	Number	"N(`lamina).PL"
`larva	N	"N"
`larvae	Number	"N(`larva).PL"
`larynx	N	"N"
la`rynges	Number	"N(`larynx).PL"
`lexicon	N	"N"
`lexica	Number	"N(`lexicon).PL"
li`bretto	N	"N"
li`bretti	Number	"N(li`bretto).PL"
`lingua	N	"N"
`linguae	Number	"N(`lingua).PL"
`locus	N	"N"
`loci	Number	"N(`locus).PL"
lym`phoma	N	"N"
lympho`mata	Number	"N(lym`phoma).PL"
`madam	N	"N"
ma`dame	N	"N"
mes`dames	Number	"N(`madam/ma`dame).PL"
`maestro	N	"N"
`maestri	Number	"N(`maestro).PL"
`magus	N	"N"
`magi	Number	"N(`magus).PL"
`mantis	N	"N"
`mantes	Number	"N(`mantis).PL"
`mare	N	"N(`mare2)" ;sea on moon
`maria	Number	"N(`mare).PL"
`matrix	N	"N"
`matrices	Number	"N(`matrix).PL"
`maximum	N	"N"
`maxima	Number	"N(`maximum).PL"
`medium	N	"N(`medium1)" ;means of conveying
`media	Number	"N(`medium1).SG/PL"
mela`noma	N	"N"
melano`mata	Number	"N(mela`noma).PL"
`memorandum	N	"N"
`memoranda	Number	"N(`memorandum).PL"
me`niscus	N	"N"
me`nisci	Number	"N(me`niscus).PL"
mi`lieu	N	"N"
mi`lieux	Number	"N(mi`lieu).PL"
mil`lennium	N	"N"
mil`lennia	Number	"N(mil`lenium).PL"
`minimum	N	"N"
`minima	Number	"N(`minimum).PL"
mi`nutia	N	"N"
mi`nutiae	Number	"N(mi`nutia).PL"
`modulus	N	"N"
`moduli	Number	"N(`modulus).PL"
mo`mentum	N	"N"
mo`menta	Number	"N(mo`mentum).PL"
`money	N	"N"
`monies	Number	"N(`money).PL"
mon`sieur	N	"N"
mes`sieurs	Number	"N(mon`sieur).PL"
mora`torium	N	"N"
mora`toria	Number	"N(mora`torium).PL"
mu`cosa	N	"N"
mu`cosae	Number	"N(mu`cosa).PL"
`naiad	N	"N"
`naiades	Number	"N(`naiad).PL"
nar`cosis	N	"N"
nar`coses	Number	"N(nar`cosis).PL"
`nebula	N	"N"
`nebulae	Number	"N(`nebula).PL"
neu`rosis	N	"N"
neu`roses	Number	"N(neu`rosis).PL"
`nimbus	N	"N"
`nimbi	Number	"N(`nimbus).PL"
`nova	N	"N"
`novae	Number	"N(`nova).PL"
no`vella	N	"N"
no`velle	Number	"N(no`vella).PL"
nucle`olus	N	"N"
nucle`oli	Number	"N(nucle`olus).PL"
`nucleus	N	"N"
`nuclei	Number	"N(`nucleus).PL"
o`asis	N	"N"
o`ases	Number	"N(o`asis).PL"
octa`hedron	N	"N"
octa`hedra	Number	"N(octa`hedron).PL"
`octopus	N	"N"
`octopi	Number	"N(`octopus).PL"
`opus	N	"N"
`opera	Number	"N(`opus).PL"
`optimum	N	"N"
`optima	Number	"N(`optimum).PL"
`ovum	N	"N"
`ova	Number	"N(`ovum).PL"
pa`lazzo	N	"N"
pa`lazzi	Number	"N(pa`lazzo).PL"
pal`ladium	N	"N"
pal`ladia	Number	"N(pal`ladium).PL"
pan`jandrum	N	"N"
pan`jandra	Number	"N(pan`jandrum).PL"
papa`razzo	N	"N"
papa`razzi	Number	"N(papa`razzo).PL"
pa`pilla	N	"N"
pa`pillae	Number	"N(pa`pilla).PL"
papil`loma	N	"N"
papil`lomata	Number	"N(papil`loma).PL"
`pappus	N	"N"
`pappi	Number	"N(`pappus).PL"
pa`pyrus	N	"N"
pa`pyri	Number	"N(pa`pyrus).PL"
pa`ralysis	N	"N"
pa`ralyses	Number	"N(pa`ralysis).PL"
pa`renthesis	N	"N"
pa`rentheses	Number	"N(pa`renthesis).PL"
pe`numbra	N	"N"
pe`numbrae	Number	"N(pe`numbra).PL"
peri`helion	N	"N"
peri`helia	Number	"N(peri`helion).PL"
per`sona	N	"N"
per`sonae	Number	"N(per`sona).PL"
`phallus	N	"N"
`phalli	Number	"N(`phallus).PL"
phe`nomenon	N	"N"
phe`nomena	Number	"N(phe`nomenon).PL"
`phylum	N	"N"
`phyla	Number	"N(`phylum).PL"
pla`centa	N	"N"
pla`centae	Number	"N(pla`centa).PL"
plane`tarium	N	"N"
plane`taria	Number	"N(plane`tarium).PL"
`plenum	N	"N"
`plena	Number	"N(`plenum).PL"
`pleura	N	"N"
`pleurae	Number	"N(`pleura).PL"
`podium	N	"N"
`podia	Number	"N(`podium).PL"
`polis	N	"N"
`poleis	Number	"N(`polis).PL"
poly`hedron	N	"N"
poly`hedra	Number	"N(poly`hedron).PL"
portman`teau	N	"N"
portman`teaux	Number	"N(portman`teau).PL"
`precis	N	"N"
`precis	Number	"N(`precis).PL"
prog`nosis	N	"N"
prog`noses	Number	"N(prog`nosis).PL"
prole`gomenon	N	"N"
prole`gomena	Number	"N(prole`gomenon).PL"
pros`thesis	N	"N"
pros`theses	Number	"N(pros`thesis).PL"
psy`chosis	N	"N"
psy`choses	Number	"N(psy`chosis).PL"
`pupa	N	"N"
`pupae	Number	"N(`pupa).PL"
quad`rennium	N	"N"
quad`rennia	Number	"N(quad`rennium).PL"
quad`riga	N	"N"
quad`rigae	Number	"N(quad`riga).PL"
`quantum	N	"N"
`quanta	Number	"N(`quantum).PL"
quet`zal	N	"N"
quet`zales	Number	"N(quet`zal).PL"
`radix	N	"N"
`radices	Number	"N(`radix).PL"
`radius	N	"N"
`radii	Number	"N(`radius).PL"
`rectum	N	"N"
`recta	Number	"N(`rectum).PL"
refer`endum	N	"N"
refer`enda	Number	"N(refer`endum).PL"
`rendezvous	N-to-V	"N.SG/PL"
re`siduum	N	"N"
re`sidua	Number	"N(re`siduum).PL"
rhi`noceros	N	"N"
rhi`noceri	Number	"N(rhi`noceros).PL"
`rhombus	N	"N"
`rhombi	Number	"N(`rhombus).PL"
`rostrum	N	"N"
`rostra	Number	"N(`rostrum).PL"
sana`tarium	N	"N"
sana`taria	Number	"N(sana`tarium).PL"
sani`tarium	N	"N"
sani`taria	Number	"N(sana`tarium).PL"
sana`torium	N	"N"
sana`toria	Number	"N(sana`torium).PL"
sani`torium	N	"N"
sani`toria	Number	"N(sana`torium).PL"
sar`coma	N	"N"
sarco`mata	Number	"N(sar`coma).PL"
`scapula	N	"N"
`scapulae	Number	"N(`scapula).PL"
`schema	N	"N"
sche`mata	Number	"N(`schema).PL"
`scherzo	N	"N"
`scherzi	Number	"N(`scherzo).PL"
`scoria	N	"N"
`scoriae	Number	"N(`scoria).PL"
scrip`torium	N	"N"
scrip`toria	Number	"N(scrip`torium).PL"
`scrotum	N	"N"
`scrota	Number	"N(`scrotum).PL"
`scutum	N	"N"
`scuta	Number	"N(`scutum).PL"
`septum	N	"N"
`septa	Number	"N(`septum).PL"
`seraph	N	"N"
`seraphim	Number	"N(`seraph).PL"
`serum	N	"N"
`sera	Number	"N(`serum).PL"
`solidus	N	"N"
`solidi	Number	"N(`solidus).PL"
`soma	N	"N"
so`mata	Number	"N(`soma).PL"
`spectrum	N	"N"
`spectra	Number	"N(`spectrum).PL"
sov`khoz	N	"N"
sov`khozy	Number	"N(sov`khoz).PL"
`spectrum	N	"N"
`spectra	Number	"N(`spectrum).PL"
`speculum	N	"N"
`specula	Number	"N(`speculum).PL"
`sputum	N	"N"
`sputa	Number	"N(`sputum).PL"
`stadium	N	"N"
`stadia	Number	"N(`stadium).PL"
staphylo`coccus	N	"N"
staphylo`cocci	Number	"N(staphylo`coccus).PL"
`stasis	N	"N"
`stases	Number	"N(`stasis).PL"
`sternum	N	"N"
`sterna	Number	"N(`sternum).PL"
`stigma	N	"N"
stig`mata	Number	"N(`stigma).PL"
`stimulus	N	"N"
`stimuli	Number	"N(`stimulus).PL"
`stratum	N	"N"
`strata	Number	"N(`stratum).PL"
strepto`coccus	N	"N"
strepto`cocci	Number	"N(strepto`coccus).PL"
`stretto	N	"N"
`stretti	Number	"N(`stretto).PL"
`stria	N	"N"
`striae	Number	"N(`stria).PL"
`stylus	N	"N"
`styli	Number	"N(`stylus).PL"
`succubus	N	"N"
`succubi	Number	"N(`succubus).PL"
`syllabus	N	"N"
`syllabi	Number	"N(`syllabus).PL"
sym`posium	N	"N"
sym`posia	Number	"N(sym`posium).PL"
syn`apsis	N	"N"
syn`apses	Number	"N(syn`apsis).PL"
syn`opsis	N	"N"
syn`opses	Number	"N(syn`opsis).PL"
`synthesis	N	"N"
`syntheses	Number	"N(`synthesis).PL"
`syrinx	N	"N"
sy`ringes	Number	"N(`syrinx).PL"
tab`leau	N	"N"
tab`leaux	Number	"N(tab`leau).PL"
`talus	N	"N"
`tali	Number	"N(`talus).PL"
`tectum	N	"N"
`tecta	Number	"N(`tectum).PL"
`tempo	N	"N"
`tempi	Number	"N(`tempo).PL"
`terminus	N	"N"
`termini	Number	"N(`terminus).PL"
ter`rarium	N	"N"
ter`raria	Number	"N(ter`rarium).PL"
`testis	N	"N"
`testes	Number	"N(`testis).PL"
tetra`hedron	N	"N"
tetra`hedra	Number	"N(tetra`hedron).PL"
`thalamus	N	"N"
`thalami	Number	"N(`thalamus).PL"
the`saurus	N	"N"
the`sauri	Number	"N(the`saurus).PL"
`thesis	N	"N"
`theses	Number	"N(`thesis).PL"
`thorax	N	"N"
`thoraces	Number	"N(`thorax).PL"
throm`bosis	N	"N"
throm`boses	Number	"N(throm`bosis).PL"
`tibia	N	"N"
`tibiae	Number	"N(`tibia).PL"
`torso	N	"N"
`torsi	Number	"N(`torso).PL"
`torus	N	"N"
`tori	Number	"N(`torus).PL"
`trachea	N	"N"
`tracheae	Number	"N(`trachea).PL"
tra`pezium	N	"N"
tra`pezia	Number	"N(tra`pezium).PL"
`trauma	N	"N"
trau`mata	Number	"N(`trauma).PL"
trous`seau	N	"N"
trous`seaux	Number	"N(trous`seau).PL"
ultima`tum	N	"N"
ultima`ta	Number	"N(ultima`tum).PL"
umbi`licus	N	"N"
umbi`lici	Number	"N(umbi`licus).PL"
`umbra	N	"N"
`umbrae	Number	"N(`umbra).PL"
u`rethra	N	"N"
u`rethrae	Number	"N(u`rethra).PL"
`uterus	N	"N"
`uteri	Number	"N(`uterus).PL"
`uvula	N	"N"
`uvulae	Number	"N(`uvula).PL"
va`gina	N	"N"
va`ginae	Number	"N(va`gina).PL"
`vas	N	"N"
`vasa	Number	"N(`vas).PL"
`velum	N	"N"
`vela	Number	"N(`velum).PL"
`vena	N	"N"
`venae	Number	"N(`vena).PL"
`vertebra	N	"N"
`vertebrae	Number	"N(`vertebra).PL"
`vertex	N	"N"
`vertices	Number	"N(`vertex).PL"
virtu`oso	N-to-AJ	"N"
virtu`osa	N	"N"
virtu`osi	Number	"N(virtu`oso).PL"
`viscus	N	"N"
`viscera	Number	"N(`viscus).PL"
`vita	N	"N"
`vitae	Number	"N(`vita).PL"
`vortex	N	"N"
`vortices	Number	"N(`vortex).PL"
ye`shiva	N	"N"
yeshi`voth	Number	"N(ye`shiva).PL"

;zero plurals
`antelope	N	"N.SG/PL"
`bison	N	"N.SG/PL"
`caribou	N	"N.SG/PL"
`cod	N	"N.SG/PL"
`deer	N	"N.SG/PL"
`elk	N	"N.SG/PL"
`fish	N-to-V	"N.SG/PL"
`flounder	N	"N.SG/PL"
ga`zelle	N	"N.SG/PL"
`grouse	N	"N.SG/PL"
`herring	N	"N.SG/PL"
`mackerel	N	"N.SG/PL"
men`haden	N	"N.SG/PL"
`moose	N	"N.SG/PL"
`muskellunge	N	"N.SG/PL"
`quail	N	"N.SG/PL"
`reindeer	N	"N.SG/PL"
`salmon	N	"N.SG/PL"
`scabies	N	"N.SG/PL"
`sheep	N	"N.SG/PL"
`shrimp	N	"N.SG/PL"
`smelt	N	"N.SG/PL"
`starfish	N	"N.SG/PL"
`swine	N	"N.SG/PL"
`thrips	N	"N.SG/PL"
`trout	N	"N.SG/PL"
`tuna	N	"N.SG/PL"
`woodcock	N	"N.SG/PL"
zuc`chini	N	"N.SG/PL"

;equivocal number
;some should have Number as continuation
`barracks	N	"N.SG/PL"
`bellows	N	"N.SG/PL"
`biceps	N	"N.SG/PL"
`checkers	N	"N.SG/PL"
`contretemps	N	"N.SG/PL"
`corps	N	"N.SG/PL"
`craft	N	"N.SG/PL"
`crossroads	N	"N.SG/PL"
down`stairs	N	"N.SG/PL"
`fowl	N	"N.SG/PL"
`gallows	N	"N.SG/PL"
`headquarters	N	"N.SG/PL"
`humankind	N	"N.SG/PL"
`hustings	N	"N.SG/PL"
in`signia	N	"N.SG/PL"
`kennels	N	"N.SG/PL"
`lazybones	N	"N.SG/PL"
`links	N	"N.SG/PL"
`mankind	N	"N.SG/PL"
`means	N	"N.SG/PL"
`measles	N	"N.SG/PL"
`military	N	"N.SG/PL"
`mumps	N	"N.SG/PL"
`oats	N	"N.SG/PL"
`offspring	N	"N.SG/PL"
parapher`nalia	N	"N.SG/PL"
person`nel	N	"N.SG/PL"
`poultry	N	"N.SG/PL"
`pox	N	"N.SG/PL"
`quadriceps	N	"N.SG/PL"
`rapids	N	"AJ(`rapid).NR0.SG/PL"
`series	N	"N.SG/PL"
`sixpence	N	"N.SG/PL"
`species	N	"N.SG/PL"
`staff	N-to-V	"N(`staff2).SG/PL"
`suds	N-to-V	"N.SG/PL"
`works	N	"N.SG/PL"
`timpani	N	"N.SG/PL"
`triceps	N	"N.SG/PL"
up`stairs	N	"N.SG/PL"
vespers	N	"N.SG/PL"
`vermin	N	"N.SG/PL"

;invariable plurals
;summation plurals
`bellows	Number	"N.PL"
bi`noculars	Number	"N.PL"
`bloomers	Number	"N.PL"
`braces	Number	"N.PL" ;british
;`breeches	Number	"N.PL"
`briefs	Number	"N.PL"
`britches	Number	"N.PL"
`clippers	Number	"N.PL"
`flannels	Number	"N.PL"
`forceps	Number	"N.PL"
`glasses	Number	"N.PL"
`innards	Number	"N.PL"
`jeans	Number	"N.PL"
`knickers	Number	"N.PL"
`pants	Number	"N.PL"
pa`jamas	Number	"N.PL"
`pincers	Number	"N.PL"
`pliers	Number	"N.PL"
py`jamas	Number	"N.PL"
`scales	Number	"N.PL" ;a balance
`scissors	Number	"N.PL"
`shears	Number	"N.PL"
`shorts	Number	"N.PL"
`slacks	Number	"N.PL"
`spectacles	Number	"N.PL"
`sunglasses	Number	"N.PL"
sus`penders	Number	"N.PL"
`tights	Number	"N.PL"
`togs	Number	"N.PL"
`tongs	Number	"N.PL"
`trousers	Number	"N.PL"
`trunks	Number	"N.PL"
`tweezers	Number	"N.PL"

;pluralia tantum
`alms	Number	"N.PL"
a`mends	Number	"N.PL"
`annals	Number	"N.PL"
ar`rears	Number	"N.PL"
`auspices	Number	"N.PL"
`banns	Number	"N.PL"
`clothes	Number	"N.PL"
`confines	Number	"V(con`fine).NR0.PL"
cre`dentials	Number	"N.PL"
`doldrums	Number	"N.PL"
`dregs	Number	"N.PL"
`entrails	Number	"N.PL"
`fixings	Number	"N.PL"
`goods	Number	"N.PL"
`housewares	Number	"N.PL"
hu`manities	Number	"N.PL"
`maths	Number	"N.PL" ;British
`odds	Number	"N.PL"
`oodles	Number	"N.PL"
par`ticulars	Number	"N.PL"
re`gards	Number	"N.PL"
re`mains	Number	"N.PL"
`riches	Number	"N.PL"
smither`eens	Number	"N.PL"
sur`roundings	Number	"N.PL"
`thanks	Number	"N.PL"
`troops	Number	"N.PL"
`valuables	Number	"N.PL"

;irregular pluralia tantum?
an`tipodes	Number	"N.PL"
ar`cana	Number	"N.PL"
at`lantes	Number	"N.PL"
e`rotica	Number	"N.PL"
ex`otica	Number	"N.PL"
`flora	Number	"N.PL"
`fauna	Number	"N.PL"
margi`nalia	Number	"N.PL"
memora`bilia	Number	"N.PL"
miscel`lanea	Number	"N.PL"
re`galia	Number	"N.PL"
`schlieren	Number	"N.PL"
`trivia	Number	"N.PL"

;unmarked plural nouns
`cattle	Number	"N.PL"
`faculty	Number	"N(`faculty2).PL" ;teachers
`folk	N	"N.SG/PL"
`kine	Number	"N.PL" ;archaic plural of cow
`kinfolk	N	"N.SG/PL"
`kinsfolk	N	"N.SG/PL"
`livestock	Number	"N.PL"
`menfolk	Number	"N.PL"
`people	N-to-V	"N.PL"
po`lice	N-to-V	"N.PL"
`townspeople	Number	"N.PL"
`womenfolk	Number	"N.PL"

;Final_y nouns
`alchem	Final_y	"N"
amphi`bolog	Final_y	"N"
a`natom	Final_y	"N"
ani`sotrop	Final_y	"N"
an`tholog	Final_y	"N"
anthro`polog	Final_y	"N"
archae`olog	Final_y	"N"
arche`olog	Final_y	"N"
assyri`olog	Final_y	"N"
as`trolog	Final_y	"N"
as`tronom	Final_y	"N"
a`synchron	Final_y	"N"
au`tonom	Final_y	"N"
axi`olog	Final_y	"N"
bibli`ograph	Final_y	"N"
bi`ograph	Final_y	"N"
bi`olog	Final_y	"N"
bi`ometr	Final_y	"N"
`botan	Final_y	"N"
ca`cophon	Final_y	"N"
cardi`olog	Final_y	"N"
car`tograph	Final_y	"N"
cet`olog	Final_y	"N"
chemo`therap	Final_y	"N"
chore`ograph	Final_y	"N"
chro`nolog	Final_y	"N"
clima`tolog	Final_y	"N"
cos`mogon	Final_y	"N"
cos`molog	Final_y	"N"
cryp`tograph	Final_y	"N"
cryp`tolog	Final_y	"N"
crystal`lograph	Final_y	"N"
cy`tolog	Final_y	"N"
de`mograph	Final_y	"N"
derma`tolog	Final_y	"N"
di`achron	Final_y	"N"
dialec`tolog	Final_y	"N"
`diatherm	Final_y	"N"
di`chotom	Final_y	"N"
e`colog	Final_y	"N"
e`conom	Final_y	"N"
`empath	Final_y	"N"
en`dogam	Final_y	"N"
ento`molog	Final_y	"N"
enzy`molog	Final_y	"N"
epidemi`olog	Final_y	"N"
episte`molog	Final_y	"N"
eth`nograph	Final_y	"N"
eth`nolog	Final_y	"N"
e`tholog	Final_y	"N"
eti`olog	Final_y	"N"
ety`molog	Final_y	"N"
ex`ogam	Final_y	"N"
gas`tronom	Final_y	"N"
gene`alog	Final_y	"N"
ge`odes	Final_y	"N"
ge`ograph	Final_y	"N"
ge`olog	Final_y	"N"
ge`ometr	Final_y	"N"
geron`tolog	Final_y	"N"
gyne`colog	Final_y	"N"
herpe`tolog	Final_y	"N"
his`tolog	Final_y	"N"
histori`ograph	Final_y	"N"
home`opath	Final_y	"N"
ho`molog	Final_y	"N"
ho`rolog	Final_y	"N"
hy`drolog	Final_y	"N"
hyste`rectom	Final_y	"N"
ichthy`olog	Final_y	"N"
ide`olog	Final_y	"N"
immun`olog	Final_y	"N"
i`sotrop	Final_y	"N"
lexi`cograph	Final_y	"N"
lexi`colog	Final_y	"N"
li`tholog	Final_y	"N"
lo`botom	Final_y	"N"
ma`jest	Final_y	"N"
metal`lograph	Final_y	"N"
`metallurg	Final_y	"N"
metho`dolog	Final_y	"N"
meteo`rolog	Final_y	"N"
me`tonym	Final_y	"N"
miner`alog	Final_y	"N"
mi`sogam	Final_y	"N"
mi`sogyn	Final_y	"N"
mo`nogam	Final_y	"N"
mor`pholog	Final_y	"N"
musi`colog	Final_y	"N"
my`colog	Final_y	"N"
myth`olog	Final_y	"N"
neuroa`natom	Final_y	"N"
neu`rolog	Final_y	"N"
neuropa`tholog	Final_y	"N"
neurophysi`olog	Final_y	"N"
numer`olog	Final_y	"N"
ocean`ograph	Final_y	"N"
on`colog	Final_y	"N"
on`togen	Final_y	"N"
on`tolog	Final_y	"N"
ophthal`molog	Final_y	"N"
op`tometr	Final_y	"N"
or`thograph	Final_y	"N"
oste`olog	Final_y	"N"
orni`tholog	Final_y	"N"
o`rograph	Final_y	"N"
path`olog	Final_y	"N"
`pedagog	Final_y	"N"
pet`rolog	Final_y	"N"
pharma`colog	Final_y	"N"
phenomen`olog	Final_y	"N"
phi`lanthrop	Final_y	"N"
phi`lolog	Final_y	"N"
phi`losoph	Final_y	"N"
pho`nolog	Final_y	"N"
phrase`olog	Final_y	"N"
phren`olog	Final_y	"N"
phy`logen	Final_y	"N"
physi`ognom	Final_y	"N"
physi`olog	Final_y	"N"
physio`therap	Final_y	"N"
po`lygyn	Final_y	"N"
po`lyphon	Final_y	"N"
por`nograph	Final_y	"N"
psy`chiatr	Final_y	"N"
psy`cholog	Final_y	"N"
psy`chometr	Final_y	"N"
radioas`tronom	Final_y	"N"
radi`ograph	Final_y	"N"
radi`olog	Final_y	"N"
radio`therap	Final_y	"N"
rhe`olog	Final_y	"N"
seis`molog	Final_y	"N"
se`rolog	Final_y	"N"
soci`olog	Final_y	"N"
soci`ometr	Final_y	"N"
sten`ograph	Final_y	"N"
stere`ograph	Final_y	"N"
stere`oscop	Final_y	"N"
stoichi`ometr	Final_y	"N"
`symmetr	Final_y	"N"
`sympath	Final_y	"N"
`symphon	Final_y	"N"
tau`tolog	Final_y	"N"
`taxiderm	Final_y	"N"
tax`onom	Final_y	"N"
tech`nolog	Final_y	"N"
tele`olog	Final_y	"N"
te`lepath	Final_y	"N"
tera`tolog	Final_y	"N"
termi`nolog	Final_y	"N"
thana`tolog	Final_y	"N"
the`olog	Final_y	"N"
the`osoph	Final_y	"N"
to`mograph	Final_y	"N"
to`pograph	Final_y	"N"
to`polog	Final_y	"N"
toxi`colog	Final_y	"N"
trigo`nometr	Final_y	"N"
ty`pograph	Final_y	"N"
ty`polog	Final_y	"N"
ur`olog	Final_y	"N"
xe`rograph	Final_y	"N"
zo`olog	Final_y	"N"

;regular plurals
;Greek alphabet
;some are commented out to avoid multiple parses
`alpha	N	"N"
`beta	N	"N"
`gamma	N	"N"
;`delta	N	"N"
`epsilon	N	"N"
`zeta	N	"N"
`eta	N	"N"
`theta	N	"N"
i`ota	N	"N"
`kappa	N	"N"
`lambda	N	"N"
;mu	N	"N"
;nu	N	"N"
;xi	N	"N"
`omicron	N	"N"
;pi	N	"N"
rho	N	"N"
`sigma	N	"N"
tau	N	"N"
`upsilon	N	"N"
phi	N	"N"
chi	N	"N"
psi	N	"N"
o`mega	N	"N"

`aardvark	N	"N"
`a-bomb	N	"N"
`abalone	N	"N"
`aberrance	N	"AJ(a`berrant)+NR41"
`aberrancy	N	"AJ(a`berrant)+NR40"
ab`be	N	"N"
`abbey	N	"N"
`abbot	N	"N"
a`beyance	N	"N"
`abdomen	N	"N"
a`bility	N	"AJ(`able)+NR21"
ab`lution	N	"N"
a`bode	N	"N"
abo`lition	N	"V(a`bolish)+NR23"
abo`rigine	N	"N"
a`bridgment	N	"V(a`bridge)+NR25" ;exception to Elision
a`brasion	N	"V(a`brade)+NR23"
`abscess	N	"N"
`absence	N	"N"
`absinthe	N	"N"
`absolute	N	"N"
abso`lution	N	"V(ab`solve)+NR23"
ab`sorbency	N	"V(ab`sorb)+AJR27+NR40"
ab`sorption	N	"V(ab`sorb)+NR23"
ab`stention	N	"V(ab`stain)+NR23"
abstinence	N	"V(ab`stain)+NR26"
`abstract	N	"V(ab`stract).NR0"
a`bundance	N	"V(a`bound)+NR26"
a`buse	N	"V(a`buse).NR0" ;[a`byus]
a`byss	N	"N"
`academe	N	"N"
aca`demia	N_Suffix1a	"N(`academe)+NR61"
aca`demic	N	"N"
a`cademy	N	"N"
acceler`ometer	N	"N"
`accent	N-to-V	"N"
`access	N-to-V	"N"
ac`cessory	N	"N"
`accident	N	"N"
accla`mation	N	"V(ac`claim)+NR23"
`accolade	N	"N"
ac`companist	N_Suffix1a	"V(ac`company)+NR31"
ac`complice	N	"N"
ac`cordion	N	"N"
ac`count	N	"N"
`accuracy	N	"AJ(`accurate)+NR40"
`ace	N	"N"
a`cerbity	N	"AJ(a`cerbic)+NR21"
`acetate	N	"N"
a`cetic	N	"N"
`acetone	N	"N"
a`cetylene	N	"N"
acknowledgment	N	"V(ac`knowledge)+NR25"
`acme	N	"N"
`acne	N	"N"
`acolyte	N	"N"
`acorn	N	"N"
acqui`escence	N	"V(ac`quiesce)+AJR27+NR41"
acqui`sition	N	"V(ac`quire)+NR23"
`actuary	N	"N"
`acre	N	"N"
`acreage	N_Suffix1a	"N(`acre)+NR1"
`acrimony	N	"N"
`acrobat	N	"N"
`acronym	N	"N"
a`cropolis	N	"N"
a`crostic	N	"N"
`actress	N_Suffix1a	"N(`actor)+NR12"
a`cuity	N	"N"
`acumen	N	"N"
`acupuncture	N	"N"
`adage	N	"N"
`addend	N	"N"
`addict	N	"V(ad`dict).NR0"
`address	N	"N"
`adequacy	N	"AJ(`adequate)+NR40"
ad`hesion	N	"V(ad`here)+NR23"
ad`herent	N	"V(ad`here)+NR17"
ad`jacency	N	"AJ(ad`jacent)+NR40"
`adjective	N	"N"
`adjunct	N	"N"
ad`jutant	N	"N"
adminis`tration	N	"V(ad`minister)+NR23"
adminis`tratrix	N	"N"
`admiral	N	"N"
`admiralty	N	"N"
admissi`bility	N	"V(ad`mit)+NR23+AJR25+NR21"
ad`mission	N	"V(ad`mit)+NR23"
ad`mixture	N	"N"
admo`nition	N	"V(ad`monish)+NR23"
a`do	N	"N"
a`dobe	N	"N"
ado`lescence	N	"AJ(ado`lescent)+NR41"
a`drenaline	N	"N"
ad`sorption	N	"V(ad`sorb)+NR23"
a`dulterer	N	"N(a`dultery)+NR19"
a`dulteress	N_Suffix1a	"N(a`dultery)+NR12"
a`dultery	N	"N"
ad`vantage	N	"N"
`advent	N	"N"
ad`venture	N	"N"
ad`venturer	N	"N(ad`venture)+NR19"
`adverb	N	"N"
`adversary	N	"AJ(ad`verse)+NR39"
ad`vice	N	"N"
;ad`visory	N	"V(ad`vise)+NR34"
`advocacy	N	"V(`advocate)+NR40"
`advocate	N	"V(`advocate).NR0" ;[-@t]
`aegis	N	"N"
`aeropark	N	"N"
`aerosol	N	"N"
`aerospace	N-to-AJ	"N"
`aesthete	N	"N"
af`fair	N	"N"
`affect	N	"N"
affi`davit	N	"N"
af`fine	N-to-AJ	"N"
af`finity	N	"N"
`affix	N	"V(af`fix).NR0"
`affluence	N	"N"
`affricate	N	"N"
aficio`nado	N	"N"
`afro	N	"N"
`afterbirth	N	"N"
`aftereffect	N	"N"
`afterglow	N	"N"
`afterimage	N	"N"
`afterlife	N	"N"
`aftermarket	N	"N"
`aftermath	N	"N"
after`noon	N	"N"
`aftershock	N	"N"
`aftertaste	N	"N"
`afterthought	N	"N"
`aftertime	N	"N"
`agate	N	"N"
`age	N-to-V	"N"
`ageism	N_Suffix1b	"N(`age)+NR8"
a`genda	N	"N"
`agent	N	"N"
ag`gression	N	"N"
ag`gressor	N	"N"
ag`nostic	N	"N"
`agony	N	"N"
`agribusiness	N	"N"
`agriculture	N	"N"
`agrimony	N	"N"
a`gue	N	"N"
`aide	N	"N"
`aileron	N	"N"
`air	N-to-V	"N"
`airbag	N	"N"
`aircraft	N	"N"
`airfare	N	"N"
`airfield	N	"N"
`airflow	N	"N"
`airfoil	N	"N"
`airframe	N	"N"
`airlift	N	"N"
`airline	N	"N"
`airliner	N	"N"
`airlock	N	"N"
`airmass	N	"N"
`airpark	N	"N"
`airplane	N	"N"
`airport	N	"N"
`airspace	N	"N"
`airspeed	N	"N"
`airstrip	N	"N"
`airway	N	"N"
`aisle	N	"N"
`alabaster	N	"N"
a`lacrity	N	"N"
`alb	N	"N"
`albacore	N	"N"
`albatross	N	"N"
`album	N	"N"
al`bumin	N	"N"
`alcohol	N	"N"
alco`holic	N	"N(`alcohol)+AJR20.NR0"
`alcove	N	"N"
`alder	N	"N"
`ale	N	"N"
`aleph	N	"N"
a`lert	N	"AJ(a`lert)+VR0.NR0"
al`falfa	N	"N"
`algebra	N	"N"
`algorithm	N	"N"
`alias	N	"N"
`alibi	N	"N"
`alien	N-to-AJ	"N"
`alimony	N	"N"
`alkali	N	"N"
`alkaloid	N	"N"
alle`gation	N	"V(al`lege)+NR23" ;exception to Elision
al`legiance	N	"AJ(al`legiant)+NR41"
`allegory	N	"N"
alle`mand	N	"N"
`allergist	N_Suffix1a	"N(`allergy)+NR31"
`allergy	N	"N"
`alley	N	"N"
`alleyway	N	"N"
`alligator	N	"N"
`allophone	N	"N"
`allomorph	N	"N"
`alloy	N-to-V	"N"
`allspice	N	"N"
al`lusion	N	"V(al`lude)+NR23"
al`luvium	N	"N"
`almanac	N	"N"
`almond	N	"N"
`aloe	N	"N"
`alphabet	N	"N"
`altar	N	"N"
`alternant	N	"N"
al`ternative	N	"V(`alternate)+AJR26.NR0"
al`timeter	N	"N"
`altitude	N	"N"
`alto	N	"N"
`altruism	N	"N"
`altruist	N	"N"
`alum	N	"N"
a`luminum	N	"N"
a`lyssum	N	"N"
a`malgam	N	"N"
`amateur	N-to-AJ	"N"
am`bassador	N	"N"
`ambergris	N	"N"
`ambiance	N	"N"
ambi`guity	N	"N"
am`bition	N	"N"
ambivalence	N	"AJ(am`bivalent)+NR41"
am`brosia	N	"N"
`ambulance	N	"N"
`ambuscade	N	"N"
a`menity	N	"N"
`amethyst	N	"N"
a`migo	N	"N"
`amity	N	"N"
`ammeter	N	"N"
`ammo	N	"N"
am`monia	N	"N"
ammu`nition	N	"N"
am`nesia	N	"N"
`amnesty	N	"N"
a`mount	N-to-V	"N"
a`mour	N	"N"
`amp	N	"N"
`ampere	N	"N"
`amperage	N_Suffix1a	"N(`ampere)+NR1"
`ampersand	N	"N"
am`phetamine	N	"N"
am`phibian	N	"N"
`amphitheater	N	"N"
`amplitude	N	"N"
ampu`tee	N	"N"
`amulet	N	"N"
a`nachronism	N	"N"
ana`conda	N	"N"
anaes`thesia	N	"N"
`anaglyph	N	"N"
`anagram	N	"N"
`analogue	N	"N"
`analog	N-to-AJ	"N"
`analogue	N	"N"
a`nalogy	N	"N"
`analyst	N	"N"
a`naphora	N	"N"
`anarch	N	"N"
`anarchy	N	"N"
a`nathema	N	"N"
`ancestor	N	"N"
`ancestress	N	"N(`ancestor)+NR12"
`ancestry	N	"N"
`anchor	N-to-V	"N"
`anchovy	N	"N"
`andiron	N	"N"
`anecdote	N	"N"
a`nemone	N	"N"
anes`thesia	N	"N"
`angel	N	"N"
`anger	N-to-V	"N"
`angiosperm	N	"N"
`angle	N-to-V	"N"
`angst	N	"N"
`angstrom	N	"N"
`anguish	N	"N"
`animal	N	"N"
`animism	N	"N"
ani`mosity	N	"N"
`anion	N	"N"
`anise	N	"N"
`ankle	N	"N"
`annex	N	"N"
`anniversary	N	"N"
an`nuity	N	"N"
`anode	N	"N"
a`nomaly	N	"N"
ano`nymity	N	"N"
ano`rexia	N	"N"
`ant	N	"N"
ant`acid	N	"ORI1+N(`acid)"
an`tagonism	N	"N"
an`tagonist	N	"N"
`ante	N-to-V	"N"
`anteater	N	"N"
ante`cedent	N	"N"
`anteroom	N	"N"
`anthem	N	"N"
`anther	N	"N"
`anthracite	N	"N"
anthropo`morphism	N	"N"
;`anti	N	"N"
antibi`otic	N	"AJ(antibi`otic).NR0"
`antic	N	"N"
`antidote	N	"N"
`antigen	N	"N"
`antimony	N	"N"
anti`pasto	N	"N"
an`tipathy	N	"N"
anti`quarian	N-to-AJ	"N"
an`tique	N-to-AJ	"N"
`antler	N	"N"
`antonym	N	"N"
anunci`ation	N	"V(an`nounce)+NR23"
`anus	N	"N"
`anvil	N	"N"
anx`iety	N	"N"
a`orta	N	"N"
a`partheid	N	"N"
a`partment	N	"N"
`apathy	N	"N"
`ape	N-to-V	"N"
`aperture	N	"N"
a`phasia	N	"N"
`aphid	N	"N"
`aphorism	N	"N"
a`plomb	N	"N"
apo`logia	N	"N"
a`pocalypse	N	"N"
`apogee	N	"N"
a`pology	N	"N"
a`pologist	N_Suffix1a	"N(a`pology)+NR31"
`apoplexy	N	"N"
a`postate	N-to-AJ	"N"
a`postle	N	"N"
a`postrophe	N	"N"
a`pothecary	N	"N"
`apothegm	N	"N"
apothe`osis	N	"N"
appa`ratus	N	"N"
ap`parel	N-to-V	"N"
appa`rition	N	"N"
ap`pellant	N-to-AJ	"V(ap`peal)+NR17"
appel`lation	N	"N"
;ap`pendage	N_Suffix1a	"V(ap`pend)+NR1"
appendi`citis	N	"N(ap`pendix)+NR50"
apper`ception	N	"N"
`appetite	N	"N"
`appetizer	N	"N"
ap`plause	N	"N"
`apple	N	"N"
`applejack	N	"N"
ap`pliance	N	"N"
`applicant	N	"V(ap`ply)+NR17"
applica`bility	N	"V(ap`ply)+AJR25+NR21"
appli`cation	N	"V(ap`ply)+NR23"
`applicator	N	"N"
`applique	N-to-V	"N"
appo`sition	N	"N"
appre`hension	N	"V(appre`hend)+NR23"
ap`prentice	N	"N"
ap`proximant	N	"N"
`apricot	N	"N"
`apron	N	"N"
`apse	N	"N"
`aptitude	N	"N"
`aqueduct	N	"N"
`aquifer	N	"N"
ar`moire	N	"N"
ara`besque	N	"N"
a`rachnid	N	"N"
`arbiter	N	"N"
`arbitrage	N	"N"
`arbor	N	"N"
arbo`retum	N	"N"
`arc	N-to-V	"N"
ar`cade	N	"N"
`arch	N-to-V	"N"
ar`chaism	N	"N"
`archery	N	"N"
`archetype	N	"DEG1+N(`type)"
`architect	N	"N"
`architecture	N	"N"
`archive	N-to-V	"N"
`ardency	N	"AJ(`ardent)+NR40"
`ardor	N	"N"
`ardour	N	"N" ;British
`area	N	"N"
`areaway	N	"N"
a`rena	N	"N"
`argon	N	"N"
`argosy	N	"N"
`argot	N	"N"
`argument	N	"V(`argue)+NR25" ;exception to Elision
argumen`tation	N	"V(`argue)+NR25+NR23"
`arhat	N	"N"
aris`tocracy	N	"N(a`ristocrat)+NR40"
a`ristocrat	N	"N"
a`rithmetic	N	"N"
`ark	N	"N"
`arm	N	"N(`arm1)" ;body part
`arm	N-to-V	"N(`arm2)" ;gun
ar`mada	N	"N"
arma`dillo	N	"N"
`armament	N	"N"
`armature	N	"N"
`armchair	N	"N"
`armful	N_Suffix1a	"N(`arm)+NR5"
`armhole	N	"N"
`armistice	N	"N"
`armload	N	"N"
`armor	N-to-V	"N"
`armour	N-to-V	"N"
`armpit	N	"N"
`army	N	"N"
a`roma	N	"N"
ar`peggio	N	"N"
`arrack	N	"N"
ar`ray	N	"N"
ar`rear	N	"N"
`arrogance	N	"AJ(`arrogant)+NR41"
`arrow	N	"N"
`arrowhead	N	"N"
ar`royo	N	"N"
`arsenal	N	"N"
`arsenic	N	"N"
`arson	N	"N"
`art	N	"N"
arterio`sclerosis	N	"N"
`artery	N	"N"
arth`ritis	N	"N"
`artichoke	N	"N"
`article	N	"N"
`artifact	N	"N"
`artifice	N	"N"
ar`tillery	N	"N"
`artisan	N	"N"
`artistry	N_Suffix1a	"N(`art)+NR31+NR3"
`artwork	N	"N"
as`bestos	N	"N"
as`cendancy	N	"V(as`cend)+NR23+AJR27+NR40"
as`cension	N	"V(as`cend)+NR23"
as`cent	N	"N"
as`cetic	N	"AJ(as`cetic).NR0"
as`cription	N	"V(as`cribe)+NR23"
`ash	N	"N"
`ashtray	N	"N"
as`paragus	N	"N"
`aspect	N	"N"
`aspen	N	"N"
as`perity	N	"N"
as`persion	N	"N"
`asphalt	N	"N"
`aspirant	N	"N"
`aspirate	N	"N" ;[-@t]
`aspirin	N	"N"
`ass	N	"N"
as`sassin	N	"N"
`asset	N	"N"
;as`semblage	N_Suffix1a	"V(as`semble)+NR1"
as`sembly	N	"V(as`semble)+NR35"
assi`duity	N	"N"
`assonance	N	"AJ(`assonant)+NR41"
as`tringency	N	"AJ(`astringent)+NR40"
as`sumption	N	"V(as`sume)+NR23"
`aster	N	"N"
`asterisk	N	"N"
`asteroid	N	"N"
`asthma	N	"N"
as`tigmatism	N	"N"
`astronaut	N	"N"
astro`physicist	N_Suffix1a	"N(`astrophysics)+NR31"
`astrophysics	Number	"N"
a`sylum	N	"N"
a`symmetry	N	"NEG1+N(`symmetry)"
`asymptote	N	"N"
a`synchrony	N	"N"
`atavism	N	"N"
`atheism	N	"N"
`atheist	N	"N"
atheroscler`osis	N	"N"
`athlete	N	"N"
`atlas	N	"N"
`atmosphere	N	"N"
`atoll	N	"N"
`atom	N	"N"
a`trocity	N	"N"
`atrophy	N-to-V	"N"
atta`che	N	"N"
at`tainder	N	"N"
at`tention	N	"V(at`tend)+NR23"
`attic	N	"N"
at`tire	N-to-V	"N"
`attitude	N	"N"
at`torney	N	"N"
`attribute	N	"V(at`tribute).NR0"
at`trition	N	"N"
`auction	N-to-V	"N"
au`dacity	N	"N"
`audience	N	"N"
`audio	N	"N"
`audiotape	N	"N"
au`dition	N-to-V	"N"
audi`torium	N	"N"
`auger	N	"N"
`aught	N	"N"
`aunt	N	"N"
;`auntie	N_Suffix1a	"N(`aunt)+NR33"
`aura	N	"N"
`aureole	N	"N"
au`reola	N	"N"
au`rora	N	"N"
`author	N-to-V	"N"
au`thority	N	"N"
`autism	N	"N"
`auto	N	"N"
`autoclave	N	"N"
au`tocracy	N	"N(`autocrat)+NR40"
`autocrat	N	"N"
`autograph	N-to-V	"N"
`automobile	N	"N"
`autopsy	N-to-V	"N"
`autumn	N	"N"
aux`iliary	N	"N"
`avalanche	N	"N"
avant-`garde	N	"N"
`avarice	N	"N"
`avatar	N	"N"
`avenue	N	"N"
`average	N-to-V-AJ	"N"
a`version	N	"N"
`aviary	N	"N"
`aviatrix	N	"N"
avo`cation	N	"N"
`awe	N-to-V	"N"
`awl	N	"N"
`awning	N	"N"
`ax	N-to-V	"N"
`axe	N-to-V	"N"
`axiom	N	"N"
`axle	N	"N"
`axon	N	"N"
a`zalea	N	"N"
`azimuth	N	"N"

`babe	N	"N"
ba`boon	N	"N"
`baby	N-to-V	"N"
bacca`laureate	N	"N"
`baccarat	N	"N"
`bachelor	N	"N"
`back	N-to-V	"N"
`backache	N	"N"
`backboard	N	"N"
`backbone	N	"N"
`backdrop	N	"N"
`backgammon	N	"N"
`background	N-to-AJ	"N"
`backhand	N-to-V	"N"
`backlash	N-to-V	"N"
`backlog	N-to-V	"N"
`backorder	N	"N"
`backpack	N-to-V	"N"
`backplane	N	"N"
`backplate	N	"N"
`backside	N	"N"
`backslash	N	"N"
`backspace	N-to-V	"N"
back`stage	N	"N"
`backstop	N	"N"
`backwater	N	"N"
back`wood	N	"N"
back`yard	N	"N"
`bacon	N	"N"
`badge	N	"N"
`badger	N-to-V	"N"
`badinage	N	"N"
`badland	N	"N"
`badminton	N	"N"
`baffle	N	"N"
`bag	N-to-V	"N"
baga`telle	N	"N"
`bagel	N	"N"
`bagful	N_Suffix1a	"N(`bag)+NR5"
`baggage	N_Suffix1a	"N(`bag)+NR1"
`bagpipe	N	"N"
`bail	N	"N"
`bailiff	N	"N"
`bailout	N	"N"
`bait	N-to-V	"N"
`bakery	N_Suffix1a	"V(`bake)+NR3"
ba`klava	N	"N"
`balcony	N	"N"
`baldpate	N	"N"
`baldy	N	"AJ(`bald)+NR35"
`bale	N-to-V	"N"
ba`leen	N	"N"
`ball	N-to-V	"N"
`ballad	N	"N"
`ballast	N-to-V	"N"
balle`rina	N	"N"
bal`let	N	"N"
`ballfield	N	"N"
bal`loon	N-to-V	"N"
`ballot	N-to-V	"N"
`ballroom	N	"N"
`ballyhoo	N	"N"
`balm	N	"N"
`balsa	N	"N"
`balsam	N	"N"
`balustrade	N	"N"
bam`boo	N	"N"
ba`nana	N	"N"
`band	N-to-V	"N"
`bandage	N-to-V	"N"
ban`dana	N	"N"
`bandit	N	"N"
`bandstand	N	"N"
`bandwagon	N	"N"
`bandwidth	N	"N"
`bane	N	"N"
`bangle	N	"N"
`banister	N	"N"
`bank	N-to-V	"N"
`bankruptcy	N	"AJ(`bankrupt)+NR40"
`banquet	N-to-V	"N"
`banshee	N	"N"
`bantam	N	"N"
`baptism	N	"N"
`baptistery	N	"N"
`baptistry	N	"N"
`bar	N-to-V	"N"
`barb	N-to-V	"N"
`barbarism	N	"N"
`barbell	N	"N"
`barber	N	"N"
`barbital	N	"N"
bar`biturate	N	"N"
`barcarole	N	"N"
`barcarolle	N	"N"
`bard	N	"N"
`barfly	N	"N"
`bargain	N-to-V	"N"
`barge	N	"N"
`baritone	N	"N"
`barium	N	"N"
`bark	N	"N" ;of tree
`barley	N	"N"
`barn	N	"N"
`barnacle	N	"N"
`barnyard	N	"N"
ba`rometer	N	"N"
`baron	N	"N"
baro`net	N	"N"
`barque	N	"N"
`barrack	N	"N"
barra`cuda	N	"N"
bar`rage	N	"N"
`barre	N	"N"
`barrel	N	"N"
`barricade	N-to-V	"N"
`barrier	N	"N"
`barrow	N	"N"
`bartender	N	"N(`bar)+V(`tend)+NR19"
`base	N-to-V	"N"
`baseball	N	"N"
`baseboard	N	"N"
`baseline	N	"N"
`basil	N	"N"
ba`silica	N	"N"
`basilisk	N	"N"
`basin	N	"N"
`basket	N	"N"
`basketball	N	"N"
`basketful	N_Suffix1a	"N(`basket)+NR5"
bassi`net	N	"N"
`bass	N	"N"
bas`soon	N	"N"
`bastard	N	"N"
`bastion	N	"N"
`bat	N	"N(`bat1)" ;animal
`bat	N-to-V	"N(`bat2)" ;stick
`batch	N	"N"
`bath	N	"N"
`bathos	N	"N"
`bathrobe	N	"N"
`bathroom	N	"N"
`bathtub	N	"N"
ba`tik	N	"N"
ba`ton	N	"N"
`batt	N	"N"
bat`talion	N	"N"
`battery	N	"N"
`batting	N	"N"
`battle	N-to-V	"N"
`battlefield	N	"N"
`battlefront	N	"N"
`battleground	N	"N"
`bauble	N	"N"
`baud	N	"N"
`bauxite	N	"N"
`bay	N	"N"
`bayberry	N	"N"
bayo`net	N	"N"
`bayou	N	"N"
ba`zaar	N	"N"
`beach	N-to-V	"N"
`beachhead	N	"N"
`beacon	N	"N"
`bead	N-to-V	"N"
`beak	N	"N"
`beaker	N	"N"
`beam	N-to-V	"N"
`bean	N	"N"
`bear	N	"N"
`beard	N	"N"
`bearing	N	"N"
`bearskin	N	"N"
`beast	N	"N"
`beat	N	"N"
beatifi`cation	N	"V(be`atify)+NR23"
`beatitude	N	"N"
beau`tician	N	"N"
beautifi`cation	N	"V(`beautify)+NR23"
`beauty	N	"N"
`beaver	N	"N"
`bebop	N	"N"
`beck	N	"N"
`bed	N-to-V	"N"
`bedbug	N	"N"
`bedding	N	"N(`bed)+NR7"
`bedfellow	N	"N"
`bedlam	N	"N"
`bedpost	N	"N"
`bedrock	N	"N"
`bedroom	N	"N"
`bedside	N	"N"
`bedspread	N	"N"
`bedspring	N	"N"
`bedtime	N	"N"
`bee	N	"N"
`beech	N	"N"
`beef	N	"N"
`beefsteak	N	"N"
`beehive	N	"N"
`beer	N	"N"
`beet	N	"N"
`beetle	N	"N"
`beggar	N	"N"
`beggary	N	"V(`beg)+NR39"
be`gonia	N	"N"
be`half	N	"N"
be`havior	N	"N"
be`haviour	N	"N" ;British
be`hemoth	N	"N"
be`hest	N	"N"
`being	N	"V(be)+NR24"
`belfry	N	"N"
be`lief	N	"N"
`bell	N	"N"
bella`donna	N	"N"
`bellboy	N	"N"
`belle	N	"N"
`bellhop	N	"N"
bel`ligerence	N	"AJ(bel`ligerent)+NR41"
bel`ligerency	N	"AJ(bel`ligerent)+NR40"
`bellwether	N	"N"
`belly	N-to-V	"N"
`bellyache	N	"N"
`bellyful	N_Suffix1a	"N(`belly)+NR5"
be`longing	N	"V(be`long)+NR24"
`belt	N-to-V	"N"
`belvedere	N	"N"
`bench	N-to-V	"N"
`benchmark	N	"N"
bene`diction	N	"N"
`benefactor	N	"N"
`benefice	N	"N"
bene`ficiary	N	"N(`benefice)+NR39"
`benefit	N-to-V	"N"
be`nevolence	N	"AJ(be`nevolent)+NR41"
`benzene	N	"N"
be`quest	N	"N"
be`ret	N	"N"
`berg	N	"N"
beri`beri	N	"N"
`berry	N	"N"
`berth	N	"N"
`beryl	N	"N"
best`seller	N	"N"
`bet	N-to-V	"N"
`betel	N	"N"
`beth	N	"N"
`bethel	N	"N"
`bevel	N	"N"
`beverage	N	"N"
`bevy	N	"N"
`bezel	N	"N"
`bias	N-to-V	"N"
`bib	N	"N"
`bible	N	"N"
`bibliophile	N	"N"
`bicycle	N	"NUM1+N(`cycle)"
`biddy	N	"N"
bi`ennium	N	"N"
`bier	N	"N"
`bifocal	N	"NUM1+AJ(`focal)"
`bigot	N	"N"
`bigotry	N_Suffix1a	"N(`bigot)+NR3"
bi`jouterie	N	"N"
`bike	N	"N"
bi`kini	N	"N"
`bile	N	"N"
`bilge	N	"N"
`bill	N-to-V	"N"
`billboard	N	"N"
`billet	N-to-V	"N"
`billfold	N	"N"
`billiard	N	"N"
billion`aire	N	"N"
`billow	N-to-V	"N"
`billy	N	"N"
`bin	N	"N"
`bindery	N_Suffix1a	"V(`bind)+NR3" ;or binder+ry
`binding	N	"V(`bind)+NR24"
`binge	N-to-V	"N"
`binnacle	N	"N"
`biopsy	N	"N"
`biosphere	N	"N"
bi`ota	N	"N"
`biped	N	"N"
;`biplane	N	"NUM1+N(`plane)"
`birch	N	"N"
`bird	N	"N"
`birdbath	N	"N"
`birdseed	N	"N"
`birth	N-to-V	"N"
`birthday	N	"N"
`birthplace	N	"N"
`birthright	N	"N"
`biscuit	N	"N"
`bishop	N	"N"
`bishopric	N	"N"
`bismuth	N	"N"
`bisque	N	"N"
`bit	N	"N"
`bitch	N	"N"
`bitt	N	"N"
`bittern	N	"N"
bi`tumen	N	"N"
`bivalve	N	"N"
`bivouac	N-to-V	"N"
`biz	N	"N"
`blackberry	N	"N"
`blackbird	N	"N"
`blackboard	N	"N"
`blacking	N	"AJ(`black).VR0+NR24"
`blackjack	N	"N"
`blacklist	N-to-V	"N"
`blackout	N	"N"
`blacksmith	N	"N"
`bladder	N	"N"
`blade	N	"N"
`blanket	N-to-V	"N"
`blasphemy	N	"N"
`blast	N-to-V	"N"
`blastoff	N	"N"
`blather	N	"N"
`blaze	N-to-V	"N"
`blemish	N-to-V	"N"
`blessing	N	"V(`bless)+NR24"
`blight	N-to-V	"N"
`blimp	N	"N"
`blind	N	"N"
`blindfold	N-to-V	"N"
`blip	N	"N"
`bliss	N	"N"
`blister	N-to-V	"N"
`blitz	N-to-V	"N"
`blizzard	N	"N"
`blob	N	"N"
`bloc	N	"N"
`block	N-to-V	"N"
`blockbuster	N	"N"
`blockhead	N	"N"
`blockhouse	N	"N"
`bloke	N	"N"
`blood	N	"N"
`bloodbath	N	"N"
`bloodhound	N	"N"
`bloodshed	N	"N"
`bloodstain	N	"N"
`bloodstone	N	"N"
`bloodstream	N	"N"
`blossom	N-to-V	"N"
`blot	N-to-V	"N"
`blotch	N	"N"
`blouse	N	"N"
`blowback	N	"N"
`blowfish	N	"N"
`blowtorch	N	"N"
`blowup	N	"N"
`blubber	N	"N"
`blueberry	N	"N"
`bluebird	N	"N"
`bluebonnet	N	"N"
`bluebook	N	"N"
`bluefish	N	"N"
`bluegill	N	"N"
`bluegrass	N	"N"
`bluing	N	"N"
`blueing	N	"N"
`bluejacket	N	"N"
`blueprint	N	"N"
`bluestocking	N	"N"
`bluet	N	"N"
`bluff	N	"N" ;cliff
`blurb	N	"N"
`blutwurst	N	"N"
`boa	N	"N"
`boar	N	"N"
`board	N	"N"
`boardinghouse	N	"N"
`boat	N-to-V	"N"
`boathouse	N	"N"
`boatload	N	"N"
`boatswain	N	"N"
`bosun	N	"N(`boatswain)"
`bo'sun	N	"N(`boatswain)"
`bos'n	N	"N(`boatswain)"
`boatyard	N	"N"
`bob	N	"N"
`bobbin	N	"N"
`bobby	N	"N"
`bobcat	N	"N"
`bobolink	N	"N"
`bock	N	"N"
`bodice	N	"N"
`body	N	"N"
`bodybuilder	N	"N(`body)+V(`build)+NR19"
`bodybuilding	N	"N(`body)+V(`build)+PRG"
`bodyguard	N	"N"
`bog	N-to-V	"N"
`bogey	N	"N"
`boil	N	"N" ;abcess
`bolivar	N	"N"
`bolo	N	"N"
`bolshevik	N	"N"
`bolt	N-to-V	"N(`bolt1)" ;nut and bolt
`bolt	N	"N(`bolt2)" ;of cloth
`bomb	N-to-V	"N"
`bombast	N	"N"
bo`nanza	N	"N"
`bond	N-to-V	"N"
`bondage	N	"N"
`bondholder	N	"N"
`bone	N-to-V	"N"
`bonfire	N	"N"
`bong	N	"N"
`bonnet	N	"N"
`bonus	N	"N"
`bonze	N	"N"
`boo	N-to-V	"N"
`booby	N	"N"
`boogie	N	"N"
`book	N-to-V	"N"
`bookbinder	N	"N(`book)+V(`bind)+NR19"
`bookbinding	N	"N(`book)+V(`bind)+PRG"
`bookbindery	N_Suffix1a	"N(`book)+V(`bind)+NR3"
`booking	N	"N(`book).VR0+NR24"
`bookkeeper	N	"N(`book)+V(`keep)+NR19"
`bookkeeping	N	"N(`book)+V(`keep)+PRG"
`bookseller	N	"N(`book)+V(`sell)+NR19"
`bookselling	N	"N(`book)+V(`sell)+PRG"
`bookcase	N	"N"
`bookend	N	"N"
`booklist	N	"N"
`bookmobile	N	"N"
`bookplate	N	"N"
`bookstore	N	"N")
`boom	N	"N" ;spar
`boomerang	N-to-V	"N"
`boon	N	"N"
`boor	N	"N"
`boot	N-to-V	"N"
`booth	N	"N"
`bootstrap	N-to-V	"N"
`booty	N	"N"
`booze	N-to-V	"N"
`borate	N	"N"
`borax	N	"N"
bor`dello	N	"N"
`border	N-to-V	"N"
`borderland	N	"N"
`boredom	N_Suffix1a	"V(`bore)+NR2"
`boron	N	"N"
`borough	N	"N"
`bosom	N	"N"
`boson	N	"N"
`boss	N-to-V	"N"
`botfly	N	"N"
`bottle	N-to-V	"N"
`bottleful	N_Suffix1a	"N(`bottle)+NR5"
`bottleneck	N	"N"
`bottom	N-to-V	"N"
`botulism	N	"N"
`boudoir	N	"N"
`bough	N	"N"
`boulder	N	"N"
`boule	N	"N"
`boulevard	N	"N"
`bound	N	"N"
`boundary	N	"V(`bound)+NR39"
`bounty	N	"N"
`bouquet	N	"N"
`bourbon	N	"N"
bourgeoi`sie	N	"N"
`bourn	N	"N"
`bout	N	"N"
`boutique	N	"N"
bouton`niere	N	"N"
`bow	N	"N(`bow1)" ;[bo] and arrow
`bow	N	"N(`bow2)" ;[baw] of a ship
`bowel	N	"N"
`bowie	N	"N"
`bowl	N	"N"
`bowlful	N_Suffix1a	"N(`bowl)+NR5"
`bowline	N	"N"
`bowstring	N	"N"
`bowsprit	N	"N"
`box	N-to-V	"N"
`boxcar	N	"N"
`boxful	N_Suffix1a	"N(`box)+NR5"
`boxwood	N	"N"
`boy	N	"N"
`boyfriend	N	"N"
`bra	N	"N"
`brace	N-to-V	"N"
`bracken	N	"N"
`bracket	N-to-V	"N"
`bract	N	"N"
`brad	N	"N"
`brae	N	"N"
`braggart	N	"N"
`braiding	N	"V(`braid)+NR24"
`braille	N-to-V	"N"
`brain	N-to-V	"N"
`brainstorm	N	"N"
`brake	N-to-V	"N"
`bramble	N	"N"
`bran	N	"N"
`branch	N-to-V	"N"
`brand	N-to-V	"N"
`brandy	N	"N"
`brandywine	N	"N"
`brant	N	"N"
`bravo	N	"N"
`brass	N	"N"
bras`siere	N	"N"
`brat	N	"N"
`bratwurst	N	"N"
bra`vado	N	"N"
`bravery	N_Suffix1a	"AJ(`brave)+NR3"
bra`vura	N	"N"
`brazier	N	"N"
`brawn	N	"N"
`breach	N-to-V	"N"
`bread	N	"N"
`breadboard	N	"N"
`breadfruit	N	"N"
`breadth	N	"AJ(`broad)+NR42"
`breadwinner	N	"N(`break)+V(`win)+NR19"
`breadwinning	N	"N(`break)+V(`win)+PRG"
`breakaway	N	"N"
`breakdown	N	"N"
`breakfast	N-to-V	"N"
`breakpoint	N	"N"
`breakthrough	N	"N"
`breakup	N	"N"
`breakwater	N	"N"
`bream	N	"N"
`breast	N	"N"
`breastplate	N	"N"
`breastwork	N	"N"
`breath	N	"N"
`breccia	N	"N"
`breech	N	"N"
`breeze	N	"N"
`breve	N	"N"
`brevity	N	"AJ(`brief)+NR21"
`brewery	N_Suffix1a	"V(`brew)+NR3"
`briar	N	"N"
`bribe	N-to-V	"N"
`bribery	N_Suffix1a	"N(`bribe).VR0+NR3"
`brick	N	"N"
`brickbat	N	"N"
`bricklayer	N	"N(`brick)+V(`lay)+NR19"
`bricklaying	N	"N(`brick)+V(`lay)+PRG"
`bride	N	"N"
`bridegroom	N	"N"
`bridesmaid	N	"N"
`bridge	N-to-V	"N"
`bridgehead	N	"N"
`bridgework	N	"N"
`bridle	N-to-V	"N"
`brief	N	"N"
`briefing	N	"V(`brief)+NR24"
`briefcase	N	"N"
`brig	N	"N"
bri`gade	N	"N"
briga`dier	N	"N"
`brigand	N	"N"
`brigantine	N	"N"
`brilliance	N	"AJ(`brilliant)+NR41"
`brilliancy	N	"AJ(`brilliant)+NR40"
`brim	N	"N"
`brimstone	N	"N"
`brindle	N	"N"
`brine	N	"N"
`brink	N	"N"
`brinkmanship	N	"N"
`brisket	N	"N"
`bristle	N-to-V	"N"
`broadloom	N	"N"
`broadside	N	"N"
bro`cade	N-to-V	"N"
`broccoli	N	"N"
bro`chure	N	"N"
`broker	N-to-V	"N"
`bromide	N	"N"
bron`chitis	N	"N"
`bronco	N	"N"
`bronze	N	"N"
`brooch	N	"N"
`brood	N-to-V	"N"
`brook	N	"N"
`brookside	N	"N"
`broom	N	"N"
`broomcorn	N	"N"
`broth	N	"N"
`brothel	N	"N"
`brouhaha	N	"N"
`brow	N	"N"
`bruit	N	"N"
`brunch	N	"N"
bru`nette	N	"N"
`brunt	N	"N"
`brush	N-to-V	"N"
`brushfire	N	"N"
`brushwork	N	"N"
`brute	N	"N"
`bubble	N-to-V	"N"
bucca`neer	N	"N"
`buck	N	"N" ;male, dollar
bucka`roo	N	"N"
`buckboard	N	"N"
`bucket	N	"N"
`bucketful	N_Suffix1a	"N(`bucket)+NR5"
`buckeye	N	"N"
`buckle	N-to-V	"N"
`buckshot	N	"N"
`buckskin	N	"N"
`buckwheat	N	"N"
`bud	N-to-V	"N"
`buddy	N	"N"
`budget	N-to-V	"N"
`buff	N	"N"
`buffer	N-to-V	"N"
buf`fet	N	"N"
buf`foon	N	"N"
`bug	N	"N" ;insect
`bugaboo	N	"N"
`bugbear	N	"N" ;insect
`bugle	N	"N"
`building	N	"V(`build)+NR24"
`buildup	N	"N"
`bulb	N	"N"
`bulk	N	"N"
`bulkhead	N	"N"
`bull	N	"N"
`bulldog	N	"N"
`bullet	N	"N"
`bulletin	N	"N"
`bullfrog	N	"N"
`bullhead	N	"N"
`bullhide	N	"N"
`bullock	N	"N"
`bullseye	N	"N"
`bully	N-to-V	"N"
`bullyboy	N	"N"
`bulrush	N	"N"
`bulwark	N	"N"
`bum	N	"N"
`bumblebee	N	"N"
`bump	N-to-V	"N"
`bumpkin	N	"N"
`bun	N	"N"
`bunch	N-to-V	"N"
`bundle	N-to-V	"N"
`bungalow	N	"N"
`bunk	N	"N"
`bunkmate	N	"N"
`bunny	N	"N"
`bunting	N	"N"
`buoy	N-to-V	"N"
`buoyancy	N	"V(`buoy)+AJR27+NR40"
`burden	N-to-V	"N"
`burdock	N	"N"
`bureau	N	"N"
bu`reaucracy	N	"N(`bureaucrat)+NR40"
`bureaucrat	N	"N"
`burg	N	"N"
`burgess	N	"N"
`burgher	N	"N"
`burglar	N	"N"
`burglary	N	"N"
`burl	N	"N"
`burlap	N	"N"
bur`lesque	N	"N"
`burley	N	"N"
`burnout	N	"N"
`burr	N	"N"
bur`rito	N	"N"
`burro	N	"N"
`burrow	N-to-V	"N"
bur`sitis	N_Suffix1a	"N(`bursa)+NR50"
`bus	N-to-V	"N"
`busboy	N	"N"
`busful	N_Suffix1a	"N(`bus)+NR5"
`bush	N	"N"
`bushel	N	"N"
`bushing	N	"N"
`bushmaster	N	"N"
`business	N	"N"
`bust	N	"N" ;statue, chest
`bustard	N	"N"
`busybody	N	"N"
`butane	N	"N"
`butler	N	"N"
`butt	N	"N"
`butte	N	"N"
`butter	N-to-V	"N"
`butterball	N	"N"
`buttercup	N	"N"
`butterfat	N	"N"
`butterfly	N	"N"
`buttermilk	N	"N"
`butternut	N	"N"
`buttock	N	"N"
`button	N-to-V	"N"
`buttonhole	N-to-V	"N"
`buttress	N-to-V	"N"
`buyout	N	"N"
`buzzard	N	"N"
`buzzsaw	N	"N"
`buzzword	N	"N"
`bye	N	"N"
`bylaw	N	"N"
`byline	N	"N"
`bypath	N	"N"
`byproduct	N	"N"
`byroad	N	"N"
`bystander	N	"N"
`byte	N	"N"
`byway	N	"N"
`byword	N	"N"

`cab	N	"N"
ca`bal	N	"N"
`cabalism	N_Suffix1a	"N(ca`bal)+NR8"
`cabalist	N_Suffix1a	"N(ca`bal)+NR31"
ca`bana	N	"N"
caba`ret	N	"N"
`cabbage	N	"N"
`cabdriver	N	"N(`cab)+V(`drive)+NR19"
`cabinetmaker	N	"N(`cabinet)+V(`make)+NR19"
`cabinetmaking	N	"N(`cabinet)+V(`make)+PRG"
`cabin	N	"N"
`cabinet	N	"N"
`cabinetry	N_Suffix1a	"N(`cabinet)+NR3"
`cable	N	"N"
ca`cao	N	"N"
`cache	N-to-V	"N"
`cad	N	"N"
ca`daver	N	"N"
`caddis	N	"N"
`caddy	N	"N"
`cadence	N	"N"
ca`denza	N	"N"
ca`det	N	"N"
`cadmium	N	"N"
`cadre	N	"N"
`caesar	N	"N"
ca`fe	N	"N"
cafe`teria	N	"N"
caf`feine	N	"N"
`cage	N	"N"
ca`hoot	N	"N"
`caiman	N	"N"
`cairn	N	"N"
`cake	N-to-V	"N"
`calabash	N	"N"
ca`lamity	N	"N"
calcifi`cation	N	"V(`calcify)+NR23"
`calcium	N	"N"
calcula`bility	AJ	"V(`calculate)+AJR25+NR21"
cal`dera	N	"N"
`calendar	N	"N"
`calf	N	"N"
`calfskin	N	"N"
`caliber	N	"N"
`calibre	N	"N"
`caliper	N	"N"
`caliph	N	"N"
`caliphate	N	"N(`caliph)+NR46"
calis`thenic	N	"N"
`calligraph	N	"N"
cal`ligrapher	N	"N(`calligraph)+NR19"
cal`ligraphy	N	"N"
cal`liope	N	"N"
`callus	N	"N"
`calorie	N	"N"
calo`rimeter	N	"N"
`calumny	N	"N"
`calvary	N	"N"
`cam	N	"N"
cama`raderie	N	"N"
`camber	N	"N"
`cambric	N	"N"
`camel	N	"N"
`camelback	N	"N"
ca`mellia	N	"N"
`camera	N	"N"
`camomile	N	"N"
`camouflage	N-to-V	"N"
`camp	N-to-V	"N"
cam`paign	N-to-V	"N"
`campanile	N	"N"
`campfire	N	"N"
`campground	N	"N"
`campion	N	"N"
`campsite	N	"N"
`campus	N	"N"
`can	N-to-V	"N"
ca`nal	N	"N"
ca`nary	N	"N"
`cancer	N	"N"
can`dela	N	"N"
can`descence	N	"AJ(can`descent)+NR41"
`candidacy	N	"N(`candidate)+NR40"
`candidate	N	"N"
`candle	N	"N"
`candlelight	N	"N"
`candlestick	N	"N"
`candor	N	"N"
`candour	N	"N" ;British
`candy	N-to-V	"N"
`cane	N	"N"
`canful	N_Suffix1a	"N(`can)+NR5"
`canine	N	"N"
`canister	N	"N"
`canker	N	"N"
`cankerworm	N	"N"
`cannabis	N	"N"
`cannery	N_Suffix1a	"N(`can).VR0+NR3"
`cannibal	N	"N"
`cannister	N	"N"
`cannon	N	"N"
`cannonball	N	"N"
ca`noe	N	"N"
`canon	N	"N"
`canopy	N	"N"
`cant	N	"N"
`cantaloupe	N	"N"
can`teen	N	"N"
`canticle	N	"N"
`cantilever	N	"N"
`cantle	N	"N"
`canto	N	"N"
`canton	N	"N"
`cantor	N	"N"
`canvas	N	"N"
`canvasback	N	"N"
`canyon	N	"N"
`cap	N-to-V	"N"
capa`bility	N	"AJ(`cabable)+NR21"
ca`pacitance	N	"N"
ca`pacitor	N	"N"
ca`pacity	N	"N"
`cape	N	"N"
`capful	N_Suffix1a	"N(`cap)+NR5"
`capillary	N	"N"
`capita	N	"N"
`capital	N	"N"
`capitol	N	"N"
`capo	N	"N"
ca`price	N	"N"
`capstan	N	"N"
`capstone	N	"N"
`capsule	N	"N"
`captain	N-to-V	"N"
`captaincy	N	"N(`captain)+NR40"
`caption	N-to-V	"N"
`captor	N	"N"
`car	N	"N"
`caramel	N	"N"
`caravan	N	"N"
`caraway	N	"N"
`carbine	N	"N"
carbo`hydrate	N	"N"
`carbon	N	"N"
`carboy	N	"N"
`carbuncle	N	"N"
`carburetor	N	"N"
`carcase	N	"N" ;British
`carcass	N	"N"
car`cinogen	N	"N"
carci`noma	N	"N"
`card	N	"N"
`cardamom	N	"N"
`cardboard	N	"N"
`cardinal	N	"N"
ca`reer	N	"N"
`caret	N	"N"
`caretaker	N	"N"
`carfare	N	"N"
`carful	N_Suffix1a	"N(`car)+NR5"
`caricature	N-to-V	"N"
`carload	N	"N"
`carnage	N	"N"
car`nation	N	"N"
`carnival	N	"N"
`carnivore	N	"N"
`carob	N	"N"
`carol	N-to-V	"N"
`carp	N	"N"
`carpenter	N	"N"
`carpentry	N	"N(`carpenter)+NR35"
`carpet	N-to-V	"N"
`carport	N	"N"
carra`geenan	N	"N"
`carrel	N	"N"
`carriage	N	"N"
`carrion	N	"N"
`carrot	N	"N"
`carryover	N	"N"
`cart	N-to-V	"N"
car`tel	N	"N"
`cartilage	N	"N"
`carton	N	"N"
car`toon	N	"N"
`cartridge	N	"N"
`cartwheel	N	"N"
`carving	N	"V(`carve)+NR24"
cary`atid	N	"N"
casa`nova	N	"N"
cas`cade	N-to-V	"N"
`case	N	"N"
`casebook	N	"N"
`casein	N	"N"
`casement	N	"N"
`casework	N	"N"
`cash	N-to-V	"N"
`cashew	N	"N"
ca`shier	N	"N"
`cashmere	N	"N"
`casing	N	"N"
ca`sino	N	"N"
`cask	N	"N"
`casket	N	"N"
`casserole	N	"N"
cas`sette	N	"N"
`cassock	N	"N"
`cast	N	"N" ;as in a play
`casting	N	"V(`cast)+NR24"
casta`net	N	"N"
`castaway	N	"N"
`caste	N	"N"
`castle	N	"N"
`castor	N	"N"
`casualty	N	"N"
`cat	N	"N"
`cataclysm	N	"N"
`catacomb	N	"N"
`catalogue	N-to-V	"N"
`catalog	N-to-V	"N"
ca`talpa	N	"N"
ca`talysis	N	"N"
`catalyst	N	"N"
`catapult	N	"N"
`cataract	N	"N"
ca`tarrh	N	"N"
ca`tastrophe	N	"N"
cata`tonia	N	"N"
`catbird	N	"N"
`catcall	N	"N"
`catchup	N	"N"
`catchword	N	"N"
`catechism	N	"N"
`catechist	N	"N"
`category	N	"N"
`caterpillar	N	"N"
`catfish	N	"N"
ca`tharsis	N	"N"
ca`thedra	N	"N"
ca`thedral	N	"N"
`catheter	N	"N"
`cathode	N	"N"
`catholic	N	"AJ(`catholic).NR0"
`cation	N	"N"
`catkin	N	"N"
`catnip	N	"N"
`catsup	N	"N"
`cattail	N	"N"
`caucus	N-to-V	"N"
`cauldron	N	"N"
`cauliflower	N	"N"
`caulk	N-to-V	"N"
`caulking	N	"N(`caulk)+NR7"
`caution	N-to-V	"N"
`cavalcade	N	"N"
`cavalry	N	"N"
`cave	N-to-V	"N"
`caveat	N	"N"
`cavern	N	"N"
`caviar	N	"N"
`cavity	N	"N"
`cayenne	N	"N"
`ceasefire	N	"N"
`cedar	N	"N"
ce`dilla	N	"N"
`ceiling	N	"N"
`celebrant	N	"N"
ce`lebrity	N	"N"
ce`lerity	N	"N"
`celery	N	"N"
ce`lesta	N	"N"
`celibacy	N	"AJ(`celibate)+NR40"
`cell	N	"N"
`cellar	N	"N"
`cello	N	"N"
`cellophane	N	"N"
`cellulose	N	"N"
ce`ment	N-to-V	"N"
`cemetery	N	"N"
`censor	N-to-V	"N"
`census	N	"N"
`cent	N	"N"
`centaur	N	"N"
cen`tenary	N	"N"
`center	N-to-V	"N"
`centre	N-to-V	"N" ;British
`centerline	N	"N"
`centerpiece	N	"N"
`centrepiece	N	"N" ;British
`centigrade	N	"N"
`centimeter	N	"N"
`centipede	N	"N"
`centrifuge	N	"N"
`centrist	N	"N(`center)+NR31"
`centroid	N_Suffix1a	"N(`center)+NR53"
cen`turion	N	"N"
`century	N	"N"
`cereal	N	"N"
cere`bellum	N	"N"
`ceremony	N	"N"
`certainty	N	"AJ(`certain)+AJR26"
cer`tificate	N	"V(`certify)+NR46"
certifi`cation	N	"V(`certify)+NR23"
`certitude	N	"N"
ces`sation	N	"N"
`cession	N	"N"
`chaff	N	"N"
cha`grin	N	"N"
`chain	N-to-V	"N"
`chair	N	"N(`chair1)" ;seat
`chair	N-to-V	"N(`chair2)" ;chairperson
`chairlady	N	"N"
`chairperson	N	"N"
`chaise	N	"N"
`chalcedony	N	"N"
cha`let	N	"N"
`chalice	N	"N"
`chalk	N	"N"
`chalkboard	N	"N"
`chalkline	N	"N"
`chamber	N	"N"
`chamberlain	N	"N"
`chambermaid	N	"N"
cha`meleon	N	"N"
`chamois	N	"N"
`chamomile	N	"N"
`champ	N	"N"
cham`pagne	N	"N"
`champion	N	"N"
`chance	N-to-V	"N"
`chancel	N	"N"
`chancellor	N	"N"
`chancery	N	"N"
chande`lier	N	"N"
`chandler	N	"N"
`changeover	N	"N"
`channel	N	"N"
chan`son	N	"N"
chanson`nier	N	"N"
`chantry	N_Suffix1a	"V(`chant)+NR3"
`chaos	N	"N"
`chap	N	"N"
chapar`ral	N	"N"
`chapel	N	"N"
`chaperon	N-to-V	"N"
`chaperone	N-to-V	"N"
`chaplain	N	"N"
`chaplaincy	N	"N(`chaplain)+NR40"
`chapter	N	"N"
`character	N	"N"
character`istic	N	"AJ(character`istic).NR0"
`charcoal	N	"N"
`chard	N	"N"
`chariot	N	"N"
cha`risma	N	"N"
`charity	N	"N"
`charlatan	N	"N"
`charm	N-to-V	"N"
`charnel	N	"N"
`chart	N-to-V	"N"
`charter	N-to-V	"N"
`chartroom	N	"N"
`chasm	N	"N"
`chassis	N	"N"
`chattel	N	"N"
chauf`feur	N	"N"
`chauvinism	N	"N"
`chauvinist	N	"N"
`chaw	N	"N"
`check	N	"N" ;bill
`checkbook	N	"N"
`checkerboard	N	"N"
`checklist	N	"N"
`checkout	N	"N"
`checkpoint	N	"N"
`checkup	N	"N"
`cheek	N	"N"
`cheekbone	N	"N"
`cheekful	N_Suffix1a	"N(`cheek)+NR5"
`cheer	N-to-V	"N"
`cheerleader	N	"N(`cheer)+V(`lead)+NR19"
`cheerleading	N	"N(`cheer)+V(`lead)+PRG"
`cheese	N	"N"
`cheesecake	N	"N"
`cheesecloth	N	"N"
`cheetah	N	"N"
`chef	N	"N"
che`mise	N	"N"
`chemist	N	"N"
`chemistry	N	"N"
che`nille	N	"N"
`cheque	N	"N"
`cherry	N	"N"
`chess	N	"N"
`chessboard	N	"N"
`chest	N	"N"
`chestful	N_Suffix1a	"N(`chest)+NR5"
`chestnut	N	"N"
che`valier	N	"N"
`chevron	N	"N"
chi`mera	N	"N"
chi`anti	N	"N"
chi`canery	N	"N"
`chick	N	"N"
`chickadee	N	"N"
`chicken	N	"N"
`chicory	N	"N"
`chieftain	N	"N"
`chieftaincy	N	"N(`chieftain)+NR40"
`chiffon	N	"N"
`chigger	N	"N"
`chignon	N	"N"
`chilblain	N	"N"
`childbearing	N	"N(`child)+V(`bear)+PRG"
`childbirth	N	"N"
`chili	N	"N"
`chilies	Number	"N(`chili)+PL"
`chill	N-to-V	"N"
`chimney	N	"N"
chimpan`zee	N	"N"
`chin	N	"N"
`china	N	"N"
`chinch	N	"N"
chin`chilla	N	"N"
`chink	N	"N"
`chip	N-to-V	"N"
`chipboard	N	"N"
`chipmunk	N	"N"
`chiropractor	N	"N"
`chisel	N-to-V	"N"
`chit	N	"N"
`chivalry	N	"N"
`chive	N	"N"
`chlordane	N	"N"
`chloride	N	"N"
`chlorine	N	"N"
`chloroform	N	"N"
`chlorophyll	N	"N"
`chock	N	"N"
`chocolate	N	"N"
`choice	N-to-AJ	"N"
`choir	N	"N"
`choirmaster	N	"N"
`cholera	N	"N"
cho`lesterol	N	"N"
`chop	N	"N" ;meat
`chopstick	N	"N"
cho`rale	N	"N"
`chord	N	"N"
`chordate	N	"N"
`chore	N	"N"
`chorus	N	"N"
`chow	N	"N"
`chowder	N	"N"
`chrome	N	"N"
`chromium	N	"N"
`chromosome	N	"N"
`chronicle	N-to-V	"N"
`chronograph	N	"N"
chro`nography	N	"N"
chro`nometer	N	"N"
`chrysalis	N	"N"
chry`santhemum	N	"N"
`chub	N	"N"
`chum	N	"N"
`chump	N	"N"
`chunk	N	"N"
`church	N	"N"
`churchgoer	N	"N(`church)+V(`go)+NR19"
`churchyard	N	"N"
`chute	N	"N"
`chutney	N	"N"
`chutzpah	N	"N"
ci`cada	N	"N"
`cider	N	"N"
`cigar	N	"N"
`cinch	N-to-V	"N"
`cinder	N-to-V	"N"
`cinema	N	"N"
`cinnamon	N	"N"
`cinquefoil	N	"N"
`cipher	N-to-V	"N"
`circle	N-to-V	"N"
`circlet	N	"N"
`circuit	N	"N"
`circuitry	N_Suffix1a	"N(`circuit)+NR3"
`circulant	N	"N"
cir`cumference	N	"N"
`circumflex	N	"N"
circumlo`cution	N	"N"
circum`scription	N	"V(`circumscribe)+NR23"
circum`spection	N	"AJ(`circumspect)+NR23"
`circumstance	N	"N"
`circus	N	"N"
`cistern	N	"N"
`citadel	N	"N"
`citizen	N	"N"
`citizenry	N_Suffix1a	"N(`citizen)+NR3"
`citron	N	"N"
`citrus	N	"N"
`city	N	"N"
`civet	N	"N"
ci`vilian	N-to-AJ	"AJ(`civil)+NR29"
clair`voyant	N	"N"
`clam	N	"N"
`clamp	N-to-V	"N"
`clamshell	N	"N"
`clan	N	"N"
`clapboard	N	"N"
`claret	N	"N"
clarifi`cation	N	"V(`clarify)+NR23"
clari`net	N	"N"
`clarity	N	"N"
`clasp	N-to-V	"N"
`class	N-to-V	"N"
`classmate	N	"N"
`classroom	N	"N"
`clause	N	"N"
claustro`phobia	N	"N"
`claw	N-to-V	"N"
`clay	N	"N"
`cleanup	N	"N"
`clearing	N	"AJ(`clear).VR0+NR24"
`cleat	N	"N"
`cleft	N	"N"
`clemency	N	"AJ(`clement)+NR40"
`clergy	N	"N"
`cleric	N	"N"
`clerk	N	"N"
cli`che	N	"N"
`client	N	"N"
clien`tele	N	"N"
`cliff	N	"N"
`cliffhanger	N	"N(`cliff)+V(`hand)+NR19"
`climate	N	"N"
`climax	N-to-V	"N"
`clime	N	"N"
`cline	N	"N"
`clinic	N	"N"
`clipboard	N	"N"
`clipping	N	"V(`clip)+NR24"
`clique	N	"N"
`clitic	N	"N"
`cloak	N-to-V	"N"
`cloakroom	N	"N"
`clock	N	"N"
`clockwatcher	N	"N(`clock)+V(`watch)+NR19"
`clockwatching	N	"N(`clock)+V(`watch)+PRG"
`clockwork	N	"N"
`clod	N	"N"
`cloister	N-to-V	"N"
`clone	N-to-V	"N"
`closet	N	"N"
`closeup	N	"N"
`closure	N	"V(`close)+NR38"
`clot	N-to-V	"N"
`cloth	N	"N"
`clotheshorse	N	"N"
`clothesline	N	"N"
`clothier	N	"N"
`clothing	N	"V(`clothe)+NR24"
`cloture	N	"N"
`cloud	N-to-V	"N"
`cloudburst	N	"N"
`clout	N	"N"
`clove	N	"N"
`clover	N	"N"
`clown	N-to-V	"N"
`club	N-to-V	"N"
`clubhouse	N	"N"
`clubroom	N	"N"
`clue	N	"N"
`clump	N-to-V	"N"
`cluster	N-to-V	"N"
`clutch	N	"N"
`clutter	N-to-V	"N"
`coachwork	N	"N"
coad`jutor	N	"N"
`coal	N	"N"
coa`lition	N	"N"
`coast	N	"N" ;shore
`coastline	N	"N"
`coat	N-to-V	"N"
`coating	N	"N(`coat).VR0+NR24"
`coattail	N	"N"
`cobalt	N	"N"
`cobblestone	N	"N"
`cobra	N	"N"
`cobweb	N	"N"
`coca	N	"N"
co`caine	N	"N"
`cochlea	N	"N"
`cock	N	"N"
`cockatoo	N	"N"
`cockcrow	N	"N"
`cockle	N	"N"
`cockleshell	N	"N"
`cockpit	N	"N"
`cockroach	N	"N"
`cocktail	N	"N"
`coco	N	"N"
`cocoa	N	"N"
`cocoanut	N	"N"
`coconut	N	"N"
co`coon	N	"N"
`coda	N	"N"
`code	N-to-V	"N"
`codeword	N	"N"
`codfish	N	"N"
`codicil	N	"N"
`codpiece	N	"N"
`coed	N	"N"
coef`ficient	N	"N"
`coffee	N	"N"
`coffeecup	N	"N"
`coffeepot	N	"N"
`coffer	N	"N"
`coffin	N-to-V	"N"
`cog	N	"N"
`cognac	N	"N"
`cognate	N	"N"
cog`nition	N	"N"
`cognizance	N	"AJ(`cognizant)+NR41"
co`herency	N	"V(co`here)+AJR27+NR40"
co`hesion	N	"V(co`here)+NR23"
`cohort	N	"N"
`cohosh	N	"N"
coif`fure	N	"N"
`coil	N-to-V	"N"
`coin	N-to-V	"N"
`coke	N	"N"
`cola	N	"N"
`colander	N	"N"
`coleus	N	"N"
`colic	N	"N"
coli`seum	N	"N"
col`lage	N	"N"
`collagen	N	"N"
`collar	N-to-V	"N"
`collarbone	N	"N"
`collard	N	"N"
col`lateral	N	"N"
`colleague	N	"N"
`college	N	"N"
`collet	N	"N"
`collie	N	"N"
col`lision	N	"V(col`lide)+NR23"
col`lusion	N	"V(col`lude)+NR23"
co`logne	N	"N"
`colon	N	"N"
`colonel	N	"N"
`colonist	N_Suffix1a	"N(`colony)+NR31"
`colonnade	N	"N"
`colony	N	"N"
`color	N-to-V	"N"
`colour	N-to-V	"N" ;British
colora`tura	N	"N"
`colt	N	"N"
`columbine	N	"N"
`column	N	"N"
`coma	N	"N"
com`batant	N	"V(`combat)+NR17"
`comeback	N	"N"
`combinator	N	"V(com`bine)+NR20" 
comedi`enne	N	"N"
`comedy	N	"N"
`comet	N	"N"
`comfit	N	"N"
`comfort	N-to-V	"N"
`comma	N	"N"
`comment	N-to-V	"N"
`commentary	N	"N(`comment).VR0+NR39"
`commentator	N	"N(`comment).VR0+NR20"
`commerce	N	"N"
com`mercial	N	"N(`commerce)+AJR17.NR0"
commis`sariat	N	"N"
`commissary	N	"N"
com`mission	N-to-V	"N"
com`modity	N	"N"
`commodore	N	"N"
`common	N	"N"
common`ality	N	"AJ(`common)+NR21"
`commoner	N	"AJ(`common)+NR11"
`commonweal	N	"N"
`commonwealth	N	"N"
com`motion	N	"N"
`commune	N	"N"
com`municant	N	"N"
communi`que	N	"N"
com`munity	N	"V(com`mune)+NR21"
`compact	N	"N"
com`panion	N	"N"
com`panionway	N	"N"
`company	N	"N"
com`parator	N	"V(com`pare)+NR20"
com`parison	N	"V(com`pare)+NR??"
com`partment	N	"N"
`compass	N	"N"
com`passion	N	"N"
compati`bility	N	"V(com`patible)+NR21"
com`patriot	N	"N"
`competence	N	"AJ(`competent)+NR41"
`competency	N	"AJ(`competent)+NR40"
com`petitor	N	"V(com`pete)+NR20"
com`placence	N	"AJ(com`placent)+NR41"
com`placency	N	"AJ(com`placent)+NR40"
com`plaint	N	"N"
com`plaisance	N	"AJ(com`plaisant)+NR41"
`complement	N-to-V	"N"
complemen`tarity	N	"N(`complement)+AJR22+NR21"
`complex	N	"N"
com`plexion	N	"N"
com`plicity	N	"N"
`compliment	N-to-V	"N"
`compline	N	"N"
com`ponent	N	"N"
com`positor	N	"N"
`compost	N-to-V	"N"
com`posure	N	"V(com`pose)+NR38"
`compote	N	"N"
`compound	N	"N"
comprehensi`bility	N	"V(compre`hend)+AJR25+NR21"
compre`hension	N	"V(compre`hen)+NR23"
`compress	N	"V(com`press).NR0"
`comptroller	N	"N"
com`pulsion	N	"V(com`pell)+NR23"
com`punction	N	"N"
`comrade	N	"N"
`con	N	"N" ;pros and cons
con`ceit	N	"N"
`concept	N	"N"
con`ception	N	"V(con`ceive)+NR23"
con`cern	N-to-V	"N"
`concert	N	"N"
concer`tina	N	"N"
`concertmaster	N	"N"
con`cession	N	"V(con`cede)+NR23"
concession`aire	N	"N"
`conch	N	"N"
`concierge	N	"N"
con`cision	N	"AJ(con`cise)+NR23"
`conclave	N	"N"
con`clusion	N	"V(con`clude)+NR23"
`concord	N	"N"
`concourse	N	"N"
`concrete	N-to-V	"N"
con`cretion	N	"N"
`concubine	N	"N"
con`cupiscence	N	"AJ(con`cupiscent)+NR41"
condes`cension	N	"V(condes`cend)+NR23"
`condiment	N	"N"
con`dition	N-to-V	"N"
`condo	N	"N" ;condominium
con`dolence	N	"N"
condo`minium	N	"N"
`condor	N	"N"
`conduct	N	"V(con`duct).NR0"
`conduit	N	"N"
`cone	N	"N"
`coneflower	N	"N"
`coney	N	"N"
con`fectionery	N_Suffix1a	"N(con`fection)+NR3"
con`federacy	N	"N(con`federate)+NR40"
con`federate	N	"N"
confer`ee	N	"V(con`fer)+NR18" ;exception to Gemination
`conference	N	"V(con`fer)+NR26"
`confidant	N	"N"
`confidante	N	"N"
confla`gration	N	"N"
`conflict	N	"V(con`flict).NR0"
con`formist	N_Suffix1a	"V(con`form)+NR31"
`confrere	N	"N"
`congener	N	"N"
con`glomerate	N	"N"
`congress	N	"N"
con`gruence	N	"AJ(con`gruent)+NR41"
con`gruency	N	"AJ(con`gruent)+NR40"
con`gruity	N	"N"
`conifer	N	"N"
con`jecture	N	"N"
`conjoint	N	"N"
`conjunct	N	"N"
con`junction	N	"V(con`join)+NR23"
con`juncture	N	"N"
con`nexion	N	"V(con`nect)+NR23" ;British
connois`seur	N	"N"
`conquest	N	"N"
con`quistador	N	"N"
`conscience	N	"N"
`conscript	N	"V(con`script).NR0"
con`sensus	N	"N"
con`servancy	N	"N"
con`servatism	N	"N"
con`servator	N	"V(con`serve)+NR20"
con`servatory	N	"N"
`consequence	N	"AJ(`consequent)+NR41"
con`sistency	N	"AJ(con`sistent)+NR40"
`consonant	N	"N"
`consort	N	"V(con`sort).NR0"
con`sortium	N	"N"
con`spiracy	N	"V(con`spire)+NR40"
con`spirator	N	"V(con`spire)+NR20"
`constable	N	"N"
`constant	N	"N"
con`stituency	N	"AJ(con`stituent)+NR40"
con`straint	N	"N"
`construct	N	"V(con`struct).NR0"
`consul	N	"N"
`consulate	N	"N"
con`sumption	N	"V(con`sume)+NR23"
`contact	N-to-V	"N"
con`tagion	N	"N"
con`taminant	N	"N"
con`tempt	N	"N"
`content	N	"N"
con`tention	N	"V(con`tend)+NR23"
`contest	N	"V(con`test).NR0"
`context	N	"N"
conti`guity	N	"N"
`continence	N	"AJ(`continent)+NR41"
`continent	N	"N"
con`tingency	N	"AJ(con`tingent)+NR40"
conti`nuity	N	"N"
con`tinuo	N	"N"
`contour	N	"N"
`contraband	N	"N"
contra`ception	N	"N"
`contract	N	"V(con`tract).NR0"
con`tralto	N	"N"
con`traption	N	"N"
con`trariety	N	"N"
`contrast	N	"V(con`trast).NR0"
contra`vention	N	"N"
con`trition	N	"AJ(`contrite)+NR23"
`controversy	N	"N"
con`tumacy	N	"N"
co`nundrum	N	"N"
con`venience	N-to-V	"AJ(con`venient)+NR41"
`convent	N	"N"
con`vention	N	"V(con`vene)+NR23"
con`version	N	"V(con`vert)+NR23"
`convert	N	"V(con`vert).NR0"
`convict	N	"V(con`vict).NR0"
convo`cation	N	"V(con`voke)+NR23"
`convoy	N	"N"
`cony	N	"N"
`cookbook	N	"N"
`cookery	N_Suffix1a	"V(`cook)+NR3"
`cookie	N	"N"
`cooky	N	"N"
`coon	N	"N"
`coop	N	"N"
co`operative	N	"V(co`operate)+AJR26.NR0"
`coot	N	"N"
`cop	N	"N"
`copper	N	"N"
`copperhead	N	"N"
`copra	N	"N"
`copter	N	"N"
`copybook	N	"N"
`copycat	N	"N"
`copyright	N-to-V	"N"
`copywriter	N	"N"
co`quet	N	"N"
`coquetry	N_Suffix1a	"N(co`quet)+NR3"
co`quette	N	"N"
co`quina	N	"N"
`coral	N	"N"
`corbel	N	"N"
`cord	N	"N"
`cordage	N	"N(`cord)+NR1"
`cordite	N	"N"
`cordon	N-to-V	"N"
`corduroy	N	"N"
`core	N	"N"
cori`ander	N	"N"
`cork	N-to-V	"N"
`corkscrew	N	"N"
`cormorant	N	"N"
`corn	N	"N"
`cornbread	N	"N"
`cornea	N	"N"
`corner	N-to-V	"N"
`cornerstone	N	"N"
cor`net	N	"N"
`cornfield	N	"N"
`cornflower	N	"N"
`cornmeal	N	"N"
`cornstarch	N	"N"
cornu`copia	N	"N"
`corollary	N	"N"
co`rona	N	"N"
`coronary	N	"N"
coro`nation	N	"N"
`coroner	N	"N"
coro`net	N	"N"
`corporal	N	"N"
corpor`ation	N	"N"
`corpse	N	"N"
`corpulence	N	"AJ(`corpulent)+NR41"
`corpulency	N	"AJ(`corpulent)+NR40"
`corpuscle	N	"N"
cor`ral	N-to-V	"N"
`correlate	N	"N"
corres`pondent	N	"V(corres`pond)+NR17"
`corridor	N	"N"
corrigi`bility	N	"AJ(`corrigible)+NR21"
corrobor`ee	N	"N"
cor`rosion	N	"V(cor`rode)+NR23"
cor`sage	N	"N"
`corset	N	"N"
cor`tege	N	"N"
co`rundum	N	"N"
cor`vette	N	"N"
`cosine	N	"N"
`cosmos	N	"N"
`cost	N-to-V	"N"
`costume	N-to-V	"N"
`cot	N	"N"
co`tillion	N	"N"
`cotoneaster	N	"N"
`cotta	N	"N"
`cottage	N	"N"
`cotton	N	"N"
`cottonmouth	N	"N"
`cottonseed	N	"N"
`cottonwood	N	"N"
`couch	N	"N"
`cougar	N	"N"
`coulomb	N	"N"
`council	N	"N"
`counsel	N-to-V	"N"
`countdown	N	"N"
`countenance	N	"N"
`counter	N	"N"
`country	N	"N"
`countryside	N	"N"
`county	N	"N"
`coup	N	"N"
`coupe	N	"N"
`couple	N-to-AJ	"N"
`coupling	N	"V(`couple)+NR24"
`coupon	N	"N"
`courage	N	"N"
`courier	N	"N"
`course	N	"N"
`court	N	"N"
`courtesan	N	"N"
`courtesy	N	"N"
`courthouse	N	"N"
`courtier	N	"N"
`courtroom	N	"N"
`courtyard	N	"N"
`couscous	N	"N"
`cousin	N	"N"
cou`turier	N	"N"
`cove	N	"N"
`coven	N	"N"
`covenant	N	"N"
`coverall	N	"N"
`covering	N	"V(`cover)+NR24"
`cow	N	"N"
`coward	N	"N"
`cowardice	N	"N"
`cowbell	N	"N"
`cowbird	N	"N"
`cowboy	N	"N"
`cowgirl	N	"N"
`cowhand	N	"N"
`cowherd	N	"N"
`cowhide	N	"N"
`cowl	N	"N"
`cowlick	N	"N"
`cowling	N	"N"
`cowpea	N	"N"
`cowpoke	N	"N"
`cowpony	N	"N"
`cowpox	N	"N"
`cowpunch	N	"N"
`cowry	N	"N"
`cowslip	N	"N"
`coxcomb	N	"N"
co`yote	N	"N"
`crab	N	"N"
`crabapple	N	"N"
`crabmeat	N	"N"
`crackdown	N	"N"
`crackpot	N	"N"
`cradle	N-to-V	"N"
`craftspeople	N	"N"
`craftsperson	N	"N"
`crag	N	"N"
`cranberry	N	"N"
`crane	N	"N"
`crank	N-to-V	"N"
`crankcase	N	"N"
`crankshaft	N	"N"
`cranny	N	"N"
`crap	N-to-V	"N"
`crape	N-to-V	"N"
`crate	N	"N"
`crater	N-to-V	"N"
cra`vat	N	"N"
`craw	N	"N"
`crawlspace	N	"N"
`crayfish	N	"N"
`crayon	N	"N"
`craze	N	"N"
`cream	N-to-V	"N"
`creamery	N_Suffix1a	"N(`cream)+NR3"
`crease	N-to-V	"N"
`creature	N	"V(cre`ate)+NR38"
`creche	N	"N"
`credence	N	"N"
cre`dential	N	"N"
cre`denza	N	"N"
credi`bility	N	"AJ(`credible)+NR21"
`credit	N-to-V	"N"
`credo	N	"N"
cre`dulity	N	"N"
`creed	N	"N"
`creek	N	"N"
`creekside	N	"N"
`creep	N	"N" ;bad fellow
`creosote	N	"N"
`crepe	N	"N"
`crescent	N	"N"
`cress	N	"N"
`crest	N-to-V	"N"
`cretin	N	"N"
`crevice	N	"N"
`crew	N	"N"
`crewcut	N	"N"
`crewel	N	"N"
`crib	N	"N"
`crick	N	"N"
`cricket	N	"N"
`crime	N	"N"
`cripple	N-to-V	"N"
`critic	N	"N"
cri`tique	N-to-V	"N"
`critter	N	"N"
`crock	N	"N"
`crockery	N_Suffix1a	"N(`crock)+NR3"
`crocodile	N	"N"
`croft	N	"N"
`crone	N	"N"
`crony	N	"N"
`crook	N	"N"
`crop	N	"N" ;garden
`cropland	N	"N"
cro`quet	N-to-V	"N"
`cross	N-to-V	"N"
`crossarm	N	"N"
`crossbar	N	"N"
`crossbill	N	"N"
`crossbow	N	"N"
`crosscut	N	"N"
`crosslink	N	"N"
`crossover	N	"N"
`crosspoint	N	"N"
`crossroad	N	"N"
`crosstalk	N	"N"
`crosswalk	N	"N"
`crossway	N	"N"
`crossword	N	"N"
`crotch	N	"N"
`crotchet	N	"N"
`croupier	N	"N"
`crow	N	"N"
`crowbar	N	"N"
`crowd	N-to-V	"N"
`crowfoot	N	"N"
`crown	N-to-V	"N"
`crucible	N	"N"
`crucifix	N	"N"
cruci`fixion	N	"V(`crucify)+NR23"
`crud	N	"N"
`cruet	N	"N"
`cruelty	N	"AJ(`cruel)+NR21"
`crumb	N	"N"
`crupper	N	"N"
cru`sade	N-to-V	"N"
`crust	N	"N"
`crutch	N	"N"
`crux	N	"N"
`crypt	N	"N"
crypta`nalysis	N	"N"
crypt`analyst	N	"N"
`cryptogram	N	"N"
`crystal	N	"N"
`crystallite	N	"N(`crystal)+NR60"
`cub	N	"N"
`cubbyhole	N	"N"
`cube	N-to-V	"N"
`cubit	N	"N"
`cuckoo	N	"N"
`cucumber	N	"N"
`cud	N	"N"
`cudgel	N	"N"
`cue	N-to-V	"N(`cue1)" ;prompt
`cue	N	"N(`cue2)" ;stick
`cuff	N	"N" ;shirt cuff
`cufflink	N	"N"
cui`sine	N	"N"
culpa`bility	N	"AJ(`culpable)+NR21"
`culprit	N	"N"
`cult	N	"N"
`culture	N	"N"
`culvert	N	"N"
`cumin	N	"N"
`cumulus	N	"N"
`cup	N	"N"
`cupboard	N	"N"
`cupful	N_Suffix1a	"N(`cup)+NR5"
cu`pidity	N	"N(`cupid)+NR21"
`cupola	N	"N"
`cur	N	"N"
`curate	N	"N"
`curb	N	"N"
`curbing	N	"N(`curb)+NR7"
`curbside	N	"N"
`curd	N	"N"
`cure	N-to-V	"N"
`curfew	N	"N"
`curia	N	"N"
`curie	N	"N"
`curio	N	"N"
curi`osity	N	"AJ(`curious)+NR21"
`curlew	N	"N"
`curlicue	N	"N"
cur`mudgeon	N	"N"
`currency	N	"AJ(`current)+NR40"
`currant	N	"N"
`current	N	"N"
`curry	N	"N"
`cursor	N	"N"
`curtain	N-to-V	"N"
`curtsey	N-to-V	"N"
`curve	N-to-V	"N"
`curvature	N	"N(`curve)+NR38"
`cushion	N-to-V	"N"
`cusp	N	"N"
`custard	N	"N"
`custody	N	"N"
`custom	N	"N"
`customer	N	"N"
`customhouse	N	"N"
`cutback	N	"N"
`cutlass	N	"N"
`cutler	N	"N"
`cutoff	N	"N"
`cutout	N	"N"
`cutover	N	"N"
`cutthroat	N	"N"
`cutting	N	"V(`cut)+NR24"
`cuttlebone	N	"N"
`cuttlefish	N	"N"
`cutworm	N	"N"
`cyanide	N	"N"
`cycle	N-to-V	"N" ;see verb.lex for verb forms
`cyclist	N_Suffix1a	"V(`cycle)+NR31" ;exception to Elision
`cycloid	N	"N"
`cyclone	N	"N"
cyclo`rama	N	"N"
`cyclotron	N	"N"
`cygnet	N	"N"
`cylinder	N	"N"
`cymbal	N	"N"
`cynic	N	"N"
`cypress	N	"N"
`cyst	N	"N"
`czar	N	"N"
cza`rina	N	"N"

`dab	N-to-V	"N"
`dachshund	N	"N"
`dad	N	"N"
`daddy	N	"N"
`daffodil	N	"N"
`dagger	N	"N"
`dahlia	N	"N"
`dainty	N	"N"
`dairy	N	"N"
`dais	N	"N"
`daisy	N	"N"
`dale	N	"N"
`dam	N-to-V	"N"
`damask	N	"N"
`dame	N	"N"
`damsel	N	"N"
`dandelion	N	"N"
`danger	N	"N"
`daredevil	N	"N"
`dart	N-to-V	"N"
`dash	N	"N" ;little bit
`dashboard	N	"N"
`dastard	N	"N"
`database	N	"N"
`date	N-to-V	"N"
`dateline	N	"N"
`daughter	N	"N"
`dauphin	N	"N"
dau`phine	N	"N"
`davenport	N	"N"
`davit	N	"N"
`dawn	N-to-V	"N"
`day	N	"N"
`daybed	N	"N"
`daybreak	N	"N"
`daydream	N-to-V	"N"
`daylight	N	"N"
`daytime	N	"N"
`deacon	N	"N"
`deadhead	N	"N"
`deadline	N	"N"
`deadlock	N	"N"
`deadwood	N	"N"
`dean	N	"N"
;`dearie	N_Suffix1a	"N(`dear)+NR33"
`dearth	N	"N"
`death	N	"N"
`deathbed	N	"N"
de`bacle	N	"N"
de`bauchery	N_Suffix1a	"V(de`bauch)+NR3"
de`benture	N	"N"
de`bility	N	"N"
`debit	N	"N"
de`bris	N	"N"
`debt	N	"N"
`debtor	N	"N"
de`but	N	"N" ;see verb.lex for verb forms
`debutante	N	"N"
`decade	N	"N"
`decadence	N	"AJ(`decadent)+NR41"
`decal	N	"N"
de`cathlon	N	"N"
de`cedent	N	"N"
de`ceit	N	"N"
`decency	N	"AJ(`decent)+NR40"
de`ception	N	"V(de`ceive)+NR23"
`decibel	N	"N"
`decile	N	"N"
de`cision	N	"V(de`cide)+NR23"
`deck	N	"N"
`decking	N	"N(`deck)+NR7"
decla`mation	N	"V(de`claim)+NR23"
de`clarator	N	"V(de`clare)+NR20"
de`clension	N	"V(de`cline)+NR23"
de`clivity	N	"N"
decolle`tage	N	"N"
de`cor	N	"N"
de`corum	N	"N"
`decoy	N-to-V	"N"
de`cree	N-to-V	"N"
`decrement	N	"N"
de`crepitude	N	"N"
`deed	N-to-V	"N"
`deerskin	N	"N"
`deerstalker	N	"N"
de`fault	N-to-V-AJ	"N"
`defect	N	"N" ;blemish
de`fense	N	"N"
de`fence	N	"N"
defensi`bility	N	"V(de`fend)+AJR25+NR21"
`deference	N	"V(de`fer)+NR26"
`deficit	N	"N"
de`ficiency	N	"AJ(de`ficient)+NR40"
de`foliant	N	"V(de`foliate)+NR17"
de`formity	N	"V(de`form)+NR21"
de`generacy	N	"AJ(de`generate)+NR40"
de`gree	N	"N"
deifi`cation	N	"V(`deify)+NR23"
`deity	N	"N"
`delegate	N	"V(`delegate).NR0" ;[-@t]
`delicacy	N	"AJ(`delicate)+NR40"
delica`tessen	N	"N"
de`lineament	N	"N"
de`linquency	N	"AJ(de`linquent)+NR40"
de`lirium	N	"N"
de`livery	N	"V(de`liver)+NR35"
`dell	N	"N"
`delta	N	"N" ;river delta
`deltoid	N	"N"
`deluge	N-to-V	"N"
de`lusion	N	"V(de`lude)+NR23"
`demagogue	N	"N"
dema`goguery	N	"N(`demagogue)+NR3"
de`meanor	N	"N"
de`meanour	N	"N" ;British
de`merit	N	"N"
`demigod	N	"N"
`demijohn	N	"N"
de`mise	N	"N"
`demo	N	"N"
de`mocracy	N	"N(`democrat)+NR40"
`democrat	N	"N"
demo`lition	N	"V(de`molish)+NR23"
`demon	N	"N"
de`moniac	N	"N"
de`monstrative	N	"V(`demonstrate)+AJR26.NR0"
`den	N	"N"
`denizen	N	"N"
denoue`ment	N	"N"
`dent	N-to-V	"N"
`dentist	N	"N"
`dentistry	N	"N"
`denture	N	"N"
denunci`ation	N	"V(de`nounce)+NR40"
de`odorant	N	"REV2+N(`odor).VR0+NR17"
de`partment	N	"N"
de`parture	N	"V(de`part)+NR38"
de`pendency	N	"V(de`pend)+AJR27b+NR40"
de`pendent	N	"V(de`pend)+AJR27b.NR0"
de`positary	N	"V(de`posit)+NR39"
depo`sition	N	"N"
`depot	N	"N"
de`pravity	N	"V(de`prave)+NR21"
`depth	N	"AJ(`deep)+NR42"
`deputy	N	"N"
`derby	N	"N"
de`rision	N	"V(de`ride)+NR40"
`derivate	N	"N"
`derrick	N	"N"
derri`ere	N	"N"
`dervish	N	"N"
`descant	N	"N"
des`cent	N	"N"
des`cription	N	"V(des`cribe)+NR40"
des`criptor	N	"V(des`cribe)+NR20"
`desert	N	"N"
`desk	N	"N"
`desktop	N	"N"
de`sorption	N	"V(de`sorb)+NR40"
desper`ation	N	"V(des`pair)+NR23"
de`spite	N	"N"
des`pondence	N	"V(des`pond)+AJR27+NR41"
des`pondency	N	"V(des`pond)+AJR27+NR40"
`despot	N	"N"
des`sert	N	"N"
`destiny	N	"N"
desti`tution	N	"AJ(`destitute)+NR23"
de`suetude	N	"N"
`detail	N	"V(de`tail).NR0"
de`tective	N	"V(de`tect)+AJR26.NR0"
`detent	N	"N"
de`tente	N	"N"
de`tention	N	"V(de`tain)+NR40"
de`tergent	N	"N"
de`terminacy	N	"V(de`termine)+AJR24+NR40"
de`terminism	N	"N"
de`terminist	N	"N"
`detour	N-to-V	"N"
detoxifi`cation	N	"REV2+N(`toxin)+VR5+NR23"
`detriment	N	"N"
`deuce	N	"N"
`deviance	N	"AJ(`deviant)+NR41"
`deviancy	N	"AJ(`deviant)+NR40"
de`vice	N	"N"
`devil	N	"N"
devo`lution	N	"V(de`volve)+NR23"
`dew	N	"N"
`dewar	N	"N"
`dewdrop	N	"N"
`dextrose	N	"N"
dia`betes	N	"N"
dia`critic	N	"N"
`diadem	N	"N"
`diagram	N-to-V	"N"
`dial	N-to-V	"N"
`dialect	N	"N"
`dialog	N-to-V	"N"
`dialogue	N-to-V	"N"
di`alysis	N	"N"
di`ameter	N	"N"
`diamond	N	"N"
`diaper	N-to-V	"N"
`diaphragm	N	"N"
diar`rhea	N	"N"
diar`rhoea	N	"N"
`diary	N	"N"
`diatribe	N	"N"
`dibble	N-to-V	"N"
`dick	N	"N"
`dickens	N	"N"
`dickey	N	"N"
`diction	N	"N"
`dictionary	N	"N"
`diehard	N	"N"
`diesel	N	"N"
`diet	N-to-V	"N"
die`tician	N	"N(dia`tetics)+NR29"
die`titian	N	"N(dia`tetics)+NR29"
differ`ential	N	"N"
`difficulty	N	"AJ(`difficult)+NR21"
`diffidence	N	"AJ(`diffident)+NR41"
`digest	N	"V(di`gest).NR0"
`digit	N	"N"
digi`talis	N	"N"
`dignitary	N	"N"
`dignity	N	"N"
`digram	N	"N"
di`lemma	N	"N"
`dilettante	N	"N"
`diligence	N	"AJ(`diligent)+NR41"
`dill	N	"N"
`dime	N	"N"
di`mension	N	"N"
dimi`nution	N	"V(di`minish)+NR40"
`dimple	N-to-V	"N"
`din	N	"N"
`ding	N-to-V	"N"
`dinghy	N	"N"
`dinner	N	"N"
`dinnertime	N	"N"
`dinnerware	N	"N"
`dinosaur	N	"N"
`dint	N	"N"
`diocese	N	"N"
`diode	N	"N"
`diopter	N	"N"
dio`rama	N	"N"
diph`theria	N	"N"
`diphthong	N	"N"
di`ploma	N	"N"
di`plomacy	N	"N(`diplomat)+NR40"
`diplomat	N	"N"
di`rectorate	N	"N"
di`rectory	N	"N"
`dirge	N	"N"
`dirt	N	"N"
`disc	N	"N"
`discard	N	"V(dis`card).NR0"
dis`ciple	N	"N"
`discipline	N-to-V	"N"
`disco	N	"N"
`discord	N-to-V	"N"
`discount	N-to-V	"V(dis`count).NR0"
`discourse	N-to-V	"N"
dis`covery	N_Suffix1a	"V(dis`cover)+NR3"
dis`crepancy	N	"AJ(dis`crepant)+NR40"
dis`cretion	N	"AJ(dis`creet)+NR23"
dis`criminant	N	"V(dis`criminate)+NR17"
`discus	N	"N"
dis`dain	N-to-V	"N"
`dish	N-to-V	"N"
`dishful	N_Suffix1a	"N(`dish)+NR5"
`dishwasher	N	"N"
`dishwater	N	"N"
`disk	N	"N"
dis`pensary	N	"V(dis`pense)+NR39"
dis`quietude	N	"N"
disqui`sition	N	"N"
disre`pair	N	"REV3+V(re`pair)"
dis`sension	N	"V(dis`sent)+NR40"
`dissident	N	"V(dis`sent)+NR17"
`dissonance	N	"AJ(`dissonant)+NR41"
`distaff	N-to-AJ	"N"
`distance	N-to-V	"AJ(`distant)+NR41"
`distillate	N	"V(dis`till)+NR46"
dis`tillery	N_Suffix1a	"V(dis`till)+NR3"
dis`tinction	N	"AJ(dis`tinct)+NR23"
dis`tress	N-to-V	"N"
`district	N	"N"
`ditch	N-to-V	"N"
`ditto	N-to-V	"N"
`ditty	N	"N"
`diva	N	"N"
`divan	N	"N"
di`version	N	"V(di`vert)+NR40"
di`vestiture	N	"V(di`vest)+NR38"
`dividend	N	"N"
divisi`bility	N	"V(di`vide)+AJR25+NR21"
di`vision	N	"V(di`vide)+NR40"
di`visor	N	"V(di`vide)+NR20"
`dock	N	"N" ;pier
`docket	N	"N"
`dockside	N	"N"
`dockyard	N	"N"
`doctor	N-to-V	"N"
`doctorate	N	"N(`doctor)+NR46"
`doctrine	N	"N"
`document	N-to-V	"N"
docu`mentary	N	"N(`document)+NR39"
`doer	N	"V(`do)+NR19"
`doe	N	"N"
`dog	N-to-V	"N"
`dogfish	N	"N"
`doghouse	N	"N"
`dogleg	N	"N"
`dogma	N	"N"
`dogmatism	N_Suffix1b	"N(`dogma)+NR8"
`dogtrot	N	"N"
`dogwood	N	"N"
`doll	N	"N"
`dollar	N	"N"
`dollop	N	"N"
`dolly	N	"N"
`dolphin	N	"N"
`dolt	N	"N"
do`main	N	"N"
`dome	N	"N"
`domicile	N	"N"
`dominance	N	"V(`dominate)+AJR27+NR41"
do`minion	N	"N"
`domino	N	"N"
`donkey	N	"N"
`donnybrook	N	"N"
`donor	N	"N"
`doodle	N	"N"
`doom	N-to-V	"N"
`doomsday	N	"N"
`door	N	"N"
`doorbell	N	"N"
`doorkeep	N	"N(`door)+V(`keep)+NR19"
`doorknob	N	"N"
`doorstep	N	"N"
`doorway	N	"N"
`dope	N-to-V	"N" ;drugs
`dormancy	N	"AJ(`dormant)+NR40"
`dormitory	N	"N"
`dose	N-to-V	"N"
`dossier	N	"N"
`dot	N-to-V	"N"
double`header	N	"N"
`doublet	N	"N"
`doubleton	N	"N"
doub`loon	N	"N"
`dough	N	"N"
`doughnut	N	"N"
`dove	N	"N" ;bird
`dovetail	N-to-V	"N"
`dowager	N	"N"
`dowel	N	"N"
`down	N	"N"
`downdraft	N	"N"
`downfall	N	"N"
`downhill	N-to-AJ	"N"
`downpour	N	"N"
`downside	N	"N"
`downslope	N	"N"
`downspout	N	"N"
`downstate	N	"N"
`downtown	N	"N"
`downtrend	N	"N"
`downturn	N	"N"
`dowry	N	"N"
dox`ology	N	"N"
`doxy	N	"N"
`dozen	N-to-AJ	"N"
`draft	N	"N" ;breeze
`draftsperson	N	"N"
`dragnet	N	"N"
`dragon	N	"N"
`dragonfly	N	"N"
dra`goon	N-to-V	"N"
`drake	N	"N"
`dram	N	"N"
`drama	N	"N"
`dramatist	N_Suffix1a	"N(`drama)+NR31"
`dramaturgy	N	"N"
`drape	N-to-V	"N"
`drapery	N_Suffix1a	"N(`drape)+NR3"
`draught	N	"N" ;British var. of draft
`drawback	N	"N"
`drawbridge	N	"N"
`drawing	N	"V(`draw)+NR24"
`dreadnought	N	"N"
`dreamboat	N	"N"
`dreg	N	"N"
`dressing	N	"V(`dress)+NR24"
`dressmaker	N	"N(`dress)+V(`make)+NR19"
`dressmaking	N	"N(`dress)+V(`make)+PRG"
`drib	N	"N"
`drippings	N	"V(`drip)+NR24+PL"
`driveway	N	"N"
`drizzle	N-to-V	"N"
`dromedary	N	"N"
`drone	N	"N"
`dropout	N	"N"
`dropping	N	"V(`drop)+NR24"
`dropsy	N	"N"
`dross	N	"N"
`drought	N	"N"
`drove	N	"N"
`drudge	N	"N"
`drudgery	N_Suffix1a	"N(`drudge)+NR3"
`drug	N-to-V	"N"
`drugstore	N	"N"
`druid	N	"N"
`drum	N-to-V	"N"
`drumhead	N	"N"
`drumstick	N	"N"
`drunkard	N	"N"
`dryad	N	"N"
`ducat	N	"N"
`duchess	N_Suffix1a	"N(`duke)+NR12"
`duck	N	"N" ;bird
`duct	N	"N"
`ducting	N	"N(`duct)+NR7"
`ductwork	N	"N"
`dud	N	"N"
du`et	N	"N"
`duff	N	"N"
`duffel	N	"N"
`dugout	N	"N"
`duke	N	"N"
`dulse	N	"N"
`dumbbell	N	"N"
`dummy	N-to-AJ	"N"
`dunce	N	"N"
`dune	N	"N"
`dung	N	"N"
`dungeon	N	"N"
du`plicity	N	"N"
dura`bility	N	"AJ(`durable)+NR21"
du`ration	N	"N"
du`ress	N	"N"
`dusk	N	"N"
`dust	N-to-V	"N"
`dustbin	N	"N"
`duty	N	"N"
`dwelling	N	"V(`dwell)+NR24"
`dyad	N	"N"
`dye	N-to-V	"N"
`dynamism	N	"N"
`dynamite	N-to-V	"N"
`dynamo	N	"N"
`dynast	N	"N"
`dynasty	N	"N"
`dyne	N	"N"
`dysentery	N	"N"
dys`function	N	"N"
dys`pepsia	N	"N"
`dystrophy	N	"N"

`eagle	N	"N"
`eaglet	N_Suffix1a	"N(`eagle)+NR14"
`ear	N	"N"
`eardrum	N	"N"
`earful	N_Suffix1a	"N(`ear)+NR5"
`earl	N	"N"
`earlobe	N	"N"
`earmark	N-to-V	"N"
`earning	N	"V(`earn)+NR24"
`earphone	N	"N"
`earring	N	"N"
`earth	N	"N"
`earthenware	N	"N"
`earthquake	N	"N"
`earthworm	N	"N"
`earwig	N	"N"
`ease	N-to-V	"N"
`easel	N	"N"
`east	N-to-AJ	"N"
`easterner	N	"N"
`eave	N	"N"
`ebony	N	"N"
e`bullience	N	"AJ(e`bullient)+NR41"
ec`centric	N	"AJ(ec`centric).NR0"
`echelon	N	"N"
e`clat	N	"N"
`eclogue	N	"N"
`ecosystem	N	"N"
`ecstasy	N	"N"
ecu`menicist	N	"N"
`eddy	N-to-V	"N"
`edelweiss	N	"N"
`edge	N-to-V	"N"
`edging	N	"N(`edge)+NR7" ;or V(`edge)
`edict	N	"N"
edifi`cation	N	"V(`edify)+NR23"
`edifice	N	"N"
edi`torial	N	"N"
`eel	N	"N"
ef`feminacy	N	"AJ(ef`feminate)+NR40"
effer`vescence	N	"V(effer`vesce)+AJR27+NR41"
`efficacy	N	"N"
ef`ficiency	N	"AJ(ef`ficient)+NR40"
`effigy	N	"N"
`effort	N	"N"
ef`fulgence	N	"AJ(ef`fulgent)+NR41"
`egg	N	"N"
`egghead	N	"N"
`eggplant	N	"N"
`eggshell	N	"N"
`ego	N	"N"
`egotism	N	"N"
`egotist	N	"N"
`egress	N	"V(e`gress).NR0"
`egret	N	"N"
`eider	N	"N"
;`el	N	"N"
e`lan	N	"N"
e`lastic	N	"AJ(e`lastic).NR0"
`elbow	N-to-V	"N"
e`lectorate	N	"V(e`lect)+NR20+NR46"
e`lectress	N_Suffix1a	"N(e`lector)+NR12"
e`lectret	N	"N"
elec`trician	N	"AJ(e`lectric)+NR29"
electrification	N	"AJ(e`lectric)+VR5+NR23"
electro`cardiogram	N	"N"
electro`cardiograph	N	"N"
e`lectrode	N	"N"
elec`trolysis	N	"N"
e`lectrolyte	N	"N"
e`lectron	N	"N"
`elegance	N	"AJ(`elegant)+NR41"
`elegy	N	"N"
`element	N	"N"
`elephant	N	"N"
eligi`bility	N	"AJ(`eligible)+NR21"
e`lision	N	"V(e`lide)+NR23"
`ell	N	"N"
el`lipse	N	"N"
el`lipsis	N	"N"
el`lipsoid	N	"N"
`elm	N	"N"
`eloquence	N	"AJ(`eloquent)+NR41"
;`em	N	"N"
`e-mail	N-to-V	"N"
`email	N-to-V	"N"
embarca`dero	N	"N"
`embassy	N	"N"
`ember	N	"N"
`emblem	N	"N"
em`bodiment	N	"VR1+N(`body)+NR25"
`embouchure	N	"N"
em`broidery	N	"V(em`broider)+NR35"
`embryo	N	"N"
em`cee	N-to-V	"N"
`emerald	N	"N"
e`mergency	N	"N"
`emigrant	N	"N"
`eminence	N	"AJ(`eminent)+NR41"
e`mir	N	"N"
`emirate	N	"N(e`mir)+NR46"
`emissary	N	"N"
e`mission	N	"V(e`mit)+NR23"
`emmy	N	"N"
e`molument	N	"N"
e`motion	N	"N"
`emperor	N	"N"
emphy`sema	N	"N"
`empire	N	"N"
em`porium	N	"N"
`empress	N_Suffix1a	"N(`emperor)+NR12"
emulsifi`cation	N	"V(e`mulsify)+NR23"
e`mulsion	N	"N"
;`en	N	"N"
e`namel	N-to-V	"N"
encepha`litis	N	"N"
en`chantress	N_Suffix1a	"V(en`chant)+NR20+NR12"
`enclave	N	"N"
en`closure	N	"V(en`close)+NR38"
`encore	N	"N"
en`cumbrance	N	"V(en`cumber)+NR26"
encyclo`pedia	N	"N"
`end	N-to-V	"N"
`endgame	N	"N"
`ending	N	"V(`end)+NR24"
`endosperm	N	"N"
`endpoint	N	"N"
`enema	N	"N"
`enemy	N	"N"
`energy	N	"N"
en`fant	N	"N"
`engine	N	"N"
en`graving	N	"V(en`grave)+NR24"
e`nigma	N	"N"
en`joinder	N	"N"
`enmity	N	"N"
en`nui	N	"N"
e`normity	N	"N" ;cf. enormous
`enquiry	N	"N" ;cf. enquire
en`semble	N	"N"
`ensign	N	"N"
en`tendre	N	"N"
`enterprise	N	"N"
en`thusiasm	N	"N"
en`thusiast	N	"N"
en`tirety	N	"AJ(en`tire)+NR21"
`entity	N	"N"
`entourage	N	"N"
`entranceway	N	"N"
`entrant	N	"V(`enter)+NR17"
en`treaty	N	"N"
entrepre`neur	N	"N"
`entropy	N	"N"
`entry	N	"V(`enter)+NR35"
`envelope	N	"N"
en`viron	N	"N"
en`vironment	N	"N"
`envoy	N	"N"
`enzyme	N	"N"
epau`let	N	"N"
`epic	N	"N"
`epicenter	N	"NEO9+N(`center)"
`epicure	N	"N"
`epicycle	N	"NEO9+N(`cycle)"
epi`demic	N	"N"
epi`dermis	N	"N"
`epigram	N	"N"
`epigraph	N	"N"
epi`leptic	N	"AJ(epi`leptic).NR0"
`epilog	N	"N"
`epilogue	N	"N"
e`piphany	N	"N"
e`piscopal	N	"N"
e`piscopate	N	"N"
`episode	N	"N"
e`pistle	N	"N"
`epitaph	N	"N"
`epithet	N	"N"
e`pitome	N	"N"
`epoch	N	"N"
`epochs	N	"N(`epoch)+PL"
e`poxy	N	"N"
equa`nimity	N	"N"
`equinox	N	"N"
equi`tation	N	"N"
`equity	N	"N"
e`quivalence	N	"AJ(`e`quivalent)+NR41"
e`quivalency	N	"AJ(`e`quivalent)+NR40"
`era	N	"N"
e`rasure	N	"V(e`rase)+NR38"
`ermine	N	"N"
e`rosion	N	"V(e`rode)+NR23"
`errancy	N	"AJ(`errant)+NR40"
`errand	N	"N"
`errantry	N	"N"
`error	N	"N"
eru`dition	N	"AJ(`erudite)+NR23"
`escadrille	N	"N"
`escapade	N	"N"
es`cheat	N-to-V	"N"
`escort	N	"V(es`cort).NR0"
`escritoire	N	"N"
`escrow	N	"N"
es`cutcheon	N	"N"
`espionage	N	"N"
`esplanade	N	"N"
es`prit	N	"N"
`esquire	N	"N"
`essay	N	"N"
`essence	N	"N"
es`tate	N	"N"
`ester	N	"N"
es`toppal	N	"N"
`estuary	N	"N"
`etching	N	"V(`etch)+NR24"
e`ternity	N	"N" ;cf. eternal
`ethanol	N	"N"
`ether	N	"N"
`ethic	N	"N"
`ethos	N	"N"
`ethyl	N	"N"
`etiquette	N	"N"
`etude	N	"N"
evita`bility	N	"AJ(`evitable)+NR21"
euca`lyptus	N	"N"
`eucharist	N	"N"
`eulogy	N	"N"
`eunuch	N	"N"
`euphemism	N	"N"
eu`phoria	N	"N"
eutha`nasia	N	"N"
evacu`ee	N	"V(e`vacuate)+NR18"
evan`escence	N	"V(evan`esce)+AJR27+NR41"
e`vangel	N	"N"
evan`gelical	N	"N(e`vangel)+AJR20+AJR17.NR0"
e`vasion	N	"V(e`vade)+NR23"
`eve	N	"N"
`evening	N	"N"
`evensong	N	"N"
e`vent	N	"N"
`eventide	N	"N"
`everyman	N	"N"
`evidence	N	"N"
`evildoer	N	"N"
e`vocation	N	"V(e`voke)+NR23"
evo`lution	N	"V(e`volve)+NR23"
`ewe	N	"N"
`ewer	N	"N"
;`ex	N	"N"
ex`actitude	N	"N"
ex`am	N	"N" ;examination
ex`ample	N-to-V	"N"
`excellency	N	"V(ex`cell)+AJR27+NR40"
ex`celsior	N	"N"
ex`ception	N	"N"
`excerpt	N-to-V	"N"
`excess	N	"N"
ex`chequer	N	"N"
excla`mation	N	"V(ex`claim)+NR23"
ex`clusion	N	"V(ex`clude)+NR23"
ex`cursion	N	"N"
ex`cursus	N	"N"
execu`tioner	N	"V(`execute)+NR23+NR19"
ex`ecutive	N	"N"
ex`ecutor	N	"N"
ex`ecutrix	N	"N"
exe`gesis	N	"N"
`exegete	N	"N"
ex`emplar	N	"N"
exemplifi`cation	N	"V(ex`emplify)+NR23"
ex`emption	N	"AJ(ex`empt)+NR23"
ex`igency	N	"AJ(`exigent)+NR40"
`exodus	N	"N"
`exorcism	N	"N"
`exorcist	N_Suffix1a	"V(`exorcise)+NR31"
`exoskeleton	N	"NEO8+N(`skeleton)"
ex`panse	N	"N"
ex`pansion	N	"V(ex`pand)+NR23"
ex`pectancy	N	"V(ex`pect)+AJR27+NR40"
ex`pectorant	N	"N"
ex`pediency	N	"V(ex`pedient)+NR40"
expe`dition	N	"N"
ex`penditure	N	"V(ex`pend)+NR38"
ex`pense	N	"N"
`expert	N	"N"
exper`tise	N	"N"
expla`nation	N	"V(ex`plain)+NR23"
`expletive	N	"N"
`exploit	N	"V(ex`ploit).NR0"
ex`plosion	N	"V(ex`plode)+NR23"
`expo	N	"N" ;exposition
`exponent	N	"N"
`export	N	"V(ex`port).NR0"
ex`posure	N	"V(ex`pose)+NR38"
ex`pressway	N	"N"
ex`pulsion	N	"V(ex`pell)+NR23"
extensi`bility	N	"V(ex`tend)+AJR25+NR21"
ex`tension	N	"V(ex`tend)+NR23"
ex`tensor	N	"N"
ex`tent	N	"N"
ex`terior	N	"N"
ex`tinction	N	"AJ(ex`tinct)+NR23"
ex`tortioner	N	"V(ex`tort)+NR23+NR19"
`extract	N	"V(ex`tract).NR0"
ex`travagance	N	"AJ(ex`travagant)+NR41"
extrava`ganza	N	"N"
extro`version	N	"N(`extrovert)+NR23"
`extrovert	N	"N"
ex`trusion	N	"V(ex`trude)+NR23"
ex`uberance	N	"AJ(ex`uberance)+NR41"
`eye	N-to-V	"N"
`eyeball	N	"N"
`eyebrow	N	"N"
`eyeful	N_Suffix1a	"N(`eye)+NR5"
`eyeglass	N	"N"
`eyelash	N	"N"
`eyelid	N	"N"
`eyepiece	N	"N"
`eyesight	N	"N"
`eyesore	N	"N"
eye`witness	N	"N"
`eyrie	N	"N"

`fable	N	"N"
`fabric	N	"N"
fa`cade	N	"N"
`face	N-to-V	"N"
`faceplate	N	"N"
`facet	N	"N"
fac`simile	N	"N"
`fact	N	"N"
`faction	N	"N"
`factor	N-to-V	"N"
`factory	N	"N"
`faculty	N	"N(`faculty1)" ;sense
`fad	N	"N"
`fadeout	N	"N"
`faery	N	"N"
`fag	N	"N"
fa`jita	N	"N"
`failure	N	"V(`fail)+NR38"
`fair	N	"N"
`fairgoer	N	"N"
`fairway	N	"N"
`fairy	N	"N"
`fairytale	N-to-AJ	"N"
`faith	N	"N"
`falcon	N	"N"
`falconry	N_Suffix1a	"N(`falcon)+NR3"
`fall	N	"N" ;autumn
`fallacy	N	"N"
`falloff	N	"N"
`fallout	N	"N"
`falsehood	N_Suffix1b	"AJ(`false)+NR6"
`fame	N	"N"
`family	N	"N"
`famine	N	"N"
fa`natic	N	"N"
`fanfare	N	"N"
`fang	N	"N"
`fanout	N	"N"
fan`tasia	N_Suffix1a	"N(`fantasy)+NR61"
`fantasist	N_Suffix1a	"N(`fantasy)+NR31"
`fantasy	N	"N"
`farad	N	"N"
`farce	N	"N"
`fare	N	"N"
fare`well	N	"N"
fa`rina	N	"N"
`farm	N-to-V	"N"
`farmhouse	N	"N"
`farmland	N	"N"
`farmyard	N	"N"
`faro	N	"N"
`farthing	N	"N"
`fascicle	N	"N"
`fascism	N	"N"
`fascist	N	"N"
`fashion	N-to-V	"N"
`fat	N-to-AJ	"N"
`fate	N	"N"
`father	N-to-V	"N"
`fathom	N	"N"
fa`tigue	N-to-V	"N"
`faucet	N	"N"
`fault	N-to-V	"N"
`faun	N	"N"
`fawn	N	"N"
`fax	N-to-V	"N"
`fealty	N	"N"
feasi`bility	N	"AJ(`feasible)+NR21"
`feast	N-to-V	"N"
`feat	N	"N"
`feather	N-to-V	"N"
`featherbed	N-to-V	"N"
`featherbrain	N	"N"
`featherweight	N	"N"
`feature	N-to-V	"N"
`fee	N	"N"
`feedback	N	"N"
`feeling	N	"V(`feel)+NR24"
`feldspar	N	"N"
fe`licity	N	"N"
`fellow	N	"N"
`felon	N	"N"
`felony	N	"N"
`feminism	N_Suffix1b	"AJ(`feminine)+NR8"
`feminist	N_Suffix1a	"AJ(`feminine)+NR31"
`femur	N	"N"
`fence	N-to-V	"N"
`fencepost	N	"N"
`fencing	N	"N(`fence)+NR7"
`fennel	N	"N"
`fenugreek	N	"N"
`ferment	N	"V(fer`ment).NR0"
`fern	N	"N"
`fernery	N_Suffix1a	"N(`fern)+NR3"
fe`rocity	N	"N"
`ferret	N-to-V	"N"
`ferris	N	"N"
`ferrule	N	"N"
`ferry	N-to-V	"N"
`ferule	N	"N"
`fervency	N	"AJ(`fervent)+NR40"
`fervor	N	"N"
`fervour	N	"N" ;British
`fescue	N	"N"
`fest	N	"N"
`festival	N	"N"
fes`toon	N-to-V	"N"
`fete	N	"N"
`fetish	N	"N"
`fetter	N-to-V	"N"
`fettle	N	"N"
`fetus	N	"N"
`feud	N-to-V	"N"
`fever	N-to-V	"N"
fi`ance	N	"N"
fi`ancee	N	"N"
`fiat	N	"N"
`fiber	N	"N"
`fiberboard	N	"N"
`fibre	N	"N"
fi`brosis	N	"N"
`fiche	N	"N"
`fiction	N	"N"
`fiddle	N-to-V	"N"
`fiddlestick	N	"N"
`fide	N	"N"
fi`delity	N	"N"
fi`duciary	N	"N"
`fief	N	"N"
`field	N-to-V	"N"
`fieldstone	N	"N"
`fieldwork	N	"N"
`fiend	N	"N"
fi`esta	N	"N"
`fife	N	"N"
`fig	N	"N"
`figure	N-to-V	"N"
figu`rine	N	"N"
`filament	N	"N"
`filbert	N	"N"
`filename	N	"N"
fi`let	N	"N"
`filigree	N	"N"
`filing	N	"V(`file)+NR24"
fil`let	N-to-V	"N" ;also `fillet
`filling	N	"V(`fill)+NR24"
`filly	N	"N"
`film	N-to-V	"N"
`filmmaker	N	"N(`film)+V(`make)+NR19"
`filmmaking	N	"N(`film)+V(`make)+PRG"
`filmstrip	N	"N"
`filth	N	"N"
`fin	N	"N"
fi`nale	N	"N"
`finance	N-to-V	"N"
finan`cier	N	"N(`finance)+NR19"
`finch	N	"N"
`finding	N	"V(`find)+NR24"
`fine	N-to-V	"N"
fi`nesse	N-to-V	"N"
`finger	N-to-V	"N"
`fingering	N	"N(`finger).VR0+NR24"
`fingernail	N	"N"
`fingerprint	N	"N"
`fingertip	N	"N"
`finitude	N	"N"
`fink	N-to-V	"N"
`fir	N	"N"
`fire	N-to-V	"N"
`firearm	N	"N"
`fireboat	N	"N"
`firebreak	N	"N"
`firebug	N	"N"
`firecracker	N	"N"
`firefly	N	"N"
`firefighter	N	"N(`fire)+V(`fight)+NR19"
`firefighting	N	"N(`fire)+V(`fight)+PRG"
`firehouse	N	"N"
`firelight	N	"N"
`fireplace	N	"N"
`firepower	N	"N"
`fireside	N	"N"
`firestorm	N	"N"
`firewall	N	"N"
`firewood	N	"N"
`firework	N	"N"
`firkin	N	"N"
`firm	N	"N"
`firmament	N	"N"
`firmware	N	"N"
`firstfruit	N	"N"
`fishery	N_Suffix1a	"N(`fish)+NR3"
`fishmonger	N	"N"
`fishnet	N	"N"
`fishpond	N	"N"
`fission	N	"N"
`fissure	N	"N"
`fist	N	"N"
`fistful	N_Suffix1a	"N(`fist)+NR5"
`fisticuff	N	"N"
`fit	N	"N"
`fixture	N	"N"
`fjord	N	"N"
`flab	N	"N"
`flack	N	"N"
`flag	N	"N"
flageo`let	N	"N"
`flagpole	N	"N"
`flagrance	N	"AJ(`flagrant)+NR41"
`flagstone	N	"N"
`flair	N	"N"
`flak	N	"N"
`flake	N-to-V	"N"
`flam	N	"N"
flam`boyance	N	"AJ(flam`boyant)+NR41"
flam`boyancy	N	"AJ(flam`boyant)+NR40"
`flame	N-to-V	"N"
flamma`bility	AJ	"N(`flame)+AJR25+NR21"
`flange	N	"N"
`flank	N-to-V	"N"
`flannel	N	"N"
`flap	N	"N"
`flapper	N	"N"
`flareup	N	"N"
`flashback	N	"N"
`flashlight	N	"N"
`flask	N	"N"
`flatbed	N	"N"
`flathead	N	"N"
`flatiron	N	"N"
`flatland	N	"N"
`flattery	N_Suffix1a	"V(`flatter)+NR3"
`flatulence	N	"AJ(`flatulent)+NR41"
`flatus	N	"N"
`flatware	N	"N"
`flatworm	N	"N"
`flautist	N_Suffix1a	"N(`flute)+NR31"
`flavor	N-to-V	"N"
`flavour	N-to-V	"N" ;British
`flavoring	N	"N(`flavor)+NR7"
`flavouring	N	"N(`flavor)+NR7" ;British
`flaw	N	"N"
`flax	N	"N"
`flaxseed	N	"N"
`flea	N	"N"
`fleabane	N	"N"
`fleck	N	"N"
`fledgling	N_Suffix1a	"V(`fledge)+NR15"
`fleece	N	"N"
`fleet	N	"N"
`flesh	N-to-V	"N"
`flicker	N-to-V	"N"
`flight	N	"N"
`flightpath	N	"N"
`flint	N	"N"
`flintlock	N	"N"
`flipper	N	"N"
`floc	N	"N"
`flock	N	"N"
`floe	N	"N"
`flood	N-to-V	"N"
`floodgate	N	"N"
`floodlight	N	"N"
`floor	N	"N"
`floorboard	N	"N"
`flooring	N	"N(`floor)+NR7"
`florin	N	"N"
`florist	N	"N(`flower)+NR31"
`floss	N-to-V	"N"
flo`tation	N	"V(`float)+NR23"
flo`tilla	N	"N"
`flour	N	"N"
`flowchart	N	"N"
`flower	N-to-V	"N"
`flowerpot	N	"N"
`flu	N	"N"
`flue	N	"N"
`fluency	N	"AJ(`fluent)+NR40"
`fluff	N	"N"
`fluke	N	"N"
`flume	N	"N"
`fluoride	N	"N"
`flurry	N	"N"
`flute	N	"N"
`flux	N	"N"
`fly	N	"N"
`flyby	N	"N"
`flycatcher	N	"N"
`flyway	N	"N"
`foal	N-to-V	"N"
`foam	N-to-V	"N"
`fob	N	"N"
`fodder	N	"N"
`foe	N	"N"
`foetus	N	"N" ;British
`fog	N-to-V	"N"
`fogy	N	"N"
`foible	N	"N"
`foil	N	"N"
`foldout	N	"N"
`foliage	N	"N"
`fold	N	"N" ;of sheep
`folio	N	"N"
`folklore	N	"N"
`folksong	N	"N"
`folktale	N	"N"
`follicle	N	"N"
`following	N	"V(`follow)+NR24"
`folly	N	"N"
`font	N	"N"
`food	N	"N"
`foodstuff	N	"N"
`fool	N-to-V	"N"
`foot	N-to-V	"N"
`football	N	"N"
`footbridge	N	"N"
`footfall	N	"N"
`foothill	N	"N"
`foothold	N	"N"
`footing	N	"N(`foot)+NR7"
`footnote	N	"N"
`footpad	N	"N"
`footpath	N	"N"
`footprint	N	"N"
`footstep	N	"N"
`footstool	N	"N"
`footwear	N	"N"
`footwork	N	"N"
`fop	N	"N"
`foray	N	"N"
`fore	N	"N"
`foreigner	N	"AJ(`foreign)+NR19"
`forest	N-to-V	"N"
`forfeit	N-to-V	"N"
`forfeiture	N	"N(`forfeit).VR0+NR38"
`fork	N-to-V	"N"
`forkful	N_Suffix1a	"N(`fork)+NR5"
`forklift	N	"N"
`form	N-to-V	"N"
for`maldehyde	N	"N"
`formant	N	"N"
`format	N-to-V	"N"
`fort	N	"N"
`forestry	N_Suffix1a	"N(`forest)+NR3"
`forgery	N_Suffix1a	"V(`forge)+NR3"
`fortitude	N	"N"
`fortnight	N	"N"
`fortress	N	"N"
`fortune	N	"N"
`fossil	N	"N"
`foundling	N	"N"
`foundry	N	"N"
`fount	N	"N"
`fountain	N	"N"
`fountainhead	N	"N"
`fox	N	"N"
`foxglove	N	"N"
`foxhole	N	"N"
`foxhound	N	"N"
`foxtail	N	"N"
`foyer	N	"N"
`fraction	N	"N"
`fracture	N-to-V	"N"
`fracus	N	"N"
`fragment	N-to-V	"N"
`fragrance	N	"AJ(`fragrant)+NR41"
`fragrancy	N	"AJ(`fragrant)+NR40"
`frailty	N	"AJ(`frail)+AJR26"
`frame	N-to-V	"N"
`framework	N	"N"
`franc	N	"N"
`franchise	N-to-V	"N"
`frankfurter	N	"N"
`frankincense	N	"N"
`frat	N	"N" ;fraternity
fra`ternity	N	"N"
`fraud	N	"N"
`fraudulence	N	"N(`fraud)+AJR27+NR41"
`freak	N	"N"
`freckle	N-to-V	"N"
`freedom	N_Suffix1a	"AJ(`free)+NR2"
free`thinker	N	"AJ(`free)+V(`think)+NR19"
free`thinking	N-to-AJ	"AJ(`free)+V(`think)+PRG"
`freeway	N	"N"
`freight	N-to-V	"N"
`frenzy	N-to-V	"N"
`freon	N	"N"
`frequency	N	"AJ(`frequent)+NR40"
`freshet	N	"N"
`fret	N	"N" ;guitar fret
`friar	N	"N"
`fricative	N	"N"
`friction	N	"N"
`friend	N	"N"
`frieze	N	"N"
`frigate	N	"N"
`fright	N	"N"
`frill	N	"N"
`fringe	N-to-V	"N"
`fritter	N	"N"
fri`volity	N	"N"
`frizz	N-to-V	"N"
`frock	N	"N"
`frog	N	"N"
`frolicker	N	"V(`frolic)+NR19"
`front	N-to-V	"N"
`frontage	N_Suffix1a	"N(`front)+NR1"
`frontispiece	N	"N"
fron`tier	N	"N"
`frost	N-to-V	"N"
`frosting	N	"N(`frost)+NR7"
`froth	N-to-V	"N"
`fruit	N	"N"
fru`ition	N	"N"
`fuddy-duddy	N	"N"
`fudge	N-to-V	"N"
`fuel	N-to-V	"N"
`fugitive	N	"N"
`fugue	N	"N"
`fulcrum	N	"N"
`fullback	N	"N"
`fulness	N	"AJ(`full)+NR27"
`fume	N	"N"
`fumigant	N	"N"
`fun	N	"N"
`function	N-to-V	"N"
`functionary	N	"N(`function)+NR39"
`functor	N	"N"
`fund	N-to-V	"N"
`funeral	N	"N"
`fungicide	N_Suffix1a	"N(`fungus)+NR54"
`funk	N	"N"
`funnel	N-to-V	"N"
`fur	N-to-V	"N"
`furlong	N	"N"
`furlough	N-to-V	"N"
`furnace	N	"N"
`furnishing	N	"V(`furnish)+NR24"
`furniture	N	"N"
`furrier	N	"N"
`furrow	N-to-V	"N"
`furtherance	N	"N"
`fury	N	"N"
`furze	N	"N"
`fuse	N	"N"
`fuselage	N	"N"
`fusillade	N	"N"
`fusion	N	"N"
`fuzz	N	"N"

`gabardine	N	"N"
`gable	N	"N"
`gadfly	N	"N"
`gadget	N	"N"
`gadgetry	N_Suffix1a	"N(`gadget)+NR3"
`gaff	N	"N"
`gaffe	N	"N"
`gage	N	"N"
`gaggle	N	"N"
`gaiety	N	"AJ(`gay)+MONR21"
`gait	N	"N"
`gal	N	"N"
`gala	N	"N"
`galaxy	N	"N"
`gale	N	"N"
`gall	N	"N"
`gallantry	N_Suffix1a	"AJ(`gallant)+NR3"
`galleon	N	"N"
`gallery	N	"N"
`galley	N	"N"
`gallon	N_Suffix1a	"N(`gallon)+NR1"
`gallonage	N	"N"
`gallstone	N	"N"
`gam	N	"N"
`gambit	N	"N"
`game	N	"N"
`gamecock	N	"N"
`gamin	N	"N"
`gamine	N	"N"
`gamut	N	"N"
`gander	N	"N"
`gang	N-to-V	"N"
`gangland	N	"N"
`gangplank	N	"N"
`gangway	N	"N"
`gantlet	N	"N"
`gantry	N	"N"
`gap	N-to-V	"N"
ga`rage	N-to-V	"N"
`garb	N-to-V	"N"
`garbage	N	"N"
`garden	N-to-V	"N"
gar`denia	N	"N"
`garland	N	"N"
`garlic	N	"N"
`garment	N	"N"
`garner	N-to-V	"N"
`garnet	N	"N"
`garnish	N-to-V	"N"
`garrison	N-to-V	"N"
`garter	N	"N"
`gas	N-to-V	"N"
`gash	N-to-V	"N"
`gasket	N	"N"
`gaslight	N	"N"
`gasohol	N	"N"
gaso`line	N	"N"
`gastronome	N	"N"
`gate	N	"N"
`gatekeeper	N	"N(`gate)+V(`keep)+NR19"
`gateway	N	"N"
`gator	N	"N"
gauche`rie	N	"N"
`gauge	N-to-V	"N"
`gauntlet	N	"N"
`gauze	N	"N"
`gavel	N	"N"
ga`votte	N	"N"
ga`zebo	N	"N"
ga`zette	N	"N"
`gear	N-to-V	"N"
`geisha	N	"N"
`gel	N-to-V	"N"
`gelatin	N	"N"
`gelding	N	"V(`geld)+NR24"
`gem	N	"N"
`gemstone	N	"N"
gen`darme	N	"N"
`gender	N	"N"
`gene	N	"N"
`general	N	"N"
gener`osity	N	"AJ(`generous)+NR21"
`genesis	N	"N"
`genie	N	"N"
`genocide	N	"N"
`genotype	N	"N"
`genre	N	"N"
`gent	N	"N"
`gentian	N	"N"
`gentile	N	"N"
gen`tility	N	"N"
`gentry	N	"N"
ge`ranium	N	"N"
`gerbil	N	"N"
`germ	N	"N"
`gerund	N	"N"
ge`rundive	N	"N"
ge`stalt	N	"N"
`getaway	N	"N"
`geyser	N	"N"
`gherkin	N	"N"
`ghost	N	"N"
`ghoul	N	"N"
`giant	N	"N"
`gibberish	N	"N"
`gibbet	N	"N"
`gibbon	N	"N"
`giblet	N	"N"
`gift	N	"N"
`gig	N-to-V	"N"
`gill	N	"N"
`gigolo	N	"N"
`gimbal	N-to-V	"N"
`gimmick	N	"N"
`gimmickry	N_Suffix1a	"N(`gimmick)+NR3"
`gin	N	"N"
`ginger	N	"N"
`gingham	N	"N"
`ginmill	N	"N"
`ginseng	N	"N"
`gipsy	N	"N"
gi`raffe	N	"N"
`girdle	N-to-V	"N"
`girl	N	"N"
`girlfriend	N	"N"
`girth	N	"N"
`gist	N	"N"
`giveaway	N	"N"
`gizzard	N	"N"
`glacier	N	"N"
`glacis	N	"N"
`glade	N	"N"
`gladiator	N	"N"
gladi`olus	N	"N"
`glamor	N	"N"
`glamour	N	"N" ;British
`gland	N	"N"
`glasnost	N	"N"
`glass	N	"N"
`glassful	N_Suffix1a	"N(`glass)+NR5"
glass`ine	N	"N"
`glassware	N	"N"
glau`coma	N	"N"
`glaze	N-to-V	"N"
`glazing	N	"N(`glaze)+NR7"
`glee	N	"N"
`glen	N	"N"
`glitch	N	"N"
`glob	N	"N"
`globe	N	"N"
`globule	N	"N"
`globulin	N	"N"
`gloom	N	"N"
`glory	N-to-V	"N"
glorifi`cation	N	"N(`glory)+VR5+NR23"
`gloss	N-to-V	"N"
`glossary	N	"N"
glosso`lalia	N	"N"
`glottis	N	"N"
`glove	N	"N"
`glue	N-to-V	"N"
`glut	N-to-V	"N"
`glutamate	N	"N"
`glutton	N	"N"
`glycerin	N	"N"
`glycerine	N	"N"
`glyph	N	"N"
`gnat	N	"N"
`gneiss	N	"N"
`gnome	N	"N"
`gnostic	N	"N"
`gnu	N	"N"
`goad	N-to-V	"N"
`goal	N	"N"
`goat	N	"N"
goat`ee	N	"N"
`goatherd	N	"N"
`gob	N	"N"
`gobbledygook	N	"N"
`goblet	N	"N"
`goblin	N	"N"
`god	N	"N"
`goddaughter	N	"N"
`godfather	N	"N"
`godhead	N	"N"
`godmother	N	"N"
`godparent	N	"N"
`godsend	N	"N"
`godson	N	"N"
`gold	N-to-AJ	"N"
`goldenrod	N	"N"
`goldfinch	N	"N"
`goldfish	N	"N"
`goldsmith	N	"N"
`golf	N-to-V	"N"
`gondola	N	"N"
`gong	N	"N"
`goober	N	"N"
good-`bye	N	"N"
good-`by	N	"N"
good`will	N	"N"
`goody	N	"N"
`goose	N	"N"
`gooseberry	N	"N"
`gopher	N	"N"
`gorge	N	"N"
`gorgon	N	"N"
go`rilla	N	"N"
`gorse	N	"N"
`goshawk	N	"N"
`gosling	N	"N(`goose)+NR15"
`gospel	N	"N"
`gossamer	N	"N"
`gossip	N-to-V	"N"
`gourd	N	"N"
`gourmand	N	"N"
gour`met	N	"N"
`gout	N	"N"
`governess	N_Suffix1a	"V(`govern)+NR20+NR12"
`gown	N	"N"
`grace	N-to-V	"N"
`grackle	N	"N"
`grad	N	"N" ;graduate
`gradient	N	"N"
`graham	N	"N"
`grail	N	"N"
`grain	N	"N"
`gram	N	"N"
`grammar	N	"N"
`granary	N	"N"
grand`aunt	N	"N"
`granddaughter	N	"N"
`grandeur	N	"N"
`grandfather	N	"N"
gran`diloquence	N	"AJ(gran`diloquent)+NR41"
`grandma	N	"N"
`grandmother	N	"N"
grand`nephew	N	"N"
grand`niece	N	"N"
`grandpa	N	"N"
`grandparent	N	"N"
`grandson	N	"N"
`grandstand	N	"N"
grand`uncle	N	"N"
`granite	N	"N"
`granny	N	"N"
gra`nola	N	"N"
`granule	N	"N"
`grape	N	"N"
`grapefruit	N	"N"
`grapevine	N	"N"
`graph	N	"N"
`grapheme	N	"N"
`graphic	N	"AJ(`graphic).NR0"
`graphite	N	"N"
`grass	N	"N"
`grasshopper	N	"N"
`grassland	N	"N"
grati`fication	N	"V(`gratify)+NR23"
`gratitude	N	"N"
gra`tuity	N	"N"
`grave	N	"N"
`gravel	N	"N"
`gravestone	N	"N"
`graveyard	N	"N"
`gravity	N	"N"
`gravy	N	"N"
`graybeard	N	"N"
`grease	N-to-V	"N"
`greatcoat	N	"N"
`grebe	N	"N"
`greed	N	"N"
`greenery	N_Suffix1a	"AJ(`green)+NR3"
`greengrocer	N	"N"
`greenhorn	N	"N"
`greenhouse	N	"N"
`greensward	N	"N"
`greenwood	N	"N"
`greeting	N	"V(`greet)+NR24"
`gremlin	N	"N"
gre`nade	N	"N"
`greyhound	N	"N"
`grid	N	"N"
`griddle	N	"N"
`gridiron	N	"N"
`gridlock	N-to-V	"N"
`grief	N	"N"
`griffin	N	"N"
`grill	N-to-V	"N"
`grille	N	"N"
`grillwork	N	"N"
`grime	N	"N"
`grindstone	N	"N"
`grippe	N	"N"
`grist	N	"N"
`gristmill	N	"N"
`grit	N-to-V	"N"
`groat	N	"N"
`grocer	N	"N"
`grocery	N	"N"
`grog	N	"N"
`groin	N	"N"
`grommet	N	"N"
`groom	N-to-V	"N"
`groove	N-to-V	"N"
`grosbeak	N	"N"
`grouch	N	"N"
`ground	N-to-V	"N"
`groundswell	N	"N"
`groundwork	N	"N"
`group	N-to-V	"N"
`grout	N	"N"
`grove	N	"N"
`grownup	N	"N"
`growth	N	"V(`grow)+NR42"
`grub	N	"N"
`grudge	N	"N"
`gryphon	N	"N"
`guano	N	"N"
guaran`tee	N-to-V	"N"
`guarantor	N	"N"
`guaranty	N	"N"
`guardhouse	N	"N"
`guernsey	N	"N"
guer`rilla	N	"N"
`guesswork	N	"N"
`guest	N	"N"
guf`faw	N-to-V	"N"
`guidebook	N	"N"
`guideline	N	"N"
`guidepost	N	"N"
`guild	N	"N"
`guildhall	N	"N"
`guile	N	"N"
`guillemot	N	"N"
`guillotine	N	"N"
`guilt	N	"N"
`guinea	N	"N"
`guise	N	"N"
gui`tar	N	"N"
`gulch	N	"N"
`gules	N	"N"
`gulf	N	"N"
`gull	N	"N"
`gullet	N	"N"
gulli`bility	N	"AJ(`gullible)+NR21"
`gully	N	"N"
`gum	N	"N"
`gumbo	N	"N"
`gumdrop	N	"N"
`gumption	N	"N"
`gumshoe	N	"N"
`gun	N-to-V	"N"
`gunboat	N	"N"
`gunfight	N	"N"
`gunfire	N	"N"
`gunflint	N	"N"
`gunk	N	"N"
`gunnery	N_Suffix1a	"N(`gun)+NR3"
`gunny	N	"N"
`gunplay	N	"N"
`gunpoint	N	"N"
`gunpowder	N	"N"
`gunshot	N	"N"
`gunslinger	N	"N(`gun)+V(`sling)+NR19"
`gunslinging	N	"N(`gun)+V(`sling)+PRG"
`gunwale	N	"N"
`guru	N	"N"
`gusset	N	"N"
`gust	N-to-V	"N"
`gusto	N	"N"
`gut	N-to-V	"N"
`gutter	N	"N"
`guy	N	"N"
`gym	N	"N"
gym`nasium	N	"N"
`gymnast	N	"N"
`gymnosperm	N	"N"
`gypsum	N	"N"
`gypsy	N	"N"
`gyrfalcon	N	"N"
`gyro	N	"N"
`gyrocompass	N	"N"
`gyroscope	N	"N"

`haberdashery	N	"N"
habita`bility	N	"AJ(`habitable)+NR21"
`hades	N	"N"
`habit	N	"N"
`habitat	N	"N"
habi`tation	N	"N"
`habitude	N	"N"
haci`enda	N	"N"
`hackle	N	"N"
`hackney	N	"N"
`hacksaw	N	"N"
`haddock	N	"N"
`hag	N	"N"
`haiku	N	"N"
`hail	N-to-V	"N"
`hailstone	N	"N"
`hailstorm	N	"N"
`hair	N	"N"
`hairdresser	N	"N(`hair)+V(`dress)+NR19"
`hairdressing	N	"N(`hair)+V(`dress)+PRG"
`haircut	N	"N"
`hairdo	N	"N"
`hairpin	N	"N"
`halfback	N	"N"
`halibut	N	"N"
`hall	N	"N"
`hallmark	N	"N"
`hallway	N	"N"
`halogen	N	"N"
hal`lucinogen	N	"N"
`halyard	N	"N"
`ham	N	"N"
`hamburger	N	"N"
`hamlet	N	"N"
`hammer	N-to-V	"N"
`hammerhead	N	"N"
`hammock	N	"N"
`hamper	N	"N"
`hamster	N	"N"
`hand	N-to-V	"N"
`handbag	N	"N"
`handbook	N	"N"
`handclasp	N	"N"
`handcuff	N-to-V	"N"
`handful	N_Suffix1a	"N(`hand)+NR5"
`handgun	N	"N"
`handhold	N	"N"
`handicap	N-to-V	"N"
`handicraft	N	"N"
`handiwork	N	"N"
`handkerchief	N	"N"
`handlebar	N	"N"
`handline	N	"N"
`handmaiden	N	"N"
`handout	N	"N"
`hangup	N	"N"
`handset	N	"N"
`handshake	N	"N"
`handspike	N	"N"
`handstand	N	"N"
`hangar	N	"N"
`hangout	N	"N"
`hangover	N	"N"
`hank	N	"N"
`hansom	N	"N"
`happening	N	"V(`happen)+NR24"
`happenstance	N	"N"
`harbinger	N	"N"
`harbor	N-to-V	"N"
`harbour	N-to-V	"N" ;British
`hardboard	N	"N"
`hardhat	N	"N"
hard`line	N	"N"
hard`liner	N	"N(hard`line)+NR11"
`hardscrabble	N	"N"
`hardship	N_Suffix1b	"AJ(`hard)+NR9"
`hardtack	N	"N"
`hardtop	N	"N"
`hardware	N	"N"
`hardwood	N	"N"
`hare	N	"N"
`harelip	N	"N"
`harem	N	"N"
`harlot	N	"N"
`harmony	N	"N"
`harness	N-to-V	"N"
`harp	N	"N"
har`poon	N-to-V	"N"
`harpsichord	N	"N"
`harpstring	N	"N"
`hart	N	"N"
`hash	N	"N"
ha`shish	N	"N"
`hasp	N	"N"
`haste	N	"N"
`hat	N	"N"
`hatful	N_Suffix1a	"N(`hat)+NR5"
`hatter	N	"N(`hat)+NR11"
`hatchet	N	"N"
`hatchway	N	"N"
`hatred	N	"N"
;`haulage	N_Suffix1a	"V(`haul)+NR1"
`haunch	N	"N"
`haven	N	"N"
`havoc	N	"N"
`hawk	N	"N"
`hawser	N	"N"
`hawthorn	N	"N"
`hay	N	"N"
`hayfield	N	"N"
`haystack	N	"N"
`hazard	N-to-V	"N"
`haze	N	"N"
`hazel	N	"N"
`hazelnut	N	"N"
`head	N	"N"
`headache	N	"N"
`headboard	N	"N"
`headdress	N	"N"
`header	N	"N"
`heading	N	"N(`head).VR0+NR24"
`headland	N	"N"
`headlight	N	"N"
`headline	N	"N"
`headmaster	N	"N"
`headphone	N	"N"
`headroom	N	"N"
`headset	N	"N"
`headstand	N	"N"
`headstone	N	"N"
`headwall	N	"N"
`headwater	N	"N"
`headway	N	"N"
`headwind	N	"N"
`health	N	"N"
`heap	N-to-V	"N"
`hearing	N	"V(`hear)+NR24"
`hearsay	N	"N"
`hearse	N	"N"
`heart	N	"N"
`heartbeat	N	"N"
`heartbreaker	N	"N(`heart)+V(`break)+NR19"
`heartburn	N	"N"
`hearth	N	"N"
`hearthrug	N	"N"
`hearthstone	N	"N"
`heat	N-to-V	"N"
`heath	N	"N"
`heathen	N	"N"
`heather	N	"N"
`heaven	N	"N"
`heavyweight	N	"N"
`hectare	N	"N"
`hedge	N-to-V	"N"
`hedgehog	N	"N"
`hedonism	N	"N"
`hedonist	N	"N"
`heel	N	"N"
he`gemony	N	"N"
`heifer	N	"N"
`height	N	"N"
`heir	N	"N"
`heirloom	N	"N"
`helicopter	N	"N"
`helium	N	"N"
`helix	N	"N"
`hell	N	"N"
`hellfire	N	"N"
`helm	N	"N"
`helmet	N	"N"
`helping	N	"V(`help)+NR24" ;of food
`helpmate	N	"N"
`hem	N-to-V	"N"
;`hemisphere	N	"N"
`hemline	N	"N"
`hemlock	N	"N"
`hemoglobin	N	"N"
hemo`philia	N	"N"
`hemorrhoid	N	"N"
`hemp	N	"N"
`hen	N	"N"
hepa`titis	N	"N"
`herb	N	"N"
`herd	N-to-V	"N"
here`after	N	"N"
he`redity	N	"N"
`heresy	N	"N"
`heretic	N	"N"
`heritage	N	"N"
`hermit	N	"N"
`heroin	N	"N"
`heroine	N	"N"
`heron	N	"N"
`herpes	N	"N"
`herringbone	N	"N"
`hertz	N	"N"
`hesitance	N	"AJ(`hesitant)+NR41"
`hesitancy	N	"AJ(`hesitant)+NR40"
`heterodoxy	N	"N"
heteroge`neity	N	"N"
heu`ristic	N	"N"
`hexagon	N	"N"
hex`ameter	N	"N"
`heyday	N	"N"
hi`atus	N	"N"
hi`bachi	N	"N"
`hiccough	N-to-V	"N"
`hiccup	N-to-V	"N"
`hick	N	"N"
`hickory	N	"N"
`hideaway	N	"N"
`hideout	N	"N"
`hierarch	N	"N"
`hierarchy	N	"N"
`highball	N	"N"
`highboy	N	"N"
`highland	N	"N"
`highlander	N	"N(`highland)+NR11"
`highlight	N-to-V	"N"
`highroad	N	"N"
`highway	N	"N"
`hijinks	N	"N"
hi`larity	N	"N"
`hill	N	"N"
`hillbilly	N	"N"
`hillock	N	"N"
`hillside	N	"N"
`hilltop	N	"N"
`hilt	N	"N"
`hind	N	"N"
`hindrance	N	"N"
`hindsight	N	"N"
`hinge	N-to-V	"N"
`hint	N-to-V	"N"
`hinterland	N	"N"
`hip	N	"N"
`hippo	N	"N" ;hippopotamus
`hippodrome	N	"N"
`hippy	N	"N"
`hireling	N	"N"
`histamine	N	"N"
`history	N	"N"
`hive	N	"N"
`hoagie	N	"N"
`hoagy	N	"N"
`hoard	N-to-V	"N"
`hoarfrost	N	"N"
`hoax	N	"N"
`hob	N	"N"
`hobby	N	"N"
`hobbyhorse	N	"N"
`hobgoblin	N	"N"
`hock	N	"N"
`hockey	N	"N"
hocus-`pocus	N	"N"
`hodge-podge	N	"N"
`hog	N-to-V	"N"
`hogan	N	"N"
`hogshead	N	"N"
`hogwash	N	"N"
hoky-`poky	N	"N"
`holding	N	"V(`hold)+NR24"
`holdout	N	"N"
`holdover	N	"N"
`holdup	N	"N"
`hole	N	"N"
`holiday	N	"N"
`hollowware	N	"N"
`holly	N	"N"
`hollyhock	N	"N"
`holocaust	N	"N"
`hologram	N	"N"
ho`lograph	N	"N"
ho`lography	N	"N"
`holster	N	"N"
`holystone	N	"N"
`homage	N	"N"
`home	N	"N"
`homecoming	N	"N(`home)+V(`come)+PRG"
`homemaker	N	"N(`home)+V(`come)+NR19"
`homeowner	N	"N(`home)+V(`come)+NR19"
`homeland	N	"N"
`homestead	N	"N"
home`town	N	"N"
`homework	N	"N"
`homicide	N	"N"
`homily	N	"N"
`homo	N	"N"
homoge`neity	N	"N"
`homograph	N	"N"
`homonym	N	"N"
ho`monymy	N	"N"
`homophone	N	"N"
`honesty	N	"AJ(`honest)+NR35"
`honey	N-to-V	"N"
`honeybee	N	"N"
`honeycomb	N	"N"
`honeydew	N	"N"
`honeymoon	N-to-V	"N"
`honeysuckle	N	"N"
`honor	N-to-V	"N"
`honour	N-to-V	"N" ;British
honor`ific	N	"AJ(honor`ific).NR0"
`hooch	N	"N"
`hood	N-to-V	"N"
`hoodlum	N	"N"
`hoofmark	N	"N"
`hook	N-to-V	"N"
`hookah	N	"N"
`hookup	N	"N"
`hookworm	N	"N"
`hooligan	N	"N"
`hoop	N	"N"
`hoopla	N	"N"
`hoosegow	N	"N"
`hopeful	N	"V(`hope).NR0+AJR9.NR0"
`hopscotch	N	"N"
`horde	N	"N"
`horehound	N	"N"
ho`rizon	N	"N"
`hormone	N	"N"
`horn	N	"N"
`hornet	N	"N"
`hornpipe	N	"N"
`horoscope	N	"N"
`horror	N	"N"
`horse	N	"N"
`horseflesh	N	"N"
`horsefly	N	"N"
`horsehair	N	"N"
`horseplay	N	"N"
`horsepower	N	"N"
`horseshoe	N	"N"
`horticulture	N	"N"
`hose	N	"N"
`hosiery	N	"N"
`hospice	N	"N"
`hospital	N	"N"
hospi`tality	N	"N"
`host	N-to-V	"N"
`hostage	N	"N"
`hostel	N	"N"
`hostelry	N_Suffix1a	"N(`hostel)+NR3"
`hostler	N	"N"
`hotbed	N	"N"
`hotbox	N	"N"
ho`tel	N	"N"
`hothead	N	"N"
`hothouse	N	"N"
`hotrod	N	"N"
`hotshot	N	"N"
`hotspot	N	"N"
`hound	N-to-V	"N"
`hour	N	"N"
`hourglass	N	"N"
`house	N-to-V	"N"
`houseboat	N	"N"
`housefly	N	"N"
`houseful	N_Suffix1a	"N(`house)+NR5"
`household	N	"N"
`householder	N	"N(`household)+NR11"
`housekeeper	N	"N(`house)+V(`keep)+NR19"
`housekeeping	N	"N(`house)+V(`keep)+PRG"
`housemaid	N	"N"
`housetop	N	"N"
`housework	N	"N"
`hovel	N	"N"
`hoyden	N	"N"
`hub	N	"N"
`hubbub	N	"N"
`hubby	N	"N"
`hubris	N	"N"
`huckleberry	N	"N"
`huckster	N	"N"
`hue	N	"N"
`hulk	N-to-V	"N"
`hull	N	"N"
`human	N	"N"
humani`tarian	N-to-AJ	"N(hu`manity)+AJR22+NR29"
`humanoid	N-to-AJ	"N(`human)+NR53"
`humbug	N	"N"
`humerus	N	"N"
hu`midistat	N	"N"
hu`mility	N	"N"
`hummingbird	N	"N"
`hummock	N	"N"
`humor	N-to-V	"N"
`humour	N-to-V	"N" ;British
`hump	N	"N"
`humpback	N	"N"
`humus	N	"N"
`hunch	N	"N"
`hunchback	N	"N"
`hunger	N-to-V	"N"
`hunk	N	"N"
`hurdle	N	"N"
`hurricane	N	"N"
`husband	N-to-V	"N"
`husbandry	N_Suffix1a	"V(`husband)+NR3"
`husk	N-to-V	"N"
`hussy	N	"N"
`hut	N	"N"
`hutch	N	"N"
huz`za	N	"N"
huz`zah	N	"N"
`hyacinth	N	"N"
`hybrid	N-to-AJ	"N"
hy`drangea	N	"N"
`hydrant	N	"N"
`hydrogen	N	"N"
hydro`phobia	N	"N"
hy`ena	N	"N"
`hygiene	N	"N"
hy`grometer	N	"N"
`hymen	N	"N"
`hymn	N	"N"
`hymnal	N	"N"
`hymnody	N	"N"
`hype	N	"N" ;see verb.lex for verb forms
hy`perbole	N	"N"
`hyphen	N	"N"
hyp`nosis	N	"N"
`hypnotism	N	"N"
`hypnotist	N	"N"
hypo`chondria	N	"N"
hy`pocrisy	N	"N"
`hypocrite	N	"N"
hy`potenuse	N	"N"
hys`teria	N	"N"

`ibis	N	"N"
`ice	N-to-V	"N"
`icing	N	"N(`ice)+NR7"
`iceberg	N	"N"
`icebox	N	"N"
`icicle	N	"N"
`icon	N	"N"
i`conoclasm	N	"N"
i`conoclast	N	"N"
i`dea	N	"N"
identifi`cation	N	"V(i`dentify)+NR23"
i`dentity	N	"N"
`ideologue	N	"N"
`idiocy	N	"N(`idiot)+NR40"
`idiom	N	"N"
idio`syncrasy	N	"N"
`idiot	N	"N"
`idol	N	"N"
i`dolater	N	"N"
i`dolator	N	"N"
i`dolatry	N	"N"
`idyll	N	"N"
`igloo	N	"N"
`ignominy	N	"N"
igno`ramus	N	"N"
il`lusion	N	"N"
`image	N	"N"
`imagery	N_Suffix1a	"N(`image)+NR3"
`imbecile	N	"N"
imbe`cility	N	"N(`imbecile).AJR0+NR21"
im`broglio	N	"N"
`immanence	N	"AJ(`immanent)+NR41"
im`mediacy	N	"AJ(im`mediate)+NR40"
`immigrant	N	"V(`immigrate)+NR17"
immunode`ficiency	N	"N"
`imp	N	"N"
`impact	N-to-V	"N"
`impasse	N	"N"
im`pediment	N	"V(im`pede)+NR25"
`impetus	N	"N"
`implant	N	"V(im`plant).NR0"
`implicant	N	"N"
im`plosion	N	"V(im`plode)+NR23"
`import	N	"V(im`port).NR0"
impor`tunity	N	"N"
im`postor	N	"N"
im`posture	N	"N"
impre`sario	N	"N"
`impress	N	"V(im`press).NR0"
impri`matur	N	"N"
`imprint	N	"V(im`print).NR0"
`impudence	N	"AJ(`impudent)+NR41"
`impulse	N	"N"
im`punity	N	"N"
`incense	N	"N"
in`centive	N	"N"
in`ception	N	"N"
in`ceptor	N	"N"
`incest	N	"N"
`inch	N-to-V	"N"
`incidence	N	"N"
`incident	N	"N"
`incline	N	"V(in`cline).NR0"
in`clusion	N	"V(in`clude)+NR23"
`income	N	"N"
incom`pletion	N	"NEG2+AJ(com`plete)+NR23"
in`continency	N	"NEG2+AJ(`continent)+NR40"
`increase	N	"V(in`crease).NR0"
incrus`tation	N	"VR1+N(`crust)+NR23"
in`cumbrance	N	"V(en`cumber)+NR26"
in`cursion	N	"N"
in`demnity	N	"N"
`indent	N	"V(in`dent).NR0"
in`denture	N	"N"
`indicant	N	"N"
`indigence	N	"AJ(`indigent)+NR41"
`indigene	N	"N"
indig`nation	N	"N"
individu`ality	N	"AJ(indi`vidual)+NR21"
`industry	N	"N"
in`ertance	N	"AJ(in`ert)+NR26"
in`ertia	N	"N"
inevita`bility	N	"NEG2+AJ(`evitable)+NR21"
`infamy	N	"N"
`infancy	N	"N(`infant)+NR40"
`infant	N	"N"
`infantry	N	"N"
`inference	N	"V(in`fer)+NR26" ;irregular stress
in`ferno	N	"N"
`infidel	N	"N"
`infield	N	"N"
in`finitive	N	"N"
in`finitude	N	"N"
in`finity	N	"N"
in`firmary	N	"AJ(in`firm)+NR39"
`infix	N	"N"
inflam`mation	N	"V(in`flame)+NR23"
`inflow	N	"N"
`influence	N-to-V	"N"
influ`enza	N	"N"
`influx	N	"N"
`info	N	"N"
`infrastructure	N	"N"
inge`nuity	N	"N"
`ingot	N	"N"
`ingrate	N	"N"
in`gredient	N	"N"
i`niquity	N	"N"
i`nitial	N-to-V	"N"
i`nitiative	N	"V(i`nitiate)+AJR26.NR0"
in`junction	N	"N"
`ink	N	"N"
`inkblot	N	"N"
`inkling	N	"N"
`inkstand	N	"N"
`inkwell	N	"N"
`inlet	N	"N"
`inmate	N	"N"
`inn	N	"N"
`inning	N	"N"
`innkeeper	N	"N"
`innocence	N	"AJ(`innocent)+NR41"
`innocency	N	"AJ(`innocent)+NR40"
`inquest	N	"N"
`inquiry	N	"V(in`quire)+NR35"
inqui`sition	N	"N"
in`quisitor	N	"N"
`inroad	N	"N"
in`scription	N	"V(in`scribe)+NR23"
`insect	N	"N"
`insert	N	"V(in`sert).NR0"
`inset	N-to-V	"N"
`insight	N	"N"
`insolence	N	"AJ(`insolent)+NR41"
in`somnia	N	"N"
in`somniac	N	"N"
in`stalment	N	"V(in`stall)+NR25"
`instance	N	"N"
`instant	N	"N"
`instep	N	"N"
`instinct	N	"N"
`instrument	N-to-V	"N"
instrumen`tation	N	"N(`instrument)+NR23"
`insult	N	"V(in`sult).NR0"
`insulin	N	"N"
in`surgency	N	"AJ(in`surgent)+NR40"
insur`rection	N	"N"
`intake	N	"N"
`integer	N	"N"
in`tegrity	N	"N"
in`tegument	N	"N"
`intellect	N	"N"
intel`lectual	N	"N(intellect)+AJR17.NR0"
in`telligence	N	"AJ(in`telligent)+NR41"
intelli`gentsia	N	"N" ;plural?
intelligi`bility	N	"AJ(in`telligible)+NR21"
in`tent	N	"N"
in`tention	N	"V(in`tend)+NR23"
`intercom	N	"N"
`interim	N	"N"
`interlude	N	"N"
inter`mediary	N	"N"
`intern	N	"N"
`interval	N	"N"
inter`vention	N	"V(inter`vene)+NR23"
in`testine	N	"N"
`intimacy	N	"AJ(`intimate)+NR40"
in`toxicant	N	"V(in`toxicate)+NR17"
in`transigence	N	"AJ(in`transigent)+NR41"
`intricacy	N	"AJ(`intricate)+NR40"
`intrigue	N	"V(in`trigue).NR0"
intro`duction	N	"V(intro`duce)+NR23"
`introit	N	"N"
intro`version	N	"V(`introvert)+NR23"
in`trusion	N	"V(in`trude)+NR23"
`invalid	N	"N"
in`vasion	N	"V(in`vade)+NR23"
in`vective	N	"N"
`inventory	N-to-V	"N"
in`version	N	"V(in`vert)+NR23"
in`vestiture	N	"N"
in`veteracy	N	"AJ(in`veterate)+NR40"
`invoice	N	"N"
invo`lution	N	"N"
`iodine	N	"N"
`ion	N	"N"
i`onosphere	N	"N"
`ipecac	N	"N"
`ire	N	"N"
`iris	N	"N"
`iron	N-to-V	"N"
`ironside	N	"N"
`ironstone	N	"N"
`ironwood	N	"N"
`irony	N	"N"
ir`regular	N	" NEG2d+AJ(`regular).NR0"
ir`relevancy	N	"NEG2+AJ(`relevant)+NR40"
irrita`bility	N	"V(`irritate)+AJR25+NR21"
`irritant	N	"V(`irritate)+NR17"
`isinglass	N	"N"
`island	N	"N"
`islander	N	"N(`island)+NR11"
`isle	N	"N"
`islet	N	"N(`isle)+NR14"
`isomer	N	"N"
`isotope	N	"N"
`item	N	"N"
i`tinerary	N	"N"
`ivory	N	"N"
`ivy	N	"N"

`jack	N	"N"
`jackanapes	N	"N"
`jackass	N	"N"
`jackboot	N	"N"
`jackdaw	N	"N"
`jacket	N	"N"
`jackhammer	N	"N"
`jackknife	N	"N"
`jackpot	N	"N"
`jade	N	"N"
`jaguar	N	"N"
`jail	N-to-V	"N"
`jailhouse	N	"N"
ja`lopy	N	"N"
jambo`ree	N	"N"
`janitor	N	"N"
`jar	N	"N"
`jarful	N_Suffix1a	"N(`jar)+NR5"
`jargon	N	"N"
`jasper	N	"N"
`jaundice	N	"N"
`jaunt	N	"N"
`javelin	N	"N"
`jaw	N-to-V	"N"
`jawbone	N	"N"
`jay	N	"N"
`jazz	N-to-V	"N"
`jealousy	N	"AJ(`jealous)+NR33"
`jean	N	"N"
`jeep	N	"N"
`jelly	N-to-V	"N"
`jellyfish	N	"N"
`jenny	N	"N"
`jeopardy	N	"N"
`jerk	N	"N" ;stupid fellow
`jerry	N	"N"
`jersey	N	"N"
`jess	N	"N"
`jesuit	N	"N"
`jet	N-to-V	"N"
`jetliner	N	"N"
`jewel	N	"N"
`jeweler	N	"N(`jewel)+NR19"
`jeweller	N	"N(`jewel)+NR19"
`jewelry	N_Suffix1a	"N(`jewel)+NR3"
`jib	N	"N"
`jiffy	N	"N"
`jig	N-to-V	"N"
`jigsaw	N	"N"
ji`had	N	"N"
`jimmy	N	"N"
`jinx	N-to-V	"N"
`jitter	N	"N"
`jitterbug	N-to-V	"N"
`job	N	"N"
`jobholder	N	"N"
`jock	N	"N"
`jockey	N	"N"
`jockstrap	N	"N"
`joey	N	"N"
`joint	N	"N"
`joist	N	"N"
`joke	N-to-V	"N"
`jollity	N	"AJ(`jolly)+NR21"
`jonquil	N	"N"
`joss	N	"N"
`joule	N	"N"
`journal	N	"N"
journal`ese	N_Suffix1a	"N(`journal)+NR28"
`journey	N-to-V	"N"
`jowl	N	"N"
`joy	N	"N"
`joyride	N	"N"
`joystick	N	"N"
jubi`lee	N	"N"
`judgment	N	"V(`judge)+NR25" ;exception to Elision
`judicatory	N	"N"
`judicature	N	"N"
ju`diciary	N	"N"
`judo	N	"N"
`jug	N	"N"
`jugful	N_Suffix1a	"N(`jug)+NR5"
`juice	N	"N"
`julep	N	"N"
`junction	N	"N"
`juncture	N	"N"
`jungle	N	"N"
`juniper	N	"N"
`junk	N-to-V	"N"
`junta	N	"N"
juris`diction	N	"N"
juris`prudence	N	"N"
juris`prudent	N	"N"
`jurist	N	"N"
`juror	N	"N"
`jury	N	"N"
`justice	N	"N"
`jute	N	"N"

`kaiser	N	"N"
`kale	N	"N"
ka`leidoscope	N	"N"
kami`kaze	N	"N"
kanga`roo	N	"N"
`kaolin	N	"N"
`kapok	N	"N"
ka`rate	N	"N"
`kava	N	"N"
`kayak	N	"N"
ka`zoo	N	"N"
`keel	N-to-V	"N"
`keg	N	"N"
`kelp	N	"N"
`ken	N	"N"
`kennel	N	"N"
`kerb	N	"N" ;British
`kerchief	N	"N"
`kernel	N	"N"
`kerosene	N	"N"
`kestrel	N	"N"
`ketch	N	"N"
`ketchup	N	"N"
`kettle	N	"N"
`key	N	"N"
`keyboard	N-to-V	"N"
`keyhole	N	"N"
`keynote	N	"N"
`keypunch	N	"N"
`keystone	N	"N"
`keyword	N	"N"
`khaki	N	"N"
`khan	N	"N"
`kickback	N	"N"
`kickoff	N	"N"
`kid	N	"N"
`kiddie	N	"N(`kid)+NR33"
`kidney	N	"N"
`killdeer	N	"N"
`killjoy	N	"N"
`kiln	N	"N"
`kilo	N	"N"
ki`mono	N	"N"
`kin	N	"N"
`kind	N	"N"
`kindergarten	N	"N"
`kindred	N	"N"
`king	N	"N"
`kingbird	N	"N"
`kingfisher	N	"N"
`kingpin	N	"N"
`kink	N	"N"
`kiosk	N	"N"
`kirk	N	"N"
`kit	N	"N"
`kitchen	N	"N"
`kite	N	"N"
`kith	N	"N"
`kitten	N	"N"
`kitty	N	"N"
`klaxon	N	"N"
`kleenex	N	"N"
`kludge	N-to-V	"N"
`knack	N	"N"
`knapsack	N	"N"
`knave	N	"N"
`knee	N	"N"
`kneecap	N	"N"
`knell	N	"N"
`knick-knack	N	"N"
`knight	N-to-V	"N"
`knitting	N	"V(`knit)+NR24"
`knob	N	"N"
`knockout	N	"N"
`knoll	N	"N"
`knot	N-to-V	"N"
`knowhow	N	"N"
`knowledge	N	"N"
`knuckle	N	"N"
`knuckleball	N	"N"
ko`ala	N	"N"
kohl`rabi	N	"N"
`kraft	N	"N"
`kraut	N	"N"
`kremlin	N	"N"
`krypton	N	"N"
`kudo	N	"N"
`kudzu	N	"N"
`kumquat	N	"N"
kwashi`orkor	N	"N"

`lab	N	"N" ;laboratory
`label	N-to-V	"N"
`laboratory	N	"N"
`labyrinth	N	"N"
`lace	N-to-V	"N"
`lacewing	N	"N"
`lacing	N	"N(`lace)+NR7"
`lackey	N	"N"
`lacquer	N-to-V	"N"
la`crosse	N	"N"
`lad	N	"N"
`ladder	N	"N"
`lading	N	"V(`lade)+NR24"
`ladle	N-to-V	"N"
`ladleful	N_Suffix1a	"N(`ladle)+NR5"
`lady	N	"N"
`lager	N	"N"
la`goon	N	"N"
`lair	N	"N"
laissez-faire	N	"N"
`laity	N	"N"
`lake	N	"N"
`lakeside	N	"N"
`lamb	N	"N"
`lamp	N	"N"
`lampblack	N	"N"
`lamplight	N	"N"
`lamprey	N	"N"
`land	N-to-V	"N"
`landfill	N	"N"
`landholder	N	"N(`land)+V(`hold)+NR19"
`landholding	N-to-AJ	"N(`land)+V(`hold)+PRG"
`landing	N	"V(`land)+NR24" ;a pier
`landlady	N	"N"
`landlord	N	"N"
`landmark	N	"N"
`landowner	N	"N(`land)+V(`own)+NR19"
`landowning	N-to-AJ	"N(`land)+V(`own)+PRG"
`landslide	N	"N"
`lane	N	"N"
`language	N	"N"
`languor	N	"N"
`lantern	N	"N"
`lanyard	N	"N"
`lap	N	"N"
la`pel	N	"N"
`lapful	N_Suffix1a	"N(`lap)+NR5"
`lapidary	N	"N"
`laptop	N	"N"
`larboard	N	"N"
`larceny	N	"N"
`larch	N	"N"
`lard	N-to-V	"N"
`larder	N	"N"
`largemouth	N	"N"
lar`gesse	N	"N"
`lariat	N	"N"
`lark	N	"N"
`larkspur	N	"N"
laryn`gitis	N_Suffix1a	"N(`larynx)+NR50"
la`sagna	N	"N"
`laser	N	"N"
`lashing	N	"V(`lash)+NR24"
`lass	N	"N"
`lassitude	N	"N"
`latch	N-to-V	"N"
`latchet	N	"N"
`latency	N	"AJ(`latent)+NR40"
`latex	N	"N"
`lath	N	"N"
`lathe	N-to-V	"N"
`lathing	N	"N(`lath)+NR7"
`latitude	N	"N"
la`trine	N	"N"
`lattice	N	"N"
`laudanum	N	"N"
`laughingstock	N	"N"
`laughter	N	"N"
`laundromat	N	"N"
`laundry	N	"N"
`laureate	N	"N"
`laurel	N	"N"
`lava	N	"N"
`lavatory	N	"N"
`law	N	"N"
`lawbreaker	N	"N(`law)+V(`break)+NR19"
`lawgiver	N	"N(`law)+V(`give)+NR19"
`lawmaker	N	"N(`law)+V(`make)+NR19"
`lawn	N	"N"
`lawsuit	N	"N"
`lawyer	N	"N"
`layer	N-to-V	"N"
lay`ette	N	"N"
`layoff	N	"N"
`layout	N	"N"
`layup	N	"N"
`lea	N	"N"
`lead	N	"N"
`league	N	"N"
;`leakage	N_Suffix1a	"V(`leak)+NR1"
`leaseholder	N	"N(`lease)+V(`hold)+NR19"
`leash	N-to-V	"N"
`leather	N	"N"
`leatherback	N	"N"
`leatherneck	N	"N"
`leatherwork	N	"N"
`leaven	N-to-V	"N"
`lecher	N	"N"
`lechery	N	"N"
`lectern	N	"N"
`lectionary	N	"N"
`lecture	N-to-V	"N"
`ledge	N	"N"
`ledger	N	"N"
`lee	N	"N"
`leech	N	"N"
`leek	N	"N"
`leeway	N	"N"
`lefty	N	"N"
`leg	N	"N"
`legacy	N	"N(`legate)+NR40"
`legate	N	"N"
`legend	N	"N"
`legerdemain	N	"N"
`legging	N	"N(`leg)+NR7"
`leghorn	N	"N"
legi`bility	N	"AJ(`legible)+NR21"
`legion	N	"N"
`legislature	N	"V(`legislate)+NR38"
legitimacy	N	"AJ(le`gitimate)+NR40"
le`gume	N	"N"
`leisure	N	"N"
`leitmotif	N	"N"
`leitmotiv	N	"N"
`lemma	N	"N"
`lemming	N	"N"
`lemon	N	"N"
lemo`nade	N_Suffix1a	"N(`lemon)+NR52"
`length	N	"AJ(`long)+NR42"
`lenience	N	"AJ(`lenient)+NR41"
`leniency	N	"AJ(`lenient)+NR40"
`lens	N	"N"
`lentil	N	"N"
`leopard	N	"N"
`leotard	N	"N"
`leper	N	"N"
`leprosy	N	"N"
`lesion	N	"N"
les`see	N	"V(`lease)+NR18"
`lesson	N	"N"
les`sor	N	"V(`lease)+NR20"
`lethargy	N	"N"
`letter	N-to-V	"N"
`letterhead	N	"N"
`lettering	N	"N(`letter)+NR7"
`lettuce	N	"N"
leu`kemia	N	"N"
`levee	N	"N"
`level	N	"N"
`lever	N	"N"
`leverage	N-to-V	"N(`lever)+NR1"
le`viathan	N	"N"
`levity	N	"N"
`lexicon	N	"N"
lia`bility	N	"AJ(`liable)+NR21"
li`aison	N	"N"
`liar	N	"V(`lie)+NR19"
li`bation	N	"N"
`libel	N-to-V	"N"
liber`tarian	N-to-AJ	"N(`liberty)+AJR22+NR29"
`libertine	N	"N"
`liberty	N	"N"
li`bido	N	"N"
`library	N	"N"
li`brettist	N_Suffix1a	"N(li`bretto)+NR31"
`licence	N-to-V	"N"
`license	N-to-V	"N"
`lichen	N	"N"
`licorice	N	"N"
`lid	N	"N"
`lie	N-to-V	"N" ;falsehood
`lien	N	"N"
`lieu	N	"N"
lieu`tenant	N	"N"
`lifeblood	N	"N"
`lifeboat	N	"N"
`lifeguard	N	"N"
`lifespan	N	"N"
`lifestyle	N	"N"
`lifetime	N	"N"
`liftoff	N	"N"
`ligament	N	"N"
`ligature	N	"N"
`light	N-to-V	"N"
`lightface	N	"N"
`lighthouse	N	"N"
`lighting	N	"N(`light).VR0+NR24"
`lightning	N	"N"
`likelihood	N_Suffix1b	"AJ(`likely)+NR6"
`lilac	N	"N"
`lily	N	"N"
`limb	N	"N"
`limbo	N	"N"
`lime	N	"N"
`limelight	N	"N"
`limestone	N	"N"
`limousine	N	"N"
`limpet	N	"N"
`linden	N	"N"
`line	N-to-V	"N"
`lineage	N	"N"
`linebacker	N	"N"
`linen	N	"N"
`lineup	N	"N"
linge`rie	N	"N"
`linguist	N	"N"
`liniment	N	"N"
`lining	N	"V(`line)+NR24"
li`noleum	N	"N"
`linseed	N	"N"
`lint	N	"N"
`lion	N	"N"
`lip	N	"N"
`lipstick	N	"N"
lique`faction	N	"AJ(`liquid)+VR5+NR23"
li`queur	N	"N"
`liquor	N	"N"
`lisle	N	"N"
`list	N-to-V	"N"
`listing	N	"N(`list).VR0+NR24"
`litany	N	"N"
`liter	N	"N"
`literacy	N	"AJ(`literate)+NR40"
`literature	N	"N"
`lithium	N	"N"
`lithograph	N	"N"
li`thography	N	"N"
`litigant	N	"V(`litigate)+NR17"
`litmus	N	"N"
`litre	N	"N"
`litter	N-to-V	"N"
`litterbug	N	"N"
`littleneck	N	"N"
`liturgy	N	"N"
`livelihood	N	"N"
`livery	N	"N"
`living	N	"V(`live)+NR24"
`lizard	N	"N"
`loam	N	"N"
`loanword	N	"N"
`lobby	N	"N"
`lobe	N	"N"
`lobo	N	"N"
`lobster	N	"N"
lo`cale	N	"N"
`locative	N	"V(`locate)+AJR26.NR0"
`lock	N-to-V	"N"
`locket	N	"N"
`locknut	N	"N"
`lockout	N	"N"
`locksmith	N	"N"
`lockstep	N	"N"
`lockup	N	"N"
loco`motive	N	"V+AJR26.NR0"
`locust	N	"N"
lo`cution	N	"N"
`locutor	N	"N"
`lodestone	N	"N"
`lodgepole	N	"N"
`lodging	N	"V(`lodge)+NR24"
`loft	N	"N"
`log	N-to-V	"N"
`logarithm	N	"N"
;`loge	N	"N" ;causes bad parses
`loggerhead	N	"N"
`logic	N	"N"
`logjam	N	"N"
`logo	N	"N"
`loin	N	"N"
`loincloth	N	"N"
`lollipop	N	"N"
`loner	N	"N"
lon`gevity	N	"N"
`longhand	N	"N"
`longitude	N	"N"
`lookout	N	"N"
`lookup	N	"N"
`loom	N	"N"
`loon	N	"N"
`loop	N-to-V	"N"
`loophole	N	"N"
`loot	N-to-V	"N"
lo`quacity	N	"N"
`lord	N-to-V	"N"
`lore	N	"N"
`lory	N	"N"
`loss	N	"N"
`lot	N	"N"
lo`thario	N	"N"
`lotion	N	"N"
`lottery	N	"N"
`lotus	N	"N"
`loudspeaker	N	"N"
`lout	N	"N"
`lovebird	N	"N"
`lowboy	N	"N"
`lowdown	N	"N"
`lowland	N	"N"
`loyalty	N	"AJ(`loyal)+AJR26"
`lozenge	N	"N"
`lubber	N	"N"
`lubricant	N	"V(`lubricate)+NR17"
lu`bricity	N	"N"
`luck	N	"N"
`lucre	N	"N"
`luge	N	"N"
;`luggage	N_Suffix1a	"V(`lug)+NR1"
`lull	N	"N"
`lullaby	N	"N"
`lulu	N	"N"
`lumber	N	"N"
`lumen	N	"N"
`luminance	N	"N"
`luminary	N	"N"
lumi`nosity	N	"N"
`lummox	N	"N"
`lump	N-to-V	"N"
`lunacy	N	"N"
`lunatic	N	"N"
`lunch	N-to-V	"N"
`luncheon	N	"N"
`lunchroom	N	"N"
`lunchtime	N	"N"
`lung	N	"N"
`lust	N-to-V	"N"
`luster	N-to-V	"N"
`lustre	N-to-V	"N"
`lutanist	N_Suffix1a	"N(`lute)+NR31"
`lute	N	"N"
`luxury	N	"N"
`lye	N	"N"
`lymph	N	"N"
`lynx	N	"N"

;`ma	N	"N" ;short words like this cause spurious parses
`ma'am	N	"N"
`mac	N	"N"
maca`roni	N	"N"
maca`ronies	Number	"N(maca`roni)+PL"
`mace	N	"N"
machi`nation	N	"N"
ma`chine	N	"N"
ma`chinery	N_Suffix1a	"N(ma`chine)+NR3"
ma`chismo	N	"N"
`macintosh	N	"N"
`mackinaw	N	"N"
`mackintosh	N	"N"
`macrame	N	"N"
`macro	N	"N"
`madhouse	N	"N"
ma`donna	N	"N"
`madrigal	N	"N"
`maelstrom	N	"N"
`magazine	N	"N"
`maggot	N	"N"
`magic	N-to-AJ	"N"
`magistrate	N	"N"
`magma	N	"N"
magna`nimity	N	"N"
`magnate	N	"N"
mag`nesia	N	"N"
mag`nesium	N	"N"
`magnet	N	"N"
mag`neto	N	"N"
magnifi`cation	N	"V(`magnify)+NR23"
mag`nificence	N	"AJ(mag`nificent)+NR41"
mag`niloquence	N	"AJ(mag`niloquent)+NR41"
`magnitude	N	"N"
mag`nolia	N	"N"
`magnum	N	"N"
`magpie	N	"N"
maha`raja	N	"N"
ma`hogany	N	"N"
`maid	N	"N"
`maiden	N	"N"
`maidservant	N	"N"
`mailbox	N	"N"
`mainland	N	"N"
`mainsail	N	"N"
`mainstay	N	"N"
`mainstream	N	"N"
`maintenance	N	"V(`maintain)+NR26"
`maize	N	"N"
`majesty	N	"N"
`makeup	N	"N"
`malady	N	"N"
ma`laise	N	"N"
`malaprop	N	"N"
ma`laria	N	"N"
;mal`conduct	N	"N"
malcon`tent	N	"PEJ1+AJ(con`tent).NR0"
`malefactor	N	"N"
mal`feasance	N	"N"
;malformation	N	"N"
`malice	N	"N"
ma`lignancy	N	"AJ(ma`lignant)+NR40"
ma`lignity	N	"V(ma`lign)+NR21"
`mall	N	"N"
`mallard	N	"N"
mallea`bility	N	"AJ(`malleable)+NR21"
`mallet	N	"N"
`mallow	N	"N"
;malnutrition	N	"N"
;malocclusion	N	"N"
;malposition	N	"N"
;malpractice	N	"N"
`malt	N	"N"
`mambo	N	"N"
`mammal	N	"N"
`mammon	N	"N"
`manacle	N-to-V	"N"
`manatee	N	"N"
`mandarin	N	"N"
`mandate	N-to-V	"N"
`mandible	N	"N"
`mandrake	N	"N"
`mane	N	"N"
`manganese	N	"N"
`mange	N	"N"
`manger	N	"N"
`mangrove	N	"N"
`manhole	N	"N"
`mania	N	"N"
`maniac	N	"N"
`manicure	N-to-V	"N"
`manikin	N	"N"
`manna	N	"N"
`mannequin	N	"N"
`manner	N	"N"
`mannikin	N	"N"
`manor	N	"N"
`manpower	N	"N"
`manse	N	"N"
`manservant	N	"N"
`mansion	N	"N"
`manslaughter	N	"N"
`mantel	N	"N"
`mantle	N	"N"
`mantelpiece	N	"N"
`mantrap	N	"N"
`manual	N	"N"
manu`mission	N	"V(manu`mit)+NR23"
ma`nure	N	"N"
`manuscript	N	"N"
`map	N-to-V	"N"
`maple	N	"N"
`marathon	N	"N"
`marble	N	"N"
`mare	N	"N(`mare1)" ;female horse
`margarine	N	"N"
`margin	N	"N"
`marigold	N	"N"
mari`juana	N	"N"
ma`rimba	N	"N"
ma`rina	N	"N"
`marinade	N	"N"
ma`rine	N	"N"
`mariner	N	"AJ(ma`rine)+NR11"
mario`nette	N	"N"
`marjoram	N	"N"
`mark	N-to-V	"N"
`market	N-to-V	"N"
`marketplace	N	"N"
`marking	N	"N(`mark).VR0+NR24"
`marlin	N	"N"
`marmalade	N	"N"
`marmot	N	"N"
`marque	N	"N"
mar`quee	N	"N"
`marquess	N	"N"
mar`quis	N	"N"
mar`quise	N	"N"
;`marriage	N_Suffix1a	"V(`marry)+NR1"
`marrow	N	"N"
`marrowbone	N	"N"
`marsh	N	"N"
`marshal	N	"N"
`marshland	N	"N"
`marshmallow	N	"N"
`mart	N	"N"
`marten	N	"N"
`martin	N	"N"
mar`tini	N	"N"
`martyr	N-to-V	"N"
mas`cara	N	"N"
`mask	N-to-V	"N"
`masochism	N	"N"
`masochist	N	"N"
`mason	N	"N"
`masonry	N_Suffix1a	"N(`mason)+NR3"
`masque	N	"N"
masque`rade	N-to-V	"N"
`mass	N-to-V	"N"
mas`seur	N	"N"
`massif	N	"N"
`mast	N	"N"
`mastermind	N-to-V	"N"
`masterpiece	N	"N"
`mastery	N	"N"
`mastiff	N	"N"
`mastodon	N	"N"
`mat	N-to-V	"N"
`match	N	"N"
`matchbook	N	"N"
`mate	N-to-V	"N"
`mater	N	"N"
ma`terial	N	"N"
materi`el	N	"N"
ma`ternity	N	"N"
`math	N	"N"
mati`nee	N	"N"
`matins	N	"N"
`matriarch	N	"N"
`matriarchs	N	"N(`matriarch)+PL" ;exception to Epenthesis
`matrimony	N	"N"
`matron	N	"N"
`matte	N	"N"
`matter	N	"N"
`mattock	N	"N"
`mattress	N	"N"
mauso`leum	N	"N"
`maverick	N	"N"
`maw	N	"N"
`maxim	N	"N"
`mayhem	N	"N"
`mayonnaise	N	"N"
`mayor	N	"N"
`maze	N	"N"
ma`zurka	N	"N"
`mead	N	"N"
`meadow	N	"N"
`meadowland	N	"N"
`meal	N	"N"
`mealtime	N	"N"
`meaning	N	"V(`mean)+NR24"
`meantime	N	"N"
`measle	N	"N"
`meat	N	"N"
me`chanic	N	"N"
`mechanism	N	"N"
`mechanist	N	"N"
`medal	N	"N"
me`dallion	N	"N"
`median	N-to-AJ	"N"
`medic	N	"N"
`medicine	N	"N"
`medico	N	"N"
`medium	N	"N(`medium2)" ;spirit medium
`medley	N	"N"
`meetinghouse	N	"N"
megalo`mania	N	"N"
megalo`maniac	N	"N"
`melancholy	N-to-AJ	"N"
me`lange	N	"N"
`melanin	N	"N"
me`lee	N	"N"
`melodrama	N	"N"
`melody	N	"N"
`melon	N	"N"
`meltdown	N	"N"
`meltwater	N	"N"
`member	N	"N"
`membrane	N	"N"
`memo	N	"N"
`memoir	N	"N"
me`morial	N	"N(`memory)+AJ17.NR0"
`memory	N	"N"
`menace	N-to-V	"N"
me`nagerie	N	"N"
`menarche	N	"N"
men`dacity	N	"N"
men`dicament	N	"N"
`menopause	N	"N"
mensu`ration	N	"N"
`menswear	N	"N"
`mentor	N	"N"
`menu	N	"N"
`mercenary	N	"N"
`mercer	N	"N"
`merchandise	N	"N"
`merchant	N	"N"
`mercury	N	"N"
`mercy	N	"N"
mer`ganser	N	"N"
me`ridian	N	"N"
me`ringue	N	"N"
`merlin	N	"N"
`mermaid	N	"N"
`merrymaker	N	"N"
`merrymaking	N	"N"
`mesa	N	"N"
`mescal	N	"N"
`mescaline	N	"N"
`mesh	N	"N"
mes`quite	N	"N"
`mess	N-to-V	"N"
`message	N	"N"
`messenger	N	"N"
`messmate	N	"N"
mes`siah	N	"N"
me`tabolism	N	"N"
`metal	N	"N"
`metalwork	N	"N"
meta`morphism	N	"N"
meta`morphosis	N	"N"
`metaphor	N	"N"
me`tastasis	N	"N"
me`tathesis	N	"N"
`meteor	N	"N"
`meteorite	N	"N"
`meter	N	"N"
`methadone	N	"N"
`methane	N	"N"
`methanol	N	"N"
`method	N	"N"
`methyl	N	"N"
`metier	N	"N"
`metre	N	"N"
`metric	N-to-AJ	"N"
`metronome	N	"N"
met`ropolis	N	"N"
`mettle	N	"N"
`mezzanine	N	"N"
mi`asma	N	"N"
`mica	N	"N"
`microbe	N	"N"
`microcosm	N	"N"
`micron	N	"N"
`microscope	N	"N"
`middle	N-to-AJ	"N"
`middleweight	N	"N"
`midge	N	"N"
`midriff	N	"N"
`midst	N	"N"
mid`wifery	N_Suffix1a	"N(`midwife)+NR3"
`mien	N	"N"
`might	N	"N"
mig`non	N	"N"
`migrant	N	"V(`migrate)+NR17"
`mike	N	"N" ;microphone
`mildew	N-to-V	"N"
`mile	N	"N"
`mileage	N_Suffix1a	"N(`mile)+NR1"
`milestone	N	"N"
`militarism	N_Suffix1b	"N(`military)+NR8"
`militarist	N_Suffix1a	"N(`military)+NR31"
mi`litia	N	"N"
`milk	N-to-V	"N"
`milkweed	N	"N"
`millenary	N-to-AJ	"N"
`millet	N	"N"
`milliner	N	"N"
`millinery	N	"N"
`milling	N	"V(`mill)+NR24"
million`aire	N	"N"
`millipede	N	"N"
`millstone	N	"N"
mi`lord	N	"N"
`milt	N	"N"
`mimeo	N-to-V	"N"
`mimeograph	N-to-V	"N"
mi`mesis	N	"N"
`mimicker	V	"V(`mimic)+NR19"
mina`ret	N	"N"
`mincemeat	N	"N"
`mind	N	"N"
`mine	N-to-V	"N"
`minefield	N	"N"
`mineral	N	"N"
mine`strone	N	"N"
`minesweeper	N	"N"
`minicomputer	N	"DEG4+V(com`pute)+NR19"
`minim	N	"N"
`minimax	N	"N"
`minion	N	"N"
minis`tration	N	"V(`minister)+NR23"
`ministry	N_Suffix1a	"V(`minister)+NR3"
`mink	N	"N"
`minnow	N	"N"
`minstrel	N	"N"
`minstrelsy	N	"N"
`mint	N	"N"
minu`et	N	"N"
`minus	N	"N"
`minute	N	"N"
`miracle	N	"N"
mi`rage	N	"N"
`mire	N-to-V	"N"
`mirror	N-to-V	"N"
`mirth	N	"N"
`misanthrope	N	"N"
miscege`nation	N	"N"
`miscellany	N	"N"
`miscreant	N	"N"
`miser	N	"N"
`misery	N	"N"
`mishap	N	"N"
mis`nomer	N	"N"
`misprint	N	"PEJ2+V.NR0"
`miss	N	"N"
`missile	N	"N"
`mission	N	"N"
`missionary	N	"N(`mission)+NR39"
`missive	N	"N"
mis`spelling	N	"PEJ2+V(`spell)+NR24"
`missus	N	"N"
`mist	N	"N"
mis`take	N-to-V	"N"
`mistletoe	N	"N"
`mite	N	"N"
`mitre	N	"N"
`mitt	N	"N"
`mitten	N	"N"
`mixture	N	"V(`mix)+NR38"
`mixup	N	"N"
`moat	N	"N"
`mob	N-to-V	"N"
`moccasin	N	"N"
`mockery	N_Suffix1a	"V(`mock)+NR3"
`mockingbird	N	"N"
`mockup	N	"N"
`mode	N	"N"
`model	N-to-V	"N"
`modem	N	"N"
`moderacy	N	"AJ(`moderate)+NR40"
`modesty	N	"AJ(`modest)+AJR26"
`modicum	N	"N"
`module	N	"N"
`mogul	N	"N"
`moisture	N	"AJ(`moist)+NR38"
`molar	N	"N"
mo`lasses	N	"N"
`mold	N-to-V	"N"
`moldboard	N	"N"
`molding	N	"N"
`mole	N	"N"
`molecule	N	"N"
`molehill	N	"N"
`mollusk	N	"N"
`moment	N	"N"
mo`mento	N	"N"
`mommy	N	"N"
`monad	N	"N"
`monarch	N	"N"
`monarchs	N	"N(`monarch)+PL"
`monarchy	N	"N"
`monastery	N	"N"
`monetarism	N	"N"
`monetarist	N	"N"
`monetary	N	"N"
`monger	N-to-V	"N"
`mongrel	N	"N"
`moniker	N	"N"
`monicker	N	"N"
`monism	N	"N"
`monk	N	"N"
`monkey	N-to-V	"N"
`monogram	N-to-V	"N"
`monolith	N	"N"
`monologue	N	"N"
`monolog	N	"N"
mo`nopolist	N_Suffix1a	"N(mo`nopoly)+NR31"
mo`nopoly	N	"N"
mon`oxide	N	"N"
mon`soon	N	"N"
`monster	N	"N"
mon`strosity	N	"N(`monster)+AJ21+NR21"
mon`tage	N	"N"
`monte	N	"N"
`month	N	"N"
`monument	N	"N"
`mood	N	"N"
`moon	N	"N"
`moonlight	N	"N"
`moor	N	"N"
`mooring	N	"V(`moor)+NR24"
`mop	N-to-V	"N"
mo`raine	N	"N"
mo`rale	N	"N"
mo`rass	N	"N"
`morgen	N	"N"
`morgue	N	"N"
`mormon	N	"N"
`morn	N-to-V	"N"
`morning	N	"N"
`moron	N	"N"
`morph	N	"N"
`morpheme	N	"N"
`morphine	N	"N"
morpho`phoneme	N	"N"
morpho`syntax	N	"N"
`morris	N	"N"
`morrow	N	"N"
`morsel	N	"N"
`mortar	N	"N"
`mortgage	N-to-V	"N"
mortgag`or	N	"N" ;exception to Elision
mortifi`cation	N	"V(`mortify)+NR23"
mor`tician	N	"N"
`mortise	N	"N"
`mortuary	N	"N"
`mosaic	N	"N"
`mosque	N	"N"
`moss	N	"N"
`mot	N	"N"
`mote	N	"N"
mo`tel	N	"N"
mo`tet	N	"N"
`moth	N	"N"
`mothball	N	"N"
`mother	N-to-V	"N"
`motherland	N	"N"
mo`tif	N	"N"
`motion	N-to-V	"N"
`motive	N	"N"
`motor	N	"N"
`motorcycle	N	"N"
`mottle	N-to-V	"N"
`mould	N-to-V	"N" ;British
`mound	N	"N"
`mountain	N	"N"
`mountainside	N	"N"
`mountaintop	N	"N"
`mousetrap	N	"N"
`moustache	N	"N"
`mouth	N-to-V	"N"
`mouthful	N_Suffix1a	"N(`mouth)+NR5"
`mouthpiece	N	"N"
`movie	N	"N"
`moviegoer	N	"N(`movie)+V(`go)+NR19"
`moviegoing	N	"N(`movie)+V(`go)+PRG"
`mucilage	N	"N"
`muck	N	"N"
`mucus	N	"N"
`mud	N	"N"
`mudguard	N	"N"
`muff	N	"N"
`muffin	N	"N"
`mug	N	"N"
`mulberry	N	"N"
`mulch	N-to-V	"N"
`mule	N	"N"
`mullah	N	"N"
`mulligan	N	"N"
mulliga`tawny	N	"N"
`multiplicand	N	"N"
multipli`cation	N	"V(`multiply)+NR23"
multi`plicity	N	"AJ(`multiple)+NR21"
`multitasking	N	"NUM4+N(`task)+PRG"
`multitude	N	"N"
`mummery	N	"N"
`mummy	N	"N"
mummifi`cation	N	"N(`mummy)+VR5+NR23"
`mung	N	"N"
mu`nition	N	"N"
`mural	N	"N"
`murk	N	"N"
`muscle	N	"N"
`musculature	N	"N(`muscle)+NR38"
mu`seum	N	"N"
`mush	N	"N"
`mushroom	N-to-V	"N"
`music	N	"N"
`musical	N	"N(`music)+AJR17.NR0"
musi`cale	N	"N"
`musk	N	"N"
`musket	N	"N"
`muskmelon	N	"N"
`muskrat	N	"N"
`muslin	N	"N"
`mussel	N	"N"
`mustache	N	"N"
mus`tachio	N	"N"
`mustang	N	"N"
`mustard	N	"N"
muta`bility	N	"AJ(`mutable)+NR21"
`mutagen	N	"N"
muti`neer	N_Suffix1a	"N(`mutiny)+NR10"
`mutiny	N-to-V	"N"
`mutt	N	"N"
`mutton	N	"N"
`mutuel	N	"N"
`mylar	N	"N"
`mynah	N	"N"
my`opia	N	"N"
`myriad	N	"N"
`myrrh	N	"N"
`myrtle	N	"N"
`mystery	N	"N"
`mystic	N	"AJ(`mystic).NR0"
mystifi`cation	N	"V(`mystify)+NR23"
mys`tique	N	"N"
`myth	N	"N"

`nadir	N	"N"
`nail	N-to-V	"N"
naive`te	N	"N"
nai`vety	N	"AJ(`naive)+NR21"
`name	N-to-V	"N"
`nameplate	N	"N"
`namesake	N	"N"
`napalm	N	"N"
`nape	N	"N"
`napkin	N	"N"
`narcissism	N	"N"
`narcissist	N	"N"
nar`cissus	N	"N"
nar`cotic	N-to-AJ	"N"
`narrative	N	"V(`narrate)+AJR26.NR0"
nas`turtium	N	"N"
`nation	N	"N"
`national	N	"N(`nation)+AJR17.NR0"
na`tivity	N	"N"
`nature	N	"N"
`naught	N	"N"
`nausea	N	"N"
`nautilus	N	"N"
`nave	N	"N"
`navel	N	"N"
`navy	N-to-AJ	"N"
ne`cessity	N	"N"
`neck	N	"N"
`necklace	N	"N"
`neckline	N	"N"
`necktie	N	"N"
`necromancer	N	"N"
`necromancy	N	"N"
`necropsy	N-to-V	"N"
ne`crosis	N	"N"
`nectar	N	"N"
`nectary	N	"N"
`needle	N-to-V	"N"
`needlepoint	N	"N"
`needlework	N	"N"
`negligee	N	"N"
`negligence	N	"AJ(`negligent)+NR41"
negotia`bility	N	"AJ(ne`gotiable)+NR21"
`neighbor	N-to-V	"N"
`neighbour	N-to-V	"N" ;British
`nemesis	N	"N"
ne`ologism	N	"N"
`neon	N	"N"
`neonate	N	"N"
`neophyte	N	"N"
`neoprene	N	"N"
ne`penthe	N	"N"
`nephew	N	"N"
`nepotism	N	"N"
`nerve	N-to-V	"N"
`nest	N-to-V	"N"
`net	N-to-V	"N"
`netherworld	N	"N"
`nettle	N-to-V	"N"
`network	N-to-V	"N"
neu`ralgia	N	"N"
neu`ritis	N	"N"
`neuron	N	"N"
neu`trino	N	"N"
`neutron	N	"N"
`newcomer	N	"AJ(`new)+V(come)+NR19"
`newel	N	"N"
`newlywed	N	"N"
`news	N	"N"
`newsboy	N	"N"
`newscast	N	"N"
`newscaster	N	"N"
`newsletter	N	"N"
`newsmaker	N	"N(`news)+V(`make)+NR19"
`newspaper	N	"N"
`newsreel	N	"N"
`newsstand	N	"N"
`newswire	N	"N"
`newt	N	"N"
`nib	N	"N"
`nicety	N	"AJ(`nice)+AJR26"
`niche	N	"N"
`nick	N-to-V	"N"
`nickel	N	"N"
`nickname	N-to-V	"N"
`nicotine	N	"N"
`niece	N	"N"
`niggard	N	"N"
`nigger	N	"N"
`night	N	"N"
`nightcap	N	"N"
`nightclub	N	"N"
`nightdress	N	"N"
`nightfall	N	"N"
`nightgown	N	"N"
`nighthawk	N	"N"
`nightingale	N	"N"
`nightmare	N	"N"
`nightshirt	N	"N"
`nightstick	N	"N"
`nighttime	N	"N"
`nihilism	N	"N"
`nihilist	N	"N"
`nil	N	"N"
`nipple	N	"N"
nir`vana	N	"N"
`nit	N	"N"
`nitrate	N	"N"
`nitrogen	N	"N"
nitro`glycerine	N	"N"
nitty-`gritty	N	"N"
`nob	N	"N"
no`bility	N	"AJ(`noble)+NR21"
no`blesse	N	"N"
`nobody	N	"N"
`nocturne	N	"N"
`node	N	"N"
`nodule	N	"N"
`noise	N	"N"
`nomad	N	"N"
no`menclature	N	"N"
nomi`nee	N	"N"
nonage`narian	N	"N"
`nonce	N	"N"
noncha`lance	N	"AJ(noncha`lant)+NR41"
`noodle	N	"N"
`nook	N	"N"
`noon	N	"N"
`noontime	N	"N"
`noose	N	"N"
nor'`easter	N	"N"
`norm	N	"N"
`normalcy	N	"N(`norm)+AJR17+NR40"
`north	N-to-AJ	"N"
north`east	N-to-AJ	"N"
north`easter	N	"N"
`northerner	N	"N"
`northland	N	"N"
north`west	N-to-AJ	"N"
`nose	N	"N"
`nosebag	N	"N"
`nosebleed	N	"N"
`nosegay	N	"N"
nos`talgia	N	"N"
`nostril	N	"N"
`notary	N	"N"
`notch	N-to-V	"N"
`notebook	N	"N"
`notion	N	"N"
`nothingness	N	"N"
noto`riety	N	"N"
`nought	N	"N" ;var. of naught
`noun	N	"N"
`novel	N	"N"
`novelty	N	"AJ(`novel)+NR21"
`novice	N	"N"
no`vitiate	N	"N"
`nozzle	N	"N"
`nuance	N	"N"
`nugget	N	"N"
`nuisance	N	"N"
`number	N-to-V	"N"
numera`bility	N	"V(`numerate)+AJR25+NR21"
`numeral	N	"N"
nu`mismatist	N	"N"
`nun	N	"N"
`nunnery	N_Suffix1a	"N(`nun)+NR3"
`nursery	N	"N"
`nursemaid	N	"N"
`nut	N	"N"
`nutcracker	N	"N"
`nuthatch	N	"N"
`nutmeg	N	"N"
`nutrient	N	"N"
nu`trition	N	"N"
`nutshell	N	"N"
`nylon	N	"N"
`nymph	N	"N"
nympho`mania	N	"N"
nympho`maniac	N	"N"

`oaf	N	"N"
`oak	N	"N"
`oakwood	N	"N"
`oar	N	"N"
`oat	N	"N"
`oath	N	"N"
`oatmeal	N	"N"
`obduracy	N	"AJ(`obdurate)+NR40"
o`bedience	N	"V(o`bey)+AJR27+NR41"
o`beisance	N	"N"
`obelisk	N	"N"
o`bituary	N	"N"
`object	N	"N"
objectiona`bility	AJ	"V(ob`ject)+NR23+AJR25+NR21"
ob`jective	N	"N"
`oblate	N	"N"
ob`livion	N	"N"
`oblong	N	"N"
`oboe	N	"N"
`oboist	N_Suffix1a	"N(`oboe)+NR31"
ob`servatory	N	"V(ob`serve)+NR34"
ob`sidian	N	"N"
obso`lescence	N	"AJ(obso`lescent)+NR41"
`obstacle	N	"N"
`obstinacy	N	"AJ(`obstinate)+NR40"
ob`trusion	N	"V(ob`trude)+NR23"
oca`rina	N	"N"
oc`casion	N-to-V	"N"
`occident	N	"N"
occi`dental	N	"N(`occident)+AJR17.NR0"
oc`clusion	N	"V(oc`clude)+NR23"
occul`tation	N	"AJ(oc`cult)+NR23"
`occupancy	N	"V(`occupy)+NR17+NR40"
`occupant	N	"V(`occupy)+NR17"
occu`pation	N	"V(`occupy)+NR23"
`ocean	N	"N"
`oceanfront	N	"N"
`oceanside	N	"N"
`ocelot	N	"N"
`octagon	N	"N"
`octane	N	"N"
`octant	N	"N"
`octave	N	"N"
oc`tavo	N	"N"
oc`tet	N	"N"
octo`genarian	N	"N"
`octopus	N	"N"
octo`roon	N	"N"
`ode	N	"N"
`odium	N	"N"
o`dometer	N	"N"
`odor	N	"N"
`odour	N	"N" ;British
`odyssey	N	"N"
`offal	N	"N"
of`fence	N	"N"
of`fense	N	"N"
`offering	N	"V(`offer)+NR24"
`offertory	N	"N"
`office	N	"N"
`officeholder	N	"N"
`officemate	N	"N"
`officer	N	"N"
of`ficial	N	"N"
`offing	N	"N"
`offprint	N	"N"
`offset	N	"N"
`offshoot	N	"N"
`ogre	N	"N"
`ohm	N	"N"
`ohmmeter	N	"N"
`oil	N-to-V	"N"
`oilcloth	N	"N"
`oilfield	N	"N"
`oilseed	N	"N"
`ointment	N	"N"
`oldy	N_Suffix1a	"AJ(`old)+NR33"
ole`ander	N	"N"
`olefin	N	"N"
oleo`margarine	N	"N"
`oligarch	N	"N"
`oligarchy	N	"N"
oli`gopoly	N	"N"
`olive	N	"N"
o`lympiad	N	"N"
`omelet	N	"N"
`omelette	N	"N"
`omen	N	"N"
o`mission	N	"V(o`mit)+NR23"
`omnibus	N	"N"
om`niscience	N	"AJ(om`niscient)+NR41"
`omnivore	N	"N"
`oneness	N	"CD(`one)+NR27"
one`upmanship	N	"N"
`onion	N	"N"
`onlooker	N	"N"
onomato`poeia	N	"N"
`onrush	N	"N"
`onset	N	"N"
`onslaught	N	"N"
`onus	N	"N"
`onyx	N	"N"
`ooze	N-to-V	"N"
o`pacity	N	"AJ(o`paque)+NR21"
`opal	N	"N"
`opening	N	"V(`open)+NR24"
`opera	N	"N"
opera`bility	AJ	"V(`operate)+AJR25+NR21"
`operand	N	"N"
`operative	N	"V(`operate)+AJR26.NR0"
oper`etta	N	"N"
`opiate	N	"N"
;o`pinion	N	"N"
`opium	N	"N"
o`possum	N	"N"
op`ponent	N	"N"
op`probrium	N	"N"
`optimism	N	"N"
`optimist	N	"N"
`option	N	"N"
`opulence	N	"AJ(`opulent)+NR41"
`oracle	N	"N"
or`angutan	N	"N"
ora`torio	N	"N"
`oratory	N	"N"
`orb	N-to-V	"N"
`orbit	N-to-V	"N"
`orchard	N	"N"
`orchestra	N	"N"
`orchid	N	"N"
or`deal	N	"N"
`ordinance	N	"N"
`ordinand	N	"N"
`ordinate	N	"N"
ordi`nation	N	"V(or`dain)+NR23"
`ordnance	N	"N"
`ore	N	"N"
o`regano	N	"N"
`organ	N	"N"
`organdy	N	"N"
`organism	N	"N"
`orgasm	N	"N"
`orgy	N	"N"
`orient	N	"N"
`orifice	N	"N"
`origin	N	"N"
o`riginal	N	"N(`origin)+AJR17.NR0"
`oriole	N	"N"
`ornament	N	"N"
ornamen`tation	N	"N"
`orphan	N-to-V	"N"
`orphanage	N_Suffix1a	"N(`orphan)+NR1"
ortho`dontist	N	"N"
`orthodoxy	N	"N"
ortho`paedist	N	"N"
ortho`pedist	N	"N"
os`cilloscope	N	"N"
os`mosis	N	"N"
`osprey	N	"N"
ossifi`cation	N	"V(`ossify)+NR23"
osten`tation	N	"N"
`osteopath	N	"N"
`osteopathy	N	"N"
`ostracism	N_Suffix1b	"V(`ostracize)+NR8"
`ostrich	N	"N"
`otherworld	N	"N"
`otter	N	"N"
`ottoman	N	"N"
`ounce	N	"N"
`outcrop	N-to-V	"N"
out`doors	Number	"N" ;singular
`outfit	N	"N"
`outgrowth	N	"N"
`outing	N	"N"
`outlaw	N-to-V	"N"
`outline	N-to-V	"N"
`outrage	N-to-V	"N"
`outside	N	"N"
out`sider	N	"N(`outside)+NR11"
`outskirt	N	"N"
out`spokenness	N	"DEG6+V(`speak).PTC+NR27"
`ovary	N	"N"
o`vation	N	"N"
`oven	N	"N"
`overhang	N	"N"
`overture	N	"N"
`owl	N	"N"
`owlet	N	"N(`owl)+NR14"
`oxcart	N	"N"
`oxide	N	"N"
`oxygen	N	"N"
oxy`moron	N	"N"
`oyster	N	"N"
`ozone	N	"N"

;`pa	N	"N" ;causes bad parses
`pacemaker	N	"N(`pace)+V(`make)+NR19"
`pacemaking	N	"N(`pace)+V(`make)+PRG"
`pacifism	N	"N"
`pacifist	N	"N"
`pack	N	"N"
`package	N-to-V	"N"
`packet	N	"N"
`packing	N	"V(`pack)+NR24"
`pact	N	"N"
`pad	N-to-V	"N"
`padding	N	"N(`pad)+NR7"
`paddle	N-to-V	"N"
`paddock	N	"N"
`paddy	N	"N"
`padlock	N-to-V	"N"
`padre	N	"N"
`paean	N	"N"
`pagan	N-to-AJ	"N"
`page	N-to-V	"N"
`pageant	N	"N"
`pageantry	N_Suffix1a	"N(`pageant)+NR3"
pa`goda	N	"N"
`pail	N	"N"
`pailful	N_Suffix1a	"N(`pail)+NR5"
`pain	N-to-V	"N"
`paint	N-to-V	"N"
`paintbrush	N	"N"
`painting	N	"V(`paint)+NR24"
`pair	N-to-V	"N"
`pal	N	"N"
`palace	N	"N"
palata`bility	N	"N(`palate)+AJR25+NR21"
`palate	N	"N"
pa`laver	N-to-V	"N"
`palette	N	"N"
`palimony	N	"N"
`palindrome	N	"N"
`palisade	N	"N"
`pall	N	"N"
`pallet	N	"N"
`palm	N-to-V	"N"
palo`mino	N	"N"
palpa`bility	N	"AJ(`palpable)+NR21"
`palsy	N-to-V	"N"
`pampa	N	"N"
`pamphlet	N	"N"
`pan	N-to-V	"N"
pana`cea	N	"N"
`panama	N	"N"
`pancake	N	"N"
`pancreas	N	"N"
`panda	N	"N"
pande`monium	N	"N"
`pane	N	"N"
`panel	N-to-V	"N"
`paneling	N	"N(`panel)+NR7"
`panful	N_Suffix1a	"N(`pan)+NR5"
`pang	N	"N"
`panic	N-to-V	"N"
`panoply	N	"N"
pano`rama	N	"N"
`pansy	N	"N"
panta`loon	N	"N"
`pantheism	N	"N"
`pantheist	N	"N"
`pantheon	N	"N"
`panther	N	"N"
`pantomime	N	"N"
`pantry	N	"N"
`panty	N	"N"
`pap	N	"N"
`papa	N	"N"
`papacy	N	"N"
`papal	N	"N"
`papaw	N	"N"
`paper	N-to-V	"N"
`paperback	N	"N"
`paperweight	N	"N"
`paperwork	N	"N"
pa`poose	N	"N"
`pappy	N	"N"
pap`rika	N	"N"
`par	N	"N"
`parable	N	"N"
pa`rabola	N	"N"
pa`raboloid	N	"N"
`parachute	N-to-V	"N"
pa`rade	N-to-V	"N"
`paradigm	N	"N"
`paradise	N	"N"
`paradox	N	"N"
`paraffin	N	"N"
`paragon	N	"N"
`paragraph	N-to-V	"N"
`parakeet	N	"N"
`parallax	N	"N"
paral`lelogram	N	"N"
para`lytic	N	"AJ(para`lytic).NR0"
pa`rameter	N	"N"
`paramour	N	"N"
para`noia	N	"N"
`parapet	N	"N"
para`plegic	N	"AJ(para`plegic).NR0"
`parasite	N	"N"
`parasol	N	"N"
`parcel	N-to-V	"N"
pare`goric	N	"N"
`parent	N-to-V	"N"
`parentage	N_Suffix1a	"N(`parent)+NR1"
pari-`mutuel	N	"N"
pari`mutuel	N	"N"
pa`riah	N	"N"
`paring	N	"V(`pare)+NR24"
`parish	N	"N"
pa`rishioner	N	"N"
`parity	N	"N"
`park	N-to-V	"N"
`parkland	N	"N"
`parkway	N	"N"
`parlance	N	"N"
`parlay	N-to-V	"N"
`parliament	N	"N"
`parlor	N	"N"
`parlour	N	"N" ;British
`parody	N-to-V	"N"
pa`role	N-to-V	"N"
par`oxysm	N	"N"
par`quet	N	"N"
`parrot	N-to-V	"N"
`parsimony	N	"N"
`parsley	N	"N"
`parsnip	N	"N"
`parson	N	"N"
`parsonage	N_Suffix1a	"N(`parson)+NR1"
`part	N-to-V	"N"
par`ticipant	N	"V(par`ticipate)+NR17"
`participle	N	"N"
`particle	N	"N"
`partisan	N	"N"
par`tition	N-to-V	"N"
`partner	N-to-V	"N"
`partridge	N	"N"
`party	N-to-V	"N"
`pasha	N	"N"
`passage	N	"N"
`passageway	N	"N"
`passband	N	"N"
`passenger	N	"N"
`passion	N	"N"
`passport	N	"N"
`password	N	"N"
`pasta	N	"N"
`paste	N-to-V	"N"
`pasteboard	N	"N"
pas`tel	N	"N"
`pasteup	N	"N"
pas`tiche	N	"N"
`pastime	N	"N"
`pastor	N	"N"
`pastry	N	"N"
`pasture	N	"N"
`patch	N-to-V	"N"
`patchwork	N	"N"
`pate	N	"N"
`patent	N-to-V	"N"
`pater	N	"N"
pa`ternity	N	"N"
pater`noster	N	"N"
`path	N	"N"
`pathfinder	N	"N(`path)+V(`find)+NR19"
`pathogen	N	"N"
patho`genesis	N	"N"
`pathos	N	"N"
`pathway	N	"N"
`patience	N	"AJ(`patient)+NR41"
`patient	N	"N"
pa`tina	N	"N"
`patio	N	"N"
`patriarch	N	"N"
`patriarchs	N	"N(`patriarch)+PL"
`patriarchy	N	"N"
pa`trician	N	"N"
`patrimony	N	"N"
`patriot	N	"N"
`patron	N	"N"
`patronage	N_Suffix1a	"N(`patron)+NR1"
`pattern	N-to-V	"N"
`patty	N	"N"
`paucity	N	"N"
`paunch	N	"N"
`pauper	N	"N"
pa`vanne	N	"N"
pa`vilion	N-to-V	"N"
`paving	N	"V(`pave)+NR24"
`paw	N-to-V	"N"
`pawn	N	"N"
`pawnshop	N	"N"
`pax	N	"N"
`paycheck	N	"N"
`payday	N	"N"
`payload	N	"N"
`paymaster	N	"N"
`payoff	N	"N"
`payroll	N	"N"
`pea	N	"N"
`peace	N	"N"
`peacekeeper	N	"N(`peace)+V(`keep)+NR19"
`peacekeeping	N	"N(`peace)+V(`keep)+PRG"
`peacemaker	N	"N(`peace)+V(`make)+NR19"
`peacetime	N	"N"
`peach	N	"N"
`peacock	N	"N"
`peafowl	N	"N"
`peak	N-to-V	"N"
`peanut	N	"N"
`pear	N	"N"
`pearl	N	"N"
`peasant	N	"N"
`peasantry	N_Suffix1a	"N(`peasant)+NR3"
;`peat	N	"N"
`pebble	N	"N"
pe`can	N	"N"
`peccary	N	"N"
`peck	N	"N" ;dry measure
`pedagogue	N	"N"
`pedal	N-to-V	"N"
`pedant	N	"N"
`pedantry	N_Suffix1a	"N(`pedant)+NR3"
`pedestal	N	"N"
pe`destrian	N	"N"
pedia`trician	N	"AJ(pedi`atric)+NR29"
`pedigree	N	"N"
`pediment	N	"N"
`peel	N-to-V	"N"
`peephole	N	"N"
`peer	N	"N"
`peeve	N	"N"
`peg	N-to-V	"N"
`pegboard	N	"N"
`pelican	N	"N"
pel`lagra	N	"N"
`pellet	N	"N"
`peltry	N	"N"
`pelvis	N	"N"
`pemmican	N	"N"
`pen	N-to-V	"N"
`penalty	N	"N"
`penance	N	"N"
`penchant	N	"N"
`pencil	N-to-V	"N"
`pendant	N	"N"
`pendulum	N	"N"
penetra`bility	N	"V(`penetrate)+AJR25+NR21"
`penguin	N	"N"
peni`cillin	N	"N"
pe`ninsula	N	"N"
`penis	N	"N"
`penitence	N	"AJ(`penitent)+NR41"
peni`tentiary	N	"N"
`pennant	N	"N"
penny`royal	N	"N"
`pennyworth	N	"N"
`pension	N-to-V	"N"
`pentagon	N	"N"
`pentagram	N	"N"
`penthouse	N	"N"
`penult	N	"N"
pe`nultima	N	"N"
`penury	N	"N"
`peony	N	"N"
`pep	N-to-V	"N"
`pepper	N-to-V	"N"
`peppergrass	N	"N"
`peppermint	N	"N"
pepper`oni	N	"N"
per`cent	N	"N"
per`centage	N	"N(per`cent)+NR1"
per`centile	N	"N"
`percept	N	"N"
percepti`bility	N	"V(per`ceive)+AJR25+NR21"
per`ception	N	"V(per`ceive)+NR23"
`perch	N	"N"
per`cipience	N	"AJ(per`cipient)+NR41"
per`dition	N	"N"
`peregrine	N	"N"
peres`troika	N	"N"
`perfidy	N	"N"
per`fume	N-to-V	"N"
per`fumery	N_Suffix1a	"N(per`fume)+NR3"
`peril	N-to-V	"N"
pe`rimeter	N	"N"
`period	N	"N"
peri`odical	N	"N(`period)+AJR20+AJR17"
pe`riphery	N	"N"
`periscope	N	"N"
perito`nitis	N	"N"
`periwinkle	N	"N"
`perjury	N	"N"
`permafrost	N	"N"
`permanence	N	"AJ(`permanent)+NR41"
`permanency	N	"AJ(`permanent)+NR40"
permea`bility	N	"V(`permeate)+AJR25+NR21"
permissi`bility	N	"V(per`mit)+AJR25+NR21"
per`mission	N	"V(per`mit)+NR23"
`permit	N	"V(per`mit).NR0"
per`oxide	N	"N"
perpe`tuity	N	"N"
per`plexity	N	"V(per`plex)+NR21"
`perquisite	N	"N"
`persiflage	N	"N"
per`simmon	N	"N"
`person	N	"N"
`personage	N_Suffix1a	"N(`person)+NR1"
per`spective	N	"N"
perspi`cacity	N	"N"
perspi`cuity	N	"N"
per`suasion	N	"V(per`suade)+NR23"
pertinacity	N	"AJ(`pertinent)+NR21"
`pertinence	N	"AJ(`pertinent)+NR41"
per`vasion	N	"V(per`vade)+NR23"
per`version	N	"V(per`vert)+NR23"
`pervert	N	"V(per`vert).NR0"
`peso	N	"N"
`pessimism	N	"N"
`pessimist	N	"N"
`pest	N	"N"
`pestilence	N	"N"
`pestle	N	"N"
`pet	N	"N"
`petal	N	"N"
pe`tition	N-to-V	"N"
`petrel	N	"N"
`petri	N	"N"
petri`faction	N	"V(`petrify)+NR23"
`petroglyph	N	"N"
`petrol	N	"N"
pet`roleum	N	"N"
`petticoat	N	"N"
`petulance	N	"AJ(`petulant)+NR41"
pe`tunia	N	"N"
`pew	N	"N"
`pewee	N	"N"
`pewter	N	"N"
`pfennig	N	"N"
`phalanx	N	"N"
`phantasy	N	"N"
`phantom	N	"N"
`pharaoh	N	"N"
`pharisee	N	"N"
`pharmacist	N	"N"
`pharmacy	N	"N"
`pharynx	N	"N"
`phase	N-to-V	"N"
`pheasant	N	"N"
philhar`monic	N	"N"
philo`dendron	N	"N"
`phlegm	N	"N"
`phlox	N	"N"
`phobia	N	"N"
`phoebe	N	"N"
`phoenix	N	"N"
`phone	N-to-V	"N"
`phoneme	N	"N"
`phonograph	N	"N"
`phosgene	N	"N"
`phosphate	N	"N"
`phosphor	N	"N"
`phosphorus	N	"N"
`photo	N	"N"
`photograph	N-to-V	"N"
pho`tography	N	"N"
`photon	N	"N"
`phrase	N-to-V	"N"
`physics	Number	"N"
`physicist	N_Suffix1a	"N(`physics)+NR31"
phy`sician	N	"N"
phy`sique	N	"N"
`pianist	N_Suffix1a	"N(pi`ano)+NR31"
pi`ano	N	"N"
pi`azza	N	"N"
`pica	N	"N"
`piccolo	N	"N"
`pickaxe	N	"N"
`pickerel	N	"N"
`pickup	N	"N"
`picnic	N-to-V	"N"
`picnicker	N	"N(`picnic)+VR0+NR19"
`picture	N-to-V	"N"
`pidgin	N	"N"
`pie	N	"N"
`piece	N-to-V	"N"
`piecrust	N	"N"
`pier	N	"N"
`pietism	N	"N"
`piety	N	"N"
`pig	N	"N"
`pigeon	N	"N"
`pigeonhole	N-to-V	"N"
`piggery	N_Suffix1a	"N(`pig)+NR3"
`pigment	N-to-V	"N"
pigmen`tation	N	"N"
`pigpen	N	"N"
`pigskin	N	"N"
`pigtail	N	"N"
`pike	N	"N"
`pile	N-to-V	"N"
;`pilferage	N_Suffix1a	"V(`pilfer)+NR1"
`pilgrim	N	"N"
`pilgrimage	N_Suffix1a	"N(`pilgrim)+NR1"
`piling	N	"N"
`pill	N	"N"
`pillar	N	"N"
`pillory	N-to-V	"N"
`pillow	N	"N"
`pilot	N-to-V	"N"
`pimp	N-to-V	"N"
`pimple	N	"N"
`pin	N-to-V	"N"
`pinafore	N	"N"
`pinball	N	"N"
`pincushion	N	"N"
`pine	N	"N"
`pineapple	N	"N"
`ping	N-to-V	"N"
`pinhead	N	"N"
`pinhole	N	"N"
`pinion	N-to-V	"N"
`pinkie	N	"N"
`pinnacle	N	"N"
`pinochle	N	"N"
`pinpoint	N-to-V	"N"
`pint	N	"N"
`pintail	N	"N"
`pinto	N	"N"
`pinwheel	N	"N"
`pion	N	"N"
`pioneer	N-to-V	"N"
`pip	N	"N"
`pipe	N-to-V	"N"
`pipeful	N_Suffix1a	"N(`pipe)+NR5"
`pipeline	N	"N"
pip`ette	N	"N"
`pique	N-to-V	"N"
`piracy	N	"N(`pirate)+NR40"
`pirate	N-to-V	"N"
pirou`ette	N-to-V	"N"
pis`tachio	N	"N"
`pistil	N	"N"
`pistol	N	"N"
`piston	N	"N"
`pit	N-to-V	"N"
`pitch	N	"N"
`pitchblende	N	"N"
`pitchfork	N	"N"
`pitchstone	N	"N"
`pitfall	N	"N"
`pith	N	"N"
`pittance	N	"N"
pi`tuitary	N	"N"
`pity	N-to-V	"N"
`pivot	N-to-V	"N"
`pixel	N	"N"
`pixie	N	"N"
`pizza	N	"N"
pizze`ria	N	"N"
`placard	N	"N"
`place	N-to-V	"N"
pla`cebo	N	"N"
`placeholder	N	"N"
`plagiarism	N	"N"
`plagiarist	N	"N"
`plague	N-to-V	"N"
`plaid	N	"N"
`plain	N	"N"
`plaintiff	N	"N"
`plan	N-to-V	"N"
`plane	N-to-V	"N(`plane1)" ;tool
`plane	N	"N(`plane2)" ;airplane
`planeload	N	"N"
`planet	N	"N"
`planetoid	N	"N(`planet)+NR53"
`plank	N	"N"
`planking	N	"N(`plank)+NR7"
`plankton	N	"N"
`plant	N-to-V	"N"
`plantain	N	"N"
plan`tation	N	"N"
`plaque	N	"N"
`plasm	N	"N"
`plasma	N	"N"
`plaster	N-to-V	"N"
`plastic	N	"AJ(`plastic).NR0"
`plate	N-to-V	"N"
pla`teau	N	"N"
`plateful	N_Suffix1a	"N(`plate)+NR5"
`platelet	N	"N"
`platen	N	"N"
`platform	N	"N"
`plating	N	"N(`plate)+NR7"
`platinum	N	"N"
`platitude	N	"N"
pla`toon	N	"N"
`platter	N	"N"
`plaudit	N	"N"
plausi`bility	N	"AJ(`plausible)+NR21"
`playa	N	"N"
`playback	N	"N"
`playboy	N	"N"
`playground	N	"N"
`playhouse	N	"N"
`playmate	N	"N"
`playoff	N	"N"
`playroom	N	"N"
`plaything	N	"N"
`playtime	N	"N"
`playwright	N	"N"
`plaza	N	"N"
`plea	N	"N"
`pleasantry	N_Suffix1a	"V(`please)+AJR27+NR3"
`pleasure	N-to-V	"V(`please)+NR38"
`pleat	N-to-V	"N"
`plebe	N	"N"
`plebiscite	N	"N"
`pledge	N-to-V	"N"
`plenitude	N	"N"
`plethora	N	"N"
`pleurisy	N	"N"
`pliancy	N	"AJ(`pliant)+AJR40"
`plight	N	"N"
`plot	N-to-V	"N"
`plover	N	"N"
`plough	N-to-V	"N"
`plow	N-to-V	"N"
`plowshare	N	"N"
`ploy	N	"N"
`pluck	N	"N"
`plug	N-to-V	"N"
`plum	N	"N"
`plumb	N	"N"
`plumbing	N	"N"
`plume	N-to-V	"N"
`plumage	N_Suffix1a	"N(`plume)+NR1"
`plus	N	"N"
plu`tonium	N	"N"
`plywood	N	"N"
pneu`monia	N	"N"
`pocket	N-to-V	"N"
`pocketbook	N	"N"
`pocketful	N_Suffix1a	"N(`pocket)+NR5"
`pockmark	N-to-V	"N"
`pod	N	"N"
`poem	N	"N"
`poesy	N	"N"
`poet	N	"N"
`poetry	N_Suffix1a	"N(`poet)+NR3"
`pogrom	N	"N"
`poi	N	"N"
`poignancy	N	"AJ(`poignant)+AJR40"
poin`settia	N	"N"
`point	N-to-V	"N"
`poison	N-to-V	"N"
`pokerface	N	"N"
`pole	N-to-V	"N"
`polecat	N	"N"
po`lemic	N	"N"
`policy	N	"N"
`polio	N	"N"
poli`tician	N	"N(`politics)+NR29"
`polity	N	"N"
`polka	N-to-V	"N"
`poll	N-to-V	"N"
`pollen	N	"N"
`polliwog	N	"N"
`pollock	N	"N"
`polo	N	"N"
polo`naise	N	"N"
`polopony	N	"N"
pol`troon	N	"N"
`polyglot	N	"N"
`polygon	N	"N"
`polymer	N	"N"
`polymorph	N	"N"
poly`nomial	N	"N"
`polyp	N	"N"
po`made	N	"N"
`pomegranate	N	"N"
`pomp	N	"N"
`pompadour	N	"N"
`pompano	N	"N"
`pom-pom	N	"N"
`pompon	N	"N"
pom`posity	N	"N(`pomp)+AJR21+NR21"
`poncho	N	"N"
`pond	N	"N"
`pontiff	N	"N"
`pony	N	"N"
`pooch	N	"N"
`poodle	N	"N"
`pool	N-to-V	"N"
`poop	N	"N"
`popcorn	N	"N"
`pope	N	"N"
`poplar	N	"N"
`poplin	N	"N"
`poppy	N	"N"
`populace	N	"N"
`populism	N	"N"
`populist	N	"N"
`porcelain	N	"N"
`porch	N	"N"
`porcupine	N	"N"
`pore	N	"N"
`pork	N	"N"
po`rosity	N	"N(`pore)+AJR21+NR21"
`porpoise	N	"N"
`porridge	N	"N"
`port	N	"N"
porta`bility	N	"AJ(`portable)+NR21"
`portage	N	"N"
`portal	N	"N"
port`cullis	N	"N"
`portent	N	"N"
`porter	N	"N"
`porterhouse	N	"N"
port`folio	N	"N"
`porthole	N	"N"
`portion	N	"N"
`portrait	N	"N"
`portraiture	N	"N(`portrait)+NR38"
portu`laca	N	"N"
po`seur	N	"N"
`posey	N	"N"
po`sition	N-to-V	"N"
`posse	N	"N"
pos`sessive	N	"V(pos`sess)+AJR26.NR0"
possi`bility	N	"AJ(`possible)+NR21"
`possum	N	"N"
`post	N	"N"
`postage	N	"N"
`postcard	N	"N"
pos`terior	N	"N"
pos`terity	N	"N"
`postfix	N	"N"
`posting	N	"V(`post)+NR24"
`postlude	N	"N"
`postmark	N	"N"
`postmaster	N	"N"
post`mortem	N	"N"
`postscript	N	"N"
`postulant	N	"N"
`posture	N-to-V	"N"
`posy	N	"N"
`pot	N-to-V	"N"
`potash	N	"N"
po`tassium	N	"N"
`potence	N	"AJ(`potent)+NR41"
`potbelly	N	"N"
`potboiler	N	"N"
`potency	N	"AJ(`potent)+NR40"
`potentate	N	"N"
potenti`ometer	N	"N"
`potful	N_Suffix1a	"N(`pot)+NR5"
`pothole	N	"N"
`potion	N	"N"
`potlatch	N	"N"
`potluck	N	"N"
potpour`ri	N	"N"
`pottery	N_Suffix1a	"N(`pot)+NR3"
`pouch	N	"N"
`poultice	N	"N"
`pound	N	"N"
`poverty	N	"N"
`powder	N-to-V	"N"
`powderpuff	N	"N"
`power	N-to-V	"N"
`powerhouse	N	"N"
practica`bility	N	"AJ(`practicable)+NR21"
prac`titioner	N	"N"
`pragmatism	N	"N"
`pragmatist	N	"N"
`prairie	N	"N"
`pram	N	"N"
`prank	N	"N"
`prayer	N	"N"
`preamble	N	"N"
pre`caution	N	"N"
`precedent	N	"V(pre`cede)+NR17"
`precept	N	"N"
`precinct	N	"N"
`precipice	N	"N"
pre`cipitance	N	"AJ(pre`cipitant)+NR41"
pre`cipitancy	N	"AJ(pre`cipitant)+NR40"
pre`cision	N	"AJ(pre`cise)+NR23"
pre`cocity	N	"N"
pre`cursor	N	"N"
`predecessor	N	"N"
pre`dicament	N	"N"
`predicate	N-to-V	"N"
predi`lection	N	"N"
`preface	N-to-V	"N"
`prefect	N	"N"
`prefecture	N	"N"
prefera`bility	AJ	"V(pre`fer)+AJR25+NR21"
`preference	N	"V(pre`fer)+NR26"
`prefix	N	"N"
`pregnancy	N	"AJ(`pregnant)+AJR40"
`prejudice	N-to-V	"N"
`prelude	N	"N"
pre`mier	N	"N"
pre`miere	N-to-V	"N"
`premise	N-to-V	"N"
`premium	N	"N"
premo`nition	N	"N"
`prep	N	"N"
prepo`sition	N	"N"
pre`requisite	N	"N"
pre`rogative	N	"N"
`presbyter	N	"N"
`presbytery	N	"N"
pre`schooler	N_Suffix1a	"ORD4+N(`school)+NR11"
`prescience	N	"AJ(`prescient)+NR41"
pre`scription	N	"V(pre`scribe)+NR23"
`presence	N	"AJ(`present)+NR41"
`present	N	"V(pre`sent).NR0"
`presidency	N	"V(pre`side)+NR17+NR40"
`president	N	"V(pre`side)+NR17"
`press	N	"N"
`presstime	N	"N"
`pressure	N-to-V	"V(`press)+NR38"
pres`tige	N	"N"
pre`sumption	N	"V(pre`sume)+NR23"
`pretence	N	"N"
`pretense	N	"N"
pre`tension	N	"N"
`pretext	N	"N"
`prevalence	N	"AJ(`prevalent)+NR41"
`prey	N-to-V	"N"
`price	N-to-V	"N"
`pricetag	N	"N"
`prickle	N-to-V	"N"
`pride	N-to-V	"N"
`priest	N	"N"
`prig	N	"N"
`primacy	N	"AJ(`prime)+NR40"
`primate	N	"N"
`prime	N	"N"
primo`genitor	N	"N"
primo`geniture	N	"N"
`primrose	N	"N"
`prince	N	"N"
`principle	N	"N"
`printmaker	N	"N(`print)+V(`make)+NR19"
`printmaking	N	"N(`print)+V(`make)+PRG"
`printout	N	"N"
`priory	N	"N"
`prism	N	"N"
`prison	N	"N"
`prisoner	N	"N(`prison)+NR19"
`privacy	N	"AJ(`private)+NR40"
`private	N	"N"
`privation	N	"N"
`privet	N	"N"
`privilege	N-to-V	"N"
`privy	N	"N"
`prize	N-to-V	"N"
`pro	N	"N"
`probabilist	N	"N"
`probate	N-to-V	"N"
pro`bation	N	"N"
`probity	N	"N"
`problem	N	"N"
pro`boscis	N	"N"
pro`cedure	N	"V(pro`ceed)+NR38"
pro`ceeding	N	"V(pro`ceed)+NR24"
`process	N-to-V	"N"
pro`cessional	N	"V(pro`cess)+NR23d+AJR17.NR0"
procla`mation	N	"V(pro`claim)+23"
pro`clivity	N	"N"
`proctor	N-to-V	"N"
`prodigy	N	"N"
`produce	N	"V(pro`duce).NR0"
`product	N	"N"
pro`duction	N	"V(pro`duce)+NR23"
produc`tivity	N	"V(pro`duce)+AJR26+NR21"
`prof	N	"N" ;professor
pro`fession	N	"V(pro`fess)+NR23"
pro`fessional	N	"V(pro`fess)+NR23+AJR17.NR0"
pro`fessor	N	"N"
pro`ficiency	N	"AJ(pro`ficient)+NR40"
`profile	N-to-V	"N"
`profit	N-to-V	"N"
profit`eering	N	"N(`profit)+NR10.VR0+PRG"
`profligacy	N	"AJ(`profligate)+NR40"
pro`fundity	N	"AJ(pro`found)+NR21"
pro`genitor	N	"N"
`progeny	N	"N"
prog`nosis	N	"N"
`program	N-to-V	"N"
`programme	N-to-V	"N" ;British
`progress	N	"V(pro`gress).NR0"
pro`gressive	N	"V(pro`gress)+AJR26.NR0"
`project	N	"N"
pro`jectile	N	"N"
prole`tariat	N	"N"
`prologue	N	"N"
pro`lusion	N	"N"
`prom	N	"N" ;promenade
`promenade	N-to-V	"N"
promis`cuity	N	"N"
`promise	N-to-V	"N"
`promontory	N	"N"
`promptitude	N	"N"
`prong	N	"N"
`pronoun	N	"N"
pronunci`ation	N	"V(pro`nounce)+NR23"
`proof	N	"N"
propa`ganda	N	"N"
propa`gandist	N	"N"
`propane	N	"N"
pro`pensity	N	"N"
`property	N	"N"
`prophecy	N	"N"
`prophet	N	"N"
pro`pinquity	N	"N"
pro`ponent	N	"N"
pro`portion	N-to-V	"N"
pro`prietor	N	"N"
pro`priety	N	"N"
pro`pulsion	N	"V(pro`pell)+NR23"
`propylene	N	"N"
pro`scription	N	"V(pro`scribe)+NR23"
`prose	N	"N"
`proselyte	N	"N"
`prosody	N	"N"
`prospect	N	"N"
pro`spectus	N	"N"
pros`perity	N	"V(`prosper)+NR21"
`prostate	N	"N"
`prostitute	N-to-V	"N"
pro`tagonist	N	"N"
pro`tectorate	N	"N"
`protege	N	"N"
`protegee	N	"N" ;female protege
`protein	N	"N"
`protest	N-to-V	"V(pro`test).NR0"
`protestant	N	"N"
`protocol	N	"N"
`proton	N	"N"
`prototype	N	"N"
proto`zoan	N	"N"
pro`trusion	N	"V(pro`trude)+NR23"
pro`tuberance	N	"AJ(pro`tuberant)+NR41"
`provenance	N	"N"
`proverb	N	"N"
`providence	N	"N"
`province	N	"N"
pro`vision	N-to-V	"V(pro`vide)+NR23"
provoca`teur	N	"N"
provo`cation	N	"V(pro`voke)+NR23"
`provost	N	"N"
`prow	N	"N"
`prowess	N	"N"
prox`imity	N	"N"
`proxy	N	"N"
`prude	N	"N"
`prudence	N	"AJ(`prudent)+NR41"
`prune	N	"N"
`prurience	N	"AJ(`prurient)+NR41"
`psalm	N	"N"
`psalter	N	"N"
`psaltery	N	"N"
`pseudonym	N	"N"
`psyche	N	"N"
`psycho	N	"N"
psychoa`nalysis	N	"N"
psycho`analyst	N	"N"
`psychopath	N	"N"
psycho`therapy	N	"N"
psycho`therapist	N	"N"
psy`chotic	N	"AJ(psy`chotic).NR0"
`ptarmigan	N	"N"
`pub	N	"N"
pu`bescence	N	"AJ(pu`bescent)+NR41"
`puberty	N	"N"
`publican	N	"N"
publi`cation	N	"V(`publish)+NR23"
`puck	N	"N"
`pudding	N	"N"
`puddle	N	"N"
`pueblo	N	"N"
`puffball	N	"N"
`puffery	N	"N"
`puffin	N	"N"
`pug	N	"N"
`pugilist	N	"N"
puis`sance	N	"AJ(puis`sant)+NR41"
`pulchritude	N	"N"
`pulley	N	"N"
`pullback	N	"N"
`pullet	N	"N"
`pullout	N	"N"
`pullover	N	"N"
`pulp	N	"N"
`pulpit	N	"N"
`pulsar	N	"N"
`puma	N	"N"
`pumice	N	"N"
`pumpkin	N	"N"
`pumpkinseed	N	"N"
`pun	N-to-V	"N"
`pundit	N	"N"
`punditry	N_Suffix1a	"N(`pundit)+NR3"
`pungency	N	"AJ(`pungent)+NR40"
`punk	N	"N"
`pup	N	"N"
`pupil	N	"N"
`puppet	N	"N"
`puppetry	N_Suffix1a	"N(`puppet)+NR3"
`puppy	N	"N"
pur`gation	N	"V(`purge)+NR23"
`purgatory	N	"V(`purge)+NR34"
`puritan	N	"N"
`purpose	N-to-V	"N"
`purse	N	"N"
`purslane	N	"N"
pur`suit	N	"N"
`purview	N	"N"
`pus	N	"N"
`pushbutton	N	"N"
`puss	N	"N"
`pussy	N	"N"
`pussycat	N	"N"
putre`faction	N	"AJ(`putrid)+VR5+NR23"
`putt	N-to-V	"N"
`putty	N-to-V	"N"
`puzzle	N-to-V	"N"
`pygmy	N	"N"
`pyramid	N	"N"
`pyre	N	"N"
`pyrite	N	"N"
pyro`mania	N	"N"
pyro`maniac	N	"N"
`pyrrhic	N-to-AJ	"N"
`python	N	"N"

`quack	N	"N" ;bad doctor
`quackery	N_Suffix1a	"N(`quack)+NR3"
`quad	N	"N"
`quadrangle	N	"N"
`quadrant	N	"N"
quadri`lateral	N-to-AJ	"N"
qua`drille	N	"N"
`quadruped	N	"N"
quad`ruplet	N	"N"
`quagmire	N	"N"
`quahog	N	"N"
qualifi`cation	N	"V(`qualify)+NR23"
`quality	N	"N"
`qualm	N	"N"
`quandary	N	"N"
quantifi`cation	N	"V(`quantify)+NR23"
`quantity	N	"N"
`quarantine	N-to-V	"N"
`quark	N	"N"
`quarry	N-to-V	"N"
`quart	N	"N"
`quarter	N-to-V	"N"
`quarterback	N	"N"
`quartermaster	N	"N"
quar`tet	N	"N"
`quartz	N	"N"
`quasar	N	"N"
`quatrain	N	"N"
`quay	N	"N"
`queen	N	"N"
`query	N-to-V	"N"
`quest	N-to-V	"N"
`question	N-to-V	"N"
question`naire	N	"N"
`queue	N-to-V	"N" ;see verb.lex for verb forms
`quicklime	N	"N"
`quicksand	N	"N"
`quicksilver	N	"N"
`quickstep	N	"N"
`quid	N	"N"
qui`escence	N	"AJ(qui`escent)+NR41"
`quietude	N	"N"
qui`etus	N	"N"
`quill	N	"N"
`quilt	N-to-V	"N"
`quilting	N	"N(`quilt)+NR7"
`quince	N	"N"
`quinine	N	"N"
`quint	N	"N"
quin`tessence	N	"N"
quin`tet	N	"N"
quin`tuplet	N	"N"
`quip	N-to-V	"N"
`quirk	N	"N"
`quod	N	"N"
`quonset	N	"N"
`quorum	N	"N"
`quota	N	"N"
`quotient	N	"N"

`rabbi	N	"N"
`rabbit	N	"N"
`rabble	N	"N"
`rabies	N	"N"
rac`coon	N	"N"
ra`coon	N	"N"
`race	N-to-V	"N"
`racetrack	N	"N"
`raceway	N	"N"
`rack	N	"N"
`racket	N	"N"
racon`teur	N	"N"
`radar	N	"N"
`radian	N	"N"
`radiance	N	"N"
`radio	N-to-V	"N"
radio`telegraph	N	"N"
radio`telephone	N	"N"
`radish	N	"N"
`radium	N	"N"
`radon	N	"N"
`raffle	N-to-V	"N"
`raft	N-to-V	"N"
`rag	N	"N"
`ragamuffin	N	"N"
`rage	N-to-V	"N"
ra`gout	N	"N"
`ragweed	N	"N"
`raid	N-to-V	"N"
`rail	N	"N"
`railbird	N	"N"
`railhead	N	"N"
`railing	N	"N(`rail)+NR7"
`raillery	N	"N"
`railroad	N-to-V	"N"
`railway	N	"N"
`raiment	N	"N"
`rain	N-to-V	"N"
`rainbow	N	"N"
`raincoat	N	"N"
`raindrop	N	"N"
`rainfall	N	"N"
`rainstorm	N	"N"
`raisin	N	"N"
`raj	N	"N"
`rajah	N	"N"
`rake	N-to-V	"N"
`ram	N	"N"
ramifi`cation	N	"V(`ramify)+NR23"
`ramp	N	"N"
`rampage	N-to-V	"N"
`rampart	N	"N"
`ramrod	N	"N"
`ranch	N-to-V	"N"
`rancho	N	"N"
`rancor	N	"N"
`rancour	N	"N" ;British
`range	N-to-V	"N"
`rangeland	N	"N"
`ranking	N	"V(`rank)+NR24"
`ransom	N-to-V	"N"
`rapier	N	"N"
rap`port	N	"N"
rapproche`ment	N	"N"
rap`scallion	N	"N"
`raptor	N	"N"
`rapture	N-to-V	"N"
`rascal	N	"N"
`rash	N	"N"
`raspberry	N	"N"
`raster	N	"N"
`rat	N	"N"
`ratchet	N-to-V	"N"
`ratepayer	N	"N"
`rating	N	"V(`rate)+NR24"
`ration	N-to-V	"N"
ratio`nale	N	"N"
`rattail	N	"N"
`rattlesnake	N	"N"
`raven	N	"N"
ra`vine	N	"N"
`rawhide	N	"N"
`ray	N	"N"
`razor	N	"N"
`razorback	N	"N"
razzle-`dazzle	N-to-AJ	"N"
`reading	N	"V(`read)+NR24"
`readout	N	"N"
`realm	N	"N"
`realtor	N	"N"
`realty	N	"N"
`ream	N	"N"
`rear	N	"N"
`reason	N-to-V	"N"
`rebel	N	"V(re`bel).NR0"
re`calcitrance	N	"AJ(re`calcitrant)+NR41"
re`calcitrancy	N	"AJ(re`calcitrant)+NR40"
re`ceipt	N	"N"
re`ceptacle	N	"N"
re`ception	N	"V(re`ceive)+NR23"
re`ceptor	N	"V(re`ceive)+NR20"
re`cessional	N	"V(re`cess)+NR23+AJR17.NR0"
re`cidivism	N	"N"
re`cidivist	N-to-AJ	"N"
`recipe	N	"N"
re`cipient	N	"V(re`ceive)+NR17"
reci`procity	N	"N"
recita`tive	N	"N"
recla`mation	N	"ORD5+V(`claim)+NR23"
re`connaissance	N	"N"
`record	N	"V(re`cord).NR0"
re`cording	N	"V(re`cord)+NR24"
re`covery	N	"V(re`cover)+NR35"
`rectangle	N	"N"
rectifi`cation	N	"N"
`rectitude	N	"N"
`rector	N	"N"
`rectory	N	"N"
`redbird	N	"N"
`redbud	N	"N"
`redcoat	N	"N"
re`demption	N	"V(re`deem+NR23"
`redhead	N	"N"
`redneck	N	"N"
`redskin	N	"N"
re`duction	N	"V(re`duce+NR23"
re`dundance	N	"AJ(re`dundant)+NR41"
re`dundancy	N	"AJ(re`dundant)+NR40"
`redwood	N	"N"
`reed	N	"N"
`reef	N	"N"
`reel	N-to-V	"N"
re`fectory	N	"V(re`fect)+NR34"
`reference	N-to-V	"V(re`fer)+NR26"
`referent	N	"V(re`fer)+NR17"
`refill	N	"ORD5+V(`fill).NR0"
re`finery	N_Suffix1a	"V(re`fine)+NR3"
`refit	N	"ORD5+V(`fit).NR0"
`reflex	N	"N"
re`formatory	N	"V(re`form)+NR34"
re`frain	N	"N"
re`frigerant	N	"V(re`frigerate)+NR17"
`refuge	N-to-V	"N"
re`fulgence	N	"AJ(re`fulgent)+NR41"
`refund	N	"V(re`fund).NR0"
re`gatta	N	"N"
`regency	N	"N"
`regent	N	"N"
re`gime	N	"N"
`regimen	N	"N"
`regiment	N-to-V	"N"
`region	N	"N"
`register	N-to-V	"N"
`registrant	N	"V(`register)+NR17"
`registrar	N	"V(`register)+NR20?"
regis`tration	N	"V(`register)+NR23"
`registry	N	"V(`register)+NR35"
`regress	N	"V(re`gress).NR0"
`reject	N	"V(re`ject).NR0"
`rein	N-to-V	"N"
re`joinder	N	"N"
`relative	N	"V(re`late)+AJR26.NR0"
`relay	N	"V(re`lay).NR0"
`relevance	N	"AJ(`relevant)+NR41"
`relevancy	N	"AJ(`relevant)+NR40"
`relic	N	"N"
`relict	N	"N"
re`lief	N	"N"
re`ligion	N	"N"
religi`osity	N	"N"
re`liquary	N	"N"
`relish	N	"N"
re`luctance	N	"AJ(re`luctant)+NR41"
re`luctancy	N	"AJ(re`luctant)+NR40"
re`mainder	N	"N"
`remedy	N-to-V	"N"
re`membrance	N	"V(re`member)+NR26"
`remnant	N	"N"
re`monstrance	N	"V(re`monstrate)+NR26"
re`morse	N	"N"
renais`sance	N	"N"
`rendering	N	"V(`render)+NR24"
ren`dition	N	"V(`render)+NR23"
`renegade	N	"N"
re`nown	N-to-V	"N"
renunci`ation	N	"V(re`nounce)+NR23"
`rep	N	"N" ;representative
repa`ration	N	"V(re`pair)+NR23"
repar`tee	N	"N"
`repast	N	"N"
`repertoire	N	"N"
`repertory	N	"N"
repe`tition	N	"V(re`peat)+NR23"
`replica	N	"N"
re`port	N-to-V	"N"
repository	N	"N"
repre`hension	N	"V(repre`hend)+NR23"
`reptile	N	"N"
re`public	N	"N"
re`pugnance	N	"AJ(re`pugnant)+NR41"
re`pugnancy	N	"AJ(re`pugnant)+NR40"
`requiem	N	"N"
requi`sition	N-to-V	"N"
re`serpine	N	"N"
re`serve	N	"N"
`reservoir	N	"N"
`resident	N-to-AJ	"V(re`side)+NR17"
`residue	N	"N"
re`sidual	N	"N(`residue)+AJR17.NR0"
re`silience	N	"V(re`sile)+AJR27+NR41"
re`siliency	N	"V(re`sile)+AJR27+NR40"
`resin	N	"N"
reso`lution	N	"V(re`solve)+NR23"
re`solve	N	"N"
`resonance	N	"AJ(`resonant)+NR41"
re`sorcinol	N	"N"
re`sort	N	"N"
`respirator	N	"V(re`spire)+NR20"
re`splendence	N	"AJ(re`splendent)+NR41"
re`spondent	N	"V(re`spond)+NR17"
re`sponse	N	"N"
responsi`bility	N	"AJ(re`sponsible)+NR21"
`restaurant	N	"N"
restauran`teur	N	"N"
restaura`teur	N	"N"
re`straint	N	"N"
`restroom	N	"N"
`resume	N	"N"
re`sumption	N	"V(re`sume)+NR23"
re`tention	N	"V(re`tain)+NR23"
`reticence	N	"AJ(`reticent)+NR41"
re`ticulum	N	"N"
`retina	N	"N"
`retinue	N	"N"
retri`bution	N	"N"
;`retrorocket	N	"N"
retro`version	N	"N"
reve`lation	N	"V(re`veal)+NR23"
`revelry	N_Suffix1a	"V(`revel)+NR3"
re`venge	N	"N"
`revenue	N	"N"
`revenuer	N	"N(`revenue)+NR11"
`reverie	N	"N"
revoca`bility	AJ	"V(re`voke)+AJR25+NR21"
revo`cation	AJ	"V(re`voke)+NR23"
revo`lution	N	"V(re`volve)+NR23"
re`vue	N	"N"
re`vulsion	N	"N"
`rhapsody	N	"N"
`rheostat	N	"N"
`rhesus	N	"N"
`rhetoric	N	"N"
`rheum	N	"N"
`rheumatism	N	"N"
`rhinestone	N	"N"
`rhino	N	"N"
rhodo`dendron	N	"N"
`rhubarb	N	"N"
`rhythm	N	"N"
`rib	N	"N"
`ribbon	N	"N"
`riboflavin	N	"N"
`rice	N	"N"
`rick	N	"N"
`rickets	N	"N"
`rickshaw	N	"N"
`riddle	N	"N"
`ridge	N	"N"
`ridgepole	N	"N"
`riffraff	N	"N"
`rifle	N	"N"
`rift	N	"N"
`rig	N-to-V	"N"
`rigging	N	"N(`rig)+NR7"
`rigmarole	N	"N"
`rigor	N	"N"
`rigour	N	"N" ;British
`rill	N	"N"
`rim	N-to-V	"N"
`rime	N	"N"
`rind	N	"N"
`ring	N	"N"
`ringleader	N	"N"
`ringmaster	N	"N"
`ringside	N	"N"
`rink	N	"N"
`riot	N-to-V	"N"
`ripoff	N	"N"
`risk	N-to-V	"N"
`rite	N	"N"
`ritual	N	"N"
`rival	N-to-V	"N"
`rivalry	N_Suffix1a	"N(`rival)+NR3"
`river	N	"N"
`riverbank	N	"N"
`riverbed	N	"N"
`riverfront	N	"N"
`riverside	N	"N"
`rivet	N-to-V	"N"
`rivulet	N	"N"
`roach	N	"N"
`road	N	"N"
`roadbed	N	"N"
`roadblock	N	"N"
`roadhouse	N	"N"
`roadside	N	"N"
`roadway	N	"N"
`robbery	N_Suffix1a	"V(`rob)+NR3"
`robe	N-to-V	"N"
`robin	N	"N"
`robot	N	"N"
`rock	N	"N"
`rocket	N-to-V	"N"
`rocketry	N_Suffix1a	"N(`rocket)+NR3"
`rod	N	"N"
`rodent	N	"N"
`rodeo	N	"N"
`roe	N	"N"
`roebuck	N	"N"
`rogue	N	"N"
`role	N	"N"
`rollback	N	"N"
`romance	N-to-V	"N"
ro`mantic	N	"AJ(ro`mantic).NR0"
`rondo	N	"N"
`rood	N	"N"
`roof	N-to-V	"N"
`roofing	N	"N(`roof)+NR7"
`rooftop	N	"N"
`rook	N	"N"
`rookie	N	"N"
`rooky	N	"N"
`room	N-to-V	"N"
`roomful	N_Suffix1a	"N(`room)+NR5"
`roommate	N	"N"
`root	N-to-V	"N"
`rope	N-to-V	"N"
`rosary	N	"N"
`rose	N	"N"
`rosebud	N	"N"
`rosebush	N	"N"
`rosemary	N	"N"
ro`sette	N	"N"
`rosin	N	"N"
`roster	N	"N"
`rotary	N	"N"
`rote	N	"N"
rotogra`vure	N	"N"
`rotor	N	"N"
ro`tunda	N	"N"
ro`uge	N	"N"
`roughage	N_Suffix1a	"AJ(`rough)+NR1"
`roughneck	N	"N"
rou`lette	N	"N"
`round	N	"N"
`roundhouse	N	"N"
`roundtable	N	"N"
`roundup	N	"N"
`roundworm	N	"N"
`roustabout	N	"N"
`route	N	"N"
rou`tine	N	"N"
`row	N	"N(`row1)" ;[row]
`row	N	"N(`row2)" ;[raw]
`rowboat	N	"N"
`royalty	N	"AJ(`royal)+AJR26"
`rubber	N	"N"
`rubbish	N	"N"
`rubble	N	"N"
`rubdown	N	"N"
`ruble	N	"N"
`rubric	N	"N"
`ruby	N	"N"
`ruckus	N	"N"
`rudder	N	"N"
`rudiment	N	"N"
`ruff	N	"N"
`ruffian	N	"N"
`rug	N	"N"
`ruling	N	"V(`rule)+NR24"
`rum	N	"N"
`rumen	N	"N"
`ruminant	N	"N"
`rummy	N	"N"
`rumor	N-to-V	"N"
`rumour	N-to-V	"N" ;British
`rump	N	"N"
`rumpus	N	"N"
`runabout	N	"N"
`runaway	N	"N"
`rundown	N	"N"
`rune	N	"N"
`rung	N	"N"
`runoff	N	"N"
`runt	N	"N"
`runway	N	"N"
`rupee	N	"N"
`ruse	N	"N"
`rusk	N	"N"
`russet	N	"N"
`rust	N-to-V	"N"
`rut	N-to-V	"N"
`rutabaga	N	"N"
`rye	N	"N"

`sabbath	N	"N"
sab`batical	N	"N"
`saber	N-to-V	"N"
`sabre	N-to-V	"N"
`sable	N	"N"
`sabotage	N-to-V	"N"
sabo`teur	N	"N"
`sabra	N	"N"
`sac	N	"N"
`saccharin	N	"N"
sa`chet	N	"N"
`sack	N	"N"
`sackcloth	N	"N"
`sackful	N_Suffix1a	"N(`sack)+NR5"
`sacrament	N	"N"
`sacrifice	N-to-V	"N"
`sacrilege	N	"N"
`saddle	N-to-V	"N"
`saddlebag	N	"N"
`sadism	N	"N"
`sadist	N	"N"
sado`masochism	N	"N"
sado`masochist	N	"N"
sa`fari	N-to-V	"N"
`safe	N	"N"
`safeguard	N-to-V	"N"
safe`keeping	N	"N"
`safety	N	"AJ(`safe)+AJR26"
`safflower	N	"N"
`saffron	N	"N"
`saga	N	"N"
sa`gacity	N	"N"
`sage	N	"N"
`sagebrush	N	"N"
`sago	N	"N"
sa`guaro	N	"N"
`sail	N	"N"
`sailboat	N	"N"
`sailfish	N	"N"
`saint	N-to-V	"N"
`sake	N	"N"
sala`bility	N	"AJ(`salable)+NR21"
`salad	N	"N"
`salamander	N	"N"
sa`lami	N	"N"
`salary	N	"N"
`sale	N	"N"
`salesgirl	N	"N"
`saleslady	N	"N"
`salesperson	N	"N"
`salience	N	"AJ(`salient)+NR41"
`saliency	N	"AJ(`salient)+NR40"
sa`liva	N	"N"
`sally	N-to-V	"N"
`salmon	N	"N"
sa`lon	N	"N"
sa`loon	N	"N"
sa`loonkeeper	N	"N"
`salsify	N	"N"
`salt	N-to-V	"N"
`saltbush	N	"N"
sal`vation	N	"N"
`salve	N-to-V	"N"
`salver	N	"N"
`samba	N	"N"
`samovar	N	"N"
`sample	N-to-V	"N"
sanctifi`cation	N	"V(`sanctify)+NR23"
`sanctimony	N	"N"
`sanction	N-to-V	"N"
`sanctity	N	"N"
`sanctuary	N	"N"
`sand	N	"N"
`sandal	N	"N"
`sandalwood	N	"N"
`sandbag	N-to-V	"N"
`sandblast	N-to-V	"N"
`sandman	N	"N"
`sandpaper	N	"N"
`sandpile	N	"N"
`sandpiper	N	"N"
`sandstone	N	"N"
`sandwich	N	"N"
sanga`ree	N	"N"
`sap	N	"N"
`sapling	N	"N"
`sapphire	N	"N"
`sapsucker	N	"N"
`sarcasm	N	"N"
sar`dine	N	"N"
`sari	N	"N"
sa`rong	N	"N"
sarsapa`rilla	N	"N"
`sash	N	"N"
`sassafras	N	"N"
`satchel	N	"N"
`satellite	N	"N"
`satiety	N	"N"
`satin	N	"N"
`satire	N	"N"
satis`faction	N	"V(`satisfy)+NR23"
`satyr	N	"N"
`sauce	N	"N"
`saucer	N	"N"
`saucepan	N	"N"
`sauerkraut	N	"N"
`sauna	N	"N"
`sausage	N	"N"
sau`terne	N	"N"
`savagery	N_Suffix1a	"AJ(`savage)+NR3"
sa`vanna	N	"N"
sa`vant	N	"N"
`saving	N	"V(`save)+NR24"
`savior	N	"N"
`saviour	N	"N" ;British
`savor	N-to-V	"N"
`savour	N-to-V	"N"
sa`voy	N	"N"
`saw	N-to-V	"N"
`sawdust	N	"N"
`sawfish	N	"N"
`sawfly	N	"N"
`sawmill	N	"N"
`sawtimber	N	"N"
`sawyer	N	"N(`saw).VR0+NR19"
`saying	N	"V(`say)+NR24"
`sax	N	"N"
`saxophone	N	"N"
`scab	N	"N"
`scabbard	N	"N"
`scad	N	"N"
`scaffold	N	"N"
`scaffolding	N	"N(`scaffold)+NR7"
`scale	N	"N"
`scallion	N	"N"
`scallop	N-to-V	"N"
`scalp	N-to-V	"N"
`scalpel	N	"N"
`scam	N	"N"
`scamp	N	"N"
`scandal	N	"N"
`scapegoat	N	"N"
`scapular	N-to-AJ	"N"
`scar	N-to-V	"N"
`scarecrow	N	"N"
`scarface	N	"N"
`scat	N	"N"
`scatterbrain	N	"N"
`scattergun	N	"N"
sce`nario	N	"N"
`scene	N	"N"
`scenery	N_Suffix1a	"N(`scene)+NR3"
`scent	N-to-V	"N"
`scepter	N-to-V	"N"
`sceptre	N-to-V	"N" ;British
`sceptic	N	"N"
`schedule	N-to-V	"N"
sche`matic	N	"AJ(sche`matic).NR0"
`scheme	N-to-V	"N"
`schism	N	"N"
`schist	N	"N"
`schizophrenia	N	"N"
schizo`phrenic	N	"AJ(schizo`phrenic).NR0"
`schnapps	N	"N"
scho`lastic	N	"AJ(scho`lastic).NR0"
scholar	N	"N"
`school	N-to-V	"N"
`schoolbook	N	"N"
`schoolboy	N	"N"
`schoolgirl	N	"N"
`schoolhouse	N	"N"
`schoolmarm	N	"N"
`schoolmaster	N	"N"
`schoolmate	N	"N"
`schoolroom	N	"N"
`schoolteacher	N	"N"
`schoolwork	N	"N"
`schooner	N	"N"
sci`atica	N	"N"
`science	N	"N"
`scientist	N	"N"
`scimitar	N	"N"
`scion	N	"N"
`sclera	N	"N"
scle`rosis	N	"N"
`scoop	N-to-V	"N"
`scoopful	N_Suffix1a	"N(`scoop)+NR5"
`sconce	N	"N"
`scone	N	"N"
`scope	N	"N"
`score	N-to-V	"N"
`scoreboard	N	"N"
`scorecard	N	"N"
`scorn	N-to-V	"N"
`scorpion	N	"N"
`scotch	N	"N"
`scoundrel	N	"N"
`scourge	N-to-V	"N"
`scrap	N-to-V	"N"
`scrapbook	N	"N"
`screed	N	"N"
`screen	N-to-V	"N"
`screenplay	N	"N"
`screw	N-to-V	"N"
`screwball	N	"N"
`screwdriver	N	"N"
`scribe	N	"N"
`scrim	N	"N"
`scrimmage	N-to-V	"N"
`script	N-to-V	"N"
`scripture	N	"N"
`scrivener	N	"N"
`scroll	N-to-V	"N"
`scrooge	N	"N"
`scruple	N	"N"
`scrupulosity	N	"N(`scruple)+AJR21+NR21"
`scrutiny	N	"N"
`scuba	N	"N"
`scull	N-to-V	"N"
`sculpin	N	"N"
`sculpture	N-to-V	"N"
`scum	N	"N"
`scurvy	N	"N"
`scythe	N	"N"
`sea	N	"N"
`seaboard	N	"N"
`seacoast	N	"N"
`seafarer	N	"N"
`seafood	N	"N"
`seagull	N	"N"
`seahorse	N	"N"
`seal	N	"N"
`seam	N	"N"
`seamstress	N_Suffix1a	"N(`seam)+NR16+NR12"
`seance	N	"N"
`seaport	N	"N"
`seaquake	N	"N"
`searchlight	N	"N"
`seashore	N	"N"
`seaside	N	"N"
`season	N	"N"
`seasoning	N	"V(`season)+NR24"
`seat	N-to-V	"N"
`seawall	N	"N"
`seaweed	N	"N"
`secant	N	"N"
se`cession	N	"V(se`cede)+NR23"
se`clusion	N	"V(se`clude)+NR23"
`second	N	"N"
`secrecy	N	"N(`secret)+NR40"
`secret	N-to-AJ	"N"
secre`tariat	N	"N"
`secretary	N	"N"
`sect	N	"N"
`section	N-to-V	"N"
`sector	N	"N"
se`dan	N	"N"
`sedative	N	"AJ.VR0+AJR26.NR0"
`seder	N	"N"
`sedge	N	"N"
`sediment	N-to-V	"N"
se`dition	N	"N"
se`duction	N	"V(se`duce)+NR23"
`seed	N-to-V	"N"
`seedbed	N	"N"
`seepage	N_Suffix1a	"V(`seep)+NR1"
`seersucker	N	"N"
`segment	N-to-V	"N"
`segregant	N	"N"
`seismograph	N	"N"
seis`mography	N	"N"
`seizure	N	"V(`seize)+NR38"
se`lenium	N	"N"
`self	N	"N"
`sellout	N	"N"
`seltzer	N	"N"
`semaphore	N	"N"
`semblance	N	"N"
se`mester	N	"N"
`semi	N	"N"
`seminar	N	"N"
`seminary	N	"N"
`semite	N	"N"
`senate	N	"N"
`senator	N	"N"
`senior	N-to-AJ	"N"
se`nor	N	"N"
senor`ita	N	"N"
`sense	N-to-V	"N"
`sentence	N-to-V	"N"
`sentiment	N	"N"
`sentinel	N	"N"
`sentry	N	"N"
`sepal	N	"N"
separa`bility	AJ	"AJ(`separate).VR0+AJR25+NR21"
sep`tet	N	"N"
septuagen`arian	N	"N"
`sepulcher	N	"N"
`sepulchre	N	"N"
`sequel	N	"N"
`sequence	N-to-V	"N"
seques`tration	N	"V(se`quester)+NR23"
`sequin	N	"N"
se`rape	N	"N"
sere`nade	N-to-V	"N"
seren`dipity	N	"N"
`serf	N	"N"
`serge	N	"N"
`sergeant	N	"N"
`serif	N	"N"
`sermon	N	"N"
`serpent	N	"N"
;`servant	N	"N"
`service	N-to-V	"N"
servi`ette	N	"N"
`serving	N	"V(`serve)+NR24"
`servitor	N	"N"
`servitude	N	"N"
`servomechanism	N	"N"
`servomotor	N	"N"
`sesame	N	"N"
`session	N	"N"
`set	N	"N"
`setback	N	"N"
`setscrew	N	"N"
`setting	N	"V(`set)+NR24"
`setup	N	"N"
`sewage	N	"N"
`sewer	N	"N"
`sewerage	N_Suffix1a	"N(`sewer)+NR1"
`sex	N-to-V	"N"
sex`tet	N	"N"
`sexton	N	"N"
sex`tuple	N	"N"
sex`tuplet	N	"N"
`shack	N	"N"
`shackle	N-to-V	"N"
`shad	N	"N"
`shade	N-to-V	"N"
`shadow	N-to-V	"N"
`shaft	N	"N"
`shag	N	"N"
`shah	N	"N"
`shakedown	N	"N"
`shale	N	"N"
`shallot	N	"N"
`sham	N	"N"
`shaman	N	"N"
`shame	N-to-V	"N"
sham`poo	N-to-V	"N"
`shamrock	N	"N"
`shank	N-to-V	"N"
`shanty	N	"N"
`shape	N-to-V	"N"
`shard	N	"N"
`share	N-to-V	"N"
`shareholder	N	"N"
`shareware	N	"N"
`shark	N	"N"
`sharecroper	N	"N"
`sharpshooter	N	"N"
`shaving	N	"V(`shave)+NR24"
`shawl	N	"N"
`sheath	N	"N"
`shed	N	"N"
`sheen	N	"N"
`sheepfold	N	"N"
`sheepskin	N	"N"
`sheet	N	"N"
`sheik	N	"N"
`sheikh	N	"N"
`shekel	N	"N"
`shelfful	N_Suffix1a	"N(`shelf)+NR5"
`shell	N-to-V	"N"
shel`lac	N-to-V	"N" ;see verb.lex for verb forms
`shelter	N-to-V	"N"
`shelving	N	"N(`shelf)+NR7"
she`nanigan	N	"N"
`shepherd	N-to-V	"N"
`sherbet	N	"N"
`sheriff	N	"N"
`sherry	N	"N"
`shibboleth	N	"N"
`shield	N-to-V	"N"
`shilling	N	"N"
`shim	N	"N"
`shin	N	"N"
`shinbone	N	"N"
`shingle	N-to-V	"N"
`ship	N-to-V	"N"
`shipbuilder	N	"N(`ship)+V(`build)+NR19"
`shipbuilding	N	"N(`ship)+V(`build)+PRG"
`shipmate	N	"N"
`shipwreck	N-to-V	"N"
`shipyard	N	"N"
`shire	N	"N"
`shirt	N	"N"
shle`miel	N	"N"
`shoal	N	"N"
`shoat	N	"N"
`shock	N-to-V	"N"
`shoe	N-to-V	"N"
`shoehorn	N	"N"
`shoelace	N	"N"
`shoestring	N	"N"
`shoemaker	N	"N(`shoe)+V(`make)+NR19"
`shoofly	N	"N"
`shootout	N	"N"
`shop	N-to-V	"N"
`shopkeeper	N	"N(`shop)+V(`keep)+NR19"
`shoptalk	N	"N(`shop)+V(`keep)+NR19"
`shore	N	"N"
`shoreline	N	"N"
`shortage	N_Suffix1a	"AJ(`short)+NR1"
`shortcoming	N	"N"
`shortcut	N	"N"
`shortfall	N	"N"
`shorthand	N	"N"
`shortstop	N	"N"
`shot	N	"N"
`shotgun	N	"N"
`shoulder	N-to-V	"N"
`shovel	N-to-V	"N"
`shovelful	N_Suffix1a	"N(`shovel)+NR5"
`show	N	"N"
`showboat	N	"N"
`showcase	N	"N"
`showdown	N	"N"
`shower	N-to-V	"N"
`showpiece	N	"N"
`showplace	N	"N"
`showroom	N	"N"
`shrapnel	N	"N"
`shrew	N	"N"
`shrift	N	"N"
`shrike	N	"N"
`shrine	N	"N"
;`shrinkage	N_Suffix1a	"V(`shrink)+NR1"
`shroud	N-to-V	"N"
`shrub	N	"N"
`shrubbery	N_Suffix1a	"N(`shrub)+NR3"
`shuffleboard	N	"N"
`shutdown	N	"N"
`shutoff	N	"N"
`shutout	N	"N"
`shutter	N-to-V	"N"
`shuttle	N-to-V	"N"
`shuttlecock	N	"N"
`sib	N	"N"
`sibling	N	"N"
`sibyl	N	"N"
`sickle	N	"N"
`sickroom	N	"N"
`side	N-to-V	"N"
`sideband	N	"N"
`sideboard	N	"N"
`sideburn	N	"N"
`sidecar	N	"N"
`sidelight	N	"N"
`sideline	N	"N"
`sidesaddle	N	"N"
`sideshow	N	"N"
`sidetrack	N-to-V	"N"
`sidewalk	N	"N"
`sidewall	N	"N"
`sidewinder	N	"N"
`siding	N	"N(`side)+NR7"
`siege	N	"N"
si`enna	N	"N"
si`erra	N	"N"
si`esta	N	"N"
`sieve	N-to-V	"N"
`sight	N-to-V	"N"
`sightseer	N	"N(`sight)+V(`see)+NR19"
`sightseeing	N	"N(`sight)+V(`see)+PRG"
`sign	N-to-V	"N"
`signal	N-to-V	"N"
`signatory	N	"N"
`signature	N	"V(`sign)+NR38"
`signboard	N	"N"
`signet	N	"N"
sig`nificance	N	"AJ(sig`nificant)+NR41"
`signpost	N	"N"
`sikh	N	"N"
`silage	N_Suffix1a	"N(`silo)+NR1"
`silence	N-to-V	"AJ(`silent)+NR41"
silhou`ette	N-to-V	"N"
`silica	N	"N"
`silicon	N	"N"
`silicone	N	"N"
`silk	N	"N"
`silkworm	N	"N"
`sill	N	"N"
`silo	N	"N"
`silt	N-to-V	"N"
`silver	N-to-V	"N"
`silversmith	N	"N"
`silverware	N	"N"
`simile	N	"N"
si`militude	N	"N"
simpleton	N	"N"
`simplicity	N	"N"
simultan`eity	N	"N"
`sin	N-to-V	"N"
`sine	N	"N"
`sinecure	N	"N"
`sinew	N	"N"
`singlet	N	"N"
`singleton	N	"N"
`singsong	N	"N"
`sinkhole	N	"N"
`sinter	N	"N"
`sinus	N	"N"
`siphon	N-to-V	"N"
`sir	N	"N"
`sire	N-to-V	"N"
`siren	N	"N"
`sirloin	N	"N"
`sis	N	"N"
`sisal	N	"N"
`siskin	N	"N"
`sister	N	"N"
`sitcom	N	"N" ;situation comedy
`site	N	"N"
`sixgun	N	"N"
`size	N-to-V	"N"
`skat	N	"N"
`skate	N-to-V	"N"
`skeet	N	"N"
`skeleton	N	"N"
`skeptic	N	"N"
`sketch	N-to-V	"N"
`sketchbook	N	"N"
`sketchpad	N	"N"
`skewer	N-to-V	"N"
`ski	N-to-V	"N"
`skiff	N	"N"
`skill	N	"N"
`skillet	N	"N"
`skin	N-to-V	"N"
`skinhead	N	"N"
`skinful	N_Suffix1a	"N(`skin)+NR5"
`skipjack	N	"N"
`skirmish	N-to-V	"N"
`skirt	N-to-V	"N"
`skit	N	"N"
`skull	N	"N"
`skullcap	N	"N"
`skullduggery	N	"N"
`skunk	N	"N"
`sky	N	"N"
`skydiver	N	"N(`sky)+V(`dive)+NR19"
`skydiving	N	"N(`sky)+V(`dive)+PRG"
`skyhook	N	"N"
`skylark	N	"N"
`skylight	N	"N"
`skyline	N	"N"
`skyrocket	N-to-V	"N"
`skyscraper	N	"N"
`skyway	N	"N"
`slab	N	"N"
`slag	N	"N"
`slander	N-to-V	"N"
`slang	N	"N"
`slant	N-to-V	"N"
`slapstick	N	"N"
`slat	N	"N"
`slate	N	"N"
`slattern	N	"N"
`slaughterhouse	N	"N"
`slave	N-to-V	"N"
`slavery	N_Suffix1a	"N(`slave)+NR3"
`sleaze	N	"N"
`sled	N	"N"
`sledge	N	"N"
`sledgehammer	N	"N"
`sleet	N-to-V	"N"
`sleeve	N	"N"
`sleigh	N	"N"
`sleight	N	"N"
`sleuth	N	"N"
`slime	N	"N"
`sling	N	"N"
`slingshot	N	"N"
`sliver	N	"N"
`slob	N	"N"
`sloe	N	"N"
`slogan	N	"N"
`sloop	N	"N"
`slope	N-to-V	"N"
`slot	N	"N"
`sloth	N	"N"
`slough	N	"N"
`sloven	N	"N"
`slowdown	N	"N"
`sludge	N	"N"
`slug	N	"N"
`sluggard	N	"N"
`sluice	N	"N"
`slum	N	"N"
`slurry	N	"N"
`slush	N	"N"
`slut	N	"N"
`smallpox	N	"N"
`smith	N	"N"
`smithy	N	"N"
`smock	N	"N"
`smog	N	"N"
`smoke	N-to-V	"N"
`smokehouse	N	"N"
`smokescreen	N	"N"
`smokestack	N	"N"
`smudge	N-to-V	"N"
`smut	N	"N"
`snack	N-to-V	"N"
`snafu	N	"N"
`snag	N-to-V	"N"
`snail	N	"N"
`snake	N-to-V	"N"
`snapback	N	"N"
`snapdragon	N	"N"
`snapshot	N	"N"
`snare	N-to-V	"N"
`snark	N	"N"
`snell	N	"N"
`snifter	N	"N"
`snippet	N	"N"
`snob	N	"N"
`snobbery	N_Suffix1a	"N(`snob)+NR3"
`snook	N	"N"
`snorkel	N	"N"
`snot	N	"N"
`snout	N	"N"
`snow	N-to-V	"N"
`snowball	N	"N"
`snowdrop	N	"N"
`snowfall	N	"N"
`snowflake	N	"N"
`snowmobile	N	"N"
`snowshoe	N	"N"
`snowstorm	N	"N"
`soap	N-to-V	"N"
`soapstone	N	"N"
`soapsuds	N	"N"
so`briety	N	"AJ(`sober)+NR21"
`sobriquet	N	"N"
`soccer	N	"N"
socia`bility	N	"AJ(`sociable)+NR21"
`socialite	N_Suffix1a	"AJ(`social)+NR32"
so`ciety	N	"N"
`sociopath	N	"N"
`sock	N	"N"
`socket	N	"N"
`sod	N	"N"
`soda	N	"N"
`sodium	N	"N"
`sodomy	N	"N"
`sofa	N	"N"
`soffit	N	"N"
`softball	N	"N"
`software	N	"N"
`softwood	N	"N"
`soil	N-to-V	"N"
soi`ree	N	"N"
`sojourn	N-to-V	"N"
`solace	N	"N"
`solder	N-to-V	"N"
`soldier	N	"N"
`soldiery	N_Suffix1a	"N(`soldier)+NR3"
`sole	N-to-V	"N"
`solecism	N	"N"
`solenoid	N	"N"
so`licitude	N	"N"
soli`darity	N	"N"
`solipsism	N	"N"
`solitaire	N	"N"
`solitude	N	"N"
`solo	N-to-V	"N"
`solstice	N	"N"
solu`bility	N	"(`soluble)+NR21"
`solute	N	"N"
so`lution	N	"N"
`solvate	N	"N"
`solvency	N	"AJ(`solvent)+NR40"
`solvent	N	"N"
`somersault	N-to-V	"N"
`somnolence	N	"AJ(`somnolent)+NR41"
`son	N	"N"
`sonar	N	"N"
so`nata	N	"N"
`song	N	"N"
`songbook	N	"N"
`sonnet	N	"N"
`sonny	N	"N(`son)+NR33"
`sonogram	N	"N"
so`nority	N	"N"
`soot	N	"N"
`sop	N	"N"
`sophism	N	"N"
`sophist	N	"N"
`sophistry	N_Suffix1a	"N(`sophist)+NR3"
`sophomore	N	"N"
so`prano	N	"N"
`sorcerer	N	"N(`sorcery)+NR19"
`sorceress	N_Suffix1a	"N(`sorcery)+NR12"
`sorcery	N	"N"
`sorghum	N	"N"
so`rority	N	"N"
`sorption	N	"V(`sorb)+NR23"
`sorrel	N	"N"
`sorrow	N-to-V	"N"
`sort	N-to-V	"N"
`sortie	N	"N"
`sou	N	"N"
souf`fle	N	"N"
`soul	N	"N"
`sound	N-to-V	"N"
`soup	N	"N"
`source	N	"N"
`sourdough	N	"N"
sou`tane	N	"N"
`south	N-to-AJ	"N"
`southerner	N	"N"
south`east	N-to-AJ	"N"
`southland	N	"N"
`southpaw	N	"N"
south`west	N-to-AJ	"N"
south`westerner	N	"N"
souve`nir	N	"N"
sou'`wester	N	"N"
`sovereignty	N	"AJ(`sovereign)+NR21"
`soviet	N	"N"
`sow	N	"N"
`sowbelly	N	"N"
`soy	N	"N"
`soya	N	"N"
`soybean	N	"N"
`spa	N	"N"
`space	N-to-V	"N"
`spacecraft	N	"N"
`spacesuit	N	"N"
`spade	N-to-V	"N"
`spadeful	N_Suffix1a	"N(`spade)+NR5"
spa`ghetti	N	"N"
`span	N-to-V	"N"
`spandrel	N	"N"
`spangle	N-to-V	"N"
`spaniel	N	"N"
`spar	N	"N"
`spare	N	"N"
`spark	N-to-V	"N"
`sparrow	N	"N"
`spasm	N	"N"
`spat	N	"N"
`spate	N	"N"
`spatula	N	"N"
`speakeasy	N	"N"
`spear	N-to-V	"N"
`spearmint	N	"N"
`specialty	N	"AJ(`special)+NR21"
spe`cific	N	"AJ(spe`cific).NR0"
specifi`cation	N	"V(`specify)+NR23"
`specimen	N	"N"
`speck	N-to-V	"N"
`speckle	N-to-V	"N"
`spectacle	N	"N"
`spectator	N	"N"
`specter	N	"N"
`spectre	N	"N"
`speech	N	"N"
`speed	N-to-V	"N"
`speedboat	N	"N"
speed`ometer	N	"N"
`speedup	N	"N"
`spell	N-to-V	"N"
`spelling	N	"V(`spell)+NR24"
`sperm	N	"N"
sperma`ceti	N	"N"
sper`matophyte	N	"N"
`sphagnum	N	"N"
`sphere	N	"N"
`spheroid	N-to-AJ	"N(`sphere)+NR53"
`spherule	N	"N"
`sphinx	N	"N"
`spice	N-to-V	"N"
`spider	N	"N"
`spiel	N	"N"
`spigot	N	"N"
`spike	N	"N"
`spikenard	N	"N"
`spill	N	"N"
`spinach	N	"N"
`spindle	N-to-V	"N"
`spine	N	"N"
`spinnaker	N	"N"
`spinneret	N	"N"
`spinoff	N	"N"
`spinster	N	"N"
`spire	N	"N"
`spirit	N-to-V	"N"
`spiritual	N	"N(`spirit)+AJR17.NR0"
`spit	N	"N"
`spite	N	"N"
`spitfire	N	"N"
`spittle	N	"N"
`spitz	N	"N"
`splat	N	"N"
`spleen	N	"N"
`splendor	N	"N"
`splendour	N	"N" ;British
`spline	N	"N"
`splint	N-to-V	"N"
`splinter	N-to-V	"N"
`split	N	"V(`split).NR0"
`splotch	N	"N"
`splurge	N-to-V	"N"
`spoil	N	"N"
`spoke	N	"N"
`spokesperson	N	"N"
`sponge	N-to-V	"N"
`sponsor	N-to-V	"N"
sponta`neity	N	"N"
`spook	N-to-V	"N"
`spool	N-to-V	"N"
`spoon	N-to-V	"N"
`spoonful	N_Suffix1a	"N(`spoon)+NR5"
`spoor	N	"N"
`spore	N	"N"
`sport	N	"N"
`sports	N	"N"
`sportswear	N	"N"
`spot	N	"N"
`spotlight	N-to-V	"N"
`spouse	N	"N"
`spout	N-to-V	"N"
`sprain	N-to-V	"N"
`spray	N-to-V	"N"
`spreadsheet	N	"N"
`spree	N	"N"
`sprig	N	"N"
`spring	N	"N"
`springboard	N	"N"
`springtime	N	"N"
`sprite	N	"N"
`sprocket	N	"N"
`spruce	N	"N"
`sprue	N	"N"
`spud	N	"N"
`spume	N	"N"
spu`moni	N	"N"
`spunk	N	"N"
`spur	N-to-V	"N"
`spurge	N	"N"
`sputnik	N	"N"
`spyglass	N	"N"
`squab	N	"N"
`squabble	N-to-V	"N"
`squad	N	"N"
`squadron	N	"N"
`squall	N	"N"
`squalor	N	"N"
`square	N	"N"
`squash	N	"N"
`squaw	N	"N"
`squeegee	N-to-V	"N"
`squid	N	"N"
`squire	N	"N"
`squirrel	N-to-V	"N"
`stable	N	"N"
`stack	N-to-V	"N"
`stag	N	"N"
`stage	N-to-V	"N"
`stagecoach	N	"N"
`staging	N	"N(`stage)+NR7"
`stair	N	"N"
`staircase	N	"N"
`stairway	N	"N"
`stairwell	N	"N"
`stake	N-to-V	"N"
sta`lactite	N	"N"
`stalemate	N-to-V	"N"
`stalk	N	"N"
`stall	N	"N"
`stallion	N	"N"
`stamen	N	"N"
`stamina	N	"N"
stam`pede	N-to-V	"N"
`stance	N	"N"
`stanchion	N	"N"
`stand	N	"N" ;of trees
`standard	N	"N"
`standby	N	"N"
`standing	N	"V(`stand)+NR24"
`standoff	N	"N"
`standpoint	N	"N"
`standstill	N	"N"
`stanza	N	"N"
`staph	N	"N" ;staphylo`coccus
`staple	N-to-V	"N"
`star	N-to-V	"N"
`starboard	N	"N"
`starch	N-to-V	"N"
`starlight	N	"N"
`starling	N	"N"
`startup	N	"N"
`state	N	"N"
`stateroom	N	"N"
`static	N	"N"
`station	N-to-V	"N"
`stationery	N	"N"
`stationmaster	N	"N"
sta`tistic	N	"N"
`stator	N	"N"
`statuary	N	"N"
`statue	N	"N"
`stature	N	"N"
`status	N	"N"
`statute	N	"N"
`stead	N	"N"
`steak	N	"N"
`stealth	N	"N"
`steam	N-to-V	"N"
`steamboat	N	"N"
`steed	N	"N"
`steel	N-to-V	"N"
`steeple	N	"N"
`stein	N	"N"
`stem	N	"N"
`stench	N	"N"
`stencil	N-to-V	"N"
`step	N-to-V	"N"
`steppe	N	"N"
`stereo	N	"N"
`stereotype	N-to-V	"N"
`sterling	N	"N"
`stern	N	"N"
`steroid	N	"N"
`stethoscope	N	"N"
`stevedore	N	"N"
`stew	N-to-V	"N"
`steward	N	"N"
`stick	N	"N"
`stickleback	N	"N"
`stickpin	N	"N"
`stile	N	"N"
`still	N	"N"
`stillbirth	N	"N"
`stilt	N	"N"
`stimulant	N	"N"
`stinkpot	N	"N"
`stint	N	"N"
`stipend	N	"N"
`stirrup	N	"N"
`stitch	N-to-V	"N"
`stock	N-to-V	"N"
stock`ade	N	"N"
`stockbroker	N	"N"
`stockholder	N	"N"
`stocking	N	"N"
`stockpile	N-to-V	"N"
`stockroom	N	"N"
`stoic	N	"N"
`stomach	N-to-V	"N"
`stomachs	Number	"N(`stomach)+PL" ;exception to Epenthesis
`stone	N-to-V	"N"
`stoneware	N	"N"
`stooge	N	"N"
`stool	N	"N"
`stopgap	N	"N"
`stopover	N	"N"
`stopwatch	N	"N"
`storehouse	N	"N"
`storekeeper	N	"N(`store)+V(`keep)+NR19"
`storeroom	N	"N"
`stork	N	"N"
`storm	N-to-V	"N"
`story	N	"N"
`storyboard	N	"N"
`storyteller	N	"N"
`stove	N	"N"
;`stowage	N_Suffix1a	"V(`stow)+NR1"
`stowaway	N	"N"
`strain	N-to-V	"N"
`strait	N	"N"
`strand	N	"N"
`stranger	N	"N"
`stranglehold	N	"N"
`strap	N-to-V	"N"
`stratagem	N	"N"
`strategist	N_Suffix1a	"N(`strategy)+NR31"
`strategy	N	"N"
stratifi`cation	N	"V(`stratify)+NR23"
`stratosphere	N	"N"
`straw	N	"N"
`strawberry	N	"N"
`strawflower	N	"N"
`streak	N-to-V	"N"
`stream	N-to-V	"N"
`streamline	N-to-V	"N"
`street	N	"N"
`streetcar	N	"N"
`strength	N	"N"
`stress	N-to-V	"N"
`stricture	N	"N"
`strife	N	"N"
`strikebreaker	N	"N(`strike)+V(`break)+NR19"
`strikebreaking	N	"N(`strike)+V(`break)+PRG"
`string	N	"N"
`strip	N-to-V	"N"
`stripe	N-to-V	"N"
`striptease	N	"N"
`strobe	N	"N"
`stroke	N-to-V	"N"
`stronghold	N	"N"
`strongroom	N	"N"
`strop	N	"N"
`strophe	N	"N"
`structuralism	N	"N(`structure)+AJR17+NR8"
`structure	N-to-V	"N"
`strut	N	"N"
`strychnine	N	"N"
`stub	N	"N"
`stubble	N	"N"
`stud	N	"N"
`student	N	"N"
`studio	N	"N"
`study	N	"N"
`stuff	N	"N"
`stuffing	N	"V(`stuff)+NR24"
stultifi`cation	N	"V(`stultify)+NR23"
`stump	N	"N"
`stunt	N	"N"
stupe`faction	N	"V(`stupify)+NR23"
`stupor	N	"N"
`sturgeon	N	"N"
`style	N-to-V	"N" ;see verb.lex for verb forms
`stylist	N_Suffix1a	"N(`style)+NR31"
`stylite	N_Suffix1a	"N(`style)+NR32"
`styrene	N	"N"
`styrofoam	N	"N"
`sub	N	"N" ;submarine
`submarine	N	"DEG8/LOC1+AJ(ma`rine).NR0"
`subject	N	"N"
sub`mission	N	"V(sub`mit)+NR23"
sub`poena	N-to-V	"N"
sub`scription	N	"V(sub`scribe)+NR23"
sub`servience	N	"AJ(sub`servient)+NR41"
`subsidy	N	"N"
sub`stituent	N	"N"
`substrate	N	"N"
`subterfuge	N	"N"
`subtlety	N	"AJ(`subtle)+AJR26"
sub`tracter	N	"N"
`subtrahend	N	"N"
`suburb	N	"N"
sub`urbia	N_Suffix1a	"N(`suburb)+NR61"
suc`cess	N	"N"
suc`cession	N	"V(suc`ceed)+NR23"
suc`cessor	N	"V(suc`ceed)+NR20"
`succor	N-to-V	"N"
`succour	N-to-V	"N" ;British
`succulence	N	"AJ(`succulent)+NR41"
`suckling	N_Suffix1a	"V(`suckle)+NR15"
`suction	N	"V(`suck)+NR23"
`suede	N-to-V	"N"
`suet	N	"N"
suf`ficiency	N	"V(suf`fice)+AJR27+NR40"
`suffix	N-to-V	"N"
`suffrage	N	"N"
`suffragan	N	"N"
`sugar	N-to-V	"N"
`sugarcane	N	"N"
`suicide	N	"N"
`suit	N	"N"
`suitcase	N	"N"
`suite	N	"N"
`suitor	N	"N"
`sulfur	N	"N"
`sulphur	N	"N"
`sultan	N	"N"
`sultanate	N	"N"
`sum	N-to-V	"N"
`sumac	N	"N"
`summand	N	"N"
`summary	N	"N"
`summertime	N	"N"
`summit	N	"N"
`summitry	N_Suffix1a	"N(`summit)+NR3"
`sump	N	"N"
`sun	N-to-V	"N"
`sunbeam	N	"N"
`sunbonnet	N	"N"
`sunburn	N-to-V	"N"
`sundew	N	"N"
`sundial	N	"N"
`sundown	N	"N"
`sunfish	N	"N"
`sunflower	N	"N"
`sunlight	N	"N"
`sunrise	N	"N"
`sunset	N	"N"
`sunshade	N	"N"
`sunshine	N	"N"
`sunspot	N	"N"
`suntan	N	"N"
super`fluity	N	"N"
superin`tendent	N	"V(superin`tend)+NR17"
super`stition	N	"N"
`supplement	N-to-V	"N"
sup`pository	N	"N"
su`premacist	N_Suffix1a	"AJ(su`preme)+NR40+NR31"
su`premacy	N	"AJ(su`preme)+NR40"
`surety	N	"AJ(`sure)+AJR26"
`surf	N-to-V	"N"
`surface	N-to-V	"N"
sur`feit	N	"N"
`surgeon	N	"N"
`surgery	N	"N"
`surname	N-to-V	"DEG10+N(`name)"
`surplus	N	"N"
`surrey	N	"N"
`surrogate	N	"N"
sur`rounding	N	"V(sur`round)+NR24"
`surtax	N	"DEG10+N(`tax)"
`survey	N	"V(sur`vey).NR0"
suscepti`bility	N	"AJ(sus`ceptible)+NR21"
`sushi	N	"N"
`suspect	N	"V(sus`pect).NR0"
sus`pense	N	"N"
sus`pension	N	"V(sus`pend)+NR23"
sus`picion	N	"V(sus`pect)+NR23"
`sustenance	N	"V(sus`tain)+NR26"
`suture	N-to-V	"N"
`suzerain	N	"N"
`suzerainty	N	"N"
`swab	N-to-V	"N"
`swag	N	"N"
`swain	N	"N"
`swallow	N	"N"
`swallowtail	N	"N"
`swami	N	"N"
`swamp	N-to-V	"N"
`swan	N	"N"
`swastika	N	"N"
`swatch	N	"N"
`swath	N	"N"
`swathe	N	"N"
`sweatband	N	"N"
`sweat	N	"V(`sweat).NR0"
`sweater	N	"N"
`sweatshirt	N	"N"
`sweepstake	N	"N"
`sweetheart	N	"N"
`swelling	N	"V(`swell)+NR24"
`swimsuit	N	"N"
`swing	N	"N"
`swirl	N-to-V	"N"
`switch	N-to-V	"N"
`switchblade	N	"N"
`switchboard	N	"N"
`swivel	N-to-V	"N"
`swizzle	N	"N"
`sword	N	"N"
`swordfish	N	"N"
`swordplay	N	"N"
`sycamore	N	"N"
`sycophant	N	"N"
syl`labic	N	"N(`syllable)+AJR20.NR0"
syllabifi`cation	V	"N(`syllable)+VR5+NR23"
`syllable	N	"N"
`syllogism	N	"N"
`syllogist	N	"N"
symbi`osis	N	"N"
`symbol	N	"N"
`symbolism	N_Suffix1b	"N(`symbol)+NR8"
`symmetry	N	"N"
`symphony	N	"N"
`symptom	N	"N"
`synagogue	N	"N"
`synapse	N	"N"
`synchronism	N	"N(`synchrony)+NR8"
`synchrony	N	"N"
`syncope	N	"N"
`syndrome	N	"N"
`synergism	N_Suffix1b	"N(`synergy)+NR8"
`synergy	N	"N"
`synod	N	"N"
`synonym	N	"N"
syn`onymy	N	"N"
`syntax	N	"N"
`syphon	N	"N"
sy`ringe	N	"N"
`syrup	N	"N"
`system	N	"N"

`tab	N	"N"
`tabernacle	N	"N"
`table	N-to-V	"N"
`tablecloth	N	"N"
`tableful	N_Suffix1a	"N(`table)+NR5"
`tableland	N	"N"
`tablespoon	N	"N"
`tablespoonful	N_Suffix1a	"N(`tablespoon)+NR5"
`tablet	N	"N"
`tabloid	N	"N"
ta`boo	N	"N"
ta`bu	N	"N"
ta`chometer	N	"N"
`tack	N-to-V	"N"
`tackle	N	"N"
`tact	N	"N"
`tactic	N	"N"
`tad	N	"N"
`tadpole	N	"N"
`taffeta	N	"N"
`taffy	N	"N"
`tag	N-to-V	"N"
`tail	N	"N"
`tailgate	N	"N"
`tailor	N-to-V	"N"
`tailwind	N	"N"
`takeoff	N	"N"
`takeover	N	"N"
`talc	N	"N"
`talcum	N	"N"
`tale	N	"N"
`talent	N	"N"
`talisman	N	"N"
`talkie	N	"N"
`tallow	N	"N"
`tally	N-to-V	"N"
tally`ho	N	"N"
`talon	N	"N"
`tam	N	"N"
ta`male	N	"N"
`tamarack	N	"N"
tambou`rine	N	"N"
`tampon	N	"N"
`tanager	N	"N"
`tandem	N	"N"
`tang	N	"N"
`tangent	N	"N"
tange`rine	N	"N"
tangi`bility	N	"AJ(`tangible)+NR21"
`tango	N-to-V	"N"
`tank	N	"N"
`tanker	N	"N"
`tankful	N_Suffix1a	"N(`tank)+NR5"
`tannin	N	"N"
`tansy	N	"N"
`tantrum	N	"N"
`tap	N-to-V	"N" ;spigot
`tape	N-to-V	"N"
`tapestry	N	"N"
`tapeworm	N	"N"
`tapir	N	"N"
`tappet	N	"N"
`tar	N-to-V	"N"
ta`rantula	N	"N"
`tare	N	"N"
`target	N-to-V	"N"
`tariff	N	"N"
`taro	N	"N"
`tarpaper	N	"N"
`tarpaulin	N	"N"
`tarpon	N	"N"
`tartar	N	"N"
`task	N	"N"
`taskmaster	N	"N"
`tassel	N-to-V	"N"
`tater	N	"N"
`tattletale	N	"N"
tat`too	N-to-V	"N"
`tavern	N	"N"
`taxi	N-to-V	"N"
`taxicab	N	"N"
`taxiway	N	"N"
`taxpayer	N	"N"
`tea	N	"N"
`teacart	N	"N"
`teaching	N	"V(`teach)+NR24"
`teacup	N	"N"
`teacupful	N_Suffix1a	"N(`teacup)+NR5"
`teahouse	N	"N"
`teakettle	N	"N"
`teakwood	N	"N"
`teapot	N	"N"
`teal	N	"N"
`team	N-to-V	"N"
`teammate	N	"N"
`teamwork	N	"N"
`teapot	N	"N"
`tear	N-to-V	"N" ;[tir]
`teardrop	N	"N"
`teasel	N	"N"
`teaspoon	N	"N"
`teaspoonful	N_Suffix1a	"N(`teaspoon)+NR5"
`teat	N	"N"
`teatime	N	"N"
tech`nician	N	"N"
tech`nique	N	"N"
`technocrat	N	"N"
`tedium	N	"N"
`tee	N-to-V	"N"
`teen	N-to-AJ	"N"
`teenager	N	"N"
`teetotaler	N	"N"
telecommuni`cation	N	"N"
`telegram	N	"N"
`telegraph	N-to-V	"N"
te`legraphy	N	"N"
`telephone	N-to-V	"N"
`telescope	N-to-V	"N"
`telethon	N	"N"
tele`vangelist	N	"N"
`television	N	"N"
`telex	N-to-V	"N"
te`merity	N	"N"
`temper	N	"N"
`tempera	N	"N"
`temperament	N	"N"
`temperature	N	"N"
`tempest	N	"N"
`template	N	"N"
`temple	N	"N"
`temptress	N_Suffix1a	"V(`tempt)+NR19+NR12"
tena`bility	N	"AJ(`tenable)+NR21"
te`nacity	N	"N"
`tenant	N	"N"
`tenancy	N	"N(`tenant)+NR40"
`tender	N-to-V	"N"
`tenderfoot	N	"N"
`tenderloin	N	"N"
`tendon	N	"N"
`tendril	N	"N"
`tenement	N	"N"
`tenet	N	"N"
`tennis	N	"N"
`tenon	N	"N"
`tenor	N-to-AJ	"N"
`tense	N	"N"
`tension	N	"N"
`tensor	N	"N"
`tenspot	N	"N"
`tent	N-to-V	"N"
`tentacle	N	"N"
`tenterhook	N	"N"
`tenure	N	"N"
`tepee	N	"N"
`term	N-to-V	"N"
`terminal	N	"N"
`termite	N	"N"
`tern	N	"N"
`terrace	N	"N"
ter`rain	N	"N"
`terrapin	N	"N"
`terrier	N	"N"
`territory	N	"N"
`terror	N	"N"
`terry	N	"N"
`test	N-to-V	"N"
`testacy	N	"AJ(`testate)+NR40"
`testament	N	"N"
`testator	N	"N"
`testatrix	N	"N"
`testbed	N	"N"
`testicle	N	"N"
testi`monial	N	"N"
`testimony	N	"N"
`tetanus	N	"N"
tete-a-tete	N	"N"
`tether	N-to-V	"N"
tetra`cycline	N	"N"
`tetrarch	N	"N"
`text	N	"N"
`textbook	N	"N"
`textile	N	"N"
`texture	N-to-V	"N"
`thatch	N-to-V	"N"
`theater	N	"N"
`theatre	N	"N"
`theft	N	"N"
`theism	N	"N"
`theist	N-to-AJ	"N"
`theme	N	"N"
the`ocracy	N	"N"
``theorem	N	"N"
`theorist	N_Suffix1a	"N(`theory)+NR31"
`theory	N	"N"
`therapy	N	"N"
`therapist	N_Suffix1a	"N(`therapy)+NR31"
ther`mometer	N	"N"
`thermostat	N	"N"
`thiamin	N	"N"
`thicket	N	"N"
`thievery	N_Suffix1a	"V(`thieve)+NR3"
`thigh	N	"N"
`thimble	N	"N"
`thimbleful	N_Suffix1a	"N(`thimble)+NR5"
`thing	N	"N"
`thirst	N-to-V	"N"
`thistle	N	"N"
`thistledown	N	"N"
`thong	N	"N"
`thorn	N	"N"
`thoroughfare	N	"N"
`thought	N	"V(`think).PST/PTC.NR0"
`thrall	N	"N"
`thread	N-to-V	"N"
`threat	N	"N"
`threshold	N	"N"
`thrift	N	"N"
`thrill	N-to-V	"N"
`throat	N	"N"
`throe	N	"N"
`throne	N-to-V	"N"
`throng	N-to-V	"N"
`throughput	N	"N"
`throwaway	N	"N"
`throwback	N	"N"
`thrum	N-to-V	"N"
`thrush	N	"N"
`thug	N	"N"
`thumb	N-to-V	"N"
`thumbnail	N	"N"
`thunder	N-to-V	"N"
`thunderbird	N	"N"
`thunderbolt	N	"N"
`thunderclap	N	"N"
`thundershower	N	"N"
`thunderstorm	N	"N"
`thyme	N	"N"
`thyroid	N	"N"
`tic	N	"N"
`tick	N	"N"
`ticket	N-to-V	"N"
`tidbit	N	"N"
`tide	N	"N"
`tideland	N	"N"
`tidewater	N	"N"
`tiding	N	"N"
`tie	N	"N"
`tier	N	"N"
`tiff	N	"N"
`tiger	N	"N"
`tightrope	N	"N"
`tigress	N_Suffix1a	"N(`tiger)+NR12"
`tilde	N	"N"
`tile	N-to-V	"N"
`till	N	"N"
`timber	N	"N"
`timberland	N	"N"
`timbre	N	"N"
`time	N-to-V	"N"
`timeshare	N	"N"
`timeout	N	"N"
`timepiece	N	"N"
`timetable	N	"N"
`timothy	N	"N"
`timpanist	N_Suffix1a	"N(`timpani).SG/PL+NR31"
`tin	N	"N"
`tincture	N-to-V	"N"
`tinder	N	"N"
`tine	N	"N"
`tinfoil	N	"N"
`tinful	N_Suffix1a	"N(`tin)+NR5"
`tinker	N	"N"
`tinsel	N	"N"
`tint	N-to-V	"N"
`tintype	N	"N"
`tip	N-to-V	"N"
`tipoff	N	"N"
`tiptoe	N-to-V	"N"
`tirade	N	"N"
`tire	N	"N"
`tissue	N	"N"
`tit	N	"N"
`titan	N	"N"
ti`tanium	N	"N"
`title	N-to-V	"N"
`titmouse	N	"N"
`toad	N	"N"
`toadstool	N	"N"
`toastmaster	N	"N"
to`bacco	N	"N"
toc`cata	N	"N"
to`day	N	"N"
`toe	N	"N"
`toenail	N	"N"
`toffee	N	"N"
`tofu	N	"N"
to`getherness	N	"AV(to`gether)+NR27"
`toilet	N	"N"
`toiletry	N_Suffix1a	"N(`toilet)+NR3"
`token	N	"N"
tolera`bility	N	"V(`tolerate)+AJR25+NR21"
`tolerance	N	"AJ(`tolerant)+NR41"
`toll	N	"N"
`tollgate	N	"N"
`tollhouse	N	"N"
`tomahawk	N	"N"
`tomb	N	"N"
`tombstone	N	"N"
`tome	N	"N"
`tommy	N	"N"
`ton	N	"N"
`tonnage	N_Suffix1a	"N(`ton)+NR1"
`tone	N-to-V	"N"
`tongue	N-to-V	"N"
`tonic	N	"N"
`tonsil	N	"N"
`tool	N-to-V	"N"
`toolkit	N	"N"
`toolsmith	N	"N"
`toothache	N	"N"
`toothbrush	N	"N"
`toothpaste	N	"N"
`toothpick	N	"N"
`top	N-to-AJ	"N"
`topaz	N	"N"
`topcoat	N	"N"
`topic	N	"N"
`topping	N	"V(`top)+NR24"
`topsoil	N	"N"
`torch	N-to-V	"N"
`torment	N-to-V	"N"
`torpor	N	"N"
`torque	N	"N"
`torr	N	"N"
`torrent	N	"N"
`torsion	N	"N"
`tort	N	"N"
`tortoise	N	"N"
`tortoiseshell	N-to-AJ	"N"
`tory	N	"N"
`tot	N	"N"
`total	N-to-V	"N"
totali`tarian	N-to-AJ	"N(to`tality)+AJR22+NR29"
`totem	N	"N"
`touchdown	N	"N"
`touchstone	N	"N"
`tour	N-to-V	"N"
`tournament	N	"N"
`towboat	N	"N"
`towel	N-to-V	"N"
`tower	N-to-V	"N"
`towhead	N	"N"
`towhee	N	"N"
`town	N	"N"
`townhouse	N	"N"
`toxin	N	"N"
`toy	N-to-V	"N"
`trace	N	"N"
`tracery	N_Suffix1a	"N(`trace)+NR3"
`tracing	N	"V(`trace)+NR24"
`track	N-to-V	"N"
`tract	N	"N"
tracta`bility	N	"AJ(`tractable)+NR21"
`traction	N	"N"
`tractor	N	"N"
`trademark	N	"N"
`tradeoff	N	"N"
tra`dition	N	"N"
`traffic	N-to-V	"N"
`trafficker	N	"N(`traffic).VR0+NR19"
`tragedy	N	"N"
`trail	N	"N"
`trailblazer	N	"N(`trail)+V(`blaze)+NR19"
`trailblazing	N	"N(`trail)+V(`blaze)+PRG"
`trailside	N	"N"
`train	N	"N"
`trainful	N_Suffix1a	"N(`train)+NR5"
`trait	N	"N"
`traitor	N	"N"
tra`jectory	N	"V(tra`ject)+NR34"
`tram	N	"N"
`trammel	N-to-V	"N"
`tramway	N	"N"
`trance	N-to-V	"N"
trans`ceiver	N	"N"
transcon`ductance	N	"LOC5+V(con`duct)+NR26"
`transcript	N	"N"
trans`cription	N	"V(trans`cribe)+NR23"
trans`duction	N	"V(trans`duce)+NR23"
`transept	N	"N"
`transfer	N	"N"
`transform	N	"V(trans`form).NR0"
`transience	N	"AJ(`transient)+NR41"
tran`sistor	N	"N"
`transit	N-to-V	"N"
trans`lucence	N	"AJ(trans`lucent)+NR41"
trans`mission	N	"V(trans`mit)+NR23"
transmogrifi`cation	N	"V(trans`mogrify)+NR23"
`transom	N	"N"
trans`parence	N	"AJ(tran`parent)+NR41"
trans`parency	N	"AJ(tran`parent)+NR40"
`transplant	N	"V(trans`plant).NR0"
tran`sponder	N	"N"
`transport	N	"V(trans`port).NR0"
trans`vestite	N	"N"
`trap	N-to-V	"N"
`trapezoid	N	"N"
`trapping	N	"N"
`trash	N-to-V	"N"
tra`vail	N-to-V	"N"
`travelogue	N	"N"
`travertine	N	"N"
`travesty	N	"N"
`tray	N	"N"
`trayful	N_Suffix1a	"N(`tray)+NR5"
`treachery	N	"N"
`treacle	N	"N"
`treadle	N-to-V	"N"
`treadmill	N	"N"
`treason	N	"N"
`treasure	N-to-V	"N"
`treasury	N	"N"
`treatise	N	"N"
`treaty	N	"N"
`tree	N	"N"
`treetop	N	"N"
`trefoil	N	"N"
`trekkie	N	"N"
`trellis	N-to-V	"N"
`tremor	N	"N"
`tremour	N	"N" ;British
`trench	N	"N"
`trencher	N	"N"
trepi`dation	N	"N"
`tress	N	"N"
`trestle	N	"N"
`triad	N	"N"
`trial	N	"N"
`triangle	N	"N"
`tribe	N	"N"
tri`bunal	N	"N"
`tribune	N	"N"
`tributary	N	"N"
`tribute	N	"N"
`trick	N-to-V	"N"
`trickery	N_Suffix1a	"N(`trick)+NR3"
`trig	N	"N"
`trigger	N-to-V	"N"
`trigram	N	"N"
`trilobite	N	"N"
`trilogy	N	"N"
`trim	N	"N"
`trimester	N	"N"
`trimming	N	"V(`trim)+NR24"
`trinity	N	"N"
`trinket	N	"N"
`trio	N	"N"
`trip	N	"N"
`tripe	N	"N"
`triplet	N	"N"
`tripod	N	"N"
`tripoli	N	"N"
`triptych	N	"N"
`triton	N	"N"
`triumph	N-to-V	"N"
tri`umvir	N	"N"
tri`umvirate	N	"N(tri`umvir)+NR46"
`troglodyte	N	"N"
`troika	N	"N"
`troll	N	"N"
`trolley	N	"N"
`trollop	N	"N"
trom`bone	N	"N"
`troop	N-to-V	"N"
`trope	N	"N"
`trophy	N	"N"
`tropic	N	"N"
`troubador	N	"N"
`trouble	N-to-V	"N"
`troublemaker	N	"N(`trouble)+V(`make)+NR19"
`troubleshooter	N	"N(`trouble)+V(`shoot)+NR19"
`troubleshooting	N	"N(`trouble)+V(`shoot)+PRG"
`trough	N	"N"
`troupe	N	"N"
`trowel	N	"N"
`truancy	N	"AJ(`truant)+NR40"
`truce	N	"N"
`truck	N-to-V	"N"
`truckful	N_Suffix1a	"N(`truck)+NR5"
`truculence	N	"AJ(`truculent)+NR41"
`trump	N-to-V	"N"
`trumpery	N	"N"
`trumpet	N-to-V	"N"
`trundle	N-to-V	"N"
`trunk	N	"N"
`trust	N-to-V	"N"
`truth	N	"AJ(`true)+NR42"
`tryst	N	"N"
`tsar	N	"N"
tsa`rina	N	"N"
t-shirt	N	"N"
tsu`nami	N	"N"
`tub	N	"N"
`tuba	N	"N"
`tube	N	"N"
`tuber	N	"N"
tu`berculin	N	"N"
tubercu`losis	N	"N"
`tubing	N	"N(`tubing)+NR7"
`tubule	N	"N"
`tuck	N-to-V	"N"
`tuff	N	"N"
`tuft	N-to-V	"N"
tu`ition	N	"N"
`tulip	N	"N"
`tulle	N	"N"
`tumbrel	N	"N"
tu`mescence	N	"AJ(tu`mescent)+NR41"
`tumor	N	"N"
`tumour	N	"N" ;British
`tumult	N	"N"
`tun	N	"N"
`tundra	N	"N"
`tune	N	"N"
`tungsten	N	"N"
`tunic	N	"N"
`tunnel	N-to-V	"N"
`turban	N	"N"
`turbine	N	"N"
`turbofan	N	"N"
`turbojet	N	"N"
`turbulence	N	"AJ(`turbulent)+NR41"
tu`reen	N	"N"
`turk	N	"N"
`turkey	N	"N"
`turmoil	N	"N"
`turnabout	N	"N"
`turnaround	N	"N"
`turnery	N	"V(`turn)+NR3"
`turnip	N	"N"
`turnkey	N	"N"
`turnoff	N	"N"
`turnout	N	"N"
`turnover	N	"N"
`turnpike	N	"N"
`turnstile	N	"N"
`turntable	N	"N"
`turpentine	N	"N"
`turpitude	N	"N"
`turret	N	"N"
`turtle	N	"N"
`turtleneck	N	"N"
`tusk	N	"N"
`tussle	N-to-V	"N"
`tutelage	N	"N"
`tutor	N-to-V	"N"
tu`torial	N	"N(`tutor)+AJR17.NR0"
`tutu	N	"N"
`twaddle	N	"N"
`twain	N	"N"
`tweed	N	"N"
`twig	N	"N"
`twilight	N	"N"
`twill	N	"N"
`twine	N	"N"
`twit	N	"N"
ty`coon	N	"N"
`type	N	"N"
`typeface	N	"N"
`typescript	N	"N"
`typhoid	N	"N"
ty`phoon	N	"N"
`typhus	N	"N"
`typist	N_Suffix1a	"V(`type)+NR31"
`typo	N	"N"
ty`rannicide	N	"N"
`tyre	N	"N" ;British
`tyro	N	"N"
`tyranny	N	"N"
`tyrant	N	"N"

u`biquity	N	"N"
`udder	N	"N"
uglifi`cation	N	"AJ(`ugly)+VR5+NR23"
uke`lele	N	"N"
`ulcer	N	"N"
`ultima	N	"N"
`umbrage	N	"N"
um`brella	N	"N"
`umlaut	N	"N"
`umpire	N-to-V	"N"
unan`imity	N	"N"
`uncle	N	"N"
`unction	N	"N"
`underling	N	"N"
`underpinning	N	"V(`underpin)+NR24"
`unguent	N	"N"
`unicorn	N	"N"
unifi`cation	N	"V(`unify)+NR23"
`union	N	"N"
`unison	N-to-AJ	"N"
`unit	N	"N"
`unity	N	"N"
`universe	N	"N"
uni`versity	N	"N"
`upbringing	N	"N"
`upcountry	N	"N"
`updraft	N	"N"
up`holstery	N	"N"
`upkeep	N	"N"
`upland	N	"N"
`uplift	N	"V(up`lift).NR0"
`uppercut	N	"N"
`uprising	N	"N"
`uproar	N	"N"
`upset	N	"V(up`set).NR0"
`upshot	N	"N"
`upside	N	"N"
`upstart	N	"N"
`upstate	N	"N"
up`stater	N	"N"
`upsurge	N	"N"
`upswing	N	"N"
`uptake	N	"N"
`uptown	N	"N"
`uptrend	N	"N"
`upturn	N	"N"
u`ranium	N	"N"
`urbanite	N_Suffix1a	"AJ(`urban)+NR32"
`urchin	N	"N"
u`rea	N	"N"
u`remia	N	"N"
`urethane	N	"N"
`urgency	N	"V(`urge)+AJR27+NR40"
`urinal	N	"N"
uri`nalysis	N	"N"
`urine	N	"N"
`urn	N	"N"
;`use	N	"N"
`usurer	N	"N"
`usury	N	"N"
u`tensil	N	"N"
u`topia	N	"N"

`vacancy	N	"AJ(`vacant)+NR40"
va`cation	N-to-V	"N"
va`cationland	N	"N"
vac`cine	N	"N"
va`cuity	N	"N"
`vacuum	N-to-V	"N"
`vagabond	N	"N"
`vagary	N	"N"
`vagrancy	N	"N(`vagrant)+NR40"
`vainglory	N	"N"
`vale	N	"N"
vale`diction	N	"N"
valedic`torian	N	"N"
`valence	N	"N"
`valentine	N	"N"
`valet	N-to-V	"N"
`valiance	N	"AJ(`valiant)+NR41"
`valiancy	N	"AJ(`valiant)+NR40"
`valley	N	"N"
`valor	N	"N"
`valour	N	"N" ;British
`value	N-to-V	"N"
`valve	N	"N"
`vamp	N-to-V	"N"
`vampire	N	"N"
`van	N	"N"
`vandal	N	"N"
`vane	N	"N"
`vanful	N_Suffix1a	"N(`van)+NR5"
`vanguard	N	"N"
va`nilla	N-to-AJ	"N"
`vanity	N	"AJ(`vain)+AJR26"
`vantage	N	"N"
`vapor	N-to-V	"N"
`vapour	N-to-V	"N" ;British
`variable	N	"V(`vary)+AJR25.NR0"
va`riety	N	"N"
va`ristor	N	"N"
`varmint	N	"N"
`varnish	N-to-V	"N"
`varsity	N	"N"
`vase	N	"N"
`vassal	N	"N"
`vat	N	"N"
`vatful	N_Suffix1a	"N(`vat)+NR5"
`vaudeville	N	"N"
`vault	N	"N"
`veal	N	"N"
`vector	N-to-V	"N"
`vee	N	"N"
`veery	N	"N"
`vegetable	N	"N"
`vehemence	N	"AJ(`vehement)+NR41"
`vehemency	N	"AJ(`vehement)+NR40"
`vehicle	N	"N"
`veil	N-to-V	"N"
`vein	N	"N"
`veld	N	"N"
`veldt	N	"N"
`vellum	N	"N"
ve`locity	N	"N"
ve`lour	N	"N"
`velvet	N-to-AJ	"N"
ven`detta	N	"N"
ve`neer	N-to-V	"N"
venera`bility	AJ	"V(`venerate)+AJR25+NR21"
`venison	N	"N"
`venom	N	"N"
`ventricle	N	"N"
ven`triloquism	N	"N"
ven`triloquist	N	"N"
ven`turi	N	"N"
`venue	N	"N"
ve`racity	N	"N"
ve`randa	N	"N"
ve`randah	N	"N"
`verb	N	"N"
`verbiage	N	"N"
`verdancy	N	"AJ(`verdant)+NR40"
`verdict	N	"N"
`verdure	N	"N"
verifi`cation	N	"V(`verify)+NR23"
verisi`militude	N	"N"
`verity	N	"N"
ver`meil	N-to-AJ	"N"
ver`miculite	N	"N"
ver`mouth	N	"N"
`vernier	N	"N"
`verse	N	"N"
`version	N	"N"
`verso	N	"N"
`vertigo	N	"N"
`verve	N	"N"
`vesicle	N	"N"
`vessel	N	"N"
`vest	N	"N"
`vestibule	N	"N"
`vestige	N	"N"
`vestry	N	"N"
`vesture	N-to-V	"N"
`vet	N-to-V	"N"
`vetch	N	"N"
`veteran	N	"N"
veteri`narian	N	"N"
via`bility	N	"AJ(`viable)+NR21"
`viaduct	N	"N"
`vial	N	"N"
`vibe	N	"N"
`vibrance	N	"V(`vibrate)+AJR27+NR41"
`vibrancy	N	"V(`vibrate)+AJR27+NR40"
vi`brato	N	"N"
`vicar	N	"N"
`vice	N	"N"
`viceroy	N	"N"
vichys`soise	N	"N"
vi`cinity	N	"N"
vi`cissitude	N	"N"
`victim	N	"N"
`victor	N	"N"
`victory	N	"N"
`victual	N-to-V	"N"
`video	N	"N"
`videocassette	N	"N"
`videodisc	N	"N"
`videotape	N-to-V	"N"
`videotext	N	"N"
`view	N-to-V	"N"
`viewpoint	N	"N"
`vigil	N	"N"
`vigilance	N	"N(`vigil)+AJR27+NR41"
vigi`lante	N	"N"
vig`nette	N-to-V	"N"
`vigor	N	"N"
`vigour	N	"N" ;British
`viking	N	"N"
`villa	N	"N"
`village	N	"N"
`villager	N_Suffix1a	"N(`village)+NR11"
`villain	N	"N"
`villein	N	"N"
`vine	N	"N"
`vinegar	N	"N"
`vinery	N_Suffix1a	"N(`vine)+NR3"
`vineyard	N	"N"
`vintage	N	"N"
`vintner	N	"N"
`vinyl	N	"N"
`viol	N	"N"
vi`ola	N	"N"
viola`bility	AJ	"V(`violate)+AJR25+NR21"
`violence	N	"AJ(`violent)+NR41"
`violet	N	"N"
vio`lin	N	"N"
vio`linist	N_Suffix1a	"N(vio`lin)+NR31" ;exception to Gemination
vi`olist	N_Suffix1a	"N(vi`ola)+NR31"
`viper	N	"N"
`virgin	N-to-AJ	"N"
`virgule	N	"N"
`virtue	N	"N"
virtu`osity	N	"N(virtu`oso).AJR0+NR21"
`virulence	N	"AJ(`virulent)+NR41"
`virulency	N	"AJ(`virulent)+NR40"
`virus	N	"N"
`visa	N	"N"
`visage	N	"N"
vis`cosity	N	"N"
`viscount	N	"N"
`vise	N	"N"
visi`bility	N	"AJ(`visible)+NR21"
`visigoth	N	"N"
`vision	N	"N"
`visionary	N	"N(`vision)+AJR22.NR0"
`visor	N	"N"
`vista	N	"N"
`vitals	N	"AJ(`vital).NR0+PL"
``vitamin	N	"N"
`vitriol	N	"N"
vi`vacity	N	"N"
`vixen	N	"N"
`vocable	N	"N"
vo`cabulary	N	"N"
vo`cation	N	"N"
`vodka	N	"N"
`vogue	N	"N"
`voice	N-to-V	"N"
`volcanism	N_Suffix1b	"N(vol`cano)+NR8"
vo`lition	N	"N"
`volley	N-to-V	"N"
`volleyball	N	"N"
`volt	N	"N"
`voltage	N_Suffix1a	"N(`volt)+NR1"
`voltmeter	N	"N"
volu`bility	N	"AJ(`voluble)+NR21"
`volume	N	"N"
`voluntarism	N_Suffix1b	"AJ(`voluntary)+NR8"
volun`teer	N-to-V	"N"
`voodoo	N	"N"
vo`racity	N	"N"
vor`ticity	N	"N"
`votary	N	"N"
`vote	N-to-V	"N"
`vow	N-to-V	"N"
`vowel	N	"N"
`voyage	N-to-V	"N"
voy`eur	N	"N"
`vulture	N	"N"
vulnera`bility	N	"AJ(`vulnerable)+NR21"

`wad	N-to-V	"N"
`wadi	N	"N"
`wafer	N	"N"
`waffle	N	"N"
`wag	N	"N"
`wage	N	"N"
`wager	N-to-V	"N"
`waggle	N	"N"
`wagon	N	"N"
`waif	N	"N"
`wainscot	N-to-V	"N"
`wainwright	N	"N"
`waist	N	"N"
`waistband	N	"N"
`waistcoat	N	"N"
`waistline	N	"N"
`waiter	N	"V(`wait)+NR19"
`waitress	N_Suffix1a	"V(`wait)+NR19+NR12"
`wake	N	"N"
`wale	N	"N"
walkie-`talkie	N	"N"
`walkout	N	"N"
`walkover	N	"N"
`walkway	N	"N"
`wall	N-to-V	"N"
`wallaby	N	"N"
`wallboard	N	"N"
`wallet	N	"N"
`wallpaper	N-to-V	"N"
`walnut	N	"N"
`walrus	N	"N"
`waltz	N-to-V	"N"
`wampum	N	"N"
`wand	N	"N"
`war	N-to-V	"N"
`ward	N	"N"
`warden	N	"N"
`wardrobe	N	"N"
`wardroom	N	"N"
`ware	N	"N"
`warehouse	N-to-V	"N"
`warfare	N	"N"
`warhead	N	"N"
`warhorse	N	"N"
`warlock	N	"N"
`warlord	N	"N"
`warmonger	N	"N"
`warmth	N	"AJ(`warm)+NR42"
`warmup	N	"N"
`warpath	N	"N"
`warplane	N	"N"
`warrant	N-to-V	"N"
`warranty	N	"N"
`warren	N	"N"
`warrior	N	"N"
`wart	N	"N"
`warthog	N	"N"
`wartime	N	"N"
`washbasin	N	"N"
`washboard	N	"N"
`washbowl	N	"N"
`washcloth	N	"N"
`washout	N	"N"
`washroom	N	"N"
`washtub	N	"N"
`wasp	N	"N"
`wassail	N-to-V	"N"
`wastebasket	N	"N"
`wasteland	N	"N"
`wastepaper	N	"N"
`wastewater	N	"N"
`wastrel	N	"N"
`watch	N	"N"
`watchband	N	"N"
`watchdog	N	"N"
`watchmaker	N	"N(`watch)+V(`make)+NR19"
`watchmaking	N	"N(`watch)+V(`make)+PRG"
`watchword	N	"N"
`water	N-to-V	"N"
`watercolor	N	"N"
`watercourse	N	"N"
`waterfall	N	"N"
`waterfront	N	"N"
`waterfowl	N	"N"
`waterline	N	"N"
`watermelon	N	"N"
`watershed	N	"N"
`waterside	N	"N"
`waterski	N	"N"
`waterspout	N	"N"
`waterway	N	"N"
`watt	N	"N"
`wattage	N_Suffix1a	"N(`watt)+NR1"
`wattle	N-to-V	"N"
`waveform	N	"N"
`wavelength	N	"N"
`wax	N-to-V	"N"
`waxwork	N	"N"
`way	N	"N"
`waybill	N	"N"
`wayfarer	N	"N"
`wayside	N-to-AJ	"N"
`weakling	N_Suffix1a	"AJ(`weak)+NR15"
`weal	N	"N"
`wealth	N	"N"
`weapon	N	"N"
`weaponry	N_Suffix1a	"N(`weapon)+NR3"
`weasel	N	"N"
`weather	N-to-V	"N"
`web	N-to-V	"N"
`webbing	N	"N(`web)+NR7"
;`wedding	N	"V(`wed)+NR24"
`wedge	N-to-V	"N"
`wedlock	N	"N"
`weed	N-to-V	"N"
`week	N	"N"
`weekday	N	"N"
`weekend	N	"N"
`weevil	N	"N"
`weight	N-to-V	"N"
`weir	N	"N"
`weirdo	N	"N"
`welfare	N	"N"
`well	N	"N" ;water well
well`being	N	"N"
`welt	N-to-V	"N"
`wen	N	"N"
`wench	N	"N"
`west	N-to-AJ	"N"
`westerly	N	"N"
`westerner	N_Suffix1a	"AJ(`western)+NR11"
`wetback	N	"N"
`wetland	N	"N"
`wetsuit	N	"N"
`whale	N-to-V	"N"
`whalebone	N	"N"
`whatnot	N	"PR/N"
`wheat	N	"N"
`wheel	N-to-V	"N"
`wheelbase	N	"N"
`wheelbarrow	N	"N"
`wheelchair	N	"N"
`wheelhouse	N	"N"
`wheelwright	N	"N"
`whelk	N	"N"
`whetstone	N	"N"
`whey	N	"N"
`whig	N	"N"
`while	N	"N"
`whim	N	"N"
`whimsey	N	"N"
`whimsy	N	"N"
`whip	N-to-V	"N"
`whiplash	N	"N"
`whippet	N	"N"
`whipsaw	N	"N"
`whirligig	N	"N"
`whirlpool	N	"N"
`whirlwind	N	"N"
`whisk	N-to-V	"N"
`whiskey	N	"N"
`whit	N	"N"
`whitecap	N	"N"
`whiteface	N	"N"
`whitetail	N	"N"
`whiting	N	"N"
who`dunit	N	"N"
who`dunnit	N	"N"
`wholesale	N-to-V	"N"
`whoosh	N-to-V	"N"
`whop	N	"N"
`whore	N-to-V	"N"
`whoremonger	N	"N"
`whorl	N	"N"
`wick	N	"N"
`wicker	N	"N"
`wicket	N	"N"
`widget	N	"N"
`widow	N-to-V	"N"
`widower	N	"N"
`width	N	"AJ(`wide)+AJR42"
`wiener	N	"N"
`wig	N	"N"
`wigwam	N	"N"
`wildcard	N	"N"
`wildcat	N	"N"
`wildcatter	N	"N"
`wilderness	N	"N"
`wildfire	N	"N"
`wildlife	N	"N"
`wile	N	"N"
`will	N-to-V	"N"
`willow	N	"N"
`winch	N-to-V	"N"
`wind	N	"N"
`windbag	N	"N"
`windbreak	N	"N"
`windfall	N	"N"
`windlass	N	"N"
`windmill	N	"N"
`window	N	"N"
`windowpane	N	"N"
`windowsill	N	"N"
`windpipe	N	"N"
`windshield	N	"N"
`windstorm	N	"N"
`windup	N	"N"
`wine	N	"N"
`winebibber	N	"N"
`winemaker	N	"N(`wine)+V(`make)+NR19"
`winemaking	N	"N(`wine)+V(`make)+PRG"
`winemaster	N	"N"
`winepress	N	"N"
`winery	N_Suffix1a	"N(`wine)+NR3"
`wineskin	N	"N"
`wing	N-to-V	"N"
`wingspan	N	"N"
`wingtip	N	"N"
`winning	N	"V(`win)+NR24"
`wino	N	"N"
`winter	N-to-V	"N"
`wintertime	N	"N"
`wire	N-to-V	"N"
`wiretap	N-to-V	"N"
`wiring	N	"N(`wire)+NR7"
`wisdom	N_Suffix1a	"AJ(`wise)+NR2"
`wiseacre	N	"N"
`wisecrack	N-to-V	"N"
`wishbone	N	"N"
`wisp	N	"N"
`wit	N	"N"
`witch	N	"N"
`witchcraft	N	"N"
`witchery	N_Suffix1a	"N(`witch)+NR3"
with`holding	N	"V(with`hold)+NR24"
`witness	N-to-V	"N"
`wizard	N	"N"
`wizardry	N_Suffix1a	"N(`wizard)+NR3"
`woe	N	"N"
`wok	N	"N"
`wold	N	"N"
`womenkind	N	"N"
`womb	N	"N"
`wonderland	N	"N"
`wood	N	"N"
`woodchuck	N	"N"
`woodcut	N	"N"
`woodgrain	N	"N"
`woodland	N	"N"
`woodlot	N	"N"
`woodpecker	N	"N"
`woodshed	N	"N"
`woodwind	N	"N"
`woodwork	N	"N"
`woof	N-to-V	"N"
`wool	N	"N"
`wop	N	"N"
`word	N-to-V	"N"
`wording	N	"N(`word).VR0+NR24"
`workbench	N	"N"
`workbook	N	"N"
`workday	N	"N"
`workforce	N	"N"
`workhorse	N	"N"
`workload	N	"N"
`workout	N	"N"
`workplace	N	"N"
`worksheet	N	"N"
`workshop	N	"N"
`workspace	N	"N"
`worktable	N	"N"
`world	N	"N"
`worm	N-to-V	"N"
`wormwood	N	"N"
`worship	N-to-V	"N"
`worsted	N	"N"
`worth	N	"N"
`wound	N-to-V	"N"
`wraith	N	"N"
`wrapup	N	"N"
`wrath	N	"N"
`wreath	N	"N"
`wren	N	"N"
`wretch	N	"N"
`wright	N	"N"
`wrinkle	N-to-V	"N"
`wrist	N	"N"
`wristband	N	"N"
`wristwatch	N	"N"
`writ	N	"N"
`writeup	N	"N"
`writing	N	"V(`write)+NR24"
`wrongdoer	N	"N(`wrong)+V(`do)+NR19"
`wrongdoing	N	"N(`wrong)+V(`do)+PRG"

`x-ray	N-to-V	"N"
`xenon	N	"N"
xeno`phobia	N	"N"
`xylophone	N	"N"

`yacht	N-to-V	"N"
`yahoo	N	"N"
`yak	N	"N"
`yam	N	"N"
`yang	N	"N"
yankee	N	"N"
`yard	N	"N"
`yardage	N_Suffix1a	"N(`yard)+NR1"
`yardstick	N	"N"
`yarmulke	N	"N"
`yarn	N-to-V	"N"
`yarrow	N	"N"
`yawl	N-to-V	"N"
`year	N	"N"
`yearbook	N	"N"
`yeast	N	"N"
`yelp	N-to-V	"N"
`yen	N	"N"
`yeoman	N	"N"
`yeomanry	N_Suffix1a	"N(`yeoman)+NR3"
`yesterday	N	"N"
`yesteryear	N	"N"
`yin	N	"N"
`yo-yo	N	"N"
`yoyo	N	"N"
`yoga	N	"N"
`yoghurt	N	"N"
`yogi	N	"N"
`yogurt	N	"N"
`yoke	N-to-V	"N"
`yokel	N	"N"
`yolk	N	"N"
`yore	N	"N"
`youth	N	"N"
`yucca	N	"N"
`yuppie	N	"N"
`yurt	N	"N"

`zag	N-to-V	"N"
`zeal	N	"N"
`zealot	N	"N"
`zealotry	N_Suffix1a	"N(`zealot)+NR3"
`zebra	N	"N"
`zeitgeist	N	"N"
`zen	N	"N"
`zenith	N	"N"
`zephyr	N	"N"
`zest	N	"N"
`zig	N-to-V	"N"
`zigzag	N-to-V	"N"
`zilch	N	"N"
`zinc	N	"N"
`zipper	N	"N"
`zodiac	N	"N"
`zombi	N	"N"
`zombie	N	"N"
`zone	N-to-V	"N"
`zoo	N	"N"
`zookeeper	N	"N"
`zwieback	N	"N"
`zygote	N	"N"

END
