/* ------------------------------------------------------------------------ */
/* MCGBDUMP.C (C) CopyLeft Bill Buckels 1991-1999                           */
/* All Rights Reversed.                                                     */
/*                                                                          */
/* Licence Agreement                                                        */
/* -----------------                                                        */
/*                                                                          */
/* You have a royalty-free right to use, modify, reproduce and              */
/* distribute this source code in any way you find useful,                  */
/* provided that you agree that Bill Buckels has no warranty obligations    */
/* or liability resulting from said distribution in any way whatsoever.     */
/* If you don't agree, remove this source code from your computer now.      */
/*                                                                          */
/* Written by   : Bill Buckels                                              */
/*                589 Oxford Street                                         */
/*                Winnipeg, Manitoba, Canada R3M 3J2                        */
/*                                                                          */
/* Email: bbuckels@escape.ca                                                */
/* WebSite: http://www.escape.ca/~bbuckels                                  */
/*                                                                          */
/* Purpose      : A memory resident program.                                */
/*                This utility will allow you to grab screens in other      */
/*                programs that use the 320 x 200 x 256 color MCGA video    */
/*                mode and save them to a Windows BMP file.                 */
/*                                                                          */
/* Revision     : 1.0 First Release                                         */
/* ------------------------------------------------------------------------ */
/* Written in Medium Model Mix Power C Version 2.0                          */
/* link with a 4K stack and a 4K heap                                       */
/* ------------------------------------------------------------------------ */


unsigned char BMP_header[]={
0x42, 0x4D, 0x36, 0xFE, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x36, 0x04, 0x00, 0x00, 0x28, 0x00, 
0x00, 0x00, 0x40, 0x01, 0x00, 0x00, 0xC8, 0x00, 
0x00, 0x00, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0xFA, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
0x00, 0x00, 0x00, 0x01, 0x00, 0x00};

#include <bios.h>
#include <stdio.h>
#include <dos.h>


int one_count=0;
int two_count=0;

void interrupt makedump()
{
    FILE *bmpfile;
    unsigned int i, y, x;
    unsigned int temp;
    char *ptr;
    static char far *screenbuffer;
    char *filename="IMAGE000.MCG";
    unsigned frdiv ;
    int frequency = 700;
    int portB;

    disable();

    /* beep before and after */
    frdiv     = 1193180L/frequency;   /* timer divisor */

    outp(0x43,0xB6);           /* write timer mode register  */
    outp(0x42,frdiv & 0xFF);   /* write divisor LSB          */
    outp(0x42,frdiv >> 8);     /* write divisor MSB          */
    portB = inp(0x61);         /* get current port B setting */
    outp(0x61,portB | 0x03);   /* turn speaker on            */
    for(i=0;i<10000;i++);
    outp(0x61,portB);         /* restore port B setting     */
                              /* this turns the speaker off */
                              /* reset the flags            */

    /* make a filename */
    if(one_count==10){
      one_count=0;
      two_count++;
      if(two_count==10)
        two_count=0;
    }
    filename[7]=one_count+48;
    filename[6]=two_count+48;
    one_count++;
    filename[9]= 'B';
    filename[10]='M';
    filename[11]='P';


    bmpfile=fopen(filename,"wb");

    if (NULL != bmpfile) {
      for (i=0; i < sizeof(BMP_header); i++) {
        temp=BMP_header[i];
        fputc(temp,bmpfile);
      }

      /* read color register settings from the DAC and write */
      for (i=0; i<256; i++)
      {
        _AH='\x10';
        _AL='\x15';
        _BX=i;

        geninterrupt(0x10);

        temp=_CL;                    /* RGB Quad Structure b,g,r,0 */
        temp <<=2;
        fputc(temp,bmpfile);
        temp=_CH;
        temp <<= 2;
        fputc(temp,bmpfile);
        temp=_DH;
        temp <<=2;
        fputc(temp,bmpfile);
        fputc(0, bmpfile);
      }

      /* point to the screen and dump it */
      for (y = 200; y > 0; y--) {
        screenbuffer=MK_FP(0xa000,((y-1)*320));
        for (i = 0; i < 320; i++) {
          temp=screenbuffer[i];
          fputc(temp,bmpfile);
        }
      }

      fclose(bmpfile);
    }

    outp(0x43,0xB6);           /* write timer mode register  */
    outp(0x42,frdiv & 0xFF);   /* write divisor LSB          */
    outp(0x42,frdiv >> 8);     /* write divisor MSB          */
    portB = inp(0x61);         /* get current port B setting */
    outp(0x61,portB | 0x03);   /* turn speaker on            */
    for(i=0;i<10000;i++);      /* timing loop                */
    outp(0x61,portB);          /* restore port B setting     */
    enable();

}

main(char argc,int *argv[])
{
    unsigned programsize;

    printf("MCGBDUMP(C) Version 1.0 CopyLeft Bill Buckels 1999\n");
    printf("Uses Prt Scrn as a camera shutter...\n");
    printf("Beeps before and after each capture.\n");
    printf("Saves to a Windows .BMP format.\n");

    setvect(5,makedump);
    programsize=farsetsize(0);
    keep(0, programsize);

}

