DEFINT A-Z
'       VERBALIST
'       Program to demonstrate verb forms
'       by John Higgins
'       Written in Microsoft QuickBasic (PDS 7.1)
'       with Crescent Software's Quickpak PRO7.LIB extensions
'       February - May 1990, revised July 92

'       Subprograms
        DECLARE SUB Barmenu (first, last, default)
        DECLARE SUB Blankline (device)
        DECLARE SUB Buildverb ()
        DECLARE SUB Centreprint (a$, row)
        DECLARE SUB Explain (device)
        DECLARE SUB Giveverb (a)
        DECLARE SUB Mainloop ()
        DECLARE SUB Printat (x, y)
        DECLARE SUB Printgloss ()
        DECLARE SUB Printout ()
        DECLARE SUB Setup ()
        DECLARE SUB Showcont ()
        DECLARE SUB Showmodal ()
        DECLARE SUB Showpassive ()
        DECLARE SUB Showperfect ()
        DECLARE SUB Showstative ()
        DECLARE SUB Showtran ()
        DECLARE SUB Showverbs (device)
        DECLARE SUB Showwarning (a$, r)
        DECLARE SUB Terminate (ask)
        DECLARE SUB Titlescreen ()
        DECLARE SUB Topline ()
        DECLARE SUB Wipe (row1, row2)
        DECLARE SUB Wrap (x$, row, col, lineleng, device)
'       BLPRINT and EDITOR are Quickpak routines in PRO7.LIB
       
        DECLARE FUNCTION Hasaprefix (a$)
        DECLARE FUNCTION Ing$ (a$)
        DECLARE FUNCTION Isavowel (a$)
        DECLARE FUNCTION Keycode ()
        DECLARE FUNCTION Monitor ()             ' Quickpak
        DECLARE FUNCTION PrnReady (dev)         ' Quickpak
        DECLARE FUNCTION Regular$ (a$, p)
        DECLARE FUNCTION Sending$ (a$)
    
'       Constants: most of these are the numbers returned by particular
'       keys when Keycode is called, so that the program recognises
'       which key has been pressed.

        CONST DOWNARROW = 20480
        CONST ENTER = 13
        CONST ESCAPE = 27
        CONST FUNCONE = 15104
        CONST FUNCTWO = 15360
        CONST FUNCTHREE = 15616
        CONST FUNCFOUR = 15872
        CONST FUNCFIVE = 16128
        CONST FUNCSIX = 16384
        CONST FUNCSEVEN = 16640
        CONST FUNCEIGHT = 16896
        CONST FUNCNINE = 17152
        CONST LEFTARROW = 19200
        CONST NONOISE = 23552
        CONST QUITKEY = 17408
        CONST RIGHTARROW = 19712
        CONST UPARROW = 18432
        CONST TRUE = -1
        CONST FALSE = 0

'       Variables common to several parts of the program
        DIM SHARED allnotes, allverbs
        DIM SHARED caspect, comcol, continuous, cperfect, dull
        DIM SHARED strong, ink, modal, mono
        DIM SHARED negative, nextmodal, noise, paper
        DIM SHARED passive, past, perfect, person, question
        DIM SHARED restriction, rule, syllable, testscreen, textcol
        DIM SHARED crlf$, glossary$, mainverb$, pronoun$, tag$, verb$
        DIM SHARED stative$, intran$

        TYPE vrecd
        ' This is the form of record in which information about verbs
        ' is stored in the file VERBLIST.VRB
          spell AS STRING * 24
          limits AS INTEGER
          recpoint AS LONG
          reclong AS INTEGER
          defin AS STRING * 64
        END TYPE

        DIM SHARED vv AS vrecd
      
'       Arrays
'       Shade() tells the program which colours to use for the top
'         four lines, reporting the current sentence pattern.
'       Tense$() is the names of the tenses as shown on the top 3 lines.
'       Ltense$() has unabbreviated tense names for use in paper printout.
'       Choose$() is the set of choices passed to Barmenu.
'       Modal$() has six auxiliary verbs in present and past forms.
'       pp$ has three columns for principal parts of irregular verbs
'       Note$ has notes on usage

        DIM SHARED shade(9, 5), ltense$(9, 3), tense$(9, 3), choose$(34, 1)
        DIM SHARED modal$(6, 1), pp$(3), rule$(39), note$(1)
     
'       Call to Setup and main loop
        Setup
        Mainloop

'       data for tense selection
        DATA Present,"Past   ",
        DATA "     ",modal,emph.
        DATA "       ",perfect,
        DATA "simple  ","contin. ",going to
        DATA "       ",perfect,
        DATA "       ","contin.",
        DATA "active ", passive,
        DATA "affirm. ","negative",
        DATA statement,"question ","ques. tag"

'       data for Barmenu menus
        DATA VERB,Enter a new verb
        DATA PRONOUN,Select a new subject pronoun
        DATA MODAL,Select a new modal verb
        DATA RULES,See all the spelling rules and explanations of terms
        DATA OUTPUT,Copy verb and explanation to the printer or a disk file
        DATA QUIT, Exit to DOS

        DATA " I ",
        DATA " we ",
        DATA " you ",
        DATA " they ",
        DATA " she ",
        DATA " he ",
        DATA " it ",

        DATA shall,
        DATA will,
        DATA can,
        DATA may,
        DATA must,
        
        DATA PRINTER, Print explanations to a parallel printer on LPT1
        DATA DISK FILE, A file called EXPLAIN.VRB will be saved on the default drive
        DATA EXIT,Main menu

        DATA SPELLING,See the full set of spelling rules
        DATA FUTURE,See explanation of modal verbs and the future
        DATA PERFECT,See explanation of perfect aspect
        DATA CONTINUOUS,See explanation of continuous aspect
        DATA STATIVE,See explanation and list of stative verbs
        DATA VOICE,See explanation of the passive voice
        DATA TRANSITIVE,See explanation and list of intransitive verbs
        DATA EXIT,Main menu

        DATA SPELLING,See the full set of spelling rules
        DATA STATIVE,See explanation and list of stative verbs
        DATA TRANSITIVE,See explanation and list of intransitive verbs
        DATA EXIT,Main menu

'       data for lists
        DATA shall,should
        DATA will,would
        DATA can,could
        DATA may,might
        DATA must,had to
        DATA do, did

'       data for rules
        DATA "The verb is not inflected; no spelling rules apply."
        DATA change HAVE to HAS (irregular)
        DATA the verb BE is irregular
        DATA double the last letter and add ES if the verb has less than three syllables and ends in one vowel plus S or Z
        DATA add S if the verb ends in CH after one vowel or Y
        DATA "add ES if the verb ends in S, X, Z, SH, CH or consonant + O"
        DATA change Y to IES if the verb ends in consonant plus Y
        DATA "add S to verbs which do not end in S, Z, SH, CH, consonant + Y or consonant + O"
        DATA add ING if the verb is only two letters long
        DATA change final IE to YING
        DATA "add ING to verbs which end in EE, OE, YE or NGE"
        DATA reverse the last two letters and add ING if the word ends in consonant + RE
        DATA delete the final E and add ING
        DATA add KING if the verb ends in vowel + C
        DATA add ING if the verb ends in two consonants or two vowels plus a consonant
        DATA "add ING to the verb if it ends in a vowel other than E or one of the consonants F, H, J, Q, W, X or Y"
        DATA add ING to verbs of three or more syllables
        DATA "double the last letter and add ING if the verb has two syllables, ends consonant-vowel-consonant, and begins with a Latin prefix"
        DATA double the last letter and add ING if the verb has one syllable and ends consonant-vowel-consonant
        DATA double the L and add ING to a two-syllable verb ending consonant-vowel-L
        DATA "add ING to a two-syllable verb ending in R, N, P or T with stress on the first syllable"
        DATA "double the final consonant and add ING if the verb ends consonant-vowel-consonant and the last consonant is B, D, G, K, M, P, S, V or Z"
        DATA change BE to WAS (irregular)
        DATA change BE to WERE (irregular)
        DATA change BE to BEEN (irregular)
        DATA reverse the last two letters and add ED if the word ends in consonant + RE
        DATA add D to any verb which ends in E
        DATA "if the verb ends consonant-Y, change Y to IED"
        DATA "if the verb ends vowel-Y, add ED"
        DATA "add ED to a verb which ends with any vowel except E or with the consonants F, H, J, Q, W or X"
        DATA add ED to verbs of three or more syllables
        DATA "double the last letter and add ED if the verb has two syllables, ends consonant-vowel-consonant, and begins with a Latin prefix"
        DATA "add ED to a two-syllable verb ending in R, N, P or T with stress on the first syllable"
        DATA double the R and add ED if the verb ends in R preceded by a single vowel other than E
        DATA "double the final consonant and add ED to a one-syllable verb which ends consonant-vowel plus  N, P, R or T"
        DATA add KED if the verb ends in vowel + C
        DATA double the L and add ED to a two-syllable verb which ends consonant-vowel-L
        DATA "double the last consonant and add ED if the verb ends consonant-vowel- consonant and the last consonant is B, D, G, J, K, M, S, V or Z"
        DATA add ED if the verb ends in two consonants or two vowels plus a consonant
        DATA irregular

'       Flow of control:
'       Main program calls Setup and Mainloop
'         Setup sets colours, fills arrays, opens files and calls Titlescreen
'         Mainloop calls Buildverb, Topline, Showverbs,
'         Printgloss and Showwarning
'         and loops through Barmenu 1-5, Topline and Showverbs
'           Buildverb investigates the settings of the tense variables
'           and calls Ing$, Regular$ & Sending$
'             Ing$ adds the -ing ending
'             Regular$ puts an -ed ending on regular verbs
'             Sending adds the 3rd-person s
'             All these functions call the functions Hasaprefix and Isavowel
'               Hasaprefix returns TRUE if word begins with a Latin prefix
'               Isavowel returns TRUE for vowel and FALSE for consonant
'           Topline prints top 4 lines showing status of verb phrase
'           Showverbs calls Wrap and Showwarning
'             Wrap prints text in designated area
'             Showwarning displays messages
'           Barmenu calls Keycode, Wipe, and Buildverb
'             Keycode returns which key was pressed
'             Wipe deletes selected lines
'             Keys F1 to F9 call Buildverb without quitting the loop
'           Barmenu 1 calls Giveverb
'           Barmenu 2 calls Barmenu 6 to 13 to select pronoun
'           Barmenu 3 calls Barmenu 14 to 18 to select modal
'           Barmenu 4 calls Showrule
'           Barmenu 5 calls Explain and Printout
'             Explain calls Wrap, Centreprint and Keycode
'             Printout calls Barmenu 19 to 21
'               Barmenu 19 selects printer for output
'               Barmenu 20 selects disk file for output
'               Barmenu 21 quits from the submenu
'           Barmenu 6 calls Terminate
'             Terminate calls Centreprint and makes orderly exit to DOS
'               Centreprint centres a line of text

SUB Barmenu (first, last, default) STATIC
' provides a Lotus-style menu with explanations
' It uses choose$(), a 2-dimensional array
' with commands in the first column
' and explanations in the second column.
' Default is the ordinal of default choice;
' the choice actually made is transmitted
' to the calling program in the default variable.

  howmany = last - first + 1
  REDIM high(howmany, 2)       ' array to store colours
  linelength = 0
        
  FOR n = 1 TO howmany
    IF n = default THEN
      high(n, 1) = paper          ' foreground if default
      high(n, 2) = ink            ' background if default
    ELSE
      high(n, 1) = ink            ' foreground for word
      high(n, 2) = paper          ' background for word
    END IF
    linelength = linelength + LEN(choose$(n + first - 1, 0))
    ' add length of current command to linelength
  NEXT n
  gap = (80 - linelength) \ (howmany - 1)
  ' space between items

  Wipe 23, 24
  ' flush keyboard buffer
  a$ = "!"
  DO WHILE a$ <> ""
    a$ = INKEY$
  LOOP
         
  DO
    residue = (80 - linelength) MOD (howmany - 1)
    ' pads out the 23rd line if necessary
    Printat 23, 1
    FOR n = 1 TO howmany
      COLOR high(n, 1), high(n, 2)
      PRINT choose$(first + n - 1, 0);
      ' print each command
      COLOR ink, paper
      IF residue > 0 THEN
        PRINT " ";
        residue = residue - 1
      END IF
      PRINT SPACE$(gap);
    NEXT n
    Wipe 24, 24
    thisone = first + default - 1
    ' index of default command
    IF default <> howmany THEN
    ' not the rightmost so print it flush left
      PRINT choose$(thisone, 1);
      ' print the explanation
    ELSE
      offset = 81 - LEN(choose$(thisone, 1))
      ' so that explanation of last command is printed flush right
      PRINT TAB(offset); choose$(thisone, 1);
    END IF
          
    touch = Keycode
    ' get keypress
           
    SELECT CASE touch
      CASE 48 TO 57, 65 TO 90, 97 TO 122
      ' alphabetical character or numeral
        FOR n = first TO last
          match$ = UCASE$(LEFT$(choose$(n, 0), 1)) ' first letter of command
          IF match$ = UCASE$(CHR$(touch)) THEN ' same as keypress
            default = n - first + 1            ' make default
            EXIT DO                            ' and exit Barmenu
          END IF
        NEXT n
        IF noise THEN BEEP            ' impossible letter pressed
             
      CASE UPARROW, LEFTARROW            ' up or left arrow
        IF default > 1 THEN
        ' highlight now at middle or right
          SWAP high(default - 1, 1), high(default - 1, 2)
          ' highlight to left
          SWAP high(default, 1), high(default, 2)
          ' and unlight old
          default = default - 1
          ' change default
        END IF
            
      CASE RIGHTARROW, DOWNARROW
      ' forward or right arrow
        IF default < howmany THEN
        ' now at middle or left
          SWAP high(default + 1, 1), high(default + 1, 2)
          ' highlight to right
          SWAP high(default, 1), high(default, 2)
          ' and unlight old
          default = default + 1
          ' change default
        END IF
           
      CASE 32
      ' space bar pressed
        IF default < howmany THEN
        ' now at middle or left
          SWAP high(default + 1, 1), high(default + 1, 2)
          ' highlight to right
          SWAP high(default, 1), high(default, 2)
          ' and unlight old
          default = default + 1
          ' change default
        ELSE
        ' now at right
          SWAP high(1, 1), high(1, 2)
          ' highlight to right
          SWAP high(default, 1), high(default, 2)
          ' and unlight old
          default = 1
          ' change default
        END IF
            
      CASE ENTER
        EXIT DO               ' enter key pressed, accept settings
            
      CASE ESCAPE
      '  ESCAPE
        default = howmany
        EXIT DO               ' enter key pressed, select quit option
           
      CASE NONOISE
        noise = NOT noise
           
      CASE FUNCONE
      ' f1 for present/past
        IF first = 1 THEN
        ' are we at the main viewing screen?
          SWAP shade(1, 0), shade(1, 2)
          SWAP shade(1, 1), shade(1, 3)
          past = NOT past
          default = 0
          EXIT DO
        ELSE
          IF noise THEN BEEP
        END IF

      CASE FUNCTWO
      ' f2 for modal
        IF first = 1 THEN
          SELECT CASE modal
            CASE 0
            ' swap from no-modal to modal
              SWAP shade(2, 0), shade(2, 2)
              SWAP shade(2, 1), shade(2, 3)
              modal = 1
            CASE 1
            'modal is current selection, swap to emphatic
              IF NOT negative AND NOT perfect AND continuous = 0 THEN
              ' can't have DO HAVE or DO BE or DON'T DO
                noemph = FALSE
              ELSE
                noemph = TRUE
              END IF
              IF NOT noemph AND mainverb$ <> "be" THEN
              ' ok to swap to emphatic
                SWAP shade(2, 2), shade(2, 4)
                SWAP shade(2, 3), shade(2, 5)
                ' swap it to emphatic
                modal = 2
                ' set emphatic
              ELSE
              ' swap back to no-modal
                SWAP shade(2, 2), shade(2, 0)
                SWAP shade(2, 3), shade(2, 1)
                modal = 0
              END IF
            CASE 2
            ' current selection is emphatic, swap to no-modal
              SWAP shade(2, 4), shade(2, 0)
              SWAP shade(2, 5), shade(2, 1)
              ' swap it for simple
              modal = 0
              ' set no modal verb
          END SELECT
          default = 0
          EXIT DO
        ELSE
          IF noise THEN BEEP
        END IF

      CASE FUNCTHREE
      ' f3 for perfect
        IF first = 1 THEN
          SWAP shade(3, 0), shade(3, 2)
          SWAP shade(3, 1), shade(3, 3)
          perfect = NOT perfect
          IF perfect AND modal = 2 THEN
          ' current selection is emphatic
            SWAP shade(2, 4), shade(2, 0)
            SWAP shade(2, 5), shade(2, 1)
            ' swap it for simple
            modal = 0
            ' set no modal verb
          END IF
          default = 0
          EXIT DO
        ELSE
          IF noise THEN BEEP
        END IF

      CASE FUNCFOUR
      ' f4 for simple/continuous
        IF first = 1 THEN
          SELECT CASE continuous
            CASE 0
            ' simple is current selection
              SWAP shade(4, 0), shade(4, 2)
              SWAP shade(4, 1), shade(4, 3)
              ' swap it to continuous
              continuous = 1
              ' set continuous
            CASE 1
            'continuous is current selection
              SWAP shade(4, 2), shade(4, 4)
              SWAP shade(4, 3), shade(4, 5)
              ' swap it to going to
              continuous = 2
            CASE 2
            ' current selection is going to
              SWAP shade(4, 4), shade(4, 0)
              SWAP shade(4, 5), shade(4, 1)
              ' swap it for simple
              continuous = 0
              ' set simple
              IF cperfect THEN
              ' turn off perfect after going to
                SWAP shade(5, 0), shade(5, 2)
                SWAP shade(5, 1), shade(5, 3)
                cperfect = FALSE
              END IF
              IF caspect THEN
              ' turn off continuous after going to
                SWAP shade(6, 0), shade(6, 2)
                SWAP shade(6, 1), shade(6, 3)
                caspect = FALSE
              END IF
          END SELECT
          IF continuous > 0 AND modal = 2 THEN
          ' current selection is emphatic
            SWAP shade(2, 4), shade(2, 0)
            SWAP shade(2, 5), shade(2, 1)
            ' swap it for simple
            modal = 0
            ' set no modal verb
          END IF
          default = 0
          EXIT DO
        ELSE
          IF noise THEN BEEP
        END IF
                
      CASE FUNCFIVE
      ' f5 for perfect after going to
        IF first = 1 AND continuous = 2 THEN
          SWAP shade(5, 0), shade(5, 2)
          SWAP shade(5, 1), shade(5, 3)
          cperfect = NOT cperfect
          default = 0
          EXIT DO
        ELSEIF first = 1 THEN
          GOSUB alertgoing
        ELSE
          IF noise THEN BEEP
        END IF

      CASE FUNCSIX
      ' f6 for continuous after going to
        IF first = 1 AND continuous = 2 THEN
          SWAP shade(6, 0), shade(6, 2)
          SWAP shade(6, 1), shade(6, 3)
          caspect = NOT caspect
          default = 0
          EXIT DO
        ELSEIF first = 1 THEN
          GOSUB alertgoing
        ELSE
          IF noise THEN BEEP
        END IF

      CASE FUNCSEVEN
      ' f7 for active/passive
        IF first = 1 THEN
          SWAP shade(7, 0), shade(7, 2)
          SWAP shade(7, 1), shade(7, 3)
          passive = NOT passive
          default = 0
          EXIT DO
        ELSE
          IF noise THEN BEEP
        END IF

      CASE FUNCEIGHT
      ' f8 for affirmative/negative
        IF first = 1 THEN
          SWAP shade(8, 0), shade(8, 2)
          SWAP shade(8, 1), shade(8, 3)
          negative = NOT negative
          IF negative AND modal = 2 THEN
          ' current selection is emphatic
            SWAP shade(2, 4), shade(2, 0)
            SWAP shade(2, 5), shade(2, 1)
            ' swap it for simple
            modal = 0
            ' set no modal verb
          END IF
          default = 0
          EXIT DO
        ELSE
          IF noise THEN BEEP
        END IF

      CASE FUNCNINE
      ' f9 for statement/question/tag
        IF first = 1 THEN
          SELECT CASE question
            CASE 0
            ' statement is current selection
              SWAP shade(9, 0), shade(9, 2)
              SWAP shade(9, 1), shade(9, 3)
              ' swap it to question
              question = 1
              ' set question
            CASE 1
            'question is current selection
              SWAP shade(9, 2), shade(9, 4)
              SWAP shade(9, 3), shade(9, 5)
              ' swap it to tag
              question = 2
              ' set tag
            CASE 2
            ' current selection is tag
              SWAP shade(9, 4), shade(9, 0)
              SWAP shade(9, 5), shade(9, 1)
              ' swap it for statement
              question = 0
              ' set statement
          END SELECT
          default = 0
          EXIT DO
        ELSE
          IF noise THEN BEEP
        END IF
                
      CASE ELSE
      ' no legal key pressed
        IF noise THEN BEEP
         
    END SELECT

  LOOP
  COLOR ink, paper
  Wipe 23, 24
  EXIT SUB

alertgoing:
  Printat 2, 35
  COLOR comcol
  PRINT "after GOING TO "
  IF noise THEN BEEP
  SLEEP 1
  Printat 2, 35
  COLOR , textcol
  PRINT SPACE$(7);
  COLOR , paper
  PRINT " ";
  COLOR , textcol
  PRINT SPACE$(7)
  RETURN

END SUB

SUB Blankline (device)

  IF device THEN
    CALL BLPRINT(1, crlf$, fixit)
  ELSE
    PRINT #3,
  END IF

END SUB

SUB Buildverb STATIC
' assembles the verb phrase for printing
               
  rule = 0
  ' start by fixing tense
  IF modal > 0 THEN
    firstwd = 2
  ELSEIF perfect THEN
    firstwd = 3
  ELSEIF continuous > 0 THEN
    firstwd = 4
  ELSEIF passive THEN
    firstwd = 5
  ELSE
    firstwd = 1
  END IF

  SELECT CASE firstwd
    CASE 2
    ' modal is filled
      IF modal = 2 THEN
      ' emphatic
        IF past THEN
          verb$ = "did"
        ELSEIF person > 4 THEN
          verb$ = "does"
        ELSE
          verb$ = "do"
        END IF
      ELSE
        verb$ = modal$(nextmodal, ABS(past))
      END IF
      ' writes present or past tense form of modal to first element
      IF negative THEN
        tag$ = verb$ + " "
        IF past THEN
          verb$ = verb$ + "n't "
          IF nextmodal = 5 THEN
            verb$ = "didn't have to "
            tag$ = "did "
          END IF
        ELSE
          SELECT CASE nextmodal
            CASE 1
              verb$ = "shan't "
            CASE 2
              verb$ = "won't "
            CASE 3
              verb$ = "can't "
            CASE 4
              verb$ = "mayn't "
            CASE 5
              verb$ = "mustn't "
          END SELECT
        END IF
      ELSE
        IF past THEN
          tag$ = verb$ + "n't "
          IF nextmodal > 4 OR modal = 2 THEN
            tag$ = "didn't "
          END IF
        ELSEIF modal = 2 THEN
          tag$ = verb$ + "n't "
        ELSE
          SELECT CASE nextmodal
            CASE 1
              tag$ = "shan't "
            CASE 2
              tag$ = "won't "
            CASE 3
              tag$ = "can't "
            CASE 4
              tag$ = "may not "
            CASE ELSE
              tag$ = "mustn't "
          END SELECT
        END IF
        verb$ = verb$ + " "
      END IF
    CASE 3
    ' have is filled but not modal
      IF past THEN
        verb$ = "had"
      ELSEIF person > 4 THEN
        verb$ = "has"
      ELSE
        verb$ = "have"
      END IF
      IF negative THEN
        tag$ = verb$ + " "
        verb$ = verb$ + "n't "
      ELSE
        tag$ = verb$ + "n't "
        verb$ = verb$ + " "
      END IF
    CASE 4, 5
    ' be is filled but not have or modal
      IF past THEN
        IF person = 1 OR person > 4 THEN
          verb$ = "was"
          tag$ = "was"
        ELSE
          verb$ = "were"
          tag$ = "were"
        END IF
      ELSE
        SELECT CASE person
          CASE 1
            IF negative AND question = 1 THEN
            ' special case for "aren't I"
              verb$ = "are"
            ELSE
              verb$ = "am"
              IF negative THEN
                tag$ = "am"
              ELSE
                tag$ = "are"
              END IF
            END IF
          CASE IS > 4
            verb$ = "is"
            tag$ = "is"
          CASE ELSE
            verb$ = "are"
            tag$ = "are"
        END SELECT
      END IF
      IF negative THEN
        tag$ = tag$ + " "
        IF person = 1 AND question <> 1 THEN
        ' special case for "I am not"
          verb$ = verb$ + " not "
        ELSE
          verb$ = verb$ + "n't "
        END IF
      ELSE
        tag$ = tag$ + "n't "
        verb$ = verb$ + " "
      END IF
    CASE ELSE
    ' main verb only
      IF past THEN
        IF mainverb$ = "be" THEN
          IF person = 1 OR person > 4 THEN
            verb$ = "was"
            rule = 22
            tag$ = "was"
          ELSE
            verb$ = "were"
            rule = 23
            tag$ = "were"
          END IF
        ELSEIF mainverb$ = "have" THEN
          verb$ = "had"
          rule = 39
          tag$ = "had"
        ELSEIF negative OR question = 1 THEN
          verb$ = "did"
          tag$ = "did"
        ELSE
          verb$ = Regular$(mainverb$, 2)
          tag$ = "did"
        END IF
      ELSEIF mainverb$ = "be" THEN
        SELECT CASE person
          CASE 1
            verb$ = "am"
            rule = 2
            tag$ = "are"
          CASE 2, 3, 4
            verb$ = "are"
            rule = 2
            tag$ = "are"
          CASE ELSE
            verb$ = "is"
            rule = 2
            tag$ = "is"
        END SELECT
      ELSEIF person > 4 THEN
        IF negative OR question = 1 THEN
        ' question or negative?
          verb$ = "does"
        ELSE
        ' add the 3rd-person s
          verb$ = Sending$(mainverb$)
        END IF
        tag$ = "does"
      ELSEIF negative OR question = 1 THEN
      ' question or negative?
        verb$ = "do"
        tag$ = "do"
      ELSE
      ' verb is main verb
        verb$ = mainverb$
        tag$ = "do"
      END IF
      IF negative THEN
      ' negative
        tag$ = tag$ + " "
        IF verb$ = "am" THEN
          verb$ = verb$ + " not "
        ELSE
          verb$ = verb$ + "n't "
        END IF
      ELSE
        tag$ = tag$ + "n't "
        verb$ = verb$ + " "
      END IF
  END SELECT

  IF firstwd = 2 AND nextmodal = 4 AND NOT past THEN
  ' special case for not contracting NOT
    tag$ = "may " + pronoun$ + "not "
  ELSE
    tag$ = tag$ + RTRIM$(pronoun$)
  END IF
  IF question = 1 THEN
    IF firstwd = 2 AND nextmodal = 5 AND past THEN
    ' modal is MUST/HAVE TO
      IF negative THEN
        verb$ = "didn't " + pronoun$ + "have to "
      ELSE
        verb$ = "did " + pronoun$ + "have to "
      END IF
    ELSE
      verb$ = verb$ + pronoun$
    END IF
  ELSE
    verb$ = pronoun$ + verb$
  END IF
           
  ' at this stage we have the first two words of the phrase
  ' and have to complete it.  We can still us the firstwd variable
  SELECT CASE firstwd
    CASE 2
    ' modal is first element, so no need to change next form
      IF perfect THEN
      ' have is present
        SELECT CASE continuous
          CASE 0
          ' simple
            IF passive THEN
              verb$ = verb$ + "have been "
            ELSE
            ' have but not be
              verb$ = verb$ + "have "
            END IF
            verb$ = verb$ + Regular$(mainverb$, 3)
          CASE 1
          ' continuous
            IF passive THEN
              verb$ = verb$ + "have been being "
              verb$ = verb$ + Regular$(mainverb$, 3)
            ELSE
              verb$ = verb$ + "have been " + Ing$(mainverb$)
            END IF
          CASE ELSE
          ' going to
            IF cperfect THEN
            ' ... going to have ...ed
              IF caspect THEN
              ' ... going to have been ...ing
                IF passive THEN
                  verb$ = verb$ + "have been going to have been being "
                  verb$ = verb$ + Regular$(mainverb$, 3)
                ELSE
                  verb$ = verb$ + "have been going to have been "
                  verb$ = verb$ + Ing$(mainverb$)
                END IF
              ELSE
                IF passive THEN
                  verb$ = verb$ + "have been going to have been "
                ELSE
                  verb$ = verb$ + "have been going to have "
                END IF
                verb$ = verb$ + Regular$(mainverb$, 3)
              END IF
            ELSE
            ' no have
              IF caspect THEN
              ' going to be ...ing
                IF passive THEN
                  verb$ = verb$ + "have been going to be being "
                  verb$ = verb$ + Regular$(mainverb$, 3)
                ELSE
                  verb$ = verb$ + "have been going to be "
                  verb$ = verb$ + Ing$(mainverb$)
                END IF
              ELSE
              ' ... going to ...
                IF passive THEN
                  verb$ = verb$ + "have been going to be "
                  verb$ = verb$ + Regular$(mainverb$, 3)
                ELSE
                  verb$ = verb$ + "have been going to " + mainverb$
                END IF
              END IF
            END IF
        END SELECT
      ELSE
      ' no have
        SELECT CASE continuous
          CASE 0
            IF passive THEN
              IF modal = 2 THEN
                verb$ = verb$ + "get "
              ELSE
                verb$ = verb$ + "be "
              END IF
              verb$ = verb$ + Regular$(mainverb$, 3)
            ELSE
              verb$ = verb$ + mainverb$
            END IF
          CASE 1
          ' continuous
            IF passive THEN
              verb$ = verb$ + "be being "
              verb$ = verb$ + Regular$(mainverb$, 3)
            ELSE
              verb$ = verb$ + "be " + Ing$(mainverb$)
            END IF
          CASE ELSE
          ' going to
            IF cperfect THEN
              IF caspect THEN
                verb$ = verb$ + "be going to have been "
                IF passive THEN
                  verb$ = verb$ + "being "
                  verb$ = verb$ + Regular$(mainverb$, 3)
                ELSE
                  verb$ = verb$ + Ing$(mainverb$)
                END IF
              ELSE
                verb$ = verb$ + "be going to have "
                IF passive THEN verb$ = verb$ + "been "
                verb$ = verb$ + Regular$(mainverb$, 3)
              END IF
            ELSE
              verb$ = verb$ + "be going to "
              IF caspect THEN
                verb$ = verb$ + "be "
                IF passive THEN
                  verb$ = verb$ + "being "
                  verb$ = verb$ + Regular$(mainverb$, 3)
                ELSE
                  verb$ = verb$ + Ing$(mainverb$)
                END IF
              ELSE
                IF passive THEN
                  verb$ = verb$ + "be "
                  verb$ = verb$ + Regular$(mainverb$, 3)
                ELSE
                  verb$ = verb$ + mainverb$
                END IF
              END IF
            END IF
        END SELECT
      END IF
    CASE 3
    ' have is first element
      SELECT CASE continuous
        CASE 0
          IF passive THEN verb$ = verb$ + "been "
          verb$ = verb$ + Regular$(mainverb$, 3)
        CASE 1
        ' be is present
          IF passive THEN
            verb$ = verb$ + "been being "
            verb$ = verb$ + Regular$(mainverb$, 3)
          ELSE
            verb$ = verb$ + "been " + Ing$(mainverb$)
          END IF
        CASE ELSE
        ' going to
          IF cperfect THEN
            IF caspect THEN
            ' going to have been ...ing
              IF passive THEN
              ' .. going to have been being ...ed
                verb$ = verb$ + "been going to have been being "
                verb$ = verb$ + Regular$(mainverb$, 3)
              ELSE
              ' ...going to have been ...ing
                verb$ = verb$ + "been going to have been "
                verb$ = verb$ + Ing$(mainverb$)
              END IF
            ELSE
              IF passive THEN
              ' ...going to have been ...ed
                verb$ = verb$ + "been going to have been "
                verb$ = verb$ + Regular$(mainverb$, 3)
              ELSE
              ' ...going to have ...ed
                verb$ = verb$ + "been going to have "
                verb$ = verb$ + Regular$(mainverb$, 3)
              END IF
            END IF
          ELSE
            IF caspect THEN
              IF passive THEN
              ' been going to be being ...ed
                verb$ = verb$ + "been going to be being "
                verb$ = verb$ + Regular$(mainverb$, 3)
              ELSE
              ' ...been going to be ...ing
                verb$ = verb$ + "been going to be "
                verb$ = verb$ + Ing$(mainverb$)
              END IF
            ELSE
              IF passive THEN
                verb$ = verb$ + "been going to be "
                ' action on verb
                verb$ = verb$ + Regular$(mainverb$, 3)
              ELSE
                verb$ = verb$ + "been going to " + mainverb$
              END IF
            END IF
          END IF
      END SELECT
    CASE 4
    ' be is first element
      IF continuous = 1 THEN
        IF passive THEN
          verb$ = verb$ + "being "
          verb$ = verb$ + Regular$(mainverb$, 3)
        ELSE
          verb$ = verb$ + Ing$(mainverb$)
        END IF
      ELSE
      ' the phrase includes going to
        IF cperfect THEN
        ' ... going to have ...ed
          IF caspect THEN
          ' ... going to have been ...ing
            IF passive THEN
              verb$ = verb$ + "going to have been being "
              verb$ = verb$ + Regular$(mainverb$, 3)
            ELSE
              verb$ = verb$ + "going to have been "
              verb$ = verb$ + Ing$(mainverb$)
            END IF
          ELSE
            IF passive THEN
              verb$ = verb$ + "going to have been "
            ELSE
              verb$ = verb$ + "going to have "
            END IF
            verb$ = verb$ + Regular$(mainverb$, 3)
          END IF
        ELSEIF caspect THEN
        ' ... going to be ...ing
          IF passive THEN
            verb$ = verb$ + "going to be being "
            verb$ = verb$ + Regular$(mainverb$, 3)
          ELSE
            verb$ = verb$ + "going to be "
            verb$ = verb$ + Ing$(mainverb$)
          END IF
        ELSEIF passive THEN
          verb$ = verb$ + "going to be "
          verb$ = verb$ + Regular$(mainverb$, 3)
        ELSE
          verb$ = verb$ + "going to " + mainverb$
        END IF
      END IF
    CASE 5
    ' passive only
      verb$ = verb$ + Regular$(mainverb$, 3)
    CASE ELSE
      IF negative OR question = 1 THEN
        IF mainverb$ <> "be" THEN
          verb$ = verb$ + mainverb$
        END IF
      END IF
  END SELECT

END SUB

SUB Centreprint (a$, row) STATIC
' prints a message in the centre of a line

  offset = (81 - LEN(a$)) / 2
  Printat row, offset
  PRINT a$;
         
END SUB

SUB Explain (device) STATIC
' prints explanation of rules applied in order to create verb
' printing is to printer (device=TRUE) or disk file (device=FALSE)

  dd = device + 2
  ' converts value of device as reported to the Wrap subroutine
  ' in which printer = 1 and diskfile = 2
  only = FALSE
  ' becomes TRUE when all the components of the verb have been
  ' added to the string
  a$ = ""
  b$ = ""
  SELECT CASE person
    CASE 1
      person$ = "first person singular"
    CASE 2
      person$ = "first person plural"
    CASE 3
      person$ = "second person"
    CASE 4
      person$ = "third person plural"
    CASE ELSE
      person$ = "third person singular"
  END SELECT
  a$ = "You have asked about the " + person$ + " of the "
  a$ = a$ + LCASE$(RTRIM$(ltense$(1, 1 - past))) + " "
  a$ = a$ + LCASE$(LTRIM$(ltense$(2, 1 + modal)))
  IF RIGHT$(a$, 1) <> " " THEN a$ = a$ + " "
  a$ = a$ + LCASE$(LTRIM$(ltense$(3, 1 - perfect)))
  IF RIGHT$(a$, 1) <> " " THEN a$ = a$ + " "
  a$ = a$ + LCASE$(RTRIM$(ltense$(4, 1 + continuous)))
  IF RIGHT$(a$, 1) <> " " THEN a$ = a$ + " "
  a$ = a$ + LCASE$(RTRIM$(ltense$(5, 1 - cperfect)))
  IF RIGHT$(a$, 1) <> " " THEN a$ = a$ + " "
  a$ = a$ + LCASE$(RTRIM$(ltense$(6, 1 - caspect)))
  IF RIGHT$(a$, 1) <> " " THEN a$ = a$ + " "
  a$ = a$ + LCASE$(RTRIM$(ltense$(7, 1 - passive))) + " "
  a$ = a$ + LCASE$(RTRIM$(ltense$(8, 1 - negative))) + " "
  a$ = a$ + LCASE$(RTRIM$(ltense$(9, 1 + question))) + " "
  a$ = a$ + "form of the verb " + UCASE$(mainverb$) + "."
  Wrap a$, 1, 1 - 5 * (device), 80 + 10 * (device), dd
  COLOR textcol
  Blankline device
  Showverbs dd
  ' call Showverbs with value 1 or 2 to allow for other routines
  ' calling it with value 0
  COLOR ink
  a$ = "The first element in the verb phrase is "
  IF modal = 1 THEN
    a$ = a$ + "a modal verb "
  ELSEIF modal = 2 THEN
    a$ = a$ + "the verb DO "
  ELSEIF perfect THEN
    a$ = a$ + "the verb HAVE "
  ELSEIF continuous > 0 OR passive THEN
    a$ = a$ + "the verb BE "
  ELSEIF question <> 1 AND NOT negative THEN
    a$ = "The only element of the verb phrase is the main verb "
    only = TRUE
  ELSE
    a$ = "The only element of the verb phrase is the main verb. "
    IF mainverb$ <> "be" THEN
      a$ = a$ + "Since the form is a "
      IF negative THEN
        a$ = a$ + LCASE$(RTRIM$(ltense$(5, 1 - negative))) + " "
      END IF
      a$ = a$ + LCASE$(RTRIM$(ltense$(6, 1 + question)))
      a$ = a$ + ", the dummy auxiliary DO is inserted "
    END IF
    only = TRUE
  END IF
  a$ = a$ + "which needs "
  IF past THEN
    a$ = a$ + "to be put into the past tense. "
    IF modal = 1 THEN
      b$ = "The past tense form of " + UCASE$(modal$(nextmodal, 0))
      b$ = b$ + " is " + UCASE$(modal$(nextmodal, 1)) + ". "
    ELSEIF modal = 2 THEN
      b$ = "The past tense form of DO is DID. "
    ELSEIF perfect THEN
      b$ = "The past tense of HAVE is HAD. "
    ELSEIF continuous THEN
      b$ = "The past tense form of "
      SELECT CASE person
        CASE 1
          b$ = b$ + "AM is WAS. "
        CASE 2, 3, 4
          b$ = b$ + "ARE is WERE. "
        CASE ELSE
          b$ = b$ + "IS is WAS. "
      END SELECT
    ELSEIF question = 1 OR negative THEN
      b$ = "DO is an irregular verb whose past tense form is DID."
    ELSEIF strong THEN
      b$ = UCASE$(mainverb$) + " is an irregular verb whose past tense"
      b$ = b$ + " form is " + UCASE$(pp$(2)) + ". "
    ELSE
      b$ = "The rule for making " + UCASE$(mainverb$) + " past is: "
      b$ = b$ + rule$(rule) + ". "
    END IF
  ELSEIF modal > 0 THEN
    IF modal = 2 AND person > 4 THEN
      a$ = a$ + "to be changed to DOES. "
    ELSE
      a$ = a$ + "no change."
    END IF
  ELSEIF perfect THEN
    IF person > 4 THEN
      a$ = a$ + "to be changed to HAS."
    ELSE
      a$ = a$ + "no change."
    END IF
  ELSEIF continuous THEN
    SELECT CASE person
      CASE 1
        a$ = a$ + "to be changed to AM."
      CASE 2, 3, 4
        a$ = a$ + "to be changed to ARE."
      CASE ELSE
        a$ = a$ + "to be changed to IS."
    END SELECT
  ELSEIF question = 1 OR negative THEN
    IF person > 4 THEN
      a$ = a$ + "an S ending."
      b$ = "The rule for adding S to DO is: " + rule$(5) + ". "
    ELSE
      a$ = a$ + "no change."
    END IF
  ELSEIF person > 4 THEN
    a$ = a$ + "an S ending on the verb."
    b$ = "The rule for adding S to " + UCASE$(mainverb$)
    b$ = b$ + " is: " + rule$(rule) + ". "
  ELSE
    a$ = a$ + "no change."
  END IF

  IF negative THEN
    IF person = 1 THEN
      IF NOT past AND NOT perfect AND continuous > 0 THEN
        a$ = a$ + " The negative word NOT is added. "
        IF question = 1 THEN
          a$ = a$ + " AM NOT is then changed to AREN'T to fit in "
          a$ = a$ + "with normal spoken usage in questions. "
        END IF
      ELSE
        a$ = a$ + " The negative marker N'T is added. "
      END IF
    ELSE
      a$ = a$ + " The negative marker N'T is added. "
    END IF
  END IF

  IF question = 1 THEN
    a$ = a$ + " This element changes places with the pronoun "
    a$ = a$ + "to form a question. "
  END IF

  IF NOT only THEN
    a$ = a$ + " The second element is "
    IF modal > 0 THEN
      IF perfect THEN
        a$ = a$ + "HAVE"
      ELSEIF continuous > 0 OR passive THEN
        IF modal = 2 THEN
          a$ = a$ + "GET"
        ELSE
          a$ = a$ + "BE"
        END IF
      ELSE
        a$ = a$ + UCASE$(mainverb$)
        only = TRUE
      END IF
    ELSEIF perfect THEN
      IF continuous > 0 OR passive THEN
        a$ = a$ + "BEEN"
        IF continuous = 2 THEN a$ = a$ + " GOING TO"
      ELSE
        a$ = a$ + "the past participle of " + UCASE$(mainverb$)
        IF strong THEN
          b$ = b$ + UCASE$(mainverb$) + " is an irregular verb whose past participle"
          b$ = b$ + " form is " + UCASE$(pp$(3)) + ". "
        ELSE
          b$ = b$ + "The rule for making the past participle of "
          b$ = b$ + UCASE$(mainverb$) + " is: " + rule$(rule) + "."
        END IF
        only = TRUE
      END IF
    ELSEIF continuous = 1 THEN
      IF passive THEN
        a$ = a$ + "BEING"
      ELSE
        a$ = a$ + "the present participle of " + UCASE$(mainverb$)
        b$ = b$ + "The rule for making the present participle of "
        b$ = b$ + UCASE$(mainverb$) + " is: " + rule$(rule) + "."
        only = TRUE
      END IF
    ELSEIF continous = 2 THEN
      a$ = a$ + "GOING TO"
    ELSEIF passive THEN
      a$ = a$ + "the past participle of " + UCASE$(mainverb$)
      IF strong THEN
        b$ = b$ + UCASE$(mainverb$) + " is an irregular verb whose past participle"
        b$ = b$ + " form is " + UCASE$(pp$(3)) + ". "
      ELSE
        b$ = b$ + "The rule for making the past participle of "
        b$ = b$ + UCASE$(mainverb$) + " is: " + rule$(rule) + "."
      END IF
      only = TRUE
    END IF
    a$ = a$ + "."
  END IF

  IF NOT only THEN
    a$ = a$ + " The third element is "
    IF modal > 0 THEN
      IF perfect THEN
        IF continuous = 1 THEN
          IF NOT passive THEN
            a$ = a$ + "BEEN, and the final element is "
            a$ = a$ + "the present participle of " + UCASE$(mainverb$)
            b$ = b$ + "The rule for making the present participle of "
            b$ = b$ + UCASE$(mainverb$) + " is: " + rule$(rule) + "."
          ELSE
            a$ = a$ + "BEEN, followed by BEING and the past participle of "
            a$ = a$ + UCASE$(mainverb$)
            IF strong THEN
              b$ = b$ + UCASE$(mainverb$) + " is an irregular verb whose past participle"
              b$ = b$ + " form is " + UCASE$(pp$(3)) + ". "
            ELSE
              b$ = b$ + "The rule for making the past participle of "
              b$ = b$ + UCASE$(mainverb$) + " is: " + rule$(rule) + "."
            END IF
          END IF
        ELSEIF continuous = 2 THEN
          a$ = a$ + "GOING TO, followed by "
          IF cperfect THEN
            a$ = a$ + "HAVE and "
            IF passive THEN a$ = a$ + "BEEN and "
          ELSEIF passive THEN
            a$ = a$ + "BE and "
          END IF
          IF cperfect OR passive THEN
            a$ = a$ + "the past participle of " + UCASE$(mainverb$)
            IF strong THEN
              b$ = UCASE$(mainverb$) + " is an irregular verb whose past tense"
              b$ = b$ + " form is " + UCASE$(pp$(2)) + "."
            ELSE
              b$ = b$ + "The rule for making the past participle of "
              b$ = b$ + UCASE$(mainverb$) + " is: " + rule$(rule) + "."
            END IF
          ELSE
            a$ = a$ + "the plain infinitive of " + UCASE$(mainverb$)
          END IF
        ELSE
          IF passive THEN a$ = a$ + "BEEN and "
          a$ = a$ + "the past participle of " + UCASE$(mainverb$)
          IF strong THEN
            b$ = UCASE$(mainverb$) + " is an irregular verb whose past tense"
            b$ = b$ + " form is " + UCASE$(pp$(2)) + "."
          ELSE
            b$ = b$ + "The rule for making the past participle of "
            b$ = b$ + UCASE$(mainverb$) + " is: " + rule$(rule) + "."
          END IF
        END IF
      ELSE
        IF continuous = 1 THEN
          IF passive THEN
            a$ = a$ + "BEING and the past participle of " + UCASE$(mainverb$)
            b$ = b$ + "The rule for making the past participle of "
            b$ = b$ + UCASE$(mainverb$) + " is: " + rule$(rule) + "."
          ELSE
            a$ = a$ + "the present participle of " + UCASE$(mainverb$)
            b$ = b$ + "The rule for making the present participle of "
            b$ = b$ + UCASE$(mainverb$) + " is: " + rule$(rule) + "."
          END IF
        ELSEIF continuous = 2 THEN
          IF cperfect THEN
            IF passive THEN
              a$ = a$ + "HAVE BEEN and the past participle of " + UCASE$(mainverb$)
              b$ = b$ + "The rule for making the past participle of "
              b$ = b$ + UCASE$(mainverb$) + " is: " + rule$(rule) + "."
            ELSE
              a$ = a$ + "HAVE and the past participle of " + UCASE$(mainverb$)
              b$ = b$ + "The rule for making the past participle of "
              b$ = b$ + UCASE$(mainverb$) + " is: " + rule$(rule) + "."
            END IF
          ELSE
            IF passive THEN
              a$ = a$ + "BE and the past participle of " + UCASE$(mainverb$)
              b$ = b$ + "The rule for making the past participle of "
              b$ = b$ + UCASE$(mainverb$) + " is: " + rule$(rule) + "."
            ELSE
              a$ = a$ + UCASE$(mainverb$)
            END IF
          END IF
        ELSE
          IF passive THEN
            a$ = a$ + "the past participle of " + UCASE$(mainverb$)
            b$ = b$ + "The rule for making the past participle of "
            b$ = b$ + UCASE$(mainverb$) + " is: " + rule$(rule) + "."
          END IF
        END IF
      END IF
    ELSE
      IF continuous = 1 THEN
        IF passive THEN
          a$ = a$ + "BEING and the past participle of " + UCASE$(mainverb$)
          b$ = b$ + "The rule for making the past participle of "
          b$ = b$ + UCASE$(mainverb$) + " is: " + rule$(rule) + "."
        ELSE
          a$ = a$ + "the present participle of " + UCASE$(mainverb$)
          b$ = b$ + "The rule for making the present participle of "
          b$ = b$ + UCASE$(mainverb$) + " is: " + rule$(rule) + "."
        END IF
      ELSEIF continuous = 2 THEN
        IF passive THEN
          a$ = a$ + "BE and the past participle of " + UCASE$(mainverb$)
          b$ = b$ + "The rule for making the past participle of "
          b$ = b$ + UCASE$(mainverb$) + " is: " + rule$(rule) + "."
        ELSE
          a$ = a$ + UCASE$(mainverb$)
        END IF
      ELSE
        a$ = a$ + "the past participle of " + UCASE$(mainverb$)
        b$ = b$ + "The rule for making the past participle of "
        b$ = b$ + UCASE$(mainverb$) + " is: " + rule$(rule) + "."
      END IF
    END IF
    a$ = a$ + "."
  END IF
  IF INSTR(b$, "consonant") > 0 AND INSTR(mainverb$, "qu") > 0 THEN
    b$ = b$ + " (QU counts as a consonant.)"
  END IF
  Wrap a$, 6, 1 - 5 * (device), 80 + 10 * (device), dd
  Blankline device
  x = CSRLIN
  Wrap b$, x + 2, 1 - 5 * (device), 80 + 10 * (device), dd

END SUB

        SUB Giveverb (aln) STATIC
        ' get entry from user

          note$(0) = ""
          DO
            Wipe 23, 24
            Centreprint "(One word only)", 24
            Printat 23, 1
            PRINT "Enter a verb: ";
            DO
              vb$ = SPACE$(24)
              CALL Editor(vb$, ll, sc, 0, 0, 113, 113, 23, 15)
              vb$ = LTRIM$(RTRIM$(vb$))
            LOOP UNTIL INSTR(vb$, " ") = 0    ' one word verbs only
            vb$ = LCASE$(vb$)
            IF LEN(vb$) < 2 THEN EXIT SUB
            yes = TRUE
            FOR n = 1 TO 5
              FOR m = 0 TO 1
                IF vb$ = modal$(n, m) THEN
                  Wipe 24, 24
                  Centreprint "Do you really mean `to " + vb$ + "'?  (Y/N)", 24
                  ' user has entered a modal verb form
                  yes = Keycode
                  yes = (yes = 121 OR yes = 89)
                  EXIT FOR
                END IF
              NEXT m
            NEXT n
            IF NOT yes THEN EXIT SUB
            
            ' search for vb$ in VERBLIST.VRB
            strong = 0
            IF allverbs > 0 THEN
              pointer = allverbs \ 2
              ' middle of the list
              increment = pointer \ 2
              ' half of what is left
              retried = 0
              DO
                IF pointer > (allverbs - 1) THEN pointer = allverbs - 1
                IF pointer < 1 THEN pointer = 1
                GET #1, pointer, vv
                IF vb$ = LTRIM$(RTRIM$(vv.spell)) THEN
                ' we have found the verb
                  IF vv.recpoint > 0 AND vv.reclong > 0 THEN
                  ' are there any notes
                    nn$ = SPACE$(vv.reclong)
                    GET #2, vv.recpoint, nn$
                    IF (vv.limits AND 1) = 1 THEN
                    ' marked as strong verb
                    ' so look for principal parts in notes
                      strong = TRUE
                      chop = INSTR(nn$, "\")
                      chop2 = INSTR(nn$, " ")
                      IF chop > 0 THEN
                        s$ = LEFT$(nn$, chop - 1)
                        ' principal parts
                        note$(0) = MID$(nn$, chop + 1)
                        ' cut the principal parts out of the notes
                        IF chop2 > 0 THEN
                          pp$(2) = LEFT$(s$, chop2 - 1)
                          ' past tense
                          pp$(3) = MID$(s$, chop2 + 1)
                          ' past participle
                        END IF
                        s$ = ""
                      END IF
                    ELSE
                      note$(0) = nn$
                    END IF
                  ELSE
                    strong = FALSE
                  END IF
                  EXIT DO
                ELSEIF vb$ < LTRIM$(RTRIM$(vv.spell)) THEN
                ' we need to look earlier in the list
                  pointer = pointer - increment
                  ' reduce pointer
                ELSEIF vb$ > LTRIM$(RTRIM$(vv.spell)) THEN
                ' we need to look later
                  pointer = pointer + increment
                  ' increase pointer
                END IF
                IF increment MOD 2 = 1 THEN
                ' divide by 2 and round up
                  increment = increment \ 2 + 1
                ELSE
                  increment = increment \ 2
                END IF
                IF increment = 1 THEN retried = retried + 1
                IF retried > 3 THEN
                  vv.spell = vb$
                  vv.defin = "unrecognised verb"
                  vv.limits = 4
                  EXIT DO
                END IF
              LOOP
            ELSE
              vv.spell = vb$
              vv.defin = "unrecognised verb"
              vv.limits = 4
              vv.recpoint = 0
              vv.reclong = 0
            END IF
            IF (vv.limits AND 1) = 1 AND (vv.limits AND 2) <> 2 THEN
              Wipe 24, 24
              a$ = "Do you really mean: to " + vb$ + ".  (Y/N)"
              ' user has entered a word which is the oblique form of
              ' a strong verb
              Centreprint a$, 24
              COLOR ink
              yes = Keycode
              IF UCASE$(CHR$(yes)) = "Y" THEN
                IF (vv.limits AND 4) <> 4 THEN
                  vv.defin = "unrecognised verb"
                  vv.limits = 4
                END IF
                EXIT DO
              END IF
            ELSE
              EXIT DO
            END IF
          LOOP

          mainverb$ = vb$
          ' how many syllables?
          syllable = 0
          n = 1
          DO WHILE n < LEN(mainverb$)
            z$ = MID$(vb$, n, 1)
            IF Isavowel(z$) AND NOT Isavowel(MID$(vb$, n + 1, 1)) THEN
              syllable = syllable + 1
            ELSEIF z$ = "y" AND n > 1 THEN
              IF NOT Isavowel(MID$(vb$, n - 1, 1)) AND NOT Isavowel(MID$(vb$, n + 1, 1)) THEN
                syllable = syllable + 1
              END IF
            END IF
            n = n + 1
          LOOP
          IF MID$(vb$, n, 1) <> "e" THEN
            z$ = MID$(vb$, n, 1)
            IF (Isavowel(z$) OR z$ = "y") AND NOT Isavowel(MID$(vb$, n - 1, 1)) THEN
              syllable = syllable + 1
            END IF
          END IF
         
        END SUB

        FUNCTION Hasaprefix (a$) STATIC
        ' returns TRUE if a$ begins with a Latin prefix

          Hasaprefix = FALSE
          IF LEN(a$) > 3 AND syllable < 3 THEN
            IF LEFT$(a$, 2) = "re" THEN
              c = Isavowel(MID$(a$, 3, 1))
              cc = Isavowel(MID$(a$, 4, 1))
              IF (c OR cc) AND a$ <> "reason" THEN Hasaprefix = TRUE
              EXIT FUNCTION
            END IF
            check = INSTR("ad/be/de/ex/in/im/oc/un", LEFT$(a$, 2))
            IF check > 0 AND a$ <> "exit" THEN
              Hasaprefix = TRUE
              EXIT FUNCTION
            END IF
          END IF
         
          IF LEN(a$) > 4 AND syllable < 3 THEN
            check = INSTR("con/com/for/mis/out/pre/per/sub", LEFT$(a$, 3))
            IF check > 0 THEN
              Hasaprefix = TRUE
              EXIT FUNCTION
            END IF
          END IF
         
          IF LEN(a$) > 5 THEN
            check = INSTR("over", LEFT$(a$, 4))
            IF check > 0 THEN
              Hasaprefix = TRUE
              EXIT FUNCTION
            END IF
          END IF
         
          IF LEN(a$) > 6 THEN
            check = INSTR("handi/inter/super/trans/under", LEFT$(a$, 5))
            IF check > 0 THEN Hasaprefix = TRUE
          END IF

        END FUNCTION

        FUNCTION Ing$ (a$) STATIC
        ' adds -ing to a verb
       
          x$ = RIGHT$(a$, 1)
          ' last letter of word
          y$ = MID$(a$, LEN(a$) - 1, 1)
          ' second-last letter
          IF LEN(a$) > 2 THEN
            z$ = MID$(a$, LEN(a$) - 2, 1)
          ELSE
            z$ = "a"
          END IF
          ' third-last letter
          IF LEN(a$) > 3 THEN
            zz$ = MID$(a$, LEN(a$) - 3, 1)
          ELSE
            zz$ = "a"
          END IF
          ' fourth-last letter

          SELECT CASE x$
           
            CASE "e"
            ' word ends in -e
              IF LEN(a$) < 3 THEN
              ' must be verb to be
                Ing$ = a$ + "ing"
                rule = 8
              ELSEIF y$ = "i" THEN
              ' word ends in ie
                Ing$ = LEFT$(a$, LEN(a$) - 2) + "ying"
                rule = 9
              ELSEIF y$ = "e" OR y$ = "o" OR y$ = "y" THEN
              ' word ends in double e, oe or ye
                Ing$ = a$ + "ing"
                rule = 10
              ELSEIF y$ = "g" AND z$ = "n" AND Isavowel(zz$) THEN
              ' verb ends in inge or onge or unge
                Ing$ = a$ + "ing"
                rule = 10
              ELSEIF y$ = "r" AND NOT Isavowel(z$) THEN
              ' word ends in consonant + re
                Ing$ = LEFT$(a$, LEN(a$) - 2) + "ering"
                rule = 11
              ELSE
              ' all other letter + e endings
                Ing$ = LEFT$(a$, LEN(a$) - 1) + "ing"
                rule = 12
                ' so drop the final e
              END IF
           
            CASE "c"
            ' ends in c
              IF Isavowel(y$) AND NOT Isavowel(z$) THEN
              ' eg picnic/picnicking
                Ing$ = a$ + "king"
                rule = 13
              ELSE
                Ing$ = a$ + "ing"
                rule = 14
              END IF
           
            CASE "a", "f", "h", "i", "j", "o", "q", "u", "w", "x", "y"
            ' single-f, j and q only possible in loan words
              Ing$ = a$ + "ing"
              rule = 15
           
            CASE ELSE
            ' ends in b, d, g, k, l, m, n, p, r, s, t, v, or z
              IF Isavowel(y$) AND (NOT Isavowel(z$) OR zz$ = "q") THEN
              ' word ends in one consonant preceded by one vowel
                SELECT CASE x$
                  CASE "r"
                  ' word ends in r
                    IF syllable > 2 THEN
                      Ing$ = a$ + "ing"
                      rule = 16
                    ELSEIF Hasaprefix(a$) OR a$ = "conquer" THEN
                    ' stress on second syllable so double the last letter
                      Ing$ = a$ + RIGHT$(a$, 1) + "ing"
                      rule = 17
                    ELSEIF syllable = 1 THEN
                    ' words like stir, bar, etc
                      Ing$ = a$ + RIGHT$(a$, 1) + "ing"
                      ' double the final consonant
                      rule = 18
                    ELSE
                    ' words like offer and cater
                      Ing$ = a$ + "ing"
                      rule = 20
                    END IF
                  CASE "t"
                    IF (syllable > 2 AND NOT Hasaprefix(a$)) OR a$ = "interpret" THEN
                      Ing$ = a$ + "ing"
                      rule = 16
                    ELSEIF syllable > 1 THEN
                    ' word ends in vowel + t
                      IF Hasaprefix(a$) OR a$ = "emit" OR a$ = "omit" THEN
                      ' stress on second syllable so double the last letter
                        Ing$ = a$ + RIGHT$(a$, 1) + "ing"
                        rule = 17
                      ELSE
                      ' words like visit,  audit
                        Ing$ = a$ + "ing"
                        rule = 20
                      END IF
                    ELSE
                    ' word is one-syllable,
                    ' so double final consonant
                      Ing$ = a$ + RIGHT$(a$, 1) + "ing"
                      rule = 18
                    END IF
                  CASE "n"
                    IF syllable > 2 THEN
                      Ing$ = a$ + "ing"
                      rule = 16
                    ELSEIF syllable = 2 THEN
                    ' word ends in vowel+n or vowel+t
                      IF Hasaprefix(a$) > 0 THEN
                      ' stress on second syllable so double the last letter
                        Ing$ = a$ + RIGHT$(a$, 1) + "ing"
                        rule = 17
                      ELSE
                      ' words like listen
                        Ing$ = a$ + "ing"
                        rule = 20
                      END IF
                    ELSE
                    ' word is one-syllable,
                    ' so double final consonant
                      Ing$ = a$ + RIGHT$(a$, 1) + "ing"
                      rule = 18
                    END IF
                  CASE "l"
                    IF syllable > 2 THEN
                      Ing$ = a$ + "ing"
                      rule = 16
                    ELSEIF syllable = 1 THEN
                      Ing$ = a$ + RIGHT$(a$, 1) + "ing"
                      rule = 18
                    ELSE
                      Ing$ = a$ + RIGHT$(a$, 1) + "ing"
                      rule = 19
                    END IF
                  CASE "p"
                    IF syllable > 2 AND NOT Hasaprefix(a$) THEN
                      Ing$ = a$ + "ing"
                      rule = 16
                    ELSEIF syllable = 1 THEN
                      Ing$ = a$ + RIGHT$(a$, 1) + "ing"
                      rule = 18
                    ELSEIF Hasaprefix(a$) OR a$ = "equip" THEN
                      Ing$ = a$ + RIGHT$(a$, 1) + "ing"
                      rule = 17
                    ELSE
                      Ing$ = a$ + "ing"
                      rule = 20
                    END IF
                  CASE ELSE
                  ' other than r, l, t or n
                    IF syllable > 2 AND NOT Hasaprefix(a$) THEN
                      Ing$ = a$ + "ing"
                      rule = 16
                    ELSE
                      Ing$ = a$ + RIGHT$(a$, 1) + "ing"
                      rule = 21
                    END IF
                    ' so double the last letter
                END SELECT
              ELSE
                Ing$ = a$ + "ing"
                rule = 14
              END IF
           
          END SELECT

        END FUNCTION

        FUNCTION Isavowel (a$) STATIC
        ' returns TRUE if a$ is a vowel, FALSE otherwise

          SELECT CASE ASC(a$)
            CASE 65, 97, 69, 101, 73, 105, 79, 111, 85, 117
              Isavowel = TRUE
            CASE ELSE
              Isavowel = FALSE
          END SELECT

        END FUNCTION

        FUNCTION Keycode STATIC
        ' waits for a keypress and then returns its number
        ' including complex numbers for function or combination keys

          DO
            k$ = INKEY$
            LOOP UNTIL k$ <> ""
          Keycode = CVI(k$ + CHR$(0))

        END FUNCTION

SUB Mainloop STATIC
' calls Barmenu for user decisions

  syllable = 1
  COLOR , paper
  Wipe 22, 22
  COLOR paper, textcol
  Centreprint " * PRESS ANY KEY TO BEGIN * ", 22
  a = Keycode
  COLOR textcol, paper
  CLS
  Buildverb
  warning = FALSE
  Topline          ' prints current tense selection
  Showverbs FALSE
  Printgloss
  a$ = "You can use the function keys f1 to f9 to look at "
  a$ = a$ + "different forms of the verb phrase. "
  Showwarning a$, TRUE
  a$ = ""
         
  DO
    Action = 1
    Barmenu 1, 6, Action
    Wipe 17, 21
    SELECT CASE Action
      CASE 0
      ' Key f1 to f9 pressed
        Buildverb
      CASE 1
        Giveverb allnotes
        Printgloss
        Buildverb
      CASE 2
        person = 1
        Barmenu 7, 13, person
        pronoun$ = LTRIM$(choose$(person + 6, 0))
        Buildverb
      CASE 3
        nextmodal = 1
        Barmenu 14, 18, nextmodal
        Buildverb
      CASE 4
        ' look at pages of spelling rules or usage notes
        seescreen = 1
        DO
          IF Monitor > 3 THEN
            Barmenu 22 - (rule = 0), 29, seescreen
            ' if EGA and no spelling rules then 23 - 29 else 22 - 29
          ELSEIF Monitor > 2 THEN
            Barmenu 30 - (rule = 0), 33, seescreen
            ' if CGA and no spelling rules then 31 - 34 else 30 - 34
          ELSE
            EXIT DO
          END IF
          seescreen = seescreen - (rule = 0)
          ' add 1 to selection if no spelling rule
          IF seescreen = 8 + 4 * (Monitor < 4) THEN EXIT DO  ' EXIT chosen
          SCREEN 0, , seescreen, seescreen
          ' switch to text page contain selected rules or notes
          seescreen = 8 + (rule = 0) + 4 * (Monitor < 4)
          ' subtract 1 if no spelling rule and set to EXIT value
        LOOP
        SCREEN 0, , 0, 0
        ' switch back to normal screen page
      CASE 5
        Printout
      CASE ELSE
        Terminate TRUE
    END SELECT
    Topline        ' prints current tense selection
    Showverbs FALSE
  LOOP

END SUB

SUB Printat (x, y) STATIC

  LOCATE x, y, 0

END SUB

        SUB Printgloss STATIC
        ' prints the definition and notes lines

          c$ = "to " + LCASE$(mainverb$) + ": " + vv.defin
          COLOR textcol
          Wipe 14, 18
          Wrap c$, 14, 2, 78, FALSE

          COLOR textcol
          Wrap note$(0), 15, 2, 78, FALSE

        END SUB

SUB Printout STATIC
' printing routines to copy verb and explanation

  Action = 1
  Barmenu 19, 21, Action
  SELECT CASE Action
    CASE 1
      IF PrnReady(1) THEN
        Explain TRUE
        CALL BLPRINT(1, CHR$(12), fixit)
      END IF
    CASE 2
      OPEN "explain.vrb" FOR APPEND AS #3
      IF LOF(3) > 5000 THEN
      ' getting too big
        CLOSE #3
        OPEN "explain.bak" FOR APPEND AS #3
        ' make sure there will be a back-up file to delete
        CLOSE #3
        KILL "explain.bak"
        ' delete it
        NAME "explain.vrb" AS "explain.bak"
        ' turn the current file into a backup
        OPEN "explain.vrb" FOR OUTPUT AS #3
        ' and start a new one
      END IF
      Explain FALSE
      PRINT #3,
      CLOSE #3
    CASE ELSE
    ' exit chosen, so no action needed
  END SELECT

END SUB

        FUNCTION Regular$ (a$, p) STATIC
        ' adds -ed ending to weak verbs for past tense or participle

          IF strong THEN
          ' this is a strong verb
            Regular$ = pp$(p)
            rule = 39
            EXIT FUNCTION
          END IF

          x$ = RIGHT$(a$, 1)
          y$ = MID$(a$, LEN(a$) - 1, 1)
          ' second last letter
          IF LEN(a$) > 2 THEN
            z$ = MID$(a$, LEN(a$) - 2, 1)
          ELSE
            z$ = "a"
          END IF
          ' third last letter
          IF LEN(a$) > 3 THEN
            zz$ = MID$(a$, LEN(a$) - 3, 1)
          ELSE
            zz$ = "a"
          END IF
          ' fourth-last letter
         
          IF a$ = "be" THEN
            Regular$ = "been"
            rule = 24
            EXIT FUNCTION
          END IF
         
          SELECT CASE x$
            CASE "e"
              IF y$ = "r" AND NOT Isavowel(z$) THEN
              ' word ends in consonant + re
                Regular$ = LEFT$(a$, LEN(a$) - 2) + "ered"
                rule = 25
              ELSE
                Regular$ = a$ + "d"
                rule = 26
              END IF
            CASE "y"
              IF NOT Isavowel(y$) THEN
                Regular$ = LEFT$(a$, LEN(a$) - 1) + "ied"
                rule = 27
              ELSE
                Regular$ = a$ + "ed"
                rule = 28
              END IF
            CASE "a", "f", "h", "i", "j", "o", "q", "u", "w", "x"
              Regular$ = a$ + "ed"
              rule = 29
            CASE ELSE
              IF Isavowel(y$) AND (NOT Isavowel(z$) OR zz$ = "q") THEN
              ' ends in a single consonant preceded by single vowel
                SELECT CASE x$
                  CASE "r"
                  ' word ends in r
                    IF syllable > 2 THEN
                      Regular$ = a$ + "ed"
                      rule = 30
                    ELSEIF Hasaprefix(a$) AND a$ <> "conquer" THEN
                    ' stress on second syllable so double the last letter
                      Regular$ = a$ + RIGHT$(a$, 1) + "ed"
                      rule = 31
                    ELSEIF syllable = 1 THEN
                    ' words like stir, bar, etc
                      Regular$ = a$ + RIGHT$(a$, 1) + "ed"
                      ' double the final consonant
                      rule = 34
                    ELSE
                    ' words like offer, utter, cater
                      Regular$ = a$ + "ed"
                      rule = 32
                    END IF
                  CASE "t"
                    IF syllable > 2 AND NOT Hasaprefix(a$) OR a$ = "interpret" THEN
                      Regular$ = a$ + "ed"
                      rule = 30
                    ELSEIF syllable > 1 THEN
                      IF Hasaprefix(a$) OR a$ = "emit" OR a$ = "omit" THEN
                      ' stress on second syllable so double the last letter
                        Regular$ = a$ + RIGHT$(a$, 1) + "ed"
                        rule = 31
                      ELSE
                      ' words like visit, audit
                        Regular$ = a$ + "ed"
                        rule = 32
                      END IF
                    ELSE
                    ' word is one-syllable,
                    ' so double final consonant
                      Regular$ = a$ + RIGHT$(a$, 1) + "ed"
                      rule = 34
                    END IF
                  CASE "n"
                    IF syllable > 2 AND NOT Hasaprefix(a$) THEN
                      Regular$ = a$ + "ed"
                      rule = 30
                    ELSEIF syllable = 2 THEN
                      IF Hasaprefix(a$) THEN
                      ' stress on second syllable so double the last letter
                        Regular$ = a$ + RIGHT$(a$, 1) + "ed"
                        rule = 31
                      ELSE
                      ' words like listen
                        Regular$ = a$ + "ed"
                        rule = 32
                      END IF
                    ELSE
                    ' word is one-syllable,
                    ' so double final consonant
                      Regular$ = a$ + RIGHT$(a$, 1) + "ed"
                      rule = 34
                    END IF
                  CASE "c"
                  ' eg frolic, panic, picnic, shellac
                    Regular$ = a$ + "ked"
                    rule = 35
                  CASE "l"
                    IF syllable > 2 THEN
                      Regular$ = a$ + "ed"
                      rule = 30
                    ELSE
                      Regular$ = a$ + RIGHT$(a$, 1) + "ed"
                      rule = 36
                    END IF
                  CASE "p"
                    IF syllable > 2 AND NOT Hasaprefix(a$) THEN
                      Regular$ = a$ + "ed"
                      rule = 30
                    ELSEIF syllable = 1 THEN
                      Regular$ = a$ + RIGHT$(a$, 1) + "ed"
                      rule = 34
                    ELSEIF Hasaprefix(a$) OR a$ = "equip" THEN
                      Regular$ = a$ + RIGHT$(a$, 1) + "ed"
                      rule = 31
                    ELSE
                      Regular$ = a$ + "ed"
                      rule = 32
                    END IF
                  CASE ELSE
                  ' b, d, g, j, k, m, s, v, z
                  ' preceded by one vowel but not two
                    IF syllable > 2 AND NOT Hasaprefix(a$) THEN
                      Regular$ = a$ + "ed"
                      rule = 30
                    ELSE
                      Regular$ = a$ + RIGHT$(a$, 1) + "ed"
                      rule = 37
                    END IF
                    ' so double the last letter
                END SELECT
              ELSE
                Regular$ = a$ + "ed"
                rule = 38
              END IF

          END SELECT
          
        END FUNCTION

        FUNCTION Sending$ (a$) STATIC
        ' adds -s to a verb

          IF a$ = "have" THEN
            Sending$ = "has"
            rule = 1
            EXIT FUNCTION
          END IF

          x$ = RIGHT$(a$, 1)
          ' last letter
          y$ = MID$(a$, LEN(a$) - 1, 1)
          ' second last letter
          IF LEN(a$) > 2 THEN
            z$ = MID$(a$, LEN(a$) - 2, 1)
          ELSE
            z$ = ""
          END IF
          ' third-last letter

          IF LEN(a$) > 3 THEN
            zz$ = MID$(a$, LEN(a$) - 3, 1)
          ELSE
            zz$ = ""
          END IF
          ' fourth-last letter

          SELECT CASE x$
            CASE "s", "z"
              IF Isavowel(y$) AND (NOT Isavowel(z$) OR zz$ = "q") THEN
                IF syllable < 3 THEN
                  Sending$ = a$ + RIGHT$(a$, 1) + "es"
                  ' double the s or z after a single vowel
                  rule = 3
                ELSE
                  Sending$ = a$ + "es"
                  rule = 5
                END IF
              ELSE
                Sending$ = a$ + "es"
                rule = 5
              END IF
            CASE "x"
                Sending$ = a$ + "es"
                rule = 5
            CASE "h"
              IF y$ = "c" AND (Isavowel(z$) OR z$ = "y") AND NOT Isavowel(zz$) THEN
                Sending$ = a$ + "s"
                rule = 4
              ELSEIF y$ = "c" OR y$ = "s" THEN
                Sending$ = a$ + "es"
                rule = 5
              ELSE
                Sending$ = a$ + "s"
                rule = 7
              END IF
            CASE "y"
              IF NOT Isavowel(y$) THEN
                Sending$ = LEFT$(a$, LEN(a$) - 1) + "ies"
                rule = 6
              ELSE
                Sending$ = a$ + "s"
                rule = 7
              END IF
            CASE "o"
              IF NOT Isavowel(y$) THEN
                Sending$ = a$ + "es"
                rule = 5
              ELSE
                Sending$ = a$ + "s"
                rule = 7
              END IF
            CASE ELSE
              Sending$ = a$ + "s"
              rule = 7
          END SELECT

        END FUNCTION

SUB Setup STATIC
' starting values and run Titlescreen

  noise = TRUE
  IF INSTR(COMMAND$, "M") > 0 OR Monitor < 3 THEN mono = TRUE
  IF mono THEN
    ink = 7
    paper = 0
    textcol = 7
    comcol = 15
    dull = 8          ' for unhighlighted element in lines 2/3
  ELSE
    ink = 0                 ' black instructions
    paper = 7               ' on white
    textcol = 1             ' blue text
    comcol = 4
    dull = 8
  END IF
  SCREEN 0
  WIDTH 80
  COLOR ink, paper
  CLS
  Titlescreen
  RESTORE
  FOR n = 1 TO 9          ' read in headings
    FOR m = 1 TO 3        ' for up to three forms of the seven
      READ ltense$(n, m)  ' tenses used in the selector panel
      tense$(n, m) = ltense$(n, m)    '  (top 4 lines)
    NEXT m
  NEXT n

  ' modify entries in ltense$ (the explaining array)
  ltense$(2, 3) = "emphatic"
  ltense$(4, 2) = "continuous"
  ltense$(5, 2) = "with perfect"
  ltense$(6, 2) = "with continuous"
  ltense$(8, 1) = "affirmative"
  ltense$(9, 3) = "statement with question tag"
          
  FOR n = 1 TO 33          ' read in actions for Barmenu
    READ choose$(n, 0)
    READ choose$(n, 1)
  NEXT n
  FOR n = 1 TO 6           ' read in present and past forms
    READ modal$(n, 0)      ' of the modal verbs
    READ modal$(n, 1)
  NEXT n
  FOR n = 0 TO 39           ' read in descriptive rules
    READ rule$(n)
  NEXT n
  FOR n = 1 TO 9
    IF mono THEN
      shade(n, 0) = ink + 8      ' starting colours for the
      shade(n, 1) = paper        ' tense selection panel
      shade(n, 2) = dull         ' on the top 3 lines
      shade(n, 3) = paper
      shade(n, 4) = dull
      shade(n, 5) = paper
    ELSE
      shade(n, 0) = paper + 8
      shade(n, 1) = textcol
      shade(n, 2) = dull
      shade(n, 3) = paper
      shade(n, 4) = dull
      shade(n, 5) = paper
    END IF
  NEXT n
  ' initial settings for pattern
  past = FALSE
  modal = FALSE
  perfect = FALSE
  continuous = FALSE
  caspect = FALSE
  cperfect = FALSE
  negative = FALSE
  question = FALSE
  person = 1
  strong = FALSE
  nextmodal = 3
  crlf$ = CHR$(13) + CHR$(10)
  pronoun$ = "I "
  ' Open files of data
  f$ = "VERBLIST.VRB"
  ' contains verbs, usage restrictions, and definitions
  a$ = DIR$(f$)
  IF a$ <> "" THEN
    OPEN f$ FOR RANDOM ACCESS READ AS #1 LEN = 96
    allverbs = LOF(1) \ 96
    ' total of verbs to be recognised
    FOR n = 1 TO allverbs
      GET #1, n, vv
      IF (vv.limits AND 8) = 8 THEN
        intran$ = intran$ + LTRIM$(RTRIM$(vv.spell)) + " "
      END IF
      IF (vv.limits AND 64) = 64 OR (vv.limits AND 128) = 128 THEN
        stative$ = stative$ + RTRIM$(vv.spell) + " "
      END IF
    NEXT n
  ELSE
    allverbs = 0
  END IF
  mainverb$ = "walk"             ' starting verb
  vv.limits = 22
  vv.defin = "(1) move on one's feet; (2) take an animal out for exercise"
  f$ = "VERBNOTE.VRB"
  ' contains principal parts of strong verbs and usage notes
  IF DIR$(f$) <> "" THEN
    OPEN f$ FOR BINARY ACCESS READ AS #2
    allnotes = LOF(2)
  ELSE
    allnotes = 0
  END IF
  ' prepare pages of notes on screen pages 2 to 7
  IF Monitor < 3 THEN EXIT SUB
  ' no screen pages available for mono adapters
  Showmodal
  Showperfect
  Showcont
  Showstative
  Showpassive
  Showtran

END SUB

SUB Showcont STATIC

  IF Monitor < 4 THEN EXIT SUB
  SCREEN 0, , 4, 0
  COLOR ink, paper
  CLS
  Centreprint "Note on continuous aspect", 1
  PRINT " A continuous verb contains a form of the verb BE, followed by an -ING form, "
  PRINT " sometimes called a present participle."
  COLOR textcol
  PRINT TAB(10); "We are waiting for a 59 bus."; TAB(43); "We must have been waiting for hours."
  COLOR ink
  PRINT " The present continuous can refer to something that is happening at the"
  PRINT " time that the speaker is speaking:"
  COLOR textcol
  PRINT TAB(10); "... and Mansell is gaining on Senna ..."
  COLOR ink
  PRINT " You can use it to emphasise that something is temporary:"
  COLOR textcol
  PRINT TAB(10); "We are living in one room, but we hope to move into a flat soon."
  COLOR ink
  PRINT " You can also use present continuous to talk about future arrangements: "
  COLOR textcol
  PRINT TAB(10); "Our daughter is going on holiday in June."
  COLOR ink
  PRINT " It is sometimes used with the word ALWAYS to talk about repeated events, but"
  PRINT " this usually expresses disapproval or complaint."
  COLOR textcol
  PRINT TAB(10); "My car is always breaking down."
  COLOR ink
  PRINT " The past continuous is often used when you are talking about interrupted"
  PRINT " events:"
  COLOR textcol
  PRINT TAB(10); "What were you doing when the lights went out?";

  SCREEN 0, , 0, 0
END SUB

SUB Showmodal STATIC

  IF Monitor < 4 THEN EXIT SUB
  SCREEN 0, , 2, 0
  COLOR ink, paper
  CLS
  Centreprint "Note on modal verbs and the future", 1
  PRINT " English has no future tense. When we talk about future time we can use the"
  PRINT " present tense forms:"
  COLOR textcol
  PRINT TAB(10); "The train leaves at 6."; TAB(43); "I'm seeing him tomorrow."
  COLOR ink
  PRINT " or we can use GOING TO, especially when talking about things that are"
  PRINT " inevitable or things that we plan or intend to do:"
  COLOR textcol
  PRINT TAB(10); "It's going to rain."; TAB(43); "I'm going to get my own back."
  COLOR ink
  PRINT " GOING TO can be followed by perfect and/or continuous forms:"
  COLOR textcol
  PRINT TAB(10); "Soon I'm going to have been waiting for an hour."
  COLOR ink
  PRINT " We can also refer to the future with the modal verbs WILL and SHALL."
  COLOR textcol
  PRINT TAB(10); "Our visitors will be here quite soon."
  PRINT TAB(10); "I shall offer them a cup of coffee."
  COLOR ink
  PRINT " Both WILL and SHALL are commonly abbreviated to 'LL in written-down forms"
  PRINT " of conversation and pronounced with the weak-form /l/ in speech."
  COLOR textcol
  PRINT TAB(10); "We'll be back next year. I hope you'll be ready for us."
  COLOR ink
  PRINT " It doesn't matter whether you say WILL or SHALL in statements after the"
  PRINT " words I or WE. The difference only shows up in questions, where SHALL is"
  PRINT " used for offers and WILL for predictions."
  COLOR textcol
  PRINT TAB(10); "Shall I open a window?"; TAB(43); "Will I get a knighthood?"
  COLOR ink
  PRINT " After other pronouns or nouns, WILL is normal; SHALL shows unusual emphasis."
  COLOR textcol
  PRINT TAB(10); "Your car will be ready at 6.     They shall not conquer!"
  SCREEN 0, , 0, 0

END SUB

SUB Showpassive STATIC

  IF Monitor < 4 THEN EXIT SUB
  SCREEN 0, , 6, 0
  COLOR ink, paper
  CLS
  Centreprint "Note on passive voice", 1
  PRINT " We use the passive voice when we are more interested in what happened to"
  PRINT " somebody or something than in what caused the event."
  COLOR textcol
  PRINT TAB(10); "The conservatives have been re-elected."
  PRINT TAB(10); "5 million copies of The Sun are sold every day."
  PRINT TAB(10); "What happened to you?  I was knocked down by a car."
  COLOR ink
  PRINT " To turn an active sentence into a passive one, make the original object of"
  PRINT " the verb into the subject and replace the active verb with a form of the"
  PRINT " verb BE and a past participle."
  COLOR textcol
  PRINT TAB(10); "A thief stole my keys."; TAB(43); "My keys were stolen."
  COLOR ink
  PRINT " The original active subject can be left out or put into a BY phrase."
  COLOR textcol
  PRINT TAB(10); "My keys were stolen by that man over there."

  SCREEN 0, , 0, 0

END SUB

SUB Showperfect STATIC

  IF Monitor < 4 THEN EXIT SUB
  SCREEN 0, , 3, 0
  COLOR ink, paper
  CLS
  Centreprint "Note on PERFECT aspect", 1
  PRINT " To make a verb phrase perfect you include a form of the verb HAVE, either"
  PRINT " at the beginning of the phrase or after the modal verb or after GOING TO."
  PRINT " The next form within the phrase must be a past participle."
  COLOR textcol
  PRINT TAB(10); "I have finished."; TAB(43); "Nobody has done it better."
  COLOR ink
  PRINT " The words HAVE, HAS or HAD may be abbreviated to 'VE, 'S or 'D after"
  PRINT " pronouns in written-down forms of conversation and would usually be"
  PRINT " pronounced with the corresponding weak-forms in speech."
  COLOR textcol
  PRINT TAB(10); "I've finished."; TAB(43); "What's he bought?"
  COLOR ink
  PRINT " The present perfect is used to talk about the present results of past events"
  PRINT " when you are not interested in precisely when or how the event took place."
  COLOR textcol
  PRINT TAB(10); "I have lost my watch. Has anybody seen it?"
  COLOR ink
  PRINT " The past perfect is common in reported speech, conditional clauses, and"
  PRINT " when talking about two events in the past and saying which one came first."
  COLOR textcol
  PRINT TAB(10); "He said that he had never tasted caviare."
  PRINT TAB(10); "If you hadn't been in such a hurry, you would have seen us."
  PRINT TAB(10); "I bought the book after I had seen the film."
  COLOR ink
  PRINT " The perfect often occurs with words like JUST, EVER, NEVER, ALREADY, and"
  PRINT " with time phrases using SINCE."
  SCREEN 0, , 0, 0

END SUB

SUB Showstative STATIC
' prepare screen for notes on stative verbs

  IF Monitor < 4 THEN
    SCREEN 0, , 2, 0
  ELSE
    SCREEN 0, , 5, 0
  END IF
  COLOR ink, paper
  CLS
  Centreprint "Note on STATIVE VERBS", 1
  PRINT " Most verbs refer to actions or conditions which can start or stop:"
  COLOR textcol
  PRINT TAB(10); "I live in Bristol."; TAB(40); "I used to drive a large car."
  COLOR ink
  PRINT " These verbs can be used in continuous or simple forms:"
  COLOR textcol
  PRINT TAB(10); "Where were you living when you got married?"
  PRINT TAB(10); "You are driving too fast."
  COLOR ink
  PRINT " Some verbs, called stative verbs, refer to states which can begin but which"
  PRINT " cannot be stopped in a sudden or deliberate way:"
  COLOR textcol
  PRINT TAB(10); "I believe you."; TAB(40); "I know what it looks like."
  COLOR ink
  PRINT " They cannot be used in continuous forms. We do not say: * I am believing"
  PRINT " what you tell me. However, some verbs have both a normal and a stative use:"
  COLOR textcol
  PRINT TAB(10); "He was feeling sick."; TAB(40); "I felt that it was all over."
  COLOR ink
  PRINT " The stative verbs in the database are:"
  COLOR textcol
  Wrap (stative$), 14, 3, 75, FALSE
  SCREEN 0, , 0, 0

END SUB

SUB Showtran STATIC
' prepare screen for notes on intransitive verbs

  IF Monitor < 4 THEN
    SCREEN 0, , 3, 0
  ELSE
    SCREEN 0, , 7, 0
  END IF
  COLOR ink, paper
  CLS
  Centreprint "Note on TRANSITIVE and INTRANSITIVE verbs", 1
  PRINT " Verbs which are transitive can have an object and can be made passive:"
  COLOR textcol
  PRINT TAB(10); "I bought a ticket."; TAB(43); "A ticket was bought."
  COLOR ink
  PRINT " With some transitive verbs you can include the object or leave it out:"
  COLOR textcol
  PRINT TAB(10); "I ate ten sandwiches."; TAB(43); "It's time to eat."
  COLOR ink
  PRINT " Intransitive verbs cannot have an object (though verbs like SEEM or LAST can"
  PRINT " be followed by a noun phrase called a complement) and cannot be made passive:"
  COLOR textcol
  PRINT TAB(10); "Islands appeared in the lake."; TAB(43); "The song lasts 10 minutes."
  COLOR ink
  PRINT " (You cannot say: * They were appeared. or * 10 minutes is lasted by the song.)"
  PRINT " The intransitive verbs in the database are:"
  COLOR textcol
  Wrap (intran$), 11, 3, 76, FALSE
  SCREEN 0, , 0, 0

END SUB

SUB Showverbs (device) STATIC
' put whole of verb phrase into box with correct punctuation
' device has value 0 for screen, 1 for printer and 2 for diskfile

  note$(1) = ""
  dd = device - 2       ' for blank line routine
  redbox = FALSE
  ' will become TRUE if a grammatical anomaly occurs
  IF continuous = 1 OR caspect THEN
    IF (vv.limits AND 64) = 64 THEN
      note$(1) = note$(1) + "This is a stative verb and is not "
      note$(1) = note$(1) + "normally used in continuous forms. "
      redbox = TRUE
    ELSEIF (vv.limits AND 128) = 128 THEN
      note$(1) = note$(1) + "This may be a stative verb. Be careful "
      note$(1) = note$(1) + "about using it in continuous forms. "
    END IF
  END IF
  IF (vv.limits AND 256) = 256 OR (vv.limits AND 512) = 512 THEN
    IF person <> 4 AND person <> 7 AND NOT passive THEN
    ' impersonal verb with personal subject
      note$(1) = note$(1) + "This is normally an impersonal verb. "
      IF (vv.limits AND 256) = 256 THEN redbox = TRUE
    END IF
  END IF
  IF (vv.limits AND 4096) = 4096 THEN
    IF person <> 4 AND person <> 7 AND passive THEN
    ' inanimate object (eg write) verb with personal subject
      note$(1) = note$(1) + "Only things can be the subject of "
      note$(1) = note$(1) + "this passive verb. "
      redbox = TRUE
    END IF
  END IF
  a$ = verb$
  a$ = UCASE$(LEFT$(a$, 1)) + RTRIM$(MID$(a$, 2)) + " ..."
  IF question = 1 THEN
    a$ = a$ + " ?"
  ELSEIF question = 2 THEN
    a$ = a$ + ", " + tag$ + "?"
  END IF
  SELECT CASE rule
    CASE 1 TO 7
      b$ = "The rule for adding -s to " + UCASE$(mainverb$) + " is: "
    CASE 8 TO 21
      b$ = "The rule for adding -ing to " + UCASE$(mainverb$) + " is: "
    CASE 22, 23
      b$ = "The rule for making " + UCASE$(mainverb$) + " past is: "
    CASE 24 TO 39
      IF NOT perfect AND NOT passive AND NOT cperfect THEN
        b$ = "The rule for making " + UCASE$(mainverb$) + " past is: "
      ELSE
        b$ = "The rule for making the past participle of "
        b$ = b$ + UCASE$(mainverb$) + " is: "
      END IF
      IF passive THEN
        IF (vv.limits AND 8) = 8 THEN
          note$(1) = note$(1) + "This is an intransitive verb and is "
          note$(1) = note$(1) + "not normally used in the passive. "
          redbox = TRUE
        ELSEIF (vv.limits AND 16) = 16 THEN
          note$(1) = note$(1) + "This verb is often intransitive. Be "
          note$(1) = note$(1) + "careful about using it in the passive. "
        END IF
      END IF
    CASE ELSE
      b$ = ""
  END SELECT
  IF b$ <> "" THEN b$ = b$ + rule$(rule) + "."
  IF redbox THEN
    COLOR comcol
  ELSE
    COLOR textcol
  END IF
  Wrap a$, 7, 14 + 6 * (device > 0), 54 - 10 * (device > 0), device
  ' print verb phrase in box
  IF LEN(note$(1)) > 0 THEN Showwarning note$(1), redbox
  COLOR ink
  Wipe 11, 13
  Wrap b$, 11, 2, 78, FALSE
  IF device > 0 THEN Blankline dd

  SCREEN 0, , 1, 0      ' reprint relevant page of spelling rules
  COLOR ink, paper
  CLS
  here = 3
  SELECT CASE rule
    CASE 1 TO 7
      COLOR comcol
      Centreprint "-S ENDING RULES", 1
      COLOR textcol
      FOR n = 1 TO 7
        Printat here, 1
        PRINT LTRIM$(STR$(n)); ": ";
        r$ = rule$(n)
        Wrap r$, here, 4, 77, FALSE
        here = CSRLIN + 1
      NEXT n
    CASE 8 TO 21
      COLOR comcol
      Centreprint "-ING ENDING RULES", 1
      COLOR textcol
      FOR n = 8 TO 21
        Printat here, 1
        PRINT LTRIM$(STR$(n)); ": ";
        r$ = rule$(n)
        Wrap r$, here, 5, 77, FALSE
        here = CSRLIN + 1
      NEXT n
    CASE 22 TO 39
      COLOR comcol
      Centreprint "-ED ENDING RULES", 1
      here = 2
      COLOR textcol
      FOR n = 25 TO 38
        Printat here, 1
        PRINT LTRIM$(STR$(n)); ": ";
        r$ = rule$(n)
        Wrap r$, here, 5, 77, FALSE
        here = CSRLIN + 1
      NEXT n
    CASE ELSE
      COLOR textcol
      Wrap (rule$(0)), here, 1, 79, FALSE
  END SELECT
  SCREEN 0, , 0, 0
  COLOR ink, paper

END SUB

SUB Showwarning (a$, red) STATIC
' uses lines 17 to 20 to print messages about verb usage

  Wipe 17, 21
  COLOR paper
  row = 18
  ' print message invisibly and use the value of row returned
  ' by the Wrap routine to calculate the size of box needed.
  Wrap (a$), row, 8, 64, FALSE
  COLOR textcol
  IF red THEN COLOR comcol
  IF row = 20 THEN
    Printat 17, 6
  ELSE
    Printat 18, 6
  END IF
  PRINT ""; STRING$(66, ""); ""
  IF row = 20 THEN
    Printat 18, 6
    PRINT ""; SPACE$(66); ""
  END IF
  Printat 19, 6
  PRINT ""; SPACE$(66); ""
  Printat 20, 6
  PRINT ""; SPACE$(66); ""
  Printat 21, 6
  PRINT ""; STRING$(66, ""); ""
  IF row = 20 THEN
    Wrap (a$), 18, 8, 64, FALSE
  ELSE
    Wrap (a$), 19, 8, 64, FALSE
  END IF
          
END SUB

SUB Terminate (ask) STATIC
' orderly exit to DOS

  IF ask THEN
    COLOR comcol
    Wipe 23, 24
    Centreprint "Leave VERBALIST?  (Y/N)", 23
    COLOR ink
    yes = Keycode
    IF yes > 126 OR UCASE$(CHR$(yes)) <> "Y" THEN EXIT SUB
  END IF
  SCREEN 0
  WIDTH 80
  COLOR 7, 0, 0
  CLS
  END
          
END SUB

        SUB Titlescreen STATIC
        ' puts up title

          COLOR paper, textcol
          Wipe 3, 8
          Printat 4, 35
          PRINT "                      "
          PRINT TAB(16); "ɻ    ͻ  ͻ  ͻ  ͻ       ͻ  "
          PRINT TAB(17); "    ͼ                    ͻ  "
          PRINT TAB(17); "ͼ         ͼ        ͼ  ͼ"
         
          Printat 11, 19
          COLOR textcol, paper
          PRINT ""; STRING$(41, ""); ""
          Printat 12, 19
          PRINT ""; SPACE$(41); ""
          Printat 13, 19
          PRINT ""; SPACE$(41); ""
          Printat 14, 19
          PRINT ""; SPACE$(41); ""
          Printat 15, 19
          PRINT ""; SPACE$(41); ""
          Printat 16, 19
          PRINT ""; STRING$(41, ""); ""
          Centreprint "A program to demonstrate English verbs", 12
          Centreprint "by John and Muriel Higgins", 13
          Centreprint "Version 1.1, May 1992", 15
          COLOR paper, textcol
          Centreprint " Reading dictionaries; please wait. ", 22
         
        END SUB

        SUB Topline STATIC
        ' prints the top menu lines and the verb box

          FOR n = 1 TO 9
            COLOR ink, paper
            SELECT CASE n
              CASE 1
                Printat 1, 1
              CASE 2
                Printat 1, 10
              CASE 3
                Printat 1, 17
              CASE 4
                Printat 1, 26
              CASE 5
                Printat 1, 35
              CASE 6
                Printat 1, 43
              CASE 7
                Printat 1, 52
              CASE 8
                Printat 1, 61
              CASE ELSE
                Printat 1, 71
            END SELECT
            PRINT "f"; MID$(STR$(n), 2);
            COLOR shade(n, 0), shade(n, 1)
            SELECT CASE n
              CASE 1
                Printat 2, 1
              CASE 2
                Printat 2, 10
              CASE 3
                Printat 2, 17
              CASE 4
                Printat 2, 26
              CASE 5
                Printat 2, 35
              CASE 6
                Printat 2, 43
              CASE 7
                Printat 2, 52
              CASE 8
                Printat 2, 61
              CASE ELSE
                Printat 2, 71
            END SELECT
            PRINT tense$(n, 1)
            COLOR shade(n, 2), shade(n, 3)
            SELECT CASE n
              CASE 1
                Printat 3, 1
              CASE 2
                Printat 3, 10
              CASE 3
                Printat 3, 17
              CASE 4
                Printat 3, 26
              CASE 5
                Printat 3, 35
              CASE 6
                Printat 3, 43
              CASE 7
                Printat 3, 52
              CASE 8
                Printat 3, 61
              CASE ELSE
                Printat 3, 71
            END SELECT
            PRINT tense$(n, 2)
            COLOR shade(n, 4), shade(n, 5)
            SELECT CASE n
              CASE 1
                Printat 4, 1
              CASE 2
                Printat 4, 10
              CASE 3
                Printat 4, 17
              CASE 4
                Printat 4, 26
              CASE 5
                Printat 4, 35
              CASE 6
                Printat 4, 43
              CASE 7
                Printat 4, 52
              CASE 8
                Printat 4, 61
              CASE ELSE
                Printat 4, 71
            END SELECT
            PRINT tense$(n, 3)
            COLOR textcol, paper
          NEXT n

          Printat 6, 12
          COLOR textcol
          PRINT ""; STRING$(55, ""); ""
          Printat 7, 12
          PRINT ""; SPACE$(55); ""
          Printat 8, 12
          PRINT ""; SPACE$(55); ""
          Printat 9, 12
          PRINT ""; STRING$(55, ""); ""
          
        END SUB

        SUB Wipe (row1, row2) STATIC
        ' wipes selected screen areas
        
          FOR n = row1 TO row2
            Printat n, 1
            PRINT SPACE$(80);
          NEXT n

          Printat row1, 1
        
        END SUB

        SUB Wrap (x$, row, col, linelen, device) STATIC
        ' prints text in defined screen area
        ' device is 0 for screen, 1 for printer and 2 for diskfile

          DO
            Printat row, col
            IF LEN(x$) < linelen THEN
              SELECT CASE device
                CASE 1
                  CALL BLPRINT(1, SPACE$(col) + x$ + crlf$, fixit)
                CASE 2
                  PRINT #3, TAB(col); x$
                CASE ELSE
                  PRINT x$;
              END SELECT
              EXIT DO
            ELSE
              fit = linelen
              IF RIGHT$(x$, 1) = "?" THEN fit = fit - 2
              ' ensures that question mark is not only item on the line
              DO WHILE MID$(x$, fit, 1) <> " "
                fit = fit - 1
                IF fit = 0 THEN
                  fit = linelen
                  EXIT DO
                END IF
              LOOP
              SELECT CASE device
                CASE 1
                  CALL BLPRINT(1, SPACE$(col) + LEFT$(x$, fit - 1) + crlf$, fixit)
                CASE 2
                  PRINT #3, TAB(col); LEFT$(x$, fit - 1)
                CASE ELSE
                  PRINT LEFT$(x$, fit - 1)
              END SELECT
              x$ = LTRIM$(MID$(x$, fit))
              row = row + 1
              IF row > 23 AND device = 0 THEN EXIT SUB
            END IF
          LOOP

        END SUB

