/* ---------------------------------------------------------------------- */
/*   BEN.c (C) Copyright Bill Buckels 1991-1999                           */
/*   All Rights Reserved.                                                 */
/*                                                                        */
/*   Licence Agreement                                                    */
/*   -----------------                                                    */
/*                                                                        */
/*   Little Ben is distributed as FreeWare.                               */
/*                                                                        */
/*   You have a royalty-free right to use, modify, reproduce and          */
/*   distribute this source code (and/or any modified version) in any     */
/*   way you find useful, provided you do not compete with Bill Buckels   */
/*   or his agents, and that you agree that Bill Buckels has no warranty  */
/*   obligations or liability whatsoever resulting from any associated    */
/*   loss or damage.                                                      */
/*                                                                        */
/*   If you do not agree with these terms, remove this source and         */
/*   all associated files from your computer now.                         */
/*                                                                        */
/*   Description                                                          */
/*   -----------                                                          */
/*                                                                        */
/*   A clock program template                                             */
/*   Written by Bill Buckels March 1991 in Mix Power C                    */
/* ---------------------------------------------------------------------- */

/*

a radian is the measure of an angle with its with vertex at the
center of a circle whose intercepted arc on the circle is equal
in length to the radius of the circle...

 - allyn j. washington

*/

#include <dos.h>
#include <graphics.h>
#include <bios.h>
#include <math.h>
#include <stdio.h>

#define ESCKEY     27  /* character generated by the Esc key            */
#define FUNCKEY    0   /* first character generated by function keys    */
#define UPARROW    'H' /* second character generated by up-arrow key    */
#define DOWNARROW  'P' /* second character generated by down-arrow key  */
#define LEFTARROW  'K' /* second character generated by left-arrow key  */
#define RIGHTARROW 'M' /* second character generated by right-arrow key */

#define ENGLISH 0
#define FRENCH  1
int language = ENGLISH;
int oldlanguage= ENGLISH;

struct vconfig _videostuff;
float aspect_rat;
char timestuff[2][40];
char stuffcords[2][2]={0,182,
                       0,24};

void circlepoints(x,y,baselength ,fdegrees)
int *x,*y;
int baselength;
float fdegrees;
{
     /* convert from degrees to radians */
     /* in order to use trig functions  */
     float pi=3.1415926535;
     float radians;
     float tempx= (float)baselength;
     float tempy= (float)baselength;
     int degrees= (int)fdegrees;

     switch(degrees)
     {
       case 360 :
       case 0   : *y-=(int)(aspect_rat*baselength);break;
       case 180 : *y+=(int)(aspect_rat*baselength);break;

       case 90  : *x+=baselength;break;
       case 270 : *x-=baselength;break;

     default    :

     /* positive angles - all quadrants */
     if(degrees > 0  && degrees <=45  || degrees >= 315 && degrees < 360||
        degrees > 90 && degrees <=135 || degrees >= 225 && degrees < 270)
     {
       radians = (pi*degrees)/180;
       tempx*= sin(radians);
       tempy*= cos(radians);
       *x+=(int)tempx;
       *y-=(int)(tempy*aspect_rat);
      }

    /*  negative angles - all quadrants */
     if(degrees > 45 && degrees < 90   || degrees < 315 && degrees > 270 ||
        degrees > 135 && degrees < 180 || degrees > 180 && degrees < 225)
     {
       degrees = 90-degrees;
       radians = (pi*degrees)/180;
       tempx*= cos(radians);
       tempy*= sin(radians);
       *x+=(int)tempx;
       *y-=(int)(tempy*aspect_rat);
      }
    }

}

char *hourstrings[14][2]={
     "Twelve", "douze",
     "One",    "une",
     "Two",    "deux",
     "Three",  "trois",
     "Four",   "quatre",
     "Five",   "cinq",
     "Six",    "six",
     "Seven",  "sept",
     "Eight",  "huit",
     "Nine",   "neuf",
     "Ten",    "dix",
     "Eleven", "onze",
     "Twelve", "douze",
     "One",    "une" };

char *minutestrings[31][2]={
     "O\'clock",      "heure",
     "One",           "une",
     "Two",           "deux",
     "Three",         "trois",
     "Four",          "quatre",
     "Five",          "cinq",
     "Six",           "six",
     "Seven",         "sept",
     "Eight",         "huit",
     "Nine",          "neuf",
     "Ten",           "dix",
     "Eleven",        "onze",
     "Twelve",        "douze",
     "Thirteen",      "treize",
     "Fourteen",      "quatorze",
     "Quarter",       "quart",
     "Sixteen",       "seize",
     "Seventeen",     "dix-sept",
     "Eighteen",      "dix-huit",
     "Nineteen",      "dix-neuf",
     "Twenty",        "vingt",
     "Twenty-One",    "vingt et un",
     "Twenty-Two",    "vingt-deux",
     "Twenty-Three",  "vingt-trois",
     "Twenty-Four",   "vingt-quatre",
     "Twenty-Five",   "vingt-cinq",
     "Twenty-Six",    "vingt-six",
     "Twenty-Seven",  "vingt-sept",
     "Twenty-Eight",  "vingt-huit",
     "Twenty-Nine",   "vingt-neuf",
     "Thirty",        "et demie"};


void dohands(hour,minute,oldhour,oldminute)
int hour, minute,oldhour,oldminute;
{
   int x1=160, y1=106, x2, y2;
   int hourbase=50, minutebase=64;
   char minister[33];

   float hourdegrees, oldhourdegrees;
   float minutedegrees, oldminutedegrees;

   minutedegrees=(float)6*minute;
   oldminutedegrees=(float)6*oldminute;

       /* update the written display first */
       pen_color(0);
       stuffcords[0][0]=x1-(strlen(timestuff[0])*4);
       move_to(stuffcords[0][0],stuffcords[0][1]);
       plots(timestuff[0]);
       stuffcords[1][0]=x1-(strlen(timestuff[1])*4);
       move_to(stuffcords[1][0],stuffcords[1][1]);
       plots(timestuff[1]);

       if(language==FRENCH)
       {
       switch(minute)
       {
          case 0 :  if(hour==1)
                       sprintf(timestuff[0],"une heure");
                    else
                     sprintf(timestuff[0],"%s heures",
                                    hourstrings[hour][language]);
                                    break;
          case 15:  if(hour==1)
                       sprintf(timestuff[0],"une heure et quart");
                    else
                     sprintf(timestuff[0],"%s heures et quart",
                                          hourstrings[hour][language]);
                                          break;
          case 30:  if(hour==1)
                       sprintf(timestuff[0],"une heure et demie");
                    else
                       sprintf(timestuff[0],"%s heures et demie",
                                    hourstrings[hour][language]);
                                    break;
          case 45:  if(hour==12||hour==0)
                       sprintf(timestuff[0],"une heure moins le quart");
                    else
                       sprintf(timestuff[0],"%s heures moins le quart",
                                      hourstrings[hour+1][language]);
                                      break;

          default:
                   if(minute<30)
                   {
                   if(hour==1)
                       sprintf(timestuff[0],"une heure %s",
                               minutestrings[minute][language]);
                   else
                      sprintf(timestuff[0],"%s heures %s",
                           hourstrings[hour][language],
                           minutestrings[minute][language]);
                   break;
                   }
                   if(hour==12||hour==0)
                       sprintf(timestuff[0],"une heure moins %s",
                               minutestrings[60-minute][language]);
                   else
                      sprintf(timestuff[0],"%s heures moins %s",
                           hourstrings[hour+1][language],
                           minutestrings[60-minute][language]);
                   }
                   }

       if(language==ENGLISH)
       {
       switch(minute)
       {
          case 0 :  sprintf(timestuff[0],"%s %s",
                                    hourstrings[hour][language],
                                    minutestrings[minute][language]);break;
          case 15:
                     sprintf(timestuff[0],"%s after %s",
                                          minutestrings[minute][language],
                                          hourstrings[hour][language]);break;
          case 30:  sprintf(timestuff[0],"%s %s",
                                    hourstrings[hour][language],
                                    minutestrings[minute][language]);break;
          case 45: sprintf(timestuff[0],"%s to %s",
                                      minutestrings[60-minute][language],
                                      hourstrings[hour+1][language]);break;

          default:
                   if(minute==1||minute==59)strcpy(minister,"Minute");
                   else strcpy(minister,"Minutes");
                   if(minute<30)
                     sprintf(timestuff[0],"%s %s after %s",
                                          minutestrings[minute][language],minister,
                                          hourstrings[hour][language]);
                   else
                     sprintf(timestuff[0],"%s %s to %s",
                                         minutestrings[60-minute][language],minister,
                                         hourstrings[hour+1][language]);
                   }
                   }


       sprintf(timestuff[1],"%2d:%2d",hour,minute);
       if(timestuff[1][3]==' ')timestuff[1][3]='0';

       pen_color(3);
       stuffcords[0][0]=x1-(strlen(timestuff[0])*4);
       move_to(stuffcords[0][0],stuffcords[0][1]);
       plots(timestuff[0]);
       stuffcords[1][0]=x1-(strlen(timestuff[1])*4);
       move_to(stuffcords[1][0],stuffcords[1][1]);
       plots(timestuff[1]);


   if(hour==12)hour = 0;
   if(oldhour == 12)oldhour = 0;

   hourdegrees= (float)30*hour;
   hourdegrees+= (float).5*minute;

   oldhourdegrees= (float)30*oldhour;
   oldhourdegrees+= (float).5*oldminute;

       /* erase the old hands */
       pen_color(0);
       x2=x1;
       y2=y1;
       circlepoints(&x2,&y2,minutebase,oldminutedegrees);
       move_to(x1,y1);
       line_to(x2,y2);
       x2=x1;
       y2=y1;
       circlepoints(&x2,&y2,hourbase,oldhourdegrees);
       move_to(x1,y1);
       line_to(x2,y2);

       /* draw the new hands */
       pen_color(2);
       x2=x1;
       y2=y1;
       circlepoints(&x2,&y2,minutebase,minutedegrees);
       move_to(x1,y1);
       line_to(x2,y2);
       pen_color(1);
       x2=x1;
       y2=y1;
       circlepoints(&x2,&y2,hourbase,hourdegrees);
       move_to(x1,y1);
       line_to(x2,y2);

       /* draw a small circle at the center */
       pen_color(3);
       move_to(x1,y1);
       circle(4,3);


}




main()
{

       int x1=160, y1=106, x2,y2,circlebase = 70, letterbase=80;
       int markout= 72, markin = 71;
       int xtemp, ytemp;

       int done = 0;
       int hour = 12, oldhour=12;
       int minute= 0, oldminute = 0;
       char c;
       char numbuf[40];
       int i, xfactor, yfactor=4;
       float hourdegrees;

    /* allow only CGA compatible adapters */
    if(((biosequip() >>4) &3)==3)
    {
        printf("Sorry... Cga Required...\n");
        exit(0);
    }

       setvmode(5);
       /* set the global aspect ratio */
       getvconfig(&_videostuff);
       aspect_rat =
       (float) _videostuff.aspect_v / (float) _videostuff.aspect_h;

       /* outline the screen */
       memoryload();
       pen_color(2);
       move_to(0,0);
       box(319,21,0);
       pen_color(1);
       move_to(0,22);
       box(319,191-22,0);



        dotitle(1);

       /* do all the small marks */
       for(i=0;i<60;i++)
       {
         hourdegrees= (float)6*i;
         x2 = x1;
         y2 = y1;
         xtemp = x1;
         ytemp = y1;

         circlepoints(&x2,&y2,markin,hourdegrees);
         if(i%5==0)
         {
            pen_color(1);
            circlepoints(&xtemp,&ytemp,markout+yfactor,hourdegrees);
            }
         else
         {
           circlepoints(&xtemp,&ytemp,markout,hourdegrees);
           pen_color(2);
           }
         move_to(x2,y2);
         line_to(xtemp, ytemp);
         }

       /* do the clock face */
       pen_color(3);
       move_to(x1,y1);
       circle(circlebase,3);


       /* put on the numbers */
       for(i=1;i<13;i++)
       {
         sprintf(numbuf,"%d",i);
         xfactor = strlen(numbuf)*4;
         hourdegrees= (float)30*i;
         x2 = x1;
         y2 = y1;
         circlepoints(&x2,&y2,letterbase,hourdegrees);
         move_to(x2-xfactor,y2-yfactor);

         if(i%3==0)pen_color(2);
         else pen_color(1);

         plots(numbuf);
         }

       /* set the hands with the start value */
       strcpy(timestuff[0],"");
       strcpy(timestuff[1],"");
       dohands(hour,minute,oldhour,oldminute);

       do
       {
        /* we can put a timer loop in here */
        if(kbhit())
        {
            c=toupper(getch());

            switch(c)
            {
             case 27: setvmode(3);exit(0);

             case 0: c=getch();
                     if(c!=UPARROW)
                       if(c!=DOWNARROW)
                         if(c!=LEFTARROW)
                           if(c!=RIGHTARROW)
                                         break;
                     oldhour=hour;
                     oldminute=minute;


                     if(c==DOWNARROW)hour++;
                     if(c==UPARROW)hour--;

                      if(c==RIGHTARROW)
                      {
                        minute=(minute/5)*5; /* truncate to even intervals */
                        minute+=5;
                        if(minute>59)
                        {
                        minute-=60;
                        hour++;
                        }
                        }

                      if(c==LEFTARROW)
                      {
                      minute=(minute/5)*5;
                      minute-=5;
                      if(minute<0)
                      {
                       minute+=60;
                       hour--;
                       }
                       }

                     if(hour>12)hour=1;
                     if(hour<1)hour=12;
            case 'F':
            case 'E':
            case 'A':if(c=='A'||c=='E')language=ENGLISH;
                     if(c=='F')language= FRENCH;
                     if(language!=oldlanguage)
                     {
                        dotitle(0);
                        oldlanguage=language;
                        dotitle(1);
                     }
                     dohands(hour,minute,oldhour,oldminute);
                     break;


             default:

                      oldminute=minute;
                      oldhour  =hour;
                      minute++;
                      if(minute>59)
                      {
                        minute=0;
                        hour++;
                        if(hour>12)hour=1;
                        }
                      dohands(hour,minute,oldhour,oldminute);
                      }
                    }
       }
       while(!(done));
       setvmode(3);
       exit(0);

}


char *titleblock[3][2]={

"Little Ben(C)1991 by Bill Buckels",
"Chez l'horloger(C) par B.Buckels",

"Most Keys and Arrows Hot-Esc Exits",
"Appuyez sur les fleches pour jouer",

"Made In Canada",
"Produit du Canada"};

dotitle(int color)
{
    int x1=160,xtemp;

    /* we use this to erase the old captions */
    if(!color)
       pen_color(color);

       if(color)pen_color(3);
       xtemp = x1-(strlen(titleblock[0][oldlanguage])*4);
       move_to(xtemp,2);
       plots(titleblock[0][oldlanguage]);
       if(color)pen_color(1);
       xtemp = x1-(strlen(titleblock[1][oldlanguage])*4);
       move_to(xtemp,10);
       plots(titleblock[1][oldlanguage]);
       if(color)pen_color(2);
       xtemp = x1-(strlen(titleblock[2][oldlanguage])*4);
       move_to(xtemp,192);
       plots(titleblock[2][oldlanguage]);
}

/* Character Array of .PCX format Run Length Full Screen CGA Graphic */
/* .PCX Input File Name was iben.PCX */

/* The BYTE COUNT Descriptor Integer precedes the Character Array.*/

int IBEN_SIZE = 8555 ;

unsigned char IBEN[8555]={
255,  68, 209,  68, 255,  17, 209,  17, 255,  68, 209,  68, 197,  17, 255,   0, 199, 
  0, 197,  17, 197,  68,  63, 255, 255, 198, 255,   4, 196,  68, 197,  17,  63, 255, 
255, 198, 255, 197,  17, 197,  68,  62, 216, 170, 138, 211, 170, 162, 215, 170, 175, 
  4, 196,  68, 197,  17,  62, 216, 170,  10, 211, 170, 160, 215, 170, 175, 197,  17, 
197,  68,  62, 215, 170, 168,  10, 211, 170, 160,  42, 214, 170, 175,   4, 196,  68, 
197,  17,  62, 215, 170, 160,  10, 211, 170, 160,  10, 214, 170, 175, 197,  17, 197, 
 68,  62, 215, 170, 128,  10, 211, 170, 160,   2, 214, 170, 175,   4, 196,  68, 197, 
 17,  62, 215, 170,   0,  10, 211, 170, 160,   0, 214, 170, 175, 197,  17, 197,  68, 
 62, 214, 170, 168,   0,  10, 211, 170, 160,   0,  42, 213, 170, 175,   4, 196,  68, 
197,  17,  62, 214, 170, 160,   0,  10, 170, 128,   0, 128, 205,   0,   2, 170, 160, 
  0,  10, 213, 170, 175, 197,  17, 197,  68,  62, 214, 170, 128,   0,  10, 170, 143, 
193, 192, 143, 194,  15, 193, 192, 194,  60,   3, 193, 195, 193, 255, 193, 252,  63, 
193, 255,   3, 193, 255,   0, 170, 160,   0,   2, 213, 170, 175,   4, 196,  68, 197, 
 17,  62, 214, 170, 196,   0,  15, 193, 192, 195,  15, 193, 192, 194,  60,   3, 193, 
192,  15,   0,  60,   0,  15,   3, 193, 192, 196,   0, 213, 170, 175, 197,  17, 197, 
 68,  62, 213, 170, 168, 196,   0,  15, 193, 240,  63, 194,  15, 193, 240, 194,  60, 
  3, 193, 192,  15,   0,  60,   0,  15, 198,   0,  42, 212, 170, 175,   4, 196,  68, 
197,  17,  62, 213, 170, 160, 196,   0,  15, 193, 240,  63, 194,  15, 193, 252, 194, 
 60,   3, 193, 192,  15,   0,  60,   0,   3, 193, 240, 197,   0,  10, 212, 170, 175, 
197,  17, 197,  68,  62, 213, 170, 128, 196,   0,  15, 193, 252, 193, 255, 194,  15, 
 63, 194,  60,   3, 193, 192,  15,   0,  63, 193, 240,   0, 193, 255, 197,   0,   2, 
212, 170, 175,   4, 196,  68, 197,  17,  62, 213, 170, 128, 196,   0,  15,  60, 193, 
255, 195,  15, 193, 252,  60,   3, 193, 192,  15,   0,  60, 194,   0,  15, 193, 192, 
196,   0,  10, 212, 170, 175, 197,  17, 197,  68,  62, 213, 170, 160, 196,   0,  15, 
 63, 193, 207, 194,  15,   3, 193, 252,  60,   3, 193, 192,  15,   0,  60, 195,   0, 
193, 240, 196,   0,  42, 212, 170, 175,   4, 196,  68, 197,  17,  62, 213, 170, 168, 
196,   0, 197,  15,   0, 193, 252,  60,   3, 193, 192,  15,   0,  60, 195,   0, 193, 
240, 196,   0, 213, 170, 175, 197,  17, 197,  68,  62, 208, 170, 168, 194,   0, 195, 
170, 196,   0, 197,  15,   0,  60, 194,  15,   0,  15,   0,  60,   0,  15, 193, 192, 
193, 240, 195,   0,   2, 194, 170, 160,   0,   2, 208, 170, 175,   4, 196,  68, 197, 
 17,  62, 208, 170,   3, 194, 255,   2, 194, 170, 128,   0,  10, 170, 143,   0, 195, 
 15,   2,  60,   3, 193, 252,   2, 143,   2,  63, 193, 255,   3, 193, 255, 193, 192, 
 42, 160,   0,  10, 170, 168,  15, 193, 255, 193, 252,  10, 207, 170, 175, 197,  17, 
197,  68,  62, 207, 170, 160, 195, 255, 193, 252,  42, 170, 160,   0,  10, 170, 128, 
  2, 128, 194,   0,   2, 195,   0,  10, 128,   2, 197,   0, 170, 160,   0,  42, 170, 
131, 195, 255, 193, 240, 207, 170, 175,   4, 196,  68, 197,  17,  62, 207, 170, 143, 
196, 255, 193, 202, 170, 168,   0,  10, 211, 170, 160,   0, 194, 170,  63, 196, 255, 
 42, 206, 170, 175, 197,  17, 197,  68,  62, 207, 170,  63, 196, 255, 193, 242, 194, 
170,   0,  10, 211, 170, 160,   2, 170, 168, 197, 255, 193, 202, 206, 170, 175,   4, 
196,  68, 197,  17,  62, 206, 170, 168, 197, 255, 193, 252, 194, 170, 128,  10, 211, 
170, 160,  10, 170, 163, 197, 255, 193, 242, 206, 170, 175, 197,  17, 197,  68,  62, 
206, 170, 163, 198, 255,  42, 170, 160,  10, 211, 170, 160,  42, 170, 143, 197, 255, 
193, 252, 206, 170, 175,   4, 196,  68, 197,  17,  62, 206, 170, 143, 198, 255, 193, 
202, 170, 168,  10, 211, 170, 160, 194, 170,  63, 198, 255,  42, 205, 170, 175, 197, 
 17, 197,  68,  62, 206, 170,  63, 198, 255, 193, 242, 194, 170,  10, 211, 170, 162, 
170, 168, 199, 255, 193, 202, 205, 170, 175,   4, 196,  68, 197,  17,  62, 205, 170, 
168, 199, 255, 193, 252, 194, 170, 138, 196, 170,   2, 208, 170, 163, 199, 255, 193, 
242, 205, 170, 175, 197,  17, 197,  68,  62, 205, 170, 168, 194, 255, 193, 252,   0, 
 15, 194, 255, 193, 252, 198, 170, 168,   2, 194, 170, 171, 193, 234, 175, 193, 250, 
202, 170, 163, 194, 255, 193, 240,   0,  63, 194, 255, 193, 242, 205, 170, 175,   4, 
196,  68, 197,  17,  62, 205, 170, 163, 194, 255,   1,  85,  80,  63, 194, 255,  42, 
197, 170, 160,   2, 194, 170, 175, 193, 234, 194, 190, 202, 170, 143, 193, 255, 193, 
252,   5,  85,  64, 194, 255, 193, 252, 205, 170, 175, 197,  17, 197,  68,  62, 205, 
170, 163, 193, 255, 193, 252,  21, 194,  85,  15, 194, 255,  42, 197, 170, 128,  10, 
194, 170, 171, 193, 234, 170, 190, 202, 170, 143, 193, 255, 193, 240, 194,  85,  84, 
 63, 193, 255, 193, 252, 205, 170, 175,   4, 196,  68, 197,  17,  62, 205, 170, 163, 
193, 255, 193, 241, 195,  85,  83, 194, 255,  42, 197, 170,   0,  42, 194, 170, 171, 
193, 234, 171, 193, 250, 202, 170, 143, 193, 255, 193, 197, 195,  85,  79, 193, 255, 
193, 252, 205, 170, 175, 197,  17, 197,  68,  62, 205, 170, 143, 193, 255, 193, 197, 
195,  85,  84, 194, 255, 193, 202, 196, 170, 168,   0, 195, 170, 171, 193, 234, 175, 
203, 170,  63, 193, 255,  21, 195,  85,  83, 194, 255,  42, 195, 170, 168, 198,   0, 
 42, 170, 175,   4, 196,  68, 197,  17,  62, 205, 170, 143, 193, 255,  21, 196,  85, 
 63, 193, 255, 193, 202, 196, 170, 160,   2, 195, 170, 171, 193, 234, 194, 190, 202, 
170,  63, 193, 252, 196,  85,  84, 194, 255,  42, 195, 170, 168, 196, 255, 193, 240, 
  0,  42, 170, 175, 197,  17, 197,  68,  62, 205, 170, 143, 193, 252,  21, 196,  85, 
 15, 193, 255, 193, 202, 196, 170, 128,  10, 195, 170, 191, 193, 254, 191, 193, 254, 
202, 170,  63, 193, 240, 196,  85,  84,  63, 193, 255,  42, 195, 170, 168, 196, 255, 
193, 240,   0,  42, 170, 175,   4, 196,  68, 197,  17,  62, 205, 170, 143, 193, 252, 
197,  85,  79, 193, 255, 193, 202, 196, 170,   0,  42, 209, 170,  63, 193, 241, 197, 
 85,  63, 193, 255,  42, 195, 170, 168, 196, 255, 193, 240,   0,  42, 170, 175, 197, 
 17, 197,  68,  62, 205, 170, 143, 193, 252, 197,  85,  79, 193, 255, 193, 202, 195, 
170, 168,   0, 196, 170, 128, 195,   0,  10, 201, 170,  63, 193, 241, 197,  85,  63, 
193, 255,  42, 195, 170, 168, 193, 255, 193, 240, 196,   0,  42, 170, 175,   4, 196, 
 68, 197,  17,  62, 205, 170, 143, 193, 241, 197,  85,  83, 193, 255, 193, 202, 193, 
250, 170, 193, 250, 160,   2, 194, 170, 168,   0,  59, 195, 187, 176,   0, 197, 170, 
171, 193, 234, 170,  63, 193, 197, 197,  85,  79, 193, 255,  42, 195, 170, 168, 193, 
255, 193, 240,   0,  42, 196, 170, 175, 197,  17, 197,  68,  62, 205, 170, 143, 193, 
241, 197,  85,  83, 193, 255, 193, 203, 193, 250, 171, 193, 250, 128,  10, 170, 168, 
  2, 199, 238,   0, 196, 170, 175, 193, 234, 170,  63, 193, 197, 197,  85,  79, 193, 
255,  42, 195, 170, 168, 193, 255, 193, 240,   0,  42, 196, 170, 175,   4, 196,  68, 
197,  17,  62, 205, 170, 143, 193, 241, 197,  85,  83, 193, 255, 193, 202, 193, 250, 
170, 193, 250,   0,  42,   0,   3, 201, 187,   0,   2, 194, 170, 171, 193, 234, 170, 
 63, 193, 197, 197,  85,  79, 193, 255,  42, 195, 170, 168, 193, 255, 193, 240,   0, 
 42, 196, 170, 175, 197,  17, 197,  68,  62, 205, 170, 143, 193, 241,  85,  84, 195, 
 85,  83, 193, 255, 193, 202, 193, 250, 170, 193, 248,   0, 160, 204, 238, 193, 236, 
 42, 170, 171, 193, 234, 170,  63, 193, 197,  85,  81, 195,  85,  79, 193, 255,  42, 
195, 170, 168, 193, 255, 193, 240,   0,  42, 196, 170, 175,   4, 196,  68, 197,  17, 
 62, 196, 170, 168, 195,   0,   2, 196, 170, 163, 193, 241,  85,  84, 195,  85,  83, 
193, 255,  42, 193, 250, 170, 193, 240,   2,  11, 205, 187, 130, 170, 171, 193, 234, 
170, 143, 193, 197,  85,  81, 195,  85,  79, 193, 252, 196, 170, 168, 193, 255, 193, 
240, 194,   0,   2, 195, 170, 175, 197,  17, 197,  68,  62, 196, 170, 128, 196,   0, 
196, 170, 163, 193, 241,  85,  80, 195,  85,  83, 193, 255,  42, 193, 250, 170, 193, 
192,   0, 206, 238, 193, 236,  42, 171, 193, 234, 170, 143, 193, 197,  85,  65, 195, 
 85,  79, 193, 252, 196, 170, 168, 195, 255,   0,   2, 195, 170, 175,   4, 196,  68, 
197,  17,  62, 195, 170, 168, 197,   0,  42, 195, 170, 163, 193, 241,  85,  80,  85, 
 21,  85,  83, 193, 255,  47, 193, 255, 175,   0,  11, 207, 187, 130, 191, 193, 254, 
170, 143, 193, 197,  85,  65,  84, 194,  85,  79, 193, 252, 196, 170, 168, 195, 255, 
  0,   2, 195, 170, 175, 197,  17, 197,  68,  62, 195, 170, 160, 197,   0,  10, 195, 
170, 168, 193, 252,  85,  80,  84,  21,  85,  79, 193, 252, 194, 170, 168,   0, 208, 
238, 193, 236,   2, 194, 170, 163, 193, 241,  85,  65,  80, 194,  85,  63, 193, 242, 
196, 170, 168, 195, 255,   0,   2, 195, 170, 175,   4, 196,  68, 197,  17,  62, 195, 
170, 128, 197,   0,   2, 195, 170, 168, 193, 252,  85, 194,  80,  21,  85,  79, 193, 
252, 194, 170, 160,   3, 200, 187,   3, 200, 187, 184,  42, 170, 163, 193, 241,  85, 
 65,  64, 194,  85,  63, 193, 242, 196, 170, 168, 193, 255, 193, 240, 194,   0,   2, 
195, 170, 175, 197,  17, 197,  68,  62, 195, 170, 198,   0,   2, 196, 170,  60,  21, 
 80,  64,  21,  85,  15, 193, 242, 194, 170, 128,  14, 200, 238,   2, 201, 238, 193, 
202, 170, 168, 193, 240,  85,  65,   0,  85,  84,  63, 193, 202, 196, 170, 168, 193, 
255, 193, 240,   0,  42, 196, 170, 175,   4, 196,  68, 197,  17,  62, 194, 170, 168, 
199,   0, 196, 170, 143,  21,  80,   0,  21,  85,  63, 193, 202, 194, 170,   0,  59, 
200, 187,   3, 201, 187, 178, 194, 170,  60,  85,  64,   0,  85,  84, 193, 255,  42, 
196, 170, 168, 193, 255, 193, 240,   0,  42, 196, 170, 175, 197,  17, 197,  68,  62, 
194, 170, 168, 196,   0,   2, 193, 236,   0,  42, 195, 170, 163, 193, 197,  80,   0, 
 21,  84, 193, 255,  42, 170, 160,   0, 201, 238,   2, 201, 238, 193, 236,  42, 170, 
143,  21,  64,   0,  85,  83, 193, 252, 197, 170, 168, 193, 255, 193, 240,   0,  42, 
196, 170, 175,   4, 196,  68, 197,  17,  62, 194, 170, 168,   0,   3, 128,   0, 194, 
187,   0,  42, 195, 170, 168, 193, 241,  80,   0,  21,  83, 193, 252, 194, 170,   0, 
  3, 201, 187,   3, 202, 187, 130, 170, 163, 193, 197,  64,   0,  85,  79, 193, 242, 
197, 170, 168, 193, 255, 193, 240,   0,  42, 196, 170, 175, 197,  17, 197,  68,  62, 
194, 170, 168,   0,  14, 196, 238, 193, 192,  42, 196, 170,  60,  16,   0,  21,  15, 
193, 242, 170, 160, 193, 192,  14, 201, 238,   2, 202, 238, 193, 236,  42, 168, 193, 
240,  64,   0,  84,  63, 193, 202, 197, 170, 168, 193, 255, 193, 240,   0,  42, 196, 
170, 175,   4, 196,  68, 197,  17,  62, 194, 170, 168,   0,  11, 184,   0, 176,  11, 
128,  42, 196, 170, 143, 194,   0,  80,  63, 193, 202, 170, 139,   0,  59, 201, 187, 
  3, 203, 187, 138, 170,  60,   0,   1,  64, 193, 255,  42, 197, 170, 168, 193, 255, 
193, 240,   0,  42, 196, 170, 175, 197,  17, 197,  68,  62, 194, 170, 168,   0,  46, 
193, 192,  14, 193, 236,   0, 193, 224,  42, 196, 170, 160, 193, 252,   0,  15, 193, 
252,  42, 170,  44,   0, 202, 238,   2, 203, 238, 193, 226, 170, 131, 193, 240,   0, 
 63, 193, 240, 198, 170, 168, 193, 255, 193, 240,   0,  42, 196, 170, 175,   4, 196, 
 68, 197,  17,  62, 194, 170, 168,   0,  59, 131, 194, 187, 194, 176,  42, 197, 170, 
  3, 194, 255,   2, 170, 168, 176,   3, 202, 187,   3, 203, 187, 184, 170, 168,  15, 
193, 255, 193, 252,  10, 198, 170, 168, 193, 255, 193, 240,   0,  42, 196, 170, 175, 
197,  17, 197,  68,  62, 194, 170, 168,   0,  46, 196, 238, 193, 236,  42, 197, 170, 
168, 194,   0, 194, 170, 130, 193, 192,  14, 202, 238,   2, 204, 238,  10, 170, 160, 
  0,   2, 199, 170, 168, 193, 255, 193, 240,   0,  42, 196, 170, 175,   4, 196,  68, 
197,  17,  62, 194, 170, 168,   0,  11, 184,   0, 187,   0,  56,  42, 202, 170,  59, 
  0,  59, 202, 187,   3, 204, 187, 178, 203, 170, 168, 195,   0,  42, 196, 170, 175, 
197,  17, 197,  68,  62, 195, 170,   0,  14, 193, 226, 193, 224, 194, 236,  44,  42, 
201, 170, 168, 194,   0, 203, 238,   2, 204, 238, 193, 236, 212, 170, 175,   4, 196, 
 68, 197,  17,  62, 195, 170,   0,  11, 139,   0, 179, 128,  56,  42, 201, 170, 160, 
 59, 184, 203, 187,   3, 205, 187,  42, 197, 170, 160, 206,   0, 197,  17, 197,  68, 
 62, 195, 170,   0,   2, 193, 238,   0, 193, 238, 193, 192,  44,  42, 201, 170, 130, 
193, 238, 193, 224, 203, 238,   2, 205, 238,  42, 197, 170, 163, 193, 192,  60,  63, 
193, 255,  15,   0, 193, 240, 193, 255, 193, 240,   3, 193, 255, 193, 240,  63, 193, 
240,   4, 196,  68, 197,  17,  62, 195, 170, 191, 193, 243, 187, 176, 179, 184,  59, 
193, 234, 201, 170,  11, 128,  12, 203, 187,   3, 205, 187, 130, 197, 170, 163, 193, 
192, 194,  60,   0,  15,   0, 194, 240,  60,   3, 193, 192,   0, 193, 240,  60, 197, 
 17, 197,  68,  62, 195, 170,   0,  50, 194, 238, 193, 224, 193, 238, 193, 236,  42, 
200, 170, 168,  46,   0, 193, 224,  14, 202, 238,   2, 205, 238, 193, 236, 197, 170, 
163, 193, 192, 194,  60,   0,  15,   0, 194, 240,  15,   3, 193, 192,   0, 193, 240, 
  0,   4, 196,  68, 197,  17,  62, 195, 170, 194,  11, 194, 187, 184,  59, 184,  42, 
196, 170, 175, 170, 191, 193, 250, 160, 184,   3, 131, 139, 202, 187,   3, 205, 187, 
184, 170, 171, 193, 254, 194, 170, 163, 193, 192, 194,  60,   0,  15,   0, 194, 240, 
 15,   3, 193, 192,   0,  63,   0, 197,  17, 197,  68,  62, 195, 170,  14, 196, 238, 
 14, 193, 236,  42, 196, 170, 191, 170, 193, 250, 190, 130, 193, 224, 195,  14, 202, 
238,   2, 206, 238,  42, 194, 175, 194, 170, 163, 193, 255, 193, 252,  63, 193, 240, 
 15,   0, 194, 240,  60,   3, 193, 255,   0,  15, 193, 240,   4, 196,  68, 197,  17, 
 62, 195, 170,  11, 194, 187, 176, 187, 139, 184,  42, 196, 170, 175, 170, 193, 250, 
193, 252,  11, 128,   8,  56,   3, 202, 187,   3, 206, 187, 138, 170, 175, 194, 170, 
163, 193, 192, 194,  60,   0,  15,   0, 193, 240, 193, 255, 193, 240,   3, 193, 192, 
194,   0, 193, 252, 197,  17, 197,  68,  62, 195, 170,  14, 194, 238, 193, 236,  46, 
 14, 193, 236,  42, 196, 170, 175, 170, 193, 251, 193, 192, 193, 206,   0, 193, 192, 
193, 224, 193, 226, 202, 238,   2, 206, 238, 193, 226, 170, 193, 254, 194, 170, 163, 
193, 192, 194,  60,   0,  15,   0, 195, 240,   3, 193, 192, 194,   0,  15,   4, 196, 
 68, 197,  17,  62, 195, 170,   0, 195, 187,   0,  59, 184,  42, 196, 170, 175, 170, 
193, 255,  15, 193, 195,   3, 179, 131, 128, 202, 187,   3, 206, 187, 184, 171, 193, 
234, 194, 170, 163, 193, 192, 194,  60,   0,  15,   0, 194, 240,  60,   3, 193, 192, 
194,   0,  15, 197,  17, 197,  68,  62, 195, 170, 160,  46, 193, 238,  14, 194, 238, 
193, 236, 197, 170, 175, 170, 193, 192,   3, 193, 242,  14, 193, 224,  14,  12, 202, 
238,   2, 206, 238, 193, 236, 194, 175, 194, 170, 163, 193, 192, 194,  60,   0,   3, 
193, 195, 193, 192, 193, 240,  15,   3, 193, 192,   0, 193, 252,  15,   4, 196,  68, 
197,  17,  62, 196, 170,  11, 187, 131, 184,  11, 176, 197, 170, 193, 255, 193, 248, 
  5,  83, 193, 240, 194, 187, 128,  48, 202, 187,   3, 207, 187,  63, 193, 255, 194, 
170, 163, 193, 192,  60,  63, 193, 255,   0, 193, 255,   0, 193, 240,   3, 193, 195, 
193, 255, 193, 240,  63, 193, 252, 197,  17, 197,  68,  62, 196, 170, 130, 193, 238, 
194, 224, 193, 238, 193, 226, 198, 170, 128,  85,  80, 193, 252, 195, 238,   2, 202, 
238,   2, 207, 238,  42, 195, 170, 160, 206,   0,   4, 196,  68, 197,  17,  62, 196, 
170, 160, 187, 184,   3, 187, 130, 197, 170, 168,   5,  85,  84, 193, 252,  59, 187, 
176,  59, 202, 187,   3, 207, 187, 138, 202, 170, 168,  42, 197, 170, 175, 197,  17, 
197,  68,  62, 196, 170, 168,  46, 195, 238,   2, 197, 170, 128, 194,  85,  84,  63, 
 44, 193, 238,   2, 203, 238,   2, 207, 238, 193, 226, 202, 170, 160,  10, 197, 170, 
175,   4, 196,  68, 197,  17,  62, 197, 170,  11, 194, 187, 184,  50, 196, 170, 168, 
  5, 195,  85,  63,  11,   0,  59, 203, 187,   3, 207, 187, 178, 202, 170, 128,   2, 
197, 170, 175, 197,  17, 197,  68,  62, 197, 170, 128, 194, 238, 193, 224, 193, 242, 
170, 128, 195,   0,  21, 195,  85,  15, 193, 192,  46, 204, 238,   2, 207, 238, 193, 
236, 202, 170, 194,   0, 197, 170, 175,   4, 196,  68, 197,  17,  62, 197, 170, 128, 
 59, 187,   3, 193, 243,   0,   5, 195,  85,  21, 195,  85,  67, 193, 240, 205, 187, 
  3, 207, 187, 184, 201, 170, 168, 194,   0,  42, 196, 170, 175, 197,  17, 197,  68, 
 62, 197, 170, 140, 194,   0,  15, 193, 240,   5, 200,  85,  67,   2, 205, 238,   2, 
208, 238,  42, 200, 170, 160, 194,   0,  10, 196, 170, 175,   4, 196,  68, 197,  17, 
 62, 197, 170, 143, 193, 252,   0,  63, 193, 240,   1, 200,  85,  80,  59, 205, 187, 
  3, 208, 187, 138, 200, 170, 128, 194,   0,   2, 196, 170, 175, 197,  17, 197,  68, 
 62, 197, 170,  15, 193, 252,   0,  63, 193, 195, 193, 193, 200,  85,  80, 206, 238, 
  2, 208, 238, 193, 202, 200, 170, 196,   0, 196, 170, 175,   4, 196,  68, 197,  17, 
 62, 196, 170, 128,  15, 193, 252,   0,   3, 193, 195, 193, 240, 200,  85,  67, 206, 
187,   3, 208, 187, 138, 199, 170, 168, 196,   0,  42, 195, 170, 175, 197,  17, 197, 
 68,  62, 196, 170,   5,  67, 193, 252, 194,   0,  15, 193, 252,  21, 199,  85,  14, 
206, 238,   2, 208, 238, 193, 226, 199, 170, 160, 196,   0,  10, 195, 170, 175,   4, 
196,  68, 197,  17,  62, 195, 170, 168,  21,  80,  60,   0,  12,  15, 193, 252,  21, 
198,  85,  84,  59, 206, 187,   3, 208, 187, 178, 199, 170, 128, 196,   0,   2, 195, 
170, 175, 197,  17, 197,  68,  62, 195, 170, 128,  85,  84, 194,   0,  15, 194, 255, 
  5,  85,   5, 196,  85,  80, 207, 238,   2, 208, 238, 193, 226, 199, 170, 198,   0, 
195, 170, 175,   4, 196,  68, 197,  17,  62, 195, 170,   5, 194,  85,  64,   0,  63, 
194, 255,   5,  85,   5, 196,  85,  67, 207, 187,   3, 208, 187, 184, 201, 170, 194, 
  0, 197, 170, 175, 197,  17, 197,  68,  62, 194, 170, 168,  21, 194,  85,  80, 193, 
240,  15, 194, 255, 193, 193,  85,  65, 196,  85,  14, 207, 238,   2, 208, 238, 193, 
236, 201, 170, 194,   0, 197, 170, 175,   4, 196,  68, 197,  17,  62, 194, 170, 160, 
195,  85,  80, 193, 240,   3, 194, 255, 193, 193,  85,  65, 195,  85,  84,  59, 207, 
187,   3, 208, 187, 184, 201, 170, 194,   0, 197, 170, 175, 197,  17, 197,  68,  62, 
194, 170, 160, 195,  85,  80, 193, 240,   0, 194, 255, 193, 240,  85,  80, 195,  85, 
 64, 208, 238,   2, 208, 238, 193, 236,  42, 200, 170, 194,   0, 197, 170, 175,   4, 
196,  68, 197,  17,  62, 194, 170, 129, 195,  85,  80, 193, 240,   0, 194, 255, 193, 
240,  85,  80, 194,  85,  84,  11, 208, 187,   3, 209, 187,  42, 200, 170, 194,   0, 
197, 170, 175, 197,  17, 197,  68,  62, 194, 170, 129, 195,  85,  84,  63,   0,  63, 
193, 255, 193, 252,  21,  80, 194,  85,   0, 209, 238,   2, 209, 238,  42, 200, 170, 
194,   0, 197, 170, 175,   4, 196,  68, 197,  17,  62, 194, 170,   5, 195,  85,  84, 
 63,   0,  15, 193, 255, 193, 252,  21,  84,  21,  64,  35, 209, 187,   3, 209, 187, 
 42, 200, 170, 194,   0, 197, 170, 175, 197,  17, 197,  68,  62, 194, 170,   5, 195, 
 85,  84,  63,   0,  15, 193, 255, 193, 252,  21,  84,   0,  10, 162, 209, 238,   2, 
209, 238,  42, 200, 170, 194,   0, 197, 170, 175,   4, 196,  68, 197,  17,  62, 170, 
168,  21, 195,  85,  84,  63,   0,   3, 194, 255,   5,  85,   2, 170, 131, 209, 187, 
  3, 209, 187,  10, 200, 170, 194,   0, 197, 170, 175, 197,  17, 197,  68,  62, 170, 
168,  21, 195,  85,  84,  63, 194,   0, 194, 255,   5,  85,  10, 170, 142, 209, 238, 
  2, 209, 238, 193, 202, 200, 170, 194,   0, 197, 170, 175,   4, 196,  68, 197,  17, 
 62, 170, 168,  21, 196,  85,  15, 194,   0, 194, 255,   5,  85,  10, 170, 139, 209, 
187,   3, 209, 187, 138, 200, 170, 194,   0, 197, 170, 175, 197,  17, 197,  68,  62, 
170, 160, 197,  85,  15, 194,   0,  63, 193, 255,   5,  85,  66, 170, 142, 209, 238, 
  2, 209, 238, 193, 202, 200, 170, 194,   0, 197, 170, 175,   4, 196,  68, 197,  17, 
 62, 170, 160, 197,  85,  15, 194,   0,  15, 193, 255, 193, 193,  85,  66, 170, 139, 
209, 187,   3, 209, 187, 138, 200, 170, 194,   0, 197, 170, 175, 197,  17, 197,  68, 
 62, 170, 129, 197,  85,  15, 194,   0,   3, 193, 255, 193, 193,  85,  82, 170, 142, 
209, 238,   2, 209, 238, 193, 202, 175, 193, 250, 198, 170, 194,   0, 197, 170, 175, 
  4, 196,  68, 197,  17,  62, 170, 129, 197,  85,  15, 193, 192,   0,   3, 193, 255, 
193, 193,  85,  82, 170, 139, 208, 187, 184,   0, 209, 187, 138, 194, 190, 198, 170, 
194,   0, 197, 170, 175, 197,  17, 197,  68,  62, 170, 129, 194,  85,  80, 194,  85, 
 67, 193, 192, 194,   0, 193, 255, 193, 240,  85,  80, 170, 142, 208, 238, 193, 224, 
  0,  46, 208, 238, 193, 202, 170, 190, 198, 170, 194,   0, 197, 170, 175,   4, 196, 
 68, 197,  17,  62, 170,   5, 194,  85,  80, 194,  85,  67, 193, 192, 194,   0,  63, 
193, 240,  85,  84,  42, 139, 208, 187, 176, 205,   0, 197, 187, 138, 171, 193, 250, 
198, 170, 194,   0, 197, 170, 175, 197,  17, 197,  68,  62, 170,   5, 194,  85,  80, 
194,  85,  67, 193, 192, 194,   0,  63, 193, 240,  85,  84,  42, 142, 208, 238, 193, 
192, 205,   0, 197, 238, 193, 202, 170, 190, 198, 170, 194,   0, 197, 170, 175,   4, 
196,  68, 197,  17,  62, 170,   5, 194,  85,  80, 194,  85,  67, 193, 192, 194,   0, 
 15, 193, 252,  21,  85,  10, 139, 208, 187, 176, 205,   0, 197, 187, 138, 194, 190, 
198, 170, 194,   0, 197, 170, 175, 197,  17, 197,  68,  62, 170,   5, 194,  85,  80, 
194,  85,  67, 193, 192, 194,   0,  63, 193, 252,  21,  85,  10, 142, 208, 238, 193, 
224,   0,  46, 208, 238, 193, 202, 175, 193, 250, 198, 170, 194,   0, 197, 170, 175, 
  4, 196,  68, 197,  17,  62, 170,   5, 194,  85,  80, 194,  85,  80, 193, 240, 194, 
  0,  63, 193, 252,  21,  85,  10, 139, 208, 187, 184,   0, 209, 187, 138, 200, 170, 
194,   0, 197, 170, 175, 197,  17, 197,  68,  62, 170,   5, 194,  85,  80, 194,  85, 
 80, 193, 240, 194,   0, 193, 255, 193, 252,  21,  85,  10, 142, 227, 238, 193, 202, 
200, 170, 194,   0, 197, 170, 175,   4, 196,  68, 197,  17,  62, 170,   5, 194,  85, 
 84,  21,  85,  80, 193, 255, 194,   0, 194, 255,   5,  85,  10, 131, 227, 187,  10, 
200, 170, 194,   0, 197, 170, 175, 197,  17, 197,  68,  62, 170,   5, 194,  85,  84, 
 21,  85,  80, 193, 255, 193, 192,   3, 194, 255,   5,  85,  10, 162, 227, 238,  42, 
200, 170, 194,   0, 197, 170, 175,   4, 196,  68, 197,  17,  62, 170,   5, 194,  85, 
 84,  21,  85,  80, 193, 255, 193, 240,   3, 194, 255,   5,  85,  66, 163, 227, 187, 
 42, 200, 170, 194,   0, 197, 170, 175, 197,  17, 197,  68,  62, 170, 129, 194,  85, 
 84,  21,  85,  80, 194, 255,  15, 194, 255,   5,  85,  66, 162, 227, 238,  42, 200, 
170, 194,   0, 197, 170, 175,   4, 196,  68, 197,  17,  62, 170, 129, 195,  85,   5, 
 85,  67, 197, 255, 193, 193,  85,  66, 163, 227, 187,  42, 200, 170, 194,   0, 197, 
170, 175, 197,  17, 197,  68,  62, 170, 160, 195,  85,  65,  85,  67, 197, 255, 193, 
193,  85,  66, 160, 226, 238, 193, 236,  42, 200, 170, 194,   0, 197, 170, 175,   4, 
196,  68, 197,  17,  62, 170, 160, 195,  85,  80,  85,  67, 197, 255, 193, 193,  85, 
 66, 168, 226, 187, 184, 201, 170, 194,   0, 197, 170, 175, 197,  17, 197,  68,  62, 
170, 168,  21, 194,  85,  80,  85,  15, 197, 255, 193, 193,  85,  66, 168, 219, 238, 
193, 236, 198, 238, 193, 236, 201, 170, 194,   0, 197, 170, 175,   4, 196,  68, 197, 
 17,  62, 170, 160, 195,  85,  80,  85,  15, 197, 255, 193, 193,  85,  66, 168, 197, 
187, 184, 214, 187,  59, 197, 187, 184, 201, 170, 194,   0, 197, 170, 175, 197,  17, 
197,  68,  62, 170, 168,  21, 194,  85,  80,  85,  63, 196, 255, 193, 240,   1,  85, 
 66, 170,  46, 196, 238, 193, 226, 214, 238, 193, 206, 197, 238, 193, 226, 201, 170, 
194,   0, 197, 170, 175,   4, 196,  68, 197,  17,  62, 170, 168,  21, 194,  85,  80, 
 84,  63, 196, 255, 193, 243, 193, 241,  85,  66, 170,  59, 196, 187, 139, 214, 187, 
179, 197, 187, 178, 198, 170, 168, 198,   0,  42, 194, 170, 175, 197,  17, 197,  68, 
 62, 194, 170,   5, 194,  85,  80,  84,   3, 195, 255, 193, 252,   3, 193, 240,  85, 
 66, 170,  46, 196, 238,  46, 213, 238, 193, 224,   0, 197, 238, 193, 226, 199, 170, 
198,   0, 195, 170, 175,   4, 196,  68, 197,  17,  62, 194, 170,   5, 194,  85, 194, 
 80, 193, 240,   3, 193, 255, 194,   0, 193, 255, 193, 192,  85,  66, 170, 139, 195, 
187, 184,   0,  11, 211, 187, 128,  15, 193, 243,  59, 196, 187, 138, 199, 170, 128, 
196,   0,   2, 195, 170, 175, 197,  17, 197,  68,  62, 194, 170, 129, 194,  85,  64, 
  0, 193, 255, 193, 240,   0,  48, 194, 255,   0,  85,  80, 170, 142, 195, 238, 193, 
226,  63, 193, 240,  14, 209, 238, 193, 192,  63, 193, 255, 193, 242, 197, 238, 193, 
202, 199, 170, 160, 196,   0,  10, 195, 170, 175,   4, 196,  68, 197,  17,  62, 194, 
170, 161, 194,  85,  12,   0,  63, 193, 255, 194, 240, 193, 255, 193, 192,   0,  85, 
 80, 170, 139, 196, 187,  63, 193, 255, 193, 240,   3, 207, 187,   0,  63, 194, 255, 
193, 243, 197, 187, 138, 199, 170, 168, 196,   0,  42, 195, 170, 175, 197,  17, 197, 
 68,  62, 194, 170, 160,  85,  84,  63, 194,   0,  15, 194, 240, 195,   0,  85,  80, 
170, 162, 196, 238,  63, 194, 255, 193, 252,   0,  46, 203, 238, 193, 224,   0, 196, 
255, 193, 242, 197, 238,  42, 200, 170, 196,   0, 196, 170, 175,   4, 196,  68, 197, 
 17,  62, 194, 170, 128,  21,  80, 193, 252, 184, 199,   0,  85,  80, 170, 168, 196, 
187,  63, 196, 255, 193, 192,   0,  59, 199, 187, 176,   0,  15, 197, 255, 193, 243, 
196, 187, 184, 201, 170, 128, 194,   0,   2, 196, 170, 175, 197,  17, 197,  68,  62, 
194, 170, 194,   5,  67, 193, 242, 193, 238, 199,   0,  85,  80, 170, 168, 196, 238, 
 63, 198, 255, 193, 192, 199,   0,  15, 199, 255, 193, 242, 196, 238, 193, 236, 201, 
170, 160, 194,   0,  10, 196, 170, 175,   4, 196,  68, 197,  17,  62, 170, 168,  21, 
 64,  15, 193, 203, 187, 199,   0,  85,  80, 194, 170,  59, 195, 187, 131, 214, 255, 
 11, 196, 187, 178, 201, 170, 168, 194,   0,  42, 196, 170, 175, 197,  17, 197,  68, 
 62, 170, 160,  85,  84,  63,  46, 193, 238, 199,   0,  85,  80, 194, 170,  46, 195, 
238, 193, 236,  63, 212, 255, 193, 240, 197, 238, 193, 226, 202, 170, 194,   0, 197, 
170, 175,   4, 196,  68, 197,  17,  62, 170, 129,  85,  84,  60, 194, 187, 199,   0, 
 85,  80, 194, 170, 139, 196, 187, 143, 212, 255, 193, 203, 197, 187, 138, 202, 170, 
128,   2, 197, 170, 175, 197,  17, 197,  68,  62, 170,   5, 194,  85,   0, 193, 238, 
193, 236, 199,   0,  85,  80, 194, 170, 162, 196, 238, 193, 227, 212, 255,  46, 197, 
238,  42, 202, 170, 160,  10, 197, 170, 175,   4, 196,  68, 197,  17,  62, 168,  21, 
194,  85,   0, 187, 176, 199,   0,  85,  80, 194, 170, 163, 196, 187, 184,  63, 210, 
255, 193, 240, 198, 187,  42, 202, 170, 168,  42, 197, 170, 175, 197,  17, 197,  68, 
 62, 160, 195,  85,  64, 201,   0,  85,  80, 194, 170, 168, 197, 238, 193, 192, 210, 
  0,  14, 197, 238, 193, 236, 197, 170, 128, 205,   0,   4, 196,  68, 197,  17,  62, 
161, 195,  85,  64, 203,   0, 191, 193, 234, 168, 198, 187,  10, 208, 170, 131, 198, 
187, 184, 170, 191, 195, 170, 143,   0, 193, 240,  15, 193, 252,   3, 193, 192,  60, 
 63, 193, 252,   0,  63, 193, 240,   0, 197,  17, 197,  68,  62, 160, 205,   0, 194, 
170, 194, 250, 170,  46, 197, 238, 193, 224, 207, 170, 168,  46, 198, 238, 193, 226, 
170, 193, 255, 195, 170, 143,   0, 193, 240,  60,  15,   3, 193, 192, 194,  60,  15, 
  0, 193, 240,  60,   0,   4, 196,  68, 197,  17,  62, 196, 170, 160, 201,   0, 194, 
170, 194, 250, 170, 139, 198, 187,  10, 206, 170, 131, 199, 187, 138, 187, 193, 239, 
195, 170, 143,   0, 194, 240,   3, 193, 195, 193, 192, 194,  60,   3, 193, 192, 193, 
240, 194,   0, 197,  17, 197,  68,  62, 196, 170, 168, 200,   0,   2, 194, 170, 191, 
193, 234, 170, 162, 198, 238, 193, 224, 205, 170, 168,  46, 199, 238,  42, 194, 175, 
195, 170, 143,   0, 194, 240,   3, 193, 195, 193, 192, 194,  60,   3, 193, 192,  63, 
194,   0,   4, 196,  68, 197,  17,  62, 197, 170, 200,   0,   2, 194, 170, 194, 250, 
170, 168, 199, 187,   2, 204, 170,   3, 199, 187, 184, 170, 175, 193, 255, 193, 234, 
194, 170, 143, 193, 255, 194, 240,   3, 193, 195, 193, 192, 194,  60,  15,   0,  15, 
193, 240,   0, 197,  17, 197,  68,  62, 197, 170, 160, 199,   0,  10, 194, 170, 194, 
250, 170, 168, 174, 198, 238, 193, 236,   0,  42, 200, 170, 160,   0, 200, 238, 193, 
232, 194, 170, 175, 195, 170, 143,   0, 194, 240,   3, 193, 195, 193, 192,  60,  63, 
193, 252, 194,   0, 193, 252,   0,   4, 196,  68, 197,  17,  62, 197, 170, 168, 199, 
  0,  10, 194, 170, 191, 193, 234, 194, 170,  11, 200, 187, 128,  42, 198, 170, 160, 
 11, 201, 187, 130, 194, 170, 191, 193, 234, 194, 170, 143,   0, 194, 240,   3, 193, 
195, 193, 192, 195,  60, 194,   0,  15,   0, 197,  17, 197,  68,  62, 198, 170, 199, 
  0,  42, 198, 170, 162, 201, 238, 193, 192,   2, 196, 170,   0,  14, 202, 238,  42, 
198, 170, 143,   0, 194, 240,   3, 193, 195, 193, 192, 194,  60,  15, 194,   0,  15, 
  0,   4, 196,  68, 197,  17,  62, 198, 170, 160, 198,   0,  42, 198, 170, 163, 202, 
187, 184, 196,   0, 204, 187,  42, 198, 170, 143,   0, 193, 240,  60,  15,   0, 194, 
240,  60,   3, 193, 192, 193, 252,  15,   0, 197,  17, 197,  68,  62, 198, 170, 160, 
198,   0, 199, 170, 168, 218, 238, 193, 236, 199, 170, 143,   0, 193, 240,  15, 193, 
252,   0,  63, 193, 192,  60,   0, 193, 240,  63, 193, 252,   0,   4, 196,  68, 197, 
 17,  62, 198, 170, 160, 198,   0, 200, 170,  59, 217, 187, 178, 199, 170, 128, 205, 
  0, 197,  17, 197,  68,  62, 198, 170, 160, 197,   0,   2, 200, 170, 130, 217, 238, 
 10, 212, 170, 175,   4, 196,  68, 197,  17,  62, 198, 170, 160, 197,   0,   2, 200, 
170, 168, 216, 187, 184, 204, 170, 168, 198,   0,  42, 170, 175, 197,  17, 197,  68, 
 62, 198, 170, 160, 197,   0,  10, 201, 170,  46, 215, 238, 193, 226, 204, 170, 168, 
196, 255, 193, 240,   0,  42, 170, 175,   4, 196,  68, 197,  17,  62, 198, 170, 160, 
197,   0,  10, 201, 170, 139, 215, 187, 138, 204, 170, 168, 196, 255, 193, 240,   0, 
 42, 170, 175, 197,  17, 197,  68,  62, 198, 170, 160, 197,   0,  10, 201, 170, 160, 
214, 238, 193, 236,  42, 204, 170, 168, 196, 255, 193, 240,   0,  42, 170, 175,   4, 
196,  68, 197,  17,  62, 198, 170, 160, 197,   0,  42, 202, 170,  11, 213, 187, 130, 
205, 170, 168, 193, 255, 193, 240, 196,   0,  42, 170, 175, 197,  17, 197,  68,  62, 
198, 170, 160, 197,   0,  42, 202, 170, 160, 212, 238, 193, 236,  42, 205, 170, 168, 
193, 255, 193, 240,   0,  42, 196, 170, 175,   4, 196,  68, 197,  17,  62, 198, 170, 
160, 197,   0,  42, 203, 170,  59, 211, 187, 178, 206, 170, 168, 193, 255, 193, 240, 
  0,  42, 196, 170, 175, 197,  17, 197,  68,  62, 198, 170, 160, 197,   0,  42, 203, 
170, 142, 211, 238, 193, 202, 206, 170, 168, 193, 255, 193, 240,   0,  42, 196, 170, 
175,   4, 196,  68, 197,  17,  62, 198, 170, 160, 197,   0,  42, 203, 170, 160, 210, 
187, 184,  42, 206, 170, 168, 193, 255, 193, 240,   0,  42, 196, 170, 175, 197,  17, 
197,  68,  62, 198, 170, 128, 197,   0, 205, 170,   0, 208, 238, 193, 236,   2, 207, 
170, 168, 193, 255, 193, 240, 194,   0,   2, 195, 170, 175,   4, 196,  68, 197,  17, 
 62, 198, 170, 128, 197,   0, 206, 170,  11, 207, 187, 130, 208, 170, 168, 195, 255, 
  0,   2, 195, 170, 175, 197,  17, 197,  68,  62, 198, 170, 198,   0, 206, 170, 160, 
206, 238, 193, 236,  42, 208, 170, 168, 195, 255,   0,   2, 195, 170, 175,   4, 196, 
 68, 197,  17,  62, 198, 170, 198,   0, 203, 170, 191, 193, 254, 194, 170,  11, 205, 
187, 130, 170, 193, 255, 193, 250, 206, 170, 168, 195, 255,   0,   2, 195, 170, 175, 
197,  17, 197,  68,  62, 198, 170, 198,   0, 203, 170, 194, 190, 194, 170, 160, 204, 
238, 193, 236,  42, 170, 193, 250, 207, 170, 168, 193, 255, 193, 240, 194,   0,   2, 
195, 170, 175,   4, 196,  68, 197,  17,  62, 197, 170, 168, 197,   0,   2, 204, 170, 
190, 195, 170,   0,   3, 201, 187,   0,   2, 194, 170, 193, 255, 193, 234, 206, 170, 
168, 193, 255, 193, 240,   0,  42, 196, 170, 175, 197,  17, 197,  68,  62, 197, 170, 
168, 197,   0,   2, 204, 170, 193, 250, 196, 170, 168,   2, 199, 238,   0, 197, 170, 
193, 250, 206, 170, 168, 193, 255, 193, 240,   0,  42, 196, 170, 175,   4, 196,  68, 
197,  17,  62, 197, 170, 160, 197,   0,   2, 203, 170, 171, 193, 234, 197, 170, 168, 
  0,  59, 195, 187, 176,   0, 198, 170, 193, 250, 206, 170, 168, 193, 255, 193, 240, 
  0,  42, 196, 170, 175, 197,  17, 197,  68,  62, 197, 170, 160, 197,   0,   2, 203, 
170, 171, 193, 234, 199, 170, 128, 195,   0,  10, 198, 170, 194, 250, 206, 170, 168, 
193, 255, 193, 240,   0,  42, 196, 170, 175,   4, 196,  68, 197,  17,  62, 197, 170, 
198,   0,   2, 203, 170, 171, 193, 234, 210, 170, 191, 193, 234, 206, 170, 168, 193, 
255, 193, 240,   0,  42, 196, 170, 175, 197,  17, 197,  68,  62, 196, 170, 160, 198, 
  0,  10, 239, 170, 168, 193, 255, 193, 240, 196,   0,  42, 170, 175,   4, 196,  68, 
197,  17,  62, 195, 170, 168, 199,   0,  10, 214, 170, 186, 216, 170, 168, 196, 255, 
193, 240,   0,  42, 170, 175, 197,  17, 197,  68,  62, 195, 170, 200,   0,   2, 213, 
170, 171, 193, 250, 216, 170, 168, 196, 255, 193, 240,   0,  42, 170, 175,   4, 196, 
 68, 197,  17,  62, 194, 170, 128, 201,   0,  42, 212, 170, 175, 217, 170, 168, 196, 
255, 193, 240,   0,  42, 170, 175, 197,  17, 197,  68,  62, 170, 168, 202,   0,   2, 
212, 170, 190, 217, 170, 168, 198,   0,  42, 170, 175,   4, 196,  68, 197,  17,  62, 
170, 160, 203,   0,   2, 211, 170, 191, 193, 250, 225, 170, 175, 197,  17, 197,  68, 
 62, 170, 160, 197,   0,   2, 170, 197,   0,  42, 210, 170, 194, 190, 225, 170, 175, 
  4, 196,  68, 197,  17,  60, 199,   0,   3, 193, 255, 198,   0,  63, 195, 255, 193, 
240, 194,   0, 200, 255, 193, 192, 197,   0,  63, 201, 255, 193, 192, 198,   0,  60, 
195,   0,  15, 195, 255, 194,   0,  15, 193, 255, 193, 252, 194,   0,  63, 197,  17, 
197,  68,  51, 193, 255,   3, 193, 192,   0, 198, 255, 193, 207,   3, 193, 192, 193, 
240,   0,  63, 195, 255, 193, 243, 193, 192,   0, 200, 255,  15,   0, 193, 255, 193, 
192, 193, 240,   0,  15, 201, 255, 193, 207, 193, 255, 193, 192, 195, 240,   0,  60, 
193, 255, 193, 252,   0,   3, 195, 255,  60,   0,  15, 193, 255, 193, 252, 193, 240, 
  0,  63,   4, 196,  68, 197,  17,  15,   3, 193, 195, 193, 192,   0, 198, 255, 193, 
207,   3, 193, 192, 193, 240,   0,  63, 195, 255, 193, 243, 193, 192,   0, 199, 255, 
193, 252,  60,   3, 193, 192, 193, 240,  60,   0,   3, 201, 255, 193, 207,   3, 193, 
240,   0, 194, 240,   0,  60, 193, 240,  63,   0,   3, 195, 255,  60, 194,   0,   3, 
193, 252, 193, 240,   0,  63, 197,  17, 197,  68,  60,   0,   3, 193, 192, 198,   0, 
  3, 193, 207,   0, 193, 192, 193, 240, 197,   0,   3, 193, 192, 201,   0, 193, 240, 
 15, 194,   0,  15, 194,   0, 193, 240, 199,   0,   3, 193, 207,   0, 193, 240,   0, 
194, 240,   0,  60, 193, 240,  15, 197,   0,  60,  15, 195,   0, 193, 240, 194,   0, 
  4, 196,  68, 197,  17,  60,   0,   3, 193, 255, 193, 192,  15, 193, 240,  63, 193, 
255,   0,   3, 193, 207,   3,   0, 193, 255, 193, 240,   3, 193, 252,   3, 193, 207, 
193, 195, 193, 192,  63, 193, 192,  15, 193, 255,   0, 193, 255,   3, 193, 207, 193, 
195, 193, 192,  15,   0,   3, 193, 195, 193, 192,   0, 193, 243,  63, 193, 192,  63, 
193, 240,  15,  63,   0,   3, 193, 207,   3, 193, 192, 195, 240,   0,  60, 193, 240, 
 60,  15,   3, 193, 192,  15, 193, 240, 194,  60,   0,  63, 193, 192, 193, 240,  63, 
193, 192, 197,  17, 197,  68,  60,   0,   3, 194, 240, 194,  60,   0,  60,   0,   3, 
193, 207, 194,   0, 193, 252,  60, 194,  15,   3, 193, 243, 193, 195, 193, 192, 194, 
240, 194,  60,   3, 194, 195, 193, 243, 193, 195, 193, 192,  15,   0,   3, 193, 243, 
193, 192,   0, 193, 243, 193, 192, 193, 240, 194,  60,  15, 193, 207,   0,   3, 193, 
207, 193, 255,   0, 195, 240,   0,  60, 193, 255, 193, 240,  15,   3, 193, 192, 195, 
 60, 193, 240,   0, 197, 240,   4, 196,  68, 197,  17,  60,   0,   3, 193, 192, 193, 
240, 193, 255, 193, 252,   0, 193, 240,   0,  15, 193, 207, 194,   0, 193, 240, 194, 
 60,   3, 193, 195, 193, 192,   3, 193, 195, 193, 192, 195,  60,  15, 193, 255, 193, 
195, 193, 192,   3, 193, 192,  15,   0,   3, 193, 243, 193, 192,   0, 193, 243, 193, 
192, 193, 240,   0,  60,  15, 194,   0,   3, 193, 207,   3, 193, 192, 195, 240,   0, 
 60, 193, 240,  60,  15,   3, 193, 192, 193, 240,   0,  63, 193, 192,   3, 193, 255, 
194, 240, 193, 252,   0, 197,  17, 197,  68,  60,   0,   3, 193, 192, 194, 240,   0, 
  3, 193, 192,   0,  63, 193, 207, 194,   0, 193, 240, 194,  60,   3, 193, 195, 193, 
192,   3, 193, 195, 193, 192, 195,  60,  15,   0,   3, 193, 192,   3, 193, 192,  15, 
  0,   3, 193, 195, 193, 192,   0, 193, 243, 193, 192, 193, 240,  63, 193, 252,  15, 
  0,   3, 193, 255, 193, 207,   0, 196, 240,   0,  60, 193, 240, 194,  15,   3, 193, 
192, 193, 240,   0,  63, 193, 240,   3, 193, 192,   0, 193, 240,  63, 193, 192,   4, 
196,  68, 197,  17,  60,   0,   3, 193, 192, 194, 240,   0,  15, 194,   0, 193, 255, 
193, 207, 194,   0, 193, 240, 194,  60,   3, 193, 195, 193, 192,   3, 193, 195, 193, 
192,  60,  15, 193, 240,  15,   0,   3, 193, 192,   0, 193, 240,  15, 194,   0,  15, 
194,   0, 193, 243, 193, 192, 194, 240,  60,  15,   0,   3, 193, 255, 193, 207,   0, 
196, 240,   0,  60, 193, 240, 194,  15,   3, 193, 192, 193, 240,   0, 194,  60,   3, 
193, 192,   0, 193, 240,   3, 193, 240, 197,  17, 197,  68,  15,   3, 193, 195, 193, 
192, 193, 240, 195,  60, 194,   0,   3, 193, 207, 194,   0, 193, 240,  60, 194,  15, 
  3, 193, 192,   3, 193, 192, 194, 240,  60,   0,   3, 194, 195, 193, 192,   0,  60, 
  3, 193, 192, 193, 240,  60,   0,   3, 193, 243, 193, 192, 194, 240,  60,  15,   0, 
  3, 193, 255, 193, 207,   3, 196, 240,   0,  60, 193, 240,  63,  15,   3, 193, 192, 
195,  60,  15,   0, 197, 240,   4, 196,  68, 197,  17,  51, 193, 255,   3, 193, 192, 
193, 240,  15, 193, 240,  63, 193, 255,   0,   3, 193, 207, 194,   0, 193, 240,  60, 
  3, 193, 252,   3, 193, 192,   3, 193, 192,  63, 193, 192,  63, 193, 252,   0, 193, 
255,   3, 193, 192,   0,  15,   0, 193, 255, 193, 192, 193, 240,   0,  15, 193, 243, 
193, 255, 193, 192,  63, 193, 255,  15,   0,   3, 193, 255, 193, 207, 193, 255, 193, 
192, 195, 240,   0,  60, 193, 255, 193, 252,   3, 193, 255, 193, 240,  15, 193, 240, 
 60,   3, 193, 192,  63, 193, 192, 193, 240,  63, 193, 192, 197,  17, 197,  68,  60, 
201,   0,   3, 193, 192, 204,   0,  60,  15, 197,   0, 193, 192, 197,   0,  63, 193, 
243, 193, 192, 197,   0,   3, 193, 255, 193, 192, 198,   0,  60, 207,   0,   4, 196, 
 68, 197,  17,  63, 215, 255,  60,  15,   0,   3, 202, 255, 193, 243, 193, 192,   0, 
221, 255, 197,  17, 197,  68,  63, 215, 255,  15, 193, 252,   0,   3, 202, 255, 193, 
243, 193, 192,   0, 221, 255,   4, 196,  68, 197,  17,  63, 215, 255, 193, 192, 194, 
  0,  15, 202, 255, 193, 240, 194,   0, 221, 255, 197,  17, 197,  68, 196,   0,  15, 
193, 255, 193, 240, 194,   0, 194, 255, 193, 252, 195,   0,  15, 195, 255, 193, 240, 
197,   0,  15, 193, 255, 193, 252, 201,   0,   3, 193, 252, 194,   0,  63, 197, 255, 
193, 192, 198,   0,  60, 195,   0,  15, 195, 255, 194,   0,  15, 193, 255, 193, 252, 
194,   0,  63,   4, 196,  68, 197,  17,  60,   0,  60, 195,   0,   3, 193, 192,   0, 
194, 255, 193, 252, 193, 255, 193, 252,   0,   3, 195, 255, 193, 195, 193, 192,  63, 
193, 240,  60,   0,   3, 193, 255, 194, 240,   0, 193, 255,   0,  15, 193, 240,   0, 
 15,   0,   3, 193, 252, 193, 240,   0,  63, 197, 255, 193, 207, 193, 255, 193, 192, 
195, 240,   0,  60, 193, 255, 193, 252,   0,   3, 195, 255,  60,   0,  15, 193, 255, 
193, 252, 193, 240,   0,  63, 197,  17, 197,  68,  60, 194,   0,  15,   0,  60,   3, 
193, 192,   0, 194, 255, 193, 252, 193, 240,  63,   0,   3, 195, 255,  15,   0, 193, 
240,  60,  15, 194,   0, 193, 255, 193, 243, 193, 240,   3, 193, 195, 193, 192, 194, 
 60,   0,  63,   0,   3, 193, 252, 193, 240,   0,  63, 197, 255, 193, 207,   3, 193, 
240,   0, 194, 240,   0,  60, 193, 240,  63,   0,   3, 195, 255,  60, 194,   0,   3, 
193, 252, 193, 240,   0,  63,   4, 196,  68, 197,  17,  60, 194,   0,  15,   0,  60, 
  3, 193, 192, 195,   0, 193, 252, 193, 240,  15, 197,   0,  60,   3, 193, 192,   0, 
  3, 193, 192,   0,  63, 194, 240,  15,   0, 194, 240,  15,   0,  15,   0,   3, 193, 
252, 193, 240, 196,   0,   3, 194, 255, 193, 207,   0, 193, 240,   0, 194, 240,   0, 
 60, 193, 240,  15, 197,   0,  60,  15, 195,   0, 193, 240, 194,   0, 197,  17, 197, 
 68,  60,   0,  60,  63, 193, 240, 193, 255, 193, 195, 193, 192,  63, 193, 192,   0, 
 60, 193, 240,  60,   0, 193, 255,   3, 193, 255, 193, 192, 193, 240,   3, 193, 192, 
  0, 194, 240,   0,  63, 193, 252, 193, 240,  15,   0, 194, 240,  15,   0,  15,   0, 
  3, 193, 252, 193, 255, 193, 240,  60,  15,   0,   3, 194, 255, 193, 207,   3, 193, 
192, 195, 240,   0,  60, 193, 240,  60,  15,   3, 193, 192,  15, 193, 240, 194,  60, 
  0,  63, 193, 192, 193, 240,  63, 193, 192,   4, 196,  68, 197,  17,  60,   0,  60, 
 15,   0,  60,   3, 193, 192, 194, 240,   0,  60, 193, 255, 193, 240,   3, 194, 195, 
195, 240,   3, 193, 192,   0, 193, 252, 193, 240,   0,  63, 193, 252, 193, 240,   3, 
193, 195, 193, 240,  60,  63,   0,  15,   0,   3, 193, 252, 193, 240, 194,  60,  15, 
  0,   3, 194, 255, 193, 207, 193, 255,   0, 195, 240,   0,  60, 193, 255, 193, 240, 
 15,   3, 193, 192, 195,  60, 193, 240,   0, 197, 240, 197,  17, 197,  68,  60,   0, 
 60,  15,   0,  60,   3, 193, 195, 193, 255, 193, 240,   0,  60, 193, 240,  60,  15, 
193, 255, 193, 195, 193, 192, 194, 240,   3, 193, 192,   0, 193, 252, 193, 240,   0, 
 63, 193, 252, 193, 240,   0, 193, 252, 193, 240,  15, 193, 207,   0,  15,   0,   3, 
193, 252, 193, 240, 194,  60,  15,   0,   3, 194, 255, 193, 207,   3, 193, 192, 195, 
240,   0,  60, 193, 240,  60,  15,   3, 193, 192, 193, 240,   0,  63, 193, 192,   3, 
193, 255, 194, 240, 193, 252,   0,   4, 196,  68, 197,  17,  60,   0,  60,  15,   0, 
 60,   3, 193, 195, 193, 192, 194,   0,  60, 193, 240, 194,  15,   0,   3, 193, 192, 
194, 240,   3, 193, 192,   0, 194, 240,   0,  63, 193, 252, 193, 240, 194,   0, 193, 
240,   0,  15,   0,  15,   0,   3, 193, 252, 193, 240,  60,  15,  12,   0,   3, 194, 
255, 193, 207,   0, 196, 240,   0,  60, 193, 240, 194,  15,   3, 193, 192, 193, 240, 
  0,  63, 193, 240,   3, 193, 192,   0, 193, 240,  63, 193, 192, 197,  17, 197,  68, 
 60,   0,  60,  15,   0,  60,   3, 193, 195, 193, 192, 194,   0,  60, 193, 240, 194, 
 15,   0,   3, 193, 192, 193, 240,  60,   3, 193, 192,   0,   3, 193, 192,   0,  63, 
193, 252, 193, 240, 194,   0, 193, 240,   0,  15,   0,  15,   0,   3, 193, 252, 193, 
240,  60,  15,  60,   0,  15, 194, 255, 193, 207,   0, 196, 240,   0,  60, 193, 240, 
194,  15,   3, 193, 192, 193, 240,   0, 194,  60,   3, 193, 192,   0, 193, 240,   3, 
193, 240,   4, 196,  68, 197,  17,  60,   0,  60,  15, 193, 192,  63,   3, 193, 192, 
194, 240,   0,  60, 193, 240,  63,   3, 194, 195, 193, 192, 193, 240,  15,   0, 193, 
240,  60,  15, 194,   0, 193, 255, 193, 252, 193, 240,   3, 193, 195, 193, 192, 194, 
 60,   0,  15,   0,   3, 193, 252, 193, 240,  60,   3, 193, 240,   0,  15, 194, 255, 
193, 207,   3, 196, 240,   0,  60, 193, 240,  63,  15,   3, 193, 192, 195,  60,  15, 
  0, 197, 240, 197,  17, 197,  68,  63, 193, 252,  60,   3, 193, 240,  15, 193, 195, 
193, 192,  63, 193, 192,   0,  60, 193, 255, 193, 252,   0, 193, 255,   3, 193, 192, 
193, 240,   3, 193, 192,  63, 193, 240,  60,   0,   3, 193, 255, 193, 252, 193, 240, 
  3, 193, 255,   0,  63, 193, 240,   0,  15,   0,   3, 193, 252, 193, 255, 193, 240, 
  0, 193, 240,   0,  63, 194, 255, 193, 207, 193, 255, 193, 192, 195, 240,   0,  60, 
193, 255, 193, 252,   3, 193, 255, 193, 240,  15, 193, 240,  60,   3, 193, 192,  63, 
193, 192, 193, 240,  63, 193, 192,   4, 196,  68, 197,  17, 233,   0,   3, 193, 192, 
219,   0, 197,  17, 197,  68, 233,   0,  51, 193, 192, 219,   0,   4, 196,  68, 197, 
 17, 233,   0,  63, 220,   0, 197,  17, 197,  68, 255,   0, 199,   0,   4, 196,  68, 
255,  17, 209,  17};


int memoryload()
{
    static char far *crt;
    unsigned int byteoff=0,inleaf=8192,packet,width=0;
    unsigned char byte,bytecount;
    int wordcount=0,target=IBEN_SIZE;
    crt = MK_FP(0xb800,0);


    do{ bytecount=1;                          /* start with a seed count */
        byte=IBEN[wordcount];
        wordcount++;
                                              /* check to see if its raw */
        if(0xC0 == (0xC0 &byte)){             /* if its not, run encoded */
                    bytecount= 0x3f &byte;
                    byte=IBEN[wordcount];
                    wordcount++;
                    }
        for(packet=0;packet<bytecount;packet++){
                     if(width<80){ crt[byteoff]=byte;
                                   width++;
                                   byteoff++;
                                   }
                     else{crt[inleaf]=byte;
                                   inleaf++;
                                   width++;
                                   if(width>159)width=0;
                                   }
                                   }
        }while(wordcount<target);
        if(toupper(getch())=='F')
        {
            language=FRENCH;
            oldlanguage=FRENCH;
        }
        wordcount=0;
        target=16384;
        while(wordcount++<target)*crt++='\x00';
        return(0);
}



