/* Copyright (c) 1990,1991,1992 Chris and John Downey */
#ifndef lint
static char *sccsid = "@(#)signal.c	2.1 (Chris & John Downey) 7/29/92";
#endif

/***

* program name:
    xvi
* function:
    PD version of UNIX "vi" editor, with extensions.
* module name:
    signal.c
* module function:
    Signal handling routines.

    This is all fairly system-dependent, & may be replaced by more
    system-specific routines if required. On MS-DOS, for instance,
    this module isn't used at all: ignore_signals() &
    catch_signals() are defined in msdos_c.c & msdos_a.asm instead.
* history:
    STEVIE - ST Editor for VI Enthusiasts, Version 3.10
    Originally by Tim Thompson (twitch!tjt)
    Extensive modifications by Tony Andrews (onecom!wldrdg!tony)
    Heavily modified by Chris & John Downey

***/

#include "xvi.h"

/*
 * Signal handlers.
 */
#ifdef	SIGINT
    static	void	int_handler P((int));
#endif
#ifdef	SIGTSTP
    static	void	tstp_handler P((int));
#endif
#ifdef	SIGHUP
    static	void	hup_handler P((int));
#endif
#ifdef SIGTERM
    static	void	term_handler P((int));
#endif

void
ignore_signals()
{
#ifdef	SIGINT
    (void) signal(SIGINT, SIG_IGN);
#endif
#ifdef SIGBREAK
    /*
     * On OS/2, this is generated by pressing control-break.
     */
    (void) signal(SIGBREAK, SIG_IGN);
#endif
#ifdef	SIGQUIT
    (void) signal(SIGQUIT, SIG_IGN);
#endif
#ifdef	SIGTSTP
    (void) signal(SIGTSTP, SIG_IGN);
#endif
    /*
     * There isn't much point in catching or ignoring SIGHUP
     * signals until we have some modified buffers to preserve.
     */
#ifdef SIGTERM
    (void) signal(SIGTERM, SIG_IGN);
#endif
}

void
catch_signals()
{
#ifdef	SIGINT
    (void) signal(SIGINT, int_handler);
#endif
#ifdef SIGBREAK
    /*
     * On OS/2, this is generated by pressing control-break.
     */
    (void) signal(SIGBREAK, int_handler);
#endif
#ifdef	SIGTSTP
    (void) signal(SIGTSTP, tstp_handler);
#endif
#ifdef SIGHUP
    (void) signal(SIGHUP, hup_handler);
#endif
#ifdef SIGTERM
    (void) signal(SIGTERM, term_handler);
#endif
}

/*
 * Handler for SIGINT (keyboard interrupt).
 */
#ifdef	SIGINT
static void
int_handler(sig)
int	sig;
{
    signal(SIGINT, int_handler);
    kbdintr = 1;
}
#endif

/*
 * This function is used on UNIX as the signal handler
 * for the keyboard-generated TSTP signal.
 */
#ifdef	SIGTSTP
static void
tstp_handler(sig)
int	sig;
{
    do_suspend(curwin);
}
#endif

/*
 * This one is used for the hangup signal, which generally means that
 * the terminal line has gone dead. This means sys_exit() doesn't make
 * much sense, so we call exit() instead.
 */
#ifdef	SIGHUP
static void
hup_handler(sig)
int	sig;
{
    signal(SIGHUP, SIG_IGN);
    /*
     * Make backup copies of all modified buffers.
     */
    (void) do_preserve();
    exit(0);
}
#endif

/*
 * This one is used for the software-generated terminate signal.
 */
#ifdef SIGTERM
static void
term_handler(sig)
int	sig;
{
    signal(SIGTERM, SIG_IGN);
    /*
     * Make backup copies of all modified buffers.
     */
    (void) do_preserve();
    sys_exit(0);
}
#endif
