echo off
ECHO  This sample batch procedure compiles, links and executes a program.
ECHO  In case of a compiler error, this procedures executes VersiEdit
ECHO  with your source code file in the first window and the error messages
ECHO  in the second window.
ECHO 
ECHO  This procedure is set up for Lattice "C" compiler.  It must be modified
ECHO  to reflect your programming environment as indicated by remarks in the
ECHO  text of the procedure.
goto end
echo off
REM  After modification, this procedure is executed by entering at DOS prompt:
REM  CLE "file", where "file" is the name of your source code file without the
REM  file name extension.  For example, if your source code file name is
REM  MAIN.FOR, enter: CLE MAIN.  The "file" is also the value of the %1
REM  parameter in this procedure.
REM
REM  MODIFICATION INSTRUCTIONS:
REM
REM  1.  Make sure that this file is backed up.
REM  2.  Remove the initial lines up to and including "goto end".
REM  3.  Change "lc -ms -ccdmsuw" on the executable line following ":beg"
REM      to the text that  will execute your compiler with your parameters.
REM      Do not change the remainder of that line.
REM  4.  Change ".c" on the "e %1.c err.msg" line to the file name extension of
REM      your source code file.  For example, if your source code file name is
REM      MAIN.FOR, ".c" should be changed to ".FOR".  This line executes
REM      VersiEdit, assuming that it is either in the current directory or its
REM      directory is contained in your PATH environment variable.
REM  5.  Change the link statement to your usual link statement.  Remember
REM      that %1 contains the name of your source code file without its
REM      extension.
REM
REM  ** END OF MODIFICATION INSTRUCTIONS **
:beg
REM  Execute compiler directing the error messages to err.msg
lc -ms -ccdmsuw %1 >err.msg
if not errorlevel 1 goto lnk
REM  An error has occurred.  Execute VersiEdit to edit/view the source code and
REM  error message files.
e %1.c err.msg
REM  Allow exit from the loop.
echo 
echo 
echo ** Press ^C to Abort, Any Other Key to Continue **
pause
goto beg
:lnk
REM  Display the error message file.  It may contain warning messages that
REM  did not trigger the error processing loop.
type err.msg
REM  Link program
link \lc\s\c+%1,%1,%1/m,\lc\s\lc
if errorlevel 1 goto end
REM  Execute the linked program.
%1
:end
