/*******************  start of original comments  ********************/
/*
 * Written by Douglas Thomson (1989/1990)
 *
 * This source code is released into the public domain.
 */
/*********************  end of original comments   ********************/

/*
 * New editor name:  TDE, the Thomson-Davis Editor.
 * Author:           Frank Davis
 * Date:             June 5, 1991
 *
 * This modification of Douglas Thomson's code is released into the
 * public domain, Frank Davis.  You may distribute it freely.
 *
 * See "tdestr.h" for a description of these variables. C requires global
 *  variables to be declared "extern" in all modules except one.  This file
 *  is included in ed.c and it should not be included in any other module.
 *
 * jmh 980525: made it a C file. ed.c now includes "common.h"
 */

#include "tdestr.h"
#include "tdefunc.h"


displays g_display;

status_infos g_status;

boyer_moore_type bm;

boyer_moore_type sas_bm;

MACRO *macro[MAX_KEYS];
TREE  key_tree = { 0x10000L, { 0 }, NULL, NULL };

CEH ceh;

SORT sort;

DIFF diff;

REGX_INFO regx;

REGX_INFO sas_regx;

NFA_TYPE nfa;

NFA_TYPE sas_nfa;


#if defined( __UNIX__ )
chtype tde_color_table[128];
#endif


/*
 *   those who use special accented characters as part of normal character set
 *     in text do not particularly care for a straight ASCII sort sequence.
 *
 *   this modified ASCII sorting sequence for special accent characters is
 *     useful with English, Esperanto, and French.
 */
SORT_ORDER sort_order = {
               /* ignore case */
   { '\x00', '\x01', '\x02', '\x03', '\x04', '\x05', '\x06', '\x07',
     '\x08', '\x09', '\x0a', '\x0b', '\x0c', '\x0d', '\x0e', '\x0f',
     '\x10', '\x11', '\x12', '\x13', '\x14', '\x15', '\x16', '\x17',
     '\x18', '\x19', '\x1a', '\x1b', '\x1c', '\x1d', '\x1e', '\x1f',
     ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',',
     '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
     ':', ';', '<', '=', '>', '?',
     '@', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm',
     'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '[',
     '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i',
     'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w',
     'x', 'y', 'z', '{', '|', '}', '~', '', 'c', 'u', 'e', 'a', 'a', 'a',
     'a', 'c', 'e', 'e', 'e', 'i', 'i', 'i', 'a', 'a', 'e', 'a', 'a', 'o',
     'o', 'o', 'u', 'u', 'y', 'o', 'u', '', '', '', '', '', 'a', 'i',
     'o', 'u', 'n', 'n', '', '', '', '', '', '', '', '', '', '',
     '', '', '', '', '', '', '', '', '', '', '', '', '', '',
     '', '', '', '', '', '', '', '', '', '', '', '', '', '',
     '', '', '', '', '', '', '', '', '', '', '', '', '', '',
     '', '', '', '', '', '', '', '', '', '', '', '', '', '',
     '', '', '', '', '', '', '', '', '', '', '', '', '', '',
     '', '', '', '', '', '', '', '', '', '' },
               /* match case */
   { '\x00', '\x01', '\x02', '\x03', '\x04', '\x05', '\x06', '\x07',
     '\x08', '\x09', '\x0a', '\x0b', '\x0c', '\x0d', '\x0e', '\x0f',
     '\x10', '\x11', '\x12', '\x13', '\x14', '\x15', '\x16', '\x17',
     '\x18', '\x19', '\x1a', '\x1b', '\x1c', '\x1d', '\x1e', '\x1f',
     ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',',
     '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
     ':', ';', '<', '=', '>', '?',
     '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M',
     'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[',
     '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i',
     'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w',
     'x', 'y', 'z', '{', '|', '}', '~', '', 'C', 'u', 'e', 'a', 'a', 'a',
     'a', 'c', 'e', 'e', 'e', 'i', 'i', 'i', 'A', 'A', 'E', 'a', 'A', 'o',
     'o', 'o', 'u', 'u', 'y', 'O', 'U', '', '', '', '', '', 'a', 'i',
     'o', 'u', 'n', 'N', '', '', '', '', '', '', '', '', '', '',
     '', '', '', '', '', '', '', '', '', '', '', '', '', '',
     '', '', '', '', '', '', '', '', '', '', '', '', '', '',
     '', '', '', '', '', '', '', '', '', '', '', '', '', '',
     '', '', '', '', '', '', '', '', '', '', '', '', '', '',
     '', '', '', '', '', '', '', '', '', '', '', '', '', '',
     '', '', '', '', '', '', '', '', '', '' },
};


#if !defined( __UNIX__ )
/*
 * Graphic character sets. Added by jmh 980724.
 */
char graphic_char[5][11] = {
   { '', '', '', '',
          '', '', '',
          '', '', '', '' },

   { '', '', '', '',
          '', '', '',
          '', '', '', '' },

   { '', '', '', '',
          '', '', '',
          '', '', '', '' },

   { '', '', '', '',
          '', '', '',
          '', '', '', '' },

   { '', '', '', '', '', '', '', '', '', '', '' }
};
#endif


mode_infos mode = {
   "$ modes",           /* signature for mode structure, 8 chars */
   0,                   /* initial color scheme */
   FALSE,               /* sync mode? */
   TRUE,                /* sync semaphore must be TRUE - DO NOT CHANGE */
   FALSE,               /* macro recording mode must be FALSE - DO NOT CHANGE */
   TRUE,                /* insert mode */
   TRUE,                /* indent mode */
   8,                   /* tab size */
   8,                   /* tab size */
   TRUE,                /* default smart tab mode */
   FALSE,               /* inflate tabs? */
   IGNORE,              /* sort case */
   FALSE,               /* enhanced keyboard flag - set in console.c */
   SMALL_INS,           /* default cursor size == small insert */
   TOF_TEXT,            /* tof message  --  ** defined in letters.h **  */
   EOF_TEXT,            /* eof message  --  ** defined in letters.h **  */
   FALSE,               /* default FALSE = do not write ^Z at end of file */
   NATIVE,              /* default write <cr><lf> at eol */
   TRUE,                /* default remove trailing space on edited lines */
   FALSE,               /* default show eol character is off */
   NO_WRAP,             /* default word wrap mode is off */
   0,                   /* default left margin - add 1 to margins for display */
   2,                   /* default paragraph begin */
   71,                  /* default right margin */
   FALSE,               /* default justify right margin */
   FALSE,               /* format paragraph/text semaphore - DO NOT CHANGE */
   UNDO_STACK_LEN,      /* number lines in undo buffer */
   FALSE,               /* default backup mode */
   TRUE,                /* default ruler mode */
   "%H:%0n  %D, %d %M, %Y",     /* default time-stamp format */
                                /* eg: "17:18  Sunday, 31 May, 1998" */
   FALSE,               /* default cursor cross is off */
   SORT_NAME            /* default filename sort for directory list */
};


/*
 * Default color settings.  Incidentally, I'm color blind (mild red-green) and
 * the default colors look fine to me, Frank.
 * jmh 980804: supplied my own defaults, since I now display the credit
 *             screen before the config is loaded.
 */
/*
 * The following defines specify which video attributes give desired
 *  effects on different display devices.
 * REVERSE is supposed to be reverse video - a different background color,
 *  so that even a blank space can be identified.
 * HIGH is supposed to quickly draw the user's eye to the relevant part of
 *  the screen, either for a message or for matched text in find/replace.
 * NORMAL is supposed to be something pleasant to look at for the main
 *  body of the text.
 */

#define HERC_REVERSE    0x70
#define HERC_UNDER      0x01
#define HERC_NORMAL     0x07
#define HERC_HIGH       0x0f

#define COLOR_HEAD      0x4b    /* Bright Cyan   on Red     */
#define COLOR_BLOCK     0x71    /*        Blue   on Gray    */
#define COLOR_CROSS     0x10    /* actually a XOR mask, not a color */
#define COLOR_RULER     0x02    /*        Green  on Black   */
#define COLOR_POINTER   0x0a    /* Bright Green  on Black   */
#if 0                           /* change to 1 for Frank's default colors */
#define COLOR_TEXT      0x07    /*        Gray   on Black   */
#define COLOR_DIRTY     0x02    /*        Green  on Black   */
#define COLOR_MODE      0x17    /*        Gray   on Blue    */
#define COLOR_MESSAGE   0x0f    /*        White  on Black   */
#define COLOR_HELP      0x1a    /* Bright Green  on Blue    */
#define COLOR_DIAG      0x0e    /*        Yellow on Black   */
#define COLOR_EOF       0x09    /* Bright Blue   on Black   */
#define COLOR_CURL      0x0f    /*        White  on Black   */
#define COLOR_HILITE    0x07    /*        Gray   on Black   */
#define COLOR_OVRS      0x00    /*                  Black   */
#else
#define COLOR_TEXT      0x17    /*        Gray   on Blue    */
#define COLOR_DIRTY     0x1e    /*        Yellow on Blue    */
#define COLOR_MODE      0x6f    /*        White  on Orange/Brown */
#define COLOR_MESSAGE   0x4f    /*        White  on Red     */
#define COLOR_HELP      0x30    /*        Black  on Cyan    */
#define COLOR_DIAG      0x03    /*        Cyan   on Black   */
#define COLOR_EOF       0x12    /*        Green  on Blue    */
#define COLOR_CURL      0x1f    /*        White  on Blue    */
#define COLOR_HILITE    0x5f    /*        White  on Magenta */
#define COLOR_OVRS      0x01    /*                  Blue    */
#endif

TDE_COLORS colour = {
   "$colors",
   { { HERC_REVERSE,  HERC_NORMAL, HERC_UNDER,    HERC_REVERSE, HERC_REVERSE,
       HERC_HIGH,     HERC_NORMAL, HERC_NORMAL,   HERC_HIGH,    HERC_HIGH,
       HERC_REVERSE,  HERC_HIGH,   HERC_REVERSE,  HERC_REVERSE, HERC_NORMAL
     },
     { COLOR_HEAD,    COLOR_TEXT,  COLOR_DIRTY,   COLOR_MODE,   COLOR_BLOCK,
       COLOR_MESSAGE, COLOR_HELP,  COLOR_DIAG,    COLOR_EOF,    COLOR_CURL,
       COLOR_CROSS,   COLOR_RULER, COLOR_POINTER, COLOR_HILITE, COLOR_OVRS
     }
   }
};


/*
 * Default syntax highlighting colors.
 */
int syntax_color[SHL_NUM_COLORS] = {
   30,          /* Normal       -        yellow on blue */
   28,          /* Bad          - bright red    on blue */
   31,          /* Keyword      -        white  on blue */
   23,          /* Comment      -        grey   on blue */
   26,          /* Function     - bright green  on blue */
   27,          /* String       - bright cyan   on blue */
   27,          /* Character    - bright cyan   on blue */
   27,          /* Integer      - bright cyan   on blue */
   27,          /* Binary       - bright cyan   on blue */
   27,          /* Octal        - bright cyan   on blue */
   27,          /* Hex          - bright cyan   on blue */
   27,          /* Real         - bright cyan   on blue */
   19,          /* Preprocessor -        cyan   on blue */
   31           /* Symbol       -        white  on blue */
};


/*
 * do_it is an array of pointers to functions that return int with an argument
 * that is a pointer to a window.  Is that right???
 */
int  (* (do_it[NUM_FUNCS]))( TDE_WIN * ) = {
   insert_overwrite,                /*   regular text keys          0  */
   get_help,                        /*   Help                       1  */
   insert_newline,                  /*   Rturn                      2  */
   next_line,                       /*   NextLine                   3  */
   beg_next_line,                   /*   BegNextLine                4  */
   move_down,                       /*   LineDown                   5  */
   move_up,                         /*   LineUp                     6  */
   move_right,                      /*   CharRight                  7  */
   move_left,                       /*   CharLeft                   8  */
   pan_right,                       /*   PanRight                   9  */
   pan_left,                        /*   PanLeft                   10  */
   word_right,                      /*   WordRight                 11  */
   word_left,                       /*   WordLeft                  12  */
   page_down,                       /*   ScreenDown                13  */
   page_up,                         /*   ScreenUp                  14  */
   goto_end_file,                   /*   EndOfFile                 15  */
   goto_top_file,                   /*   TopOfFile                 16  */
   goto_bottom,                     /*   BotOfScreen               17  */
   goto_top,                        /*   TopOfScreen               18  */
   goto_eol,                        /*   EndOfLine                 19  */
   home,                            /*   BegOfLine                 20  */
   goto_line,                       /*   JumpToLine                21  */
   center_window,                   /*   CenterWindow              22  */
   center_window,                   /*   CenterLine                23  */
   horizontal_screen_right,         /*   HorizontalScreenRight     24  */
   horizontal_screen_left,          /*   HorizontalScreenLeft      25  */
   scroll_down,                     /*   ScrollDnLine              26  */
   scroll_up,                       /*   ScrollUpLine              27  */
   pan_up,                          /*   PanUp                     28  */
   pan_down,                        /*   PanDn                     29  */
   toggle_overwrite,                /*   ToggleOverWrite           30  */
   toggle_smart_tabs,               /*   ToggleSmartTabs           31  */
   toggle_indent,                   /*   ToggleIndent              32  */
   toggle_ww,                       /*   ToggleWordWrap            33  */
   toggle_crlf,                     /*   ToggleCRLF                34  */
   toggle_trailing,                 /*   ToggleTrailing            35  */
   toggle_z,                        /*   ToggleZ                   36  */
   toggle_eol,                      /*   ToggleEol                 37  */
   toggle_sync,                     /*   ToggleSync                38  */
   toggle_ruler,                    /*   ToggleRuler               39  */
   toggle_tabinflate,               /*   ToggleTabInflate          40  */
   set_tabstop,                     /*   SetTabs                   41  */
   set_left_margin,                 /*   SetLeftMargin             42  */
   set_right_margin,                /*   SetRightMargin            43  */
   set_paragraph_margin,            /*   SetParagraphMargin        44  */
   format_paragraph,                /*   FormatParagraph           45  */
   format_paragraph,                /*   FormatText                46  */
   flush_left,                      /*   LeftJustify               47  */
   flush_right,                     /*   RightJustify              48  */
   flush_center,                    /*   CenterJustify             49  */
   tab_key,                         /*   Tab                       50  */
   backtab,                         /*   BackTab                   51  */
   match_pair,                      /*   ParenBalance              52  */
   back_space,                      /*   BackSpace                 53  */
   char_del_under,                  /*   DeleteChar                54  */
   char_del_under,                  /*   StreamDeleteChar          55  */
   line_kill,                       /*   DeleteLine                56  */
   eol_kill,                        /*   DelEndOfLine              57  */
   word_delete,                     /*   WordDelete                58  */
   insert_newline,                  /*   AddLine                   59  */
   insert_newline,                  /*   SplitLine                 60  */
   join_line,                       /*   JoinLine                  61  */
   dup_line,                        /*   DuplicateLine             62  */
   undo_line,                       /*   AbortCommand              63  */
   undo_line,                       /*   UndoLine                  64  */
   undo,                            /*   UndoDelete                65  */
   toggle_search_case,              /*   ToggleSearchCase          66  */
   find_string,                     /*   FindForward               67  */
   find_string,                     /*   FindBackward              68  */
   find_string,                     /*   RepeatFindForward         69  */
   find_string,                     /*   RepeatFindBackward        70  */
   replace_string,                  /*   ReplaceString             71  */
   define_diff,                     /*   DefineDiff                72  */
   repeat_diff,                     /*   RepeatDiff                73  */
   mark_block,                      /*   MarkBlock                 74  */
   mark_block,                      /*   MarkLine                  75  */
   mark_block,                      /*   MarkStream                76  */
   unmark_block,                    /*   UnMarkBlock               77  */
   block_operation,                 /*   FillBlock                 78  */
   block_operation,                 /*   NumberBlock               79  */
   block_operation,                 /*   CopyBlock                 80  */
   block_operation,                 /*   KopyBlock                 81  */
   block_operation,                 /*   MoveBlock                 82  */
   block_operation,                 /*   OverlayBlock              83  */
   block_operation,                 /*   DeleteBlock               84  */
   block_operation,                 /*   SwapBlock                 85  */
   block_write,                     /*   BlockToFile               86  */
   block_print,                     /*   PrintBlock                87  */
   block_expand_tabs,               /*   BlockExpandTabs           88  */
   block_compress_tabs,             /*   BlockCompressTabs         89  */
   block_compress_tabs,             /*   BlockIndentTabs           90  */
   block_trim_trailing,             /*   BlockTrimTrailing         91  */
   block_convert_case,              /*   BlockUpperCase            92  */
   block_convert_case,              /*   BlockLowerCase            93  */
   block_convert_case,              /*   BlockRot13                94  */
   block_convert_case,              /*   BlockFixUUE               95  */
   block_email_reply,               /*   BlockEmailReply           96  */
   block_convert_case,              /*   BlockStripHiBit           97  */
   sort_box_block,                  /*   SortBoxBlock              98  */
   date_time_stamp,                 /*   DateTimeStamp             99  */
   edit_another_file,               /*   EditFile                 100  */
   dir_help,                        /*   DirList                  101  */
   file_file,                       /*   File                     102  */
   save_file,                       /*   Save                     103  */
   save_as_file,                    /*   SaveAs                   104  */
   change_fattr,                    /*   SetFileAttributes        105  */
   edit_next_file,                  /*   EditNextFile             106  */
   search_and_seize,                /*   DefineGrep               107  */
   search_and_seize,                /*   RepeatGrep               108  */
   redraw_screen,                   /*   RedrawScreen             109  */
   size_window,                     /*   SizeWindow               110  */
   split_horizontal,                /*   SplitHorizontal          111  */
   split_vertical,                  /*   SplitVertical            112  */
   next_window,                     /*   NextWindow               113  */
   prev_window,                     /*   PreviousWindow           114  */
   zoom_window,                     /*   ZoomWindow               115  */
   next_hidden_window,              /*   NextHiddenWindow         116  */
   set_marker,                      /*   SetMark1                 117  */
   set_marker,                      /*   SetMark2                 118  */
   set_marker,                      /*   SetMark3                 119  */
   goto_marker,                     /*   GotoMark1                120  */
   goto_marker,                     /*   GotoMark2                121  */
   goto_marker,                     /*   GotoMark3                122  */
   record_on_off,                   /*   RecordMacro              123  */
   play_back,                       /*   PlayBack                 124  */
   save_strokes,                    /*   SaveMacro                125  */
   tdecfgfile,                      /*   LoadMacro                126  */
   clear_macros,                    /*   ClearAllMacros           127  */
   macro_pause,                     /*   Pause                    128  */
   quit,                            /*   Quit                     129  */
   next_dirty_line,                 /*   NextDirtyLine            130  */
   prev_dirty_line,                 /*   PrevDirtyLine            131  */
   find_regx,                       /*   FindRegX                 132  */
   find_regx,                       /*   RepeatFindRegX           133  */
   find_regx,                       /*   RepeatFindRegXBackward   134  */
   search_and_seize,                /*   DefineRegXGrep           135  */
   main_pull_down,                  /*   PullDown                 136  */
   tdecfgfile,                      /*   ReadConfig               137  */
   /* the following functions were added by jmh */
   prev_hidden_window,              /*   PrevHiddenWindow         138  */
   dos_shell,                       /*   DosShell                 139  */
   word_right,                      /*   FullWordRight            140  */
   word_left,                       /*   FullWordLeft             141  */
   dos_screen,                      /*   DosScreen                142  */
   quit_all,                        /*   QuitAll                  143  */
   goto_marker,                     /*   BlockBegin               144  */
   goto_marker,                     /*   BlockEnd                 145  */
   back_space,                      /*   WordDeleteBack           146  */
   goto_marker,                     /*   PreviousPosition         147  */
   file_all,                        /*   FileAll                  148  */
   syntax_toggle,                   /*   SyntaxToggle             149  */
   syntax_select,                   /*   SyntaxSelect             150  */
   transpose,                       /*   Transpose                151  */
   edit_another_file,               /*   InsertFile               152  */
   word_right,                      /*   WordEndRight             153  */
   word_left,                       /*   WordEndLeft              154  */
   word_right,                      /*   FullWordEndRight         155  */
   word_left,                       /*   FullWordEndLeft          156  */
   stamp_format,                    /*   StampFormat              157  */
   play_back,                       /*   PsuedoMacro              158  */
   set_marker,                      /*   MacroMark                159  */
   toggle_cursor_cross,             /*   ToggleCursorCross        160  */
   toggle_graphic_chars,            /*   ToggleGraphicChars       161  */
   repeat,                          /*   Repeat                   162  */
   block_operation,                 /*   BorderBlock              163  */
   mark_block,                      /*   MarkBegin                164  */
   mark_block,                      /*   MarkEnd                  165  */
   block_operation,                 /*   BlockLeftJustify         166  */
   block_operation,                 /*   BlockRightJustify        167  */
   block_operation,                 /*   BlockCenterJustify       168  */
   block_indent,                    /*   BlockIndent1             169  */
   block_indent,                    /*   BlockUndent1             170  */
   block_indent,                    /*   BlockIndent              171  */
   block_indent,                    /*   BlockUndent              172  */
   set_break_point,                 /*   SetBreakPoint            173  */
   change_cur_dir                   /*   ChangeCurDir             174  */
};
