/*
 * New editor name:  TDE, the Thomson-Davis Editor.
 * Author:           Frank Davis
 * Date:             June 5, 1992
 *
 * This file contains all user prompts in TDE.  Prompts were gathered into
 *  one file to make the job of translating English into other languages
 *  as easy as possible.
 *
 * jmh 980525: made it a C file.
 * jmh 980809: moved the help displays and menu into separate files.
 */

/*
#include "tdestr.h"
#include "define.h"
*/
#include "bj_ctype.h"


char *cb      = "Control-Break pressed";


/*
 * block.c
 */
char *block1  = "a block is already defined in another file";

char *ltol    = "Error: line would be too long";
char *block2  = "can only fill box blocks";
char *block3a = "can only number box blocks";
char *block3b = "cannot swap stream blocks";
char *block3c = "cannot swap non-existant lines";       /* added by jmh */
char *block4  = "not enough memory for block";
char *block5  = "can only overlay box blocks";

char *block6  = "File name: ";
char *block7  = "File exists. Overwrite or Append?";
char *block8  = "writing block to '";
char *block9  = "could not write block";
char *block10 = "appending block to '";
char *block11 = "could not append block";
char *block12 = "writing block to '";

char *block13 = "Print file or block?";
char *block14 =
             "Printing line         of         Press Control-Break to cancel.";

char *block15 = "Enter character to fill block (ESC to exit): ";

char *block16 = "Enter starting number: ";
char *block17 = "Enter increment: ";
char *block18 = "Left or Right justify numbers in block?";

char *block20  = "can only expand tabs in line blocks";
char *block20a = "can only compress tabs in line blocks";

char *block21 = "can only trim trailing space in line blocks";

char *block22a = "Phase 1) Quicksort";
char *block22b = "Phase 2) Insertion sort";
char *block23 = "Can only sort box blocks";
char *block24 = "Box block not marked";

char *block25 = "can only e-mail reply in line blocks";

/* jmh 980731: added following three. */
char *block26 = "can only border box blocks";
char *block27 = "Border style (F1 = help): ";
char *block28 = "invalid style";

char *block29 = "cannot justify stream blocks"; /* jmh 980810 */
char *block30 = "cannot indent stream blocks";  /* jmh 980811 */
char *block31 = "Indentation level: ";          /* jmh 980811 */


/*
 * config.c
 *
 * jmh 980721: added config0
 */
char *config0 = ".  line:  ";
char *config1 = "Setting without value";
char *config2 = "Two-key cannot be TwoCharKey";
char *config3 = "Unrecognized function";
char *config6 = "Color number out of range";
char *config7 = "Off/On error";
char *config8 = "Tab error";
char *config9 = "Left margin error";
char *config10 = "Paragraph margin error";
char *config11 = "Right margin error";
char *config12 = "CRLF or LF error";
char *config13 = "Word wrap error";
char *config14 = "Cursor size error";
char *config15 = "Control Z error";
char *config16 = "Inflate tabs error";
char *config17 = "EOL display error";
char *config18 = "Initial Case Mode error";
char *config19 = "Unknown mode";
char *config20 = "Unrecognized editor setting";
char *config21 = "Unterminated quote";
char *config22 = "Unrecognized key";
char *config23 = "No more room in macro buffer";
char *config24 = "Error parsing color pair";
char *config25 = "Invalid or missing pseudo-macro combination";
char *config26 = "Unexpected end of file";
char *config27 = "Directory sort error";
char *config28 = "Second key of two-key missing";


/*
 * diff
 */
char *diff_prompt0 = "Two visible windows required for diff'ing";
char *diff_prompt1 = "DIFF:  Enter first window number and letter (e.g. 1a) : ";
char *diff_prompt2 = "DIFF:  Enter next window number and letter (e.g. 2a) : ";
char *diff_prompt3 =
     "DIFF:  Start diff at Beginning of file or Current position?";
char *diff_prompt4 =
     "DIFF:  Diffed until EOF(s).  No diff's were found";
char *diff_prompt5 = "DIFF windows not defined";
char *diff_prompt6a = "window '";
char *diff_prompt6b = "' not visible or does not exist";
char *diff_prompt7a = "DIFF:  Ignore leading spaces?";
char *diff_prompt7b = "DIFF:  Ignore all space?";
char *diff_prompt7c = "DIFF:  Ignore blank lines?";
char *diff_prompt7d =
     "DIFF:  Ignore end of line (useful with reformatted paragraphs)?";


/*
 * dir list
 */
char *dir1 = "Search path or pattern : ";
char *dir2 = "Invalid path or file name";

char *dir4 = "    Directory : ";
char *dir5 = "Selected file : ";
char *dir6 = "    File size : ";
char *dir7 = "File count : ";

char *dir8 = "Cursor keys move.  Enter selects file or new directory";


/*
 * ed.c
 */
char *ed1  = "line too long to add";
char *ed2  = "cannot insert more characters";
char *ed3  = "no more room to add";

char *ed4  = "cannot combine lines";

char *ed5  = "cannot duplicate line";

char *ed7a = "Logical tab interval: ";
char *ed7b = "Physical (file) tab interval: ";
char *ed8  = "tab size too long";

char *ed9  = "Enter new left margin (must be less than right margin) : ";
char *ed10 = "Left margin out of range";

char *ed11a = "Justify right margin?";
char *ed11 = "Enter new right margin (must be greater than left margin) : ";
char *ed12 = "Right margin out of range";

char *ed13 = "Enter paragraph margin (must be less than right margin) : ";
char *ed14 = "Paragraph margin out of range";

char *ed15  = "File name to edit : ";
char *ed15a = "File name to insert : "; /* added by jmh */

char *ed16 = "Macro execution halted:  Internal stack overflow";
char *ed17 = "Macro execution halted:  Internal stack underflow";

char *ed18 = "BINARY line length (0 for text) : "; /* jmh 981127 */

char *ed19 = "Repeat count: ";                  /* added by jmh 980726 */
char *ed20 = "Press the key to be repeated.";   /* ditto */

char *ed21 = "Press the key for cursor update direction."; /* jmh 981129 */

char *paused1 = "Paused:";
char *paused2 = "  Press ESC to halt macro   ";


/*
 * findrep.c
 */
char *find1  = "Prompt before replace?";
char *find2  = "(R)eplace  (S)kip  (E)xit";
char *find3  = "Search has wrapped.  Continue or quit?";

char *find4  = "String to find: ";
char *find5a = "string \"";
char *find5b = "\" not found";
char *find6  = "find pattern not defined";


char *find7[] = { "          ",
                  "wrapped...",
                  "searching ",
                  "replacing ",
                  "nfa choked",
                  "diffing...",
                  "Next Key.." };


char *find8  = "string not found";
char *find9  = "String to find: ";
char *find10 = "Replacement:    ";

char *find11 = "Line number: ";
char *find12 = "must be in the range 1 - ";

char *find13 = "Search";        /* added by jmh 980614 */


/*
 * hwind.c
 */
char *file_win = "F=   W=";     /* changed from file_win_mem by jmh 981130 */
char *mem_eq   = "m=";

char *tabs       = "Tabs=";
char *smart      = "S";
char *fixed      = "F";
char *tab_mode[] = { "D",
                     "I",
                     "R" };

char *indent  = "Indent";
char *blank   = "      ";

char *ignore = "Ignore";
char *match  = "Match ";

char *sync_off = "    ";
char *sync_on  = "Sync";

char *ww_mode[]  = { "  ",
                     "FW",
                     "DW" };

char *eol_mode[] = { "Native",
                     "CRLF  ",
                     "LF    ",
                     "Binary" };

#if !defined( __UNIX__ )
char *graphic_mode = "Graphic ?";       /* cf. GRAPHIC_SLOT */
#endif

char *cur_dir_mode[] = { "Right",       /* not actually displayed */
                         "Left",        /* these three strings should not */
                         "Down",        /* be any longer than the memory  */
                         "Up" };        /* display (8 characters)         */


/*
 * Incidentally, these need to be 4 characters wide.  The previous file mode
 * should leave no residue in the lite bar, when toggling thru the modes.
 */
char *mode_lf   = "lf  ";
char *mode_crlf = "crlf";
char *mode_bin  = "BIN ";



/*
 * main.c
 */
char *main1   = "Fatal error: ";
char *main2   = "Warning: ";
char *main3   = " : press a key";

char *main4   = "Out of memory";

char *main5   = "negative move - contact Frank Davis";

char *main6   = "File is write protected.  Overwrite anyway?";

char *main7a  = "File '";
char *main7b  = "' not found or error loading file";

char *main8a  = "File '";
char *main8b  = "' too big.  FILE WILL BE TRUNCATED IF SAVED!";

char *main9   = "error reading file '";

char *main9a = "FRANK: error reading file!";    /* devas neniam okazi? */

char *main10a = "file '";
char *main10b = "' too big";

char *main11  = "Press the key that will play back this recording : ";
char *main12  = "Cannot assign a recording to this ";
char *main12a = "key";
char *main12b = "combination";
char *main13  = "No more room in recording buffer";
char *main14  = "Overwrite recording?";

char *main15  = "Recording";

char *main18  = "  Avail strokes =      ";

char *main19  = "Name for macro file name: ";
char *main20a = "; TDE global %s\n\n";
#if defined( __DOS16__ )
char *main20b = "; TDE \"%Fs\" %s\n\n";
#else
char *main20b = "; TDE \"%s\" %s\n\n";
#endif
char *main20c = "macros, written %H:%0n, %d %M, %Y";
char *main21  = "Search path or file name for macro file : ";

/* Added by jmh */
char *main22  = "Quit- and file-all are disabled during redirection";


/*
 * regx.c
 */
char *reg1   = "Regular expression search (F1 = help): ";
char *reg2   = "unmatched open paren";
char *reg3   = "unmatched close paren";
char *reg4   = "char \'\\\' at end of string is not escaped";
char *reg5   = "class is not defined properly";
char *reg6   = "unmatched open bracket";
char *reg7   = "out of heap for class definition";
char *reg8   = "operator *, + , or ? error";
char *reg9   = "unmatched close bracket";
char *reg10  = "incomplete range in character class";
char *reg11  = "Can't parse two operators in a row";


/*
 * syntax.c
 */
char *syntax1   = "Unrecognized syntax setting";
char *syntax2   = "Expecting \"pattern\" after \"language\"";
char *syntax3   = "Expecting a color setting";
char *syntax4   = "Expecting a color number";
char *syntax5   = "Setting is in the wrong place";
char *syntax6   = "Case setting not recognized";
char *syntax7   = "Expecting one non-alphanumeric character";
char *syntax8   = "Only one or two characters allowed";
char *syntax9   = "Only one character allowed";
char *syntax10  = "Number requires a prefix or suffix";
char *syntax11  = "Number cannot be both prefix and suffix";
char *syntax12  = "Syntax highlighting language: ";
char *syntax13a = "Language '";
char *syntax13b = "' not found";


/*
 * utils.c
 */
char *utils1  = "line buffer overflow - rest of line ignored";
char *utils3  = "buffer full, part line truncated";

char *utils4  = "Sort Ascending or Descending?";

char *utils5a  = "Replace";     /* split in two by jmh 980614 */
char *utils5b  = "forward or backward?";

char *utils6  = "Saving '";
char *utils7a = "file  '";
char *utils7b = "' is Read Only";
char *utils8  = "cannot write to '";

char *utils9  = "New file name: ";

char *utils10 = "Overwrite existing file?";

char *utils11 = "Error writing file or disk full";

char *utils12 = "Abandon changes?";
char *utils12a = "Abandon all files?";  /* jmh */

char *utils13 = "Marker   not set in this file";

#if defined( __UNIX__ )
char *utils14 = "Enter new file attributes, \"RrWwXx\" : ";
char *utils15 = "New file attributes not set.  Wrong owner, perhaps";
#else
char *utils14 = "Enter new file attributes, \"AaSsHhRr\" : ";
char *utils15 = "New file attributes not set";
#endif

char *utils16 = "No dirty lines found";

char *time_ampm[2] = { "am", "pm" };

/*
 * following six added by jmh 980521
 */
char *utils17 = "Enter new stamp format (F1 = help) : ";

char *months[2][12] = {
   { "January", "February", "March",     "April",   "May",      "June",
     "July",    "August",   "September", "October", "November", "December"
   },
   { "Jan", "Feb", "Mar", "Apr", "May", "Jun",
     "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
   }
};

char *days[2][7] = {
   { "Sunday",   "Monday", "Tuesday", "Wednesday",
     "Thursday", "Friday", "Saturday"
   },
   { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" }
};


/*
 * window.c
 */
char *win1 = "move cursor up first";

char *win2 = "move cursor right first";
char *win3 = "move cursor left first";

char *win4 = "Use cursor keys to change window size.  Press Return when done.";
char *win5 = "too many windows";
char *win6 = "cannot resize top window";

char *win7 = "cannot close current window";

char *win8  = "Invalid path or file name";
char *win9  = "No more files to load";
char *win9a = "Use the <Grep> key for more files";      /* jmh */

char *win16a = "Enter search string:  ";
char *win16b = "Enter regular expression search string:  ";
char *win17  = "Enter file names to search:  ";

char *win18 =
   "Press Return or the <Grep> key for more files, anything else to quit";

char *win19 = "Searching:  ";


/*
 * wordwrap.c
 */
char *ww1  = "line would be too long";
char *ww2  = "line too long to format";


/************************************************************************/
/* Editor:      TDE, the Thomson-Davis Editor
 * Filename:    prompts2.h
 * Compiled by: Byrial Jensen
 *
 * This file contains various prompts and other strings, collected to
 * to ease making versions for other languages.
 * Here is: What is "forgotten" in prompts.h
 *          A string with the alphabet used for window names
 *          Tables used by functions in myctype.c and macros in myctype.h
 * It is used with changed versions of several of the TDE source files
 */


/*
 * These letters are used to differentiate windows in the same file.
 *  Some users may prefer the sequence of their alphabet, instead of
 *  this English sequence.
 */
char *windowletters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";


/*
 * First some defines which only purpose is to make the next table
 * more compact and easy to see, Byrial.
 */
#define  S   BJ_space
#define  D   (BJ_digit | BJ_xdigit)     /* bit mask for digit */
#define  U   BJ_upper
#define  L   BJ_lower
#define  H   (BJ_xdigit | U)            /* bit mask for uppercase hex digit */
#define  h   (BJ_xdigit | L)            /* bit mask for lowercase hex digit */
#define  C   BJ_cntrl
#define  P   BJ_punct
#define  s   (S | C)                    /* counts both for space and control */


/*
 * I'll give the English ASCII and Extended-ASCII keyboards a try, Frank.
#define CHAR_SET   LATIN_3
 */
#define CHAR_SET   ENGLISH

#if CHAR_SET==ENGLISH
char bj_ctype[257] = {
    0,                        /* EOF returns 0, I am assumimg EOF == -1 */
    C,C,C,C, C,C,C,C,  C,s,s,s, s,s,C,C,  /* 00h-0Fh    0- 15 */
    C,C,C,C, C,C,C,C,  C,C,C,C, C,C,C,C,  /* 10h-1Fh   16- 31 */
    S,P,P,P, P,P,P,P,  P,P,P,P, P,P,P,P,  /* 20h-2Fh   32- 47 */
    D,D,D,D, D,D,D,D,  D,D,P,P, P,P,P,P,  /* 30h-3Fh   48- 63 */

    P,H,H,H, H,H,H,U,  U,U,U,U, U,U,U,U,  /* 40h-4Fh   64- 79 */
    U,U,U,U, U,U,U,U,  U,U,U,P, P,P,P,P,  /* 50h-5Fh   80- 95 */
    P,h,h,h, h,h,h,L,  L,L,L,L, L,L,L,L,  /* 60h-6Fh   96-111 */
    L,L,L,L, L,L,L,L,  L,L,L,P, P,P,P,C,  /* 70h-7Fh  112-127 */

    U,L,L,L, L,L,L,L,  L,L,L,L, L,L,U,U,  /* 80h-8Fh  128-143 */
    U,L,U,L, L,L,L,L,  U,L,U,P, P,P,P,P,  /* 90h-9Fh  144-159 */
    L,L,L,L, L,U,P,P,  P,P,P,P, P,P,P,P,  /* A0h-AFh  160-175 */
    P,P,P,P, P,P,P,P,  P,P,P,P, P,P,P,P,  /* B0H-BFh  176-191 */

    P,P,P,P, P,P,P,P,  P,P,P,P, P,P,P,P,  /* C0h-CFh  192-207 */
    P,P,P,P, P,P,P,P,  P,P,P,P, P,P,P,P,  /* D0h-DFh  208-223 */
    L,L,L,U, L,L,L,L,  L,L,L,L, L,L,P,P,  /* E0h-EFh  224-239 */
    P,P,P,P, P,P,P,P,  P,P,P,P, P,P,P,0   /* F0h-FFh  240-255 */
};
#else
/*
 * This is Byrial's definition for ISO 8859-3 (Latin 3) added with
 * normal ASCII control characters.
 */
char bj_ctype[257] = {
    0,                        /* EOF returns 0, I am assumimg EOF == -1 */
    C,C,C,C, C,C,C,C,  C,s,s,s, s,s,C,C,  /* 00h-0Fh    0- 15 */
    C,C,C,C, C,C,C,C,  C,C,C,C, C,C,C,C,  /* 10h-1Fh   16- 31 */
    S,P,P,P, P,P,P,P,  P,P,P,P, P,P,P,P,  /* 20h-2Fh   32- 47 */
    D,D,D,D, D,D,D,D,  D,D,P,P, P,P,P,P,  /* 30h-3Fh   48- 63 */

    P,H,H,H, H,H,H,U,  U,U,U,U, U,U,U,U,  /* 40h-4Fh   64- 79 */
    U,U,U,U, U,U,U,U,  U,U,U,P, P,P,P,P,  /* 50h-5Fh   80- 95 */
    P,h,h,h, h,h,h,L,  L,L,L,L, L,L,L,L,  /* 60h-6Fh   96-111 */
    L,L,L,L, L,L,L,L,  L,L,L,P, P,P,P,C,  /* 70h-7Fh  112-127 */

    0,0,0,0, 0,0,0,0,  0,0,0,0, 0,0,0,0,  /* 80h-8Fh  128-143 */
    0,0,0,0, 0,0,0,0,  0,0,0,0, 0,0,0,0,  /* 90h-9Fh  144-159 */
    s,U,P,P, P,0,U,P,  P,U,U,U, U,C,0,U,  /* A0h-AFh  160-175 */
    P,L,P,P, P,P,L,P,  P,L,L,L, L,P,0,L,  /* B0H-BFh  176-191 */

    U,U,U,0, U,U,U,U,  U,U,U,U, U,U,U,U,  /* C0h-CFh  192-207 */
    0,U,U,U, U,U,U,P,  U,U,U,U, U,U,U,U,  /* D0h-DFh  208-223 */
    L,L,L,0, L,L,L,L,  L,L,L,L, L,L,L,L,  /* E0h-EFh  224-239 */
    0,L,L,L, L,L,L,P,  L,L,L,L, L,L,L,P   /* F0h-FFh  240-255 */
};
#endif

#undef S        /* These letters where only defined to make the */
#undef D        /* above table as compact as possible.          */
#undef U        /* Now they can be undef'ed, Byrial             */
#undef L
#undef H
#undef h
#undef C
#undef P
#undef s


/*
 * State corresponding uppercase letter for each lowercase letter,
 * and corresponding lowercase letter for each uppercase letter.
 * If the right corresponding letter does not exist in the character set
 * state best replacement, possible the letter self in wrong case.
 * Byrial Jensen.
 */

#if CHAR_SET==ENGLISH
/*
 * Thought I would give code page 437 (English) a try, Frank.
 */
unsigned char upper_lower[256] = {

     0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,
     0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,
     0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,
     0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,

     0 ,'a','b','c', 'd','e','f','g',  'h','i','j','k', 'l','m','n','o',
    'p','q','r','s', 't','u','v','w',  'x','y','z', 0 ,  0 , 0 , 0 , 0 ,
     0 ,'A','B','C', 'D','E','F','G',  'H','I','J','K', 'L','M','N','O',
    'P','Q','R','S', 'T','U','V','W',  'X','Y','Z', 0 ,  0 , 0 , 0 , 0 ,

    '','','','A', '','A','','',  'E','E','E','I', 'I','I','','',
    '','','','O', '','O','U','U',  'y','','', 0 ,  0 , 0 , 0 , 0 ,
    'A','I','O','U', '','', 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,
     0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,

     0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,
     0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,
    '','','','', '','','','',  '','','','', '','', 0 , 0 ,
     0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0
};
#else
/*
 * This is a definition valid for ISO 8859-3 (Latin 3), Byrial:
 */
unsigned char upper_lower[256] = {

     0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,
     0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,
     0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,
     0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,

     0 ,'a','b','c', 'd','e','f','g',  'h','i','j','k', 'l','m','n','o',
    'p','q','r','s', 't','u','v','w',  'x','y','z', 0 ,  0 , 0 , 0 , 0 ,
     0 ,'A','B','C', 'D','E','F','G',  'H','I','J','K', 'L','M','N','O',
    'P','Q','R','S', 'T','U','V','W',  'X','Y','Z', 0 ,  0 , 0 , 0 , 0 ,

     0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,
     0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,
     0 ,'', 0 , 0 ,  0 , 0 ,'', 0 ,   0 ,'','','', '', 0 , 0 ,'',
     0 ,'', 0 , 0 ,  0 , 0 ,'', 0 ,   0 ,'','','', '', 0 , 0 ,'',

    '','','', 0 , '','','','',  '','','','', '','','','',
     0 ,'','','', '','','', 0 ,  '','','','', '','','','',
    '','','', 0 , '','','','',  '','','','', '','','','',
     0 ,'','','', '','','', 0 ,  '','','','', '','','', 0
};
#endif
