#include "pt.h"
#include "memory.h"
#include "malloc.h"

int pascal
/* XTAG:getBox */
getBox(inRow, inCol, outRow1, outCol1, outRow2, outCol2, boxMode)
	/* boxMode=0 is resize box; =1 is stretch box; =2 to move box */
	int inRow, inCol, *outRow1, *outCol1, *outRow2, *outCol2;
{
	extern unsigned char msgBuffer[];
	extern struct SREGS segRegs;
	extern unsigned char *screenChars;
	extern unsigned char border3[];
	extern union REGS rin, rout;
	extern int debug;
	extern unsigned char borderColor;
	extern int scrRows, scrCols;
	extern int evhead, evtail;
	extern struct event events[];
	extern int menuLine;
	extern int cursorMouse;
	extern int mousePresent;
	extern unsigned char *userMessages[];

	int curRow, curCol, row1, col1, row2, col2;
	int row2save, col2save;
	int r1, c1, r2, c2, rmin, rmax, offset, ret;
	int saveCursorMouse, twoClicks, startButtons;
	unsigned char far *sBuffer;
	unsigned int sizeOfBuffer;
	unsigned char *lineBuffer;
	int lineSize;

	/* get the present mouse button state */
	if( mousePresent ) {
		rin.x.ax = 3;
		int86(51, &rin, &rout);
		startButtons = rout.x.bx;
		if( boxMode == 2 ) {
			inRow = rout.x.dx>>3;
			inCol = rout.x.cx>>3;
		}
	} else {
		startButtons = 0x7;
		if( boxMode == 2 )
			getCPos(&inRow, &inCol);
	}
		
	/* save the bottom line */
	lineSize = scrCols<<1;
	lineBuffer = malloc(lineSize);
	if( lineBuffer != NULL )
		memcpy(lineBuffer, screenChars + (scrRows-1)*(scrCols<<1),
			lineSize);
	ret = 0;
	saveCursorMouse = cursorMouse;
	cursorMouse = 1;
	twoClicks = 0;

	switch( boxMode ) {
	case 0:	/* resize the whole box */
		msg("Press the left mouse button at one corner", 1);
		if( downButtons(&row1, &col1) ) {
			ret = 2;
			goto cancelBox;
		}
		if( menuLine > 0 && row1 == 0 ) {
			/* this is so a double click on the menu line */
			/* will default to a full size window */
			row1 = 1;
			col1 = 0;
		}
		startButtons = 0x7;	/* ignore more buttons */
		msg("Release at the opposite corner", 1);
		goto notFixed;
	case 1:	/* stretch the box from the corner */
		msg("Release at the new corner", 1);
		row1 = inRow;
		col1 = inCol;
	notFixed:
		r1 = r2 = row2 = row1;
		c1 = c2 = col2 = col1;
		break;
	case 2:	/* move the box from the corner */
		msg("Release at the new position", 1);
		r1 = row1 = *outRow1;
		c1 = col1 = *outCol1;
		r2 = row2save = *outRow2;
		c2 = col2save = *outCol2;
		row2 = inRow;
		col2 = inCol;
		break;
	}

	/* save the present screen characters */
	/* allocate some memory to hold the screen image */
	sizeOfBuffer = (unsigned)((scrCols<<1)*scrRows);
	sBuffer = _fmalloc(sizeOfBuffer);
	if( sBuffer == 0L ) {
		msg(userMessages[NOSPACEMSG], 3);
		if( lineBuffer != NULL ) {
			free(lineBuffer);
		}
		return 1;	/* getBox cancelled */
	}
	movedata(segRegs.ds, (int)screenChars, FP_SEG(sBuffer),
		FP_OFF(sBuffer), sizeOfBuffer);

	/* this loops follows the mouse and redraws the shadow box */
	while( 1 ) {
		if( !isMouseEvent(1) )
			continue;	/* wait for a mouse event */
		evhead = getMouseEvent();

		/* skip intermediate mouse movements (no button changes) */
		while( events[evhead].mask == 1 && evhead != evtail ) {
			if( ++evhead >= NEVENTS )
				evhead = 0;
		}

		/* check for more buttons to be than we at the beginning */
		if( ((~startButtons) & events[evhead].buttons) != 0 ) {
			ret = 1;
			break;
		}

		/* stop at a mouse click or release */
		if( events[evhead].buttons == 0 ) {
			/* twoClicks is for no-mouse operation */
			if( mousePresent || twoClicks )
				break;
		}
		
		/* set twoClicks on the second click */
		if( !mousePresent && events[evhead].buttons != 0 )
			twoClicks = 1;

		/* get the new corner */
		curRow = events[evhead].vertical>>3;
		/* check for going off the bottom of the screen */
		/* This can happen if the mouse driver is not set right */
		if( curRow >= scrRows )
			curRow = scrRows - 1;
		curCol = events[evhead].horizontal>>3;
		/* check for going off the right of the screen */
		/* This can happen if the mouse driver is not set right */
		if( curRow >= scrCols )
			curRow = scrCols - 1;

		/* has the mouse moved? */
		if( curRow != row2 || curCol != col2 ) {

			/* erase the old box (except the first iteration) */
			sizeOfBuffer = (unsigned)((scrCols<<1)*(r2-r1+1));
			offset = (scrCols<<1)*r1;
			movedata(FP_SEG(sBuffer), FP_OFF(sBuffer)+offset,
				segRegs.ds, (int)(screenChars+offset),
				sizeOfBuffer);

			/* determine the corners of the new shadow box */
			if( boxMode == 2 ) {
				offset = curCol - inCol;
				c1 = col1 + offset;
				if( c1 < 0 )
					c1 = 0;
				c2 = col2save + offset;
				if( c2 > (scrCols-1) )
					c2 = (scrCols-1);
				offset = curRow - inRow;
				rmin = r1;
				r1 = row1 + offset;
				if( r1 < 0 )
					r1 = 0;
				if( r1 < rmin )
					rmin = r1;
				rmax = r2;
				r2 = row2save + offset;
				if( r2 > (scrRows-1) )
					r2 = (scrRows-1);
				if( r2 > rmax )
					rmax = r2;
			} else {
				r1 = min(row1, curRow);
				c1 = min(col1, curCol);
				r2 = max(row1, curRow);
				c2 = max(col1, curCol);
			}
			if( menuLine > 0 && r1 == 0 )
				r1 = 1;
			if( menuLine < 0 && r2 == (scrRows-1) )
				--r2;
			/* highlight the border */
			setMap(r1, c1, r2, c2, 1, 0x07);
			drawBorder(&border3[0], r1, c1, r2, c2, borderColor,
				0);
			if( boxMode != 2 ) {
				rmin = min(r1, min(r2, row2));
				rmax = max(r1, max(r2, row2));
			}
			updateScreen(rmin, rmax);
			row2 = curRow;
			col2 = curCol;
		}
	}

	/* restore the screen */
	sizeOfBuffer = (unsigned)((scrCols<<1)*scrRows);
	movedata(FP_SEG(sBuffer), FP_OFF(sBuffer), segRegs.ds,
		(int)screenChars, sizeOfBuffer-(scrCols<<1));
		/* don't restore the last row since we will rewrite */
		/* in immediately (6 lines down) */
	_ffree(sBuffer);

cancelBox:
	/* retore the bottom line */
	if( lineBuffer != NULL ) {
		memcpy(screenChars+(scrRows-1)*(scrCols<<1), lineBuffer,
			lineSize);
		free(lineBuffer);
	}
	updateScreen(0, scrRows-1);
	
	/* return the new corners */
	*outRow1 = r1;
	*outCol1 = c1;
	*outRow2 = r2;
	*outCol2 = c2;
	cursorMouse = saveCursorMouse;
	return ret;
}
