#include "stdio.h"

#define NSCREENS 256
#define BUFFERSIZE 512

char buffer[BUFFERSIZE];
long screens[NSCREENS];

main(argc, argv)
	char *argv[];
{
	char ch, *s, *fgets(), fromFile[80], toFile[80];
	int i, len, n;
	long cp, ftell();
	FILE *fp, *fout;
	
	if( argc < 2 ) {
		printf("Raw help file to index: ");
		scanf("%s", fromFile);
	} else
		strcpy(fromFile, argv[1]);

	if( argc < 3 ) {
		printf("Indexed help file to write: ");
		scanf("%s", toFile);
	} else
		strcpy(toFile, argv[2]);
	printf("\nIndexing file %s into file %s\n\n",
		fromFile, toFile);

	fp = fopen(fromFile, "rb");
	if( fp == NULL ) {
		cprintf("Could not open %s\n", fromFile);
		exit(2);
	}

	/* initialize */
	for(i = 0; i < NSCREENS; ++i)
		screens[i] = 0L;

	printf("Scanning %s to find all the screens defined ...\n", fromFile);
	/* find all the screen and their offsets */
	while( 1 ) {
		cp = ftell(fp);
		s = fgets(buffer, BUFFERSIZE, fp);
		if( s == NULL )	/* end of file */
			break;
		if( *s == '\\' ) {
			ch = *++s;
			if( '0' <= ch && ch <= '9' ) {
				n = atoi(s);
				if( n > NSCREENS )
					cprintf("screen %d out of range\r\n",
						n);
				else
					screens[n] = cp+8*NSCREENS;
			}
		}
	}
	fout = fopen(toFile, "wb");
	if( fout == NULL ) {
		cprintf("Could not open %s\r\n", toFile);
		exit(3);
	}

	printf("Writing the screen index to %s\n", toFile);
	for(i = 0; i < NSCREENS; ++i)
		fprintf(fout, "%6ld\r\n", screens[i]);
	rewind(fp);

	printf("Writing the help screens to %s\n", toFile);
	while( 1 ) {
		s = fgets(buffer, BUFFERSIZE, fp);
		if( s == NULL )
			break;
		fputs(buffer, fout);
	}
	fclose(fp);
	fclose(fout);
	printf("Done  \n");
	exit(0);
}
