#include "stdio.h"
#include "ctype.h"
#include "dos.h"

enum stateType { inSingleQuotes, inDoubleQuotes, inComment, inOther };
enum tokenType { singleQuote, doubleQuote, beginComment, endComment,
	beginBracket, endBracket, idString, otherToken, openParen,
	endOfFile };
enum charType { other, alphaNumeric, sQuote, dQuote, oParen, bBracket,
	eBracket, slash, star, eof };

enum tokenType GetToken( FILE * );
char tokenString[100];	/* last string token read */

enum charType charTable[257];
enum tokenType lastToken = otherToken;

main(argc, argv)
	char *argv[];
{
	FILE *fp, *fout;
	enum tokenType token;
	enum stateType state = inOther;
	int bracketCount = 0;
	char currentFile[100];
	struct find_t buffer;
	unsigned retCode;
	int i;

	fout = fopen("ptctags.lst", "w");
	printf("Writing ctag file \"ptctags.lst\".\n");

	/* set up character coding table */
	for( i = 0; i < 257; ++i )
		charTable[i] = other;
	for( i = 'a'; i <= 'z'; ++i )
		charTable[i+1] = alphaNumeric;
	for( i = 'A'; i <= 'Z'; ++i )
		charTable[i+1] = alphaNumeric;
	for( i = '0'; i <= '9'; ++i )
		charTable[i+1] = alphaNumeric;
	charTable[0]= eof;
	charTable['\''+1]= sQuote;
	charTable['"'+1] = dQuote;
	charTable['('+1] = oParen;
	charTable['{'+1] = bBracket;
	charTable['}'+1] = eBracket;
	charTable['/'+1] = slash;
	charTable['*'+1] = star;

retCode = _dos_findfirst( "*.c", _A_NORMAL, &buffer );
while( retCode == 0 ) {
	fp = fopen( buffer.name, "r" );
	printf("%s:\n", buffer.name);
	while( 1 ) {
		token = GetToken( fp );
		switch( token ) {
		case singleQuote:
			if( state == inOther )
				state = inSingleQuotes;
			else if( state == inSingleQuotes )
				state = inOther;
			break;
		case doubleQuote:
			if( state == inOther )
				state = inDoubleQuotes;
			else if( state == inDoubleQuotes )
				state = inOther;
			break;
		case beginComment:
			if( state == inOther )
				state = inComment;
			break;
		case endComment:
			if( state == inComment )
				state = inOther;
			break;
		case beginBracket:
			if( state == inOther )
				++bracketCount;
			break;
		case endBracket:
			if( state == inOther )
				--bracketCount;
			break;
		case openParen:
			if( lastToken == idString && bracketCount == 0 ) {
				fprintf(fout, "%s:%s\n", tokenString,
					buffer.name);
				printf("\t%s\n", tokenString);
			}
			break;
		case idString:
			break;
		case otherToken:
			break;
		case endOfFile:
			break;
		}
		if( token == endOfFile )
			break;
		lastToken = token;
	}
	fclose( fp );
	retCode = _dos_findnext( &buffer );
}
fclose(fout);
printf("Done\n");
exit(0);
}

enum tokenType
GetToken( FILE *fp )
{
	int ch, len;

getAnother:
	ch = getc( fp );
	switch( charTable[ch+1] ) {

	case eof:
		return endOfFile;
	case sQuote:
		return singleQuote;
	case dQuote:
		return doubleQuote;
	case oParen:
		return openParen;
	case bBracket:
		return beginBracket;
	case eBracket:
		return endBracket;
	case slash:
		ch = getc( fp );
		if( ch == '*' )
			return beginComment;
		else
			ungetc( ch, fp );
	case star:
		ch = getc( fp );
		if( ch == '/' )
			return endComment;
		else
			ungetc( ch, fp );
		break;
	case alphaNumeric:
		len = 0;
		do {
			tokenString[len++] = ch;
			ch = getc( fp );
		} while( isalnum(ch) );
		ungetc( ch, fp );
		tokenString[len] = '\0';
		return idString;
	case other:
		lastToken = otherToken;
		goto getAnother;
	}
}

