#include "pt.h"
#include "io.h"
#include "stdlib.h"

/* This procedure checks all the things we want to check every time */
/* a mouse click or keystroke occurs.  This gives us a chance to */
/* remove temporary things. */

void pascal
/* XTAG:handleTempItems */
handleTempItems()
{
	extern struct window *windowList;
	extern int isMessage;

	/* erase old messages */
	if( isMessage )
		msg("", 1);

	/* remove temporary windows */
	if( (windowList->state & 0x4) == 0x4 )
		closeWindow(windowList, 0, 1);
}

void pascal
/* XTAG:redefine */
redefine()
{
	extern unsigned char msgBuffer[];
	extern unsigned char textBuffer[];
	extern union REGS rin, rout;
	extern int scrRows, scrCols;
	extern int keyMap[];
	extern int asciiMap[];
	extern int mouseVec1[];
	extern int mouseVec2[];
	extern unsigned char buttonVector[];
	extern struct event events[];
	extern int descrFileId;

	unsigned char ch, scan, *p;
	unsigned char keyCh, keyScan, changeType;
	int cmdNumber, mmNumber, evhead, buttons, thisShift;

	msg(
"          Redefine a key, a mouse button, or a mouse motion command?", 5);
	p = getInput(
"k-redefine key;  b-mouse button;  1,2-mouse motion 1 or 2; ",
		"k", 1);
	if( p == NULL ) {
		msg("Redefinition cancelled", 1);
		return;
	}
	changeType = *p;
	switch( changeType ) {
	case 'k':
		msg(
"                            Redefine a key", 5);
		msg("Press key to redefine or ESC to cancel redefinition", 1);
		keyCh = getKeystroke(&keyScan);
		if( keyCh == '\033' )	/* ESCape */
			goto cancelRedefine;
		if( keyCh == 0 )
			cmdNumber = keyMap[keyScan];
		else if( keyCh != '\033' )
			cmdNumber = asciiMap[keyCh];
		else
			cmdNumber = 60;	/* 60 is arbitrary */
		break;

	case '1':
	case '2':
		sprintf(msgBuffer,
"                    Redefine mouse motion command %c [#%d]",
			changeType, (changeType=='1' ? 45 : 46) );
		msg(msgBuffer, 5);
		p = getInput(
		  "Direction [n,ne,e,se,s,sw,w,nw, RETURN for no motion]: ",
		  "", 0);
		switch( *p ) {
			default:
			case '\0': mmNumber = 0; break;
			case 'e': mmNumber = 3; break;
			case 'w': mmNumber = 7; break;
			case 'n':
				switch( *++p ) {
					default:
					case '\0': mmNumber = 1; break;
					case 'e': mmNumber = 2; break;
					case 'w': mmNumber = 8; break;
				}
				break;
			case 's':
				switch( *++p ) {
					default:
					case '\0': mmNumber = 5; break;
					case 'e': mmNumber = 4; break;
					case 'w': mmNumber = 6; break;
				}
				break;
		}
		if( changeType == '1' )
			cmdNumber = mouseVec1[mmNumber];
		else
			cmdNumber = mouseVec2[mmNumber];
		break;

	case 'b':
		sprintf(msgBuffer,
"Click the mouse button to redefine (including Shift, Ctrl, or Alt)");
		msg(msgBuffer, 1);
		while( 1 ) {
			if( isMouseEvent(0) ) {
				evhead = getMouseEvent();
				/* do not look at mouse movements */
				/* only button presses */
				if( events[evhead].mask != 0x1 )
					break;
			}
		}
		buttons = events[evhead].buttons;
		/* find the shift state of the keyboard */
		rin.h.ah = 2;
		int86(0x16, &rin, &rout);
		/* mask of the Ins, Caps, Num, and Scroll states */
		thisShift = rout.h.al & 0xF;
		/* fix thisShift so that either shift keys implies shift */
		/* shift over bit1 and OR bit0 with it */
		thisShift = (thisShift>>1) | (thisShift&0x1);
		/* get the command number from the table */
		buttons += (thisShift<<3);
		cmdNumber = buttonVector[buttons];
		break;

	default:
		goto cancelRedefine;
	}

	msg(
"RETURN: choose command to redefine, ESC: cancel, ARROW KEYS or number: select",
			5);
	while( 1 ) {
		/* check for valid command number */
		if( cmdNumber < 2 )
			cmdNumber = 2;
		else if( cmdNumber > FLASTOPTION )
			cmdNumber = FLASTOPTION;
		
		/* display description for command cmdNumber */
		readLine(descrFileId, 80L*(long)cmdNumber, &textBuffer[0], 0);
		sprintf(msgBuffer, "%d:%s", cmdNumber, textBuffer);
		msgBuffer[78] = '\0';
		msg(msgBuffer, 1);

		/* read and interpret command */
		ch = getKeystroke(&scan);
		switch( ch ) {
		case 0:	/* extended character */
			switch ( scan ) {
			case 72:	/* Cursor Up */
				cmdNumber--;
				break;
			case 75:	/* Cursor Left */
				cmdNumber--;
				break;
			case 77:	/* Cursor Right */
				cmdNumber++;
				break;
			case 80:	/* Cursor Down */
				cmdNumber++;
				break;
			default:
				break;
			}
			break;
		case '\r':	/* RETURN */
			goto endLoop;
		case '\033':	/* ESCape */
			sprintf(msgBuffer, "Redefinition cancelled");
			goto ret;
		case '0': case '1': case '2': case '3': case '4':
		case '5': case '6': case '7': case '8': case '9':
			cmdNumber = ch - '0';
			/* use ``thisShift'' to count keystrokes */
			thisShift = 1;
			while( 1 ) {
				ch = getKeystroke(&scan);
				switch( ch ) {
				case '0': case '1': case '2': case '3':
				case '4': case '5': case '6': case '7':
				case '8': case '9':
					cmdNumber = 10*cmdNumber + ch - '0';
					if( ++thisShift < 3 )
						break;
					/* else drop through */
				default:
					goto endNumber;
				}
			}
		endNumber:
		default:
			break;
		}
	}
endLoop:
	switch( changeType ) {
	case 'k':
		if( keyCh == 0 ) {
			keyMap[keyScan] = cmdNumber;
			sprintf(msgBuffer,
			  "Extended key 0,%d [0x%X] defined to be command %d",
			  keyScan, keyScan, cmdNumber);
		} else {
			asciiMap[keyCh] = cmdNumber;
			sprintf(msgBuffer,
			  "ASCII key %d [0x%X] defined to be command %d",
			  keyCh, keyCh, cmdNumber);
		}
		break;
	case '1':
	case '2':
		sprintf(msgBuffer,
		"The %s mouse motion %c command is redefined to command #%d",
		*p, changeType, cmdNumber);
		if( changeType == '1' )
			mouseVec1[mmNumber] = cmdNumber;
		else
			mouseVec2[mmNumber] = cmdNumber;
		break;
	case 'b':
		buttonVector[buttons] = (unsigned char)cmdNumber;
		break;
	}
	goto ret;

cancelRedefine:
	sprintf(msgBuffer, "Redefinition cancelled");

ret:
	redrawBox(scrRows-2, 1, scrRows-2, scrCols-2);
	updateScreen(scrRows-2, scrRows-2);
	msg(msgBuffer, 1); 
}

void pascal
/* XTAG:restoreLastState */
restoreLastState()
{
	extern unsigned char msgBuffer[];
	extern int i43lines;
	extern int debug;

	unsigned char *p;
	int fid, lineNumber;
	register int row1, row2;
	int col1, col2;
	struct window *w;

	fid = openls("pt.las", 0);
	if( fid < 0 ) {
		msg(
"Cannot find \"pt.las\" containing the last state [Press any key to continue]",
			1);
		incon();
		return;
	}
	setGWBuffer(1);	/* allocate the getWord buffer */
	/* first get some state variables */
	p = getWord(fid);
	if( p == NULL ) {	/* check to be safe */
		closels(fid);
		return;
	}
	i43lines = atoi(p);
	set43lines();
	/* now get the windows */
	while( 1 ) {
		/* get the four corners  and the line number */
		p = getWord(fid);
		if( p == NULL )
			break;
		row1 = atoi(p);
		if( row1 < 0 )
			row1 = 0;
		else if( i43lines ) {
			if( row1 > 40 )
				row1 = 40;
		} else {
			if( row1 > 22 )
				row1 = 22;
		}
		col1 = atoi(getWord(fid));
		if( col1 < 0 )
			col1 = 0;
		if( col1 > 69 )
			col1 = 69;
		row2 = atoi(getWord(fid));
		if( row1 + 2 > row2 )
			row2 = row1 + 2;
		if( row2 < 0 )
			row2 = 0;
		else if( i43lines ) {
			if( row2 > 42 )
				row2 = 42;
		} else {
			if( row2 > 24 )
				row2 = 24;
		}
		col2 = atoi(getWord(fid));
		if( col1 + 10 > col2 )
			col2 = col1 + 10;
		if( col2 < 0 )
			col2 = 0;
		if( col2 > 79 )
			col2 = 79;
		lineNumber = atoi(getWord(fid));

		/* get the file name last */
		p = getWord(fid);
		if( access(p, 0) == -1 ) {
			sprintf(msgBuffer,
"Cannot find \"%s\" in previous state [Press any key to continue]", p);
			msg(msgBuffer, 1);
			incon();
		} else {
			w = createWindow(p, row1, col1, row2, col2,
				CRBOTTOM, 0);
			if( w != NULL )
				doGoto(w, lineNumber);
		}
	}
	setGWBuffer(0);	/* free the getWord buffer */
	closels(fid);
}
