program HP82240;

uses Crt;

const
  CRLF : String[2] = #13#10;
  HexChars: array [0..15] of Char = '0123456789ABCDEF';
  Translate : array[0..255] of String[4] = ('\000', '\001', '\002', '\003', 
   '\004', '\005', '\006', '\007', '\010', '\011', '\012', '\013', '\014', 
   '\015', '\016', '\017', '\020', '\021', '\022', '\023', '\024', '\025', 
   '\026', '\027', '\030', '\031', '\032', '\033', '\034', '\035', '\036', 
   '\037', ' ', '!', '"', '#', '$', '%', '&', '''', '(', ')', '*', '+', ',', 
   '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', 
   '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J',
   'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 
   'Z', '[', '\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 
   'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 
   'x', 'y', 'z', '{', '|', '}', '~', '\177', '\<)', '\x-', '\.V', '\v/', '\.S', 
   '\GS', '\|>', '\pi', '\.d', '\<=', '\>=', '\=/', '\Ga', '\->', '\<-', '\|v', 
   '\|^', '\Gg', '\Gd', '\Ge', '\Gn', '\Gh', '\Gl', '\Gr', '\Gs', '\Gt', '\Gw', 
   '\GD', '\PI', '\GW', '\[]', '\oo', '\240', '\241', '\242', '\243', '\244',
   '\245', '\246', '\247', '\250', '\251', '\252', '\<<', '\254', '\255', '\256', 
   '\257', '\^o', '\261', '\262', '\263', '\264', '\Gm', '\266', '\267', '\270', 
   '\271', '\272', '\>>', '\274', '\275', '\276', '\277', '\300', '\301', '\302',
   '\303', '\304', '\305', '\306', '\307', '\310', '\311', '\312', '\313', '\314', 
   '\315', '\316', '\317', '\320', '\321', '\322', '\323', '\324', '\325', '\326', 
   '\.x', '\O/', '\331', '\332', '\333', '\334', '\335', '\336', '\Gb', '\340',
   '\341', '\342', '\343', '\344', '\345', '\346', '\347', '\350', '\351', '\352', 
   '\353', '\354', '\355', '\356', '\357', '\360', '\361', '\362', '\363', '\364', 
   '\365', '\366', '\:-', '\370', '\371', '\372', '\373', '\374', '\375', '\376',
   '\377');

var
  ChCom, Ch : char;
  Done : boolean;
  i, Bit, Data : Byte;
  WhereX, WhereY : Word;
  FontFile : File;
  FontData : array[0..255] of array[0..5] of Byte;
  LogFile : Text;
  Lines : Word;
  Xlat : String[4];
  PrintDevice : String;
  PrintFile : Text;
  Bytes : Word;
  Printing, GraphicLine : Boolean;
  Mode24 : array[1..2] of Boolean;
  Param : String;

function Flip(b : Byte) : Byte;
var
  t, i : Byte;
begin
  t := 0;
  for i := 0 to 7 do begin
    if b and (1 shl i) <> 0 then t := t + (128 shr i);
  end;
  Flip := t;
end;

procedure PutPixel(x, y : Word; c : Byte);
begin
  Mem[$a000 : x + y * 320] := c;
end;

procedure Print24(Ch : Char);
var
  i, b : Byte;
  Data : LongInt;
begin
  b := Ord(Ch);
  Data := 0;
  for i := 0 to 7 do begin
    if b and (1 shl i) <> 0 then begin
      Data := Data + LongInt(1) shl (i * 3) + LongInt(1) shl (i * 3 + 1) + LongInt(1) shl (i * 3 + 2);
    end;
  end;
  for i := 1 to 2 do
    Write(PrintFile, Char(Data and $ff0000 shr 16), Char(Data and $ff00 shr 8), Char(Data and $ff));
end;

procedure OutString(s : String);
var
  i : Byte;

procedure OutChar(c : Char);
var
  x, y : Byte;
  Ch : Char;
begin
  GotoXY(WhereX, WhereY);
  case c of
    #10: begin
      Inc(WhereY);
      Inc(Lines);
      if Printing then Write(PrintFile, #10);
    end;
    #13: begin
      WhereX := 1;
      if Printing then begin
        if GraphicLine then Write(PrintFile, #27#65#08#13)
        else Write(PrintFile, #27#65#12#13);
      end;
      GraphicLine := False;
    end;
    else begin
      for x := 0 to 5 do begin
        for y := 0 to 7 do begin
          if FontData[Ord(c), x] and (1 shl y) <> 0 then
            PutPixel(WhereX * 6 - 6 + x, WhereY * 8 - 8 + y, 7)
          else PutPixel(WhereX * 6 - 6 + x, WhereY * 8 - 8 + y, 0);
        end;
      end;
      if Printing then begin
        if Mode24[1] then begin
          Write(PrintFile, #27#42#33#12#00);
          for x := 0 to 5 do begin
            Print24(Char(Flip(FontData[Ord(c), x])));
          end;
        end else begin
          Write(PrintFile, #27#76#12#00);
          for x := 0 to 5 do begin
            Write(PrintFile, Char(Flip(FontData[Ord(c), x])));
            Write(PrintFile, Char(Flip(FontData[Ord(c), x])));
          end;
        end;
      end;
      Inc(WhereX);
      if WhereX > 53 then begin
        WhereX := 1;
        Inc(WhereY);
        Inc(Lines);
      end;
    end;
  end;
  if WhereY > 24 then begin
    asm
      push ds
      mov ax, $a000
      mov es, ax
      mov ds, ax
      mov di, 0
      mov si, 2560
      cld
      mov cx, 30720
      rep movsw
      pop ds
      dec WhereY
    end;
  end;
  if Lines = 23 then begin
    Lines := 0;
    WhereX := 1;
    if Printing then begin
      Printing := False;
      OutString('< More >');
      Printing := True;
    end else OutString('< More >');
    Ch := ReadKey;
    if Ch = #0 then if ReadKey = #$2d then Done := True;
    while KeyPressed do ReadKey;
    WhereX := 1;
    if Printing then begin
      Printing := False;
      OutString('        ');
      Printing := True;
    end else OutString('        ');
    WhereX := 1;
    if Ch = #13 then Lines := 22 else Lines := 0;
  end;
end;

begin
  for i := 1 to Length(s) do begin
    OutChar(s[i]);
  end;
end;

function ReadChar : Char;
var
  Ch : Char;
begin
  Read(LogFile, Ch);
  ReadChar := Ch;
end;

begin
  if ((ParamCount > 1) and (Copy(ParamStr(2), 1, 2) <> '/p') and
   (Copy(ParamStr(2), 1, 2) <> '/P')) or ((ParamCount = 3) and
   (Copy(ParamStr(3), 1, 3) <> '/24')) then begin
    WriteLn('Invalid parameter: ' + ParamStr(2));
    WriteLn;
    WriteLn('HPIRLOG: HPIR Logfile viewer  Matthew Mastracci');
    WriteLn(' Usage: HPIRLOG logfile [/Pdevice [/24[T | G]]]');
    Halt;
  end;
  if not (ParamCount in [1..3]) then begin
    WriteLn('HPIRLOG: HPIR Logfile viewer  Matthew Mastracci');
    WriteLn(' Usage: HPIRLOG logfile [/Pdevice [/24[T | G]]]');
    Halt;
  end;

  Printing := False;
  if ParamCount > 1 then begin
    Printing := True;
    PrintDevice := Copy(ParamStr(2), 3, Length(ParamStr(2)) - 2);
    Assign(PrintFile, PrintDevice);
    {$i-}
    Rewrite(PrintFile);
    {$i+}
    if IOResult <> 0 then begin
      WriteLn('Error opening print device (write protected file?)');
      Halt;
    end;
    if ParamCount = 3 then begin
      Param := ParamStr(3);
      if Length(Param) = 3 then begin
        Mode24[1] := True;
        Mode24[2] := True;
      end else begin
        if UpCase(Param[4]) = 'T' then Mode24[1] := True else Mode24[1] := False;
        if UpCase(Param[4]) = 'G' then Mode24[2] := True else Mode24[2] := False;
      end;
    end;
  end;

  Lines := 0;
  Assign(FontFile, 'FONT.DAT');
  {$i-}
  Reset(FontFile, 1);
  {$i+}
  if IOResult <> 0 then begin
    WriteLn('Error: FONT.DAT not found');
    Halt;
  end;
  BlockRead(FontFile, FontData, SizeOf(FontData));
  Close(FontFile);

  Assign(LogFile, ParamStr(1));
  {$i-}
  Reset(LogFile);
  {$i+}
  if IOResult <> 0 then begin
    WriteLn('File not found');
    Halt;
  end;

  DirectVideo := False;
  asm
    mov ax, $0013
    int $10
  end;
  WhereX := 1;
  WhereY := 1;
  GraphicLine := False;
  OutString('HPIR Logfile Viewer' + CRLF);
  OutString('  (c) 1995 by Matthew Mastracci' + CRLF);
  OutString(CRLF);

  Done := False;

  repeat
    ChCom := ReadChar;
    if ChCom = '\' then begin
      Xlat := '\' + ReadChar;
      if Xlat[2] in ['0'..'9'] then begin
        Xlat := Xlat + ReadChar + ReadChar;
        for i := 0 to 255 do begin
          if Xlat = Translate[i] then Xlat := Char(i);
        end;
      end else begin
        Xlat := Xlat + ReadChar;
        for i := 0 to 255 do begin
          if Xlat = Translate[i] then Xlat := Char(i);
        end;
      end;
      ChCom := Xlat[1];
    end;
    if ChCom <> #27 then OutString(ChCom) else begin
      for i := 1 to 5 do ChCom := ReadChar;
      ChCom := ReadChar;
      Data := (Pos(ChCom, HexChars) - 1) shl 4;
      ChCom := ReadChar;
      Data := Data + Pos(ChCom, HexChars) - 1;
      ChCom := Char(Data - 1);
      Bytes := (Ord(ChCom) + 1) * 2;
      GraphicLine := True;
      if Printing then begin
        if Mode24[2] then begin
          Write(PrintFile, #27#42#33, Char(Lo(Bytes)), Char(Hi(Bytes)));
        end else Write(PrintFile, #27#76, Char(Lo(Bytes)), Char(Hi(Bytes)));
      end;
      for i := 0 to Ord(ChCom) do begin
        Ch := ReadChar;
        Data := (Pos(Ch, HexChars) - 1) shl 4;
        Ch := ReadChar;
        Data := Data + Pos(Ch, HexChars) - 1;
        Ch := Char(Data);
        for Bit := 0 to 7 do begin
          if Ord(Ch) and (1 shl Bit) <> 0 then begin
            PutPixel(WhereX * 6 - 6 + i, WhereY * 8 - 8 + Bit, 15);
          end;
        end;
        if Printing then begin
          Ch := Char(Flip(Ord(Ch)));
          if Mode24[2] then begin
            Print24(Ch);
          end else Write(PrintFile, Ch, Ch);
        end;
      end;
      WhereX := WhereX + (Ord(ChCom) - (Ord(ChCom) mod 6)) + 1;
    end;
  until EOF(LogFile) or Done;

  if not Done then begin
    if Printing then begin
      Printing := False;
      OutString('< Finished >');
    end else OutString('< Finished >');
    ReadKey;
    while KeyPressed do ReadKey;
  end;

  asm
    mov ax, $0003
    int $10
  end;

  Close(LogFile);
  WriteLn('HPIR Logfile Viewer  Matthew Mastracci');
  WriteLn;
end.
