'  COM2INC.BAS
'  Written in Turbo Basic by Bruce Tonkin on 5/11/87
'
'  This program converts COM files to $INCLUDE text files
'  with the Turbo Basic $INLINE meta-command.  The output
'  files may be inserted or easily $INCLUDEd into
'  Turbo Basic programs.
'
DEFINT A-Z         'All variables will be integers
F$=COMMAND$        'Check to see if there's a command line
WHILE F$=""
    PRINT"This program will convert COM files to $INCLUDE files"
    PRINT"for use with Turbo BASIC.  The default file type of"
    PRINT"the source file is COM.  The default file type of the"
    PRINT"output file is INC.  You may override either default"
    PRINT"by entering a spacific file type specification."
    PRINT"If you enter no name for the output file, it will be"
    PRINT"named the same as the input file, but will have a file"
    PRINT"type specification of INC."
    LINE INPUT"Enter the name of the file to convert: ";F$
WEND

IF COMMAND$="" THEN
    LINE INPUT"Enter the name of the desired output file: ";O$
    END IF

IF INSTR(F$,".")<2 THEN F$=F$+".COM"        'fix input spec
IF O$="" THEN
    O$=LEFT$(F$,INSTR(F$,"."))+"INC"        'fix output spec,
    ELSE
         IF INSTR(O$,".")<2 THEN O$=O$+".INC"    'both ways.
    END IF

OPEN"R",1,F$,1          'input file will be read one byte
FIELD #1,1 AS A$        'at a time into A$
LASTBYTE=LOF(1)         'end of file position
OPEN"O",2,O$            'output file is opened
FOR I=1 TO LASTBYTE-1
    GET 1,I
    X=ASC(A$)
    IF ((I-1) MOD 5=0) THEN PRINT #2,"":PRINT #2,"$INLINE ";
    PRINT #2,"&H";HEX$(X);
    IF ((I-1) MOD 5<>4) THEN PRINT #2,",";
NEXT I
GET 1,LASTBYTE
PRINT #2,"&H";HEX$(ASC(A$))
CLOSE
PRINT"Conversion is complete. ";LASTBYTE;" bytes read."
END

