/* custlist.c: reports name and total sales from custlist.rxd */
/* Written for small model of Turbo C by K. Porter */

/* INCLUDE FILES */
#include <stdio.h>
#include <string.h>
#include <dir.h>
#include <reflex.h>       /* Separate Reflex structure definitions */

/* DEFINE CONSTANTS */
#define  outdev    "PRN"                   /* report output device */
#define  dbname    "CUSTLIST.RXD"        /* Reflex file to process */
#define  EJECT     12                        /* printer page eject */

/* LOCAL FUNCTION PROTOTYPE */
void   report ( void );

/* GLOBAL INPUT FILE */
FILE           *db;

main ()
{
long           fpos;                              /* file position */
unsigned       d;                                 /* misc variable */

/* OPEN FILES */
  d = 0;
  lst = fopen ( outdev, "w" );                      /* open output */
  cputs ( "\nGenerating sales report from Reflex data base:\n" );
  db = fopen ( dbname, "r" );
  if ( db != NULL ) {
    setvbuf ( db, NULL, _IONBF, 0 );       /* make file unbuffered */
           /* ---- verify that file is open and a Reflex data base */
    fseek ( db, 88L, SEEK_SET );  /* point to size of control info */
    fread ( &fpos, sizeof (long), 1, db );               /* get it */
    fseek ( db, 0L, SEEK_SET );                /* repoint to start */
                              /* ---- put control info on the heap */
    base = (unsigned) malloc ((unsigned) fpos);   /* allocate node */
    head = (DFHDR*) base;                    /* set header pointer */
    d = fread (((char*)(base)), sizeof (char), ((int)(fpos)), db);
  }
  if ( db == NULL || d == 0 ) {                   /* error handler */
    printf ( "Error accessing file %s\n", dbname );
    printf ( "File is %s open, items read = %u\n",
        (db==NULL ? "not" : ""), d);
    exit (1);
  } else
    if ( strcmp ( head->stamp, RXID ) != 0 ) {
      printf ( "\n\nFile %s is not a Reflex data base\n", dbname );
      exit (1);                        /* exit with condition code */
    }

/* INITIALIZE POINTERS TO CONTROL INFO */
#include <inptrrxd.i>

/* PRODUCE REPORT BY READING DATA BASE */
  report ();

/* END OF JOB */
  putc ( EJECT, lst );                               /* eject page */
  close ( lst );                                  /* close printer */
  free ( head );                          /* deallocate heap space */
} /* ---------------- End of main() ------------------------------ */

void  report (void)                             /* generate report */
{
long     fptr, text;          /* file pointers: main and text pool */
double   sales;                               /* total sales field */
unsigned recs;                       /* loop counter for # records */
int      reclen, tofs, n;            /* record length, text offset */
char     ch, name[80];        /* character, string for text output */

  fputs ( "     SALES REPORT FROM CUSTLIST.RXD:\n", lst );
  fptr = (descr+2)->dfAddr + 2;           /* start of first record */
  for ( recs = 0; recs < mast->totalRecs; recs++ ) {
    fseek ( db, fptr, SEEK_SET );          /* point to next record */
    fread ( &reclen, sizeof(int), 1, db );           /* get length */
    fptr += 2;                       /* advance to start of header */
    fseek ( db, (fptr + 8), SEEK_SET );      /* skip to name field */
    fread ( &tofs, sizeof(int), 1, db );        /* get text offset */
    if ( tofs < 2 )
      fprintf ( "\n     %s", (tofs) ? "ERROR" : "NULL");
    else {
      text = fptr + tofs;                  /* point to name string */
      fseek ( db, text, SEEK_SET );                    /* go to it */
      n = 0;
      do {
        fread ( &ch, sizeof(char), 1, db );       /* get next char */
        name[n++] = ch;
      } while ( ch );                           /* until null char */
      fprintf ( lst, "\n     %-30s", name );         /* print name */
      fseek ( db, (fptr + 18), SEEK_SET );        /* skip to sales */
      fread ( &sales, sizeof(double), 1, db );         /* get data */
      fprintf ( lst, "    %12.2fl", sales );           /* print it */
    }
    fptr += reclen;                      /* advance to next record */
  }
}
