     REM
     REM    SS2TXT.BAS                     Dan Bruton, astro@tamu.edu
     REM
     REM      This is a text version of SATSAT2.BAS.  It is smaller,
     REM   making it easier to convert other languages (250 lines
     REM   compared to 850 lines).
     REM
     REM      This BASIC program computes and displays the locations
     REM   of Saturn's Satellites for a given date and time.  See
     REM   "Practical Astronomy with your Calculator" by Peter
     REM   Duffett-Smith and the Astronomical Almanac for explanations
     REM   of some of the calculations here.  The code is included so
     REM   that users can make changes or convert to other languages.
     REM   This code was made using QBASIC (comes with DOS 5.0).
     REM
     REM ********************************************************************
     REM *                                                                  *
     REM *                        Constants                                 *
     REM *                                                                  *
     REM ********************************************************************
     REM # means double-precision, $ means string
     DIM SMA(10), E(10), U(10), U0(10), CS(10), N$(10), PD#(10), RSS(10)
     DIM X(10), Y(10)
     PI = 3.141592654#
     P = PI / 180
     REM Orbital Rate of Saturn in Radians per Days
     TP = 2 * PI / (29.45771 * 365.2422)
     REM Orbital Rate of Earth in Radians per Day
     TE = 2 * PI / (1.00004 * 365.2422)
     REM Eccentricity of Saturn's Orbit
     EP = .0556155#
     REM Eccentricity of Earth's Orbit
     EE = .016718#
     REM Semimajor axis of Earth's and Saturn's orbit in Astronomical Units
     RE0 = 1: RP0 = 9.554747
     REM Tilt of Earth's Axis - obliquity of the ecliptic
     OBL = 23.43928 * P
     REM Names of the Satellites
     N$(1) = "Mimas": N$(2) = "Enceladus": N$(3) = "Tethys": N$(4) = "Dione"
     N$(5) = "Rhea": N$(6) = "Titan": N$(7) = "Hyperion": N$(8) = "Iapetus"
     REM Semimajor Axis of the Satellites' Orbit in Kilometers
     SMA(1) = 185600: SMA(2) = 238100: SMA(3) = 294700: SMA(4) = 377500
     SMA(5) = 527200: SMA(6) = 1221600: SMA(7) = 1483000: SMA(8) = 3560100
     REM Visual Magnitude of the Satellites
     MAG(1) = 13: MAG(2) = 11.8: MAG(3) = 10.3: MAG(4) = 10.2
     MAG(5) = 9.8: MAG(6) = 8.4: MAG(7) = 14.3: MAG(8) = 11.2
     REM Semimajor Axis of the Satellites' Orbit in Kilometers
     SMA(1) = 185600: SMA(2) = 238100: SMA(3) = 294700: SMA(4) = 377500
     SMA(5) = 527200: SMA(6) = 1221600: SMA(7) = 1483000: SMA(8) = 3560100
     REM Eccentricity of Satellites' Orbit (Program uses 0)
     REM Synodic Orbital Period of Moons in Days
     PD#(1) = .9425049#
     PD#(2) = 1.3703731#
     PD#(3) = 1.8880926#
     PD#(4) = 2.7375218#
     PD#(5) = 4.5191631#
     PD#(6) = 15.9669028#
     PD#(7) = 21.3174647#
     PD#(8) = 79.9208313#
     RS = 60330: REM Radius of planet in kilometers
     RS1 = 92000: REM Inner radius of inner ring in kilometers
     RS2 = 117500: REM Outer radius of inner ring in kilometers
     RS3 = 122500: REM Inner radius of outer ring in kilometers
     RS4 = 136500: REM Outer radius of outer ring in kilometers
     NM = 8: REM Number of moons displayed
    
     REM ********************************************************************
     REM *                                                                  *
     REM *                      Epoch Information                           *
     REM *                                                                  *
     REM ********************************************************************
     JDE# = 2444238.5#: REM Epoch Jan 0.0 1980 = December 31,1979 0:0:0 UT
     LPE = 165.322242# * P: REM Longitude of Saturn at Epoch
     LPP = 92.6653974# * P: REM Longitude of Saturn`s Perihelion
     OHM = 113.4888341# * P: REM Longitude of Saturn`s Ascending Node
     INCS = 2.4893741# * P: REM Inclination of Saturn`s Orbit
     LEE = 98.83354# * P: REM Longitude of Earth at Epoch
     LEP = 102.596403# * P: REM Longitude of Earth's Perihelion
     REM U0(I) = Angle from inferior geocentric conjuction
     REM         measured westward along the orbit at epoch
     U0(1) = 18.2919 * P
     U0(2) = 174.2135 * P
     U0(3) = 172.8546 * P
     U0(4) = 76.8438 * P
     U0(5) = 37.2555 * P
     U0(6) = 57.7005 * P
     U0(7) = 266.6977 * P
     U0(8) = 197.7663 * P
    
     REM ********************************************************************
     REM *                                                                  *
     REM *                       Date and Time                              *
     REM *                                                                  *
     REM ********************************************************************
     CLS : PRINT "Enter Universal Date"
     INPUT "  Month (MM) : ", NMONTH
     INPUT "  Day (DD) : ", NDAY
     INPUT "  Year (YYYY) : ", NYEAR
     PRINT "Enter Universal Time"
     INPUT "  Hour : ", NHOUR
     INPUT "  Minute : ", NMIN
    
     REM ********************************************************************
     REM *                                                                  *
     REM *                    Orbit Calculations                            *
     REM *                                                                  *
     REM ********************************************************************
     REM ********************** FIND JULIAN DATE ****************************
     GGG = 1: IF NYEAR <= 1585 THEN GGG = 0
     JD# = -1 * INT(7 * (INT((NMONTH + 9) / 12) + NYEAR) / 4)
     S = SGN(NMONTH - 9): a = ABS(NMONTH - 9)
     J1 = INT(NYEAR + S * INT(a / 7))
     J1 = -1 * INT((INT(J1 / 100) + 1) * 3 / 4)
     JD# = JD# + INT(275 * NMONTH / 9) + NDAY + (GGG * J1)
     JD# = JD# + 1721027 + 2 * GGG + 367 * NYEAR - .5
     JD# = JD# + (NHOUR / 24) + (NMIN / (24 * 60)):  REM      Julian Date
     REM ****************** FIND MOON ORBITAL ANGLES ************************
     NN = JD# - JDE#: REM NN = Number of days since epoch
     ME = ((TE * NN) + LEE - LEP): REM Mean Anomoly of Earth
     MP = ((TP * NN) + LPE - LPP): REM Mean Anomoly of Saturn
     VE = ME: VP = MP: REM True Anomolies - Solve Kepler's Equation
     FOR I = 1 TO 3
     VE = VE - (VE - (EE * SIN(VE)) - ME) / (1 - (EE * COS(VE)))
     VP = VP - (VP - (EP * SIN(VP)) - MP) / (1 - (EP * COS(VP)))
     NEXT I
     VE = 2 * ATN(SQR((1 + EE) / (1 - EE)) * TAN(VE / 2))
     IF VE < 0 THEN VE = (2 * PI) + VE
     VP = 2 * ATN(SQR((1 + EP) / (1 - EP)) * TAN(VP / 2))
     IF VP < 0 THEN VP = (2 * PI) + VP
     REM  Heliocentric Longitudes of Earth and Saturn
     LE = VE + LEP: IF LE > (2 * PI) THEN LE = LE - (2 * PI)
     LP = VP + LPP: IF LP > (2 * PI) THEN LP = LP - (2 * PI)
     REM  Distances of Earth and Saturn from the Sun in AU's
     RE = RE0 * (1 - EE * EE) / (1 + EE * COS(VE))
     RP = RP0 * (1 - EP * EP) / (1 + EP * COS(VP))
     REM  DT = Distance from Saturn to Earth in AU's - Law of Cosines
     DT = SQR((RE ^ 2) + (RP ^ 2) - (2 * RE * RP * COS(LE - LP)))
     REM  II = Angle between Earth and Sun as seen from Saturn
     II = RE * SIN(LE - LP) / DT
     II = ATN(II / SQR(1 - II * II)): REM  ArcSIN and Law of Sines
     REM   F = NN - (Light Time to Earth in days)
     F = NN - (DT / 173.83)
     F1 = II + MP - VP
     REM U(I) = Angle from inferior geocentric conjuction measured westward
     FOR I = 1 TO NM
     U(I) = U0(I) + (F * 2 * PI / PD#(I)) + F1
     U(I) = ((U(I) / (2 * PI)) - INT(U(I) / (2 * PI))) * 2 * PI
     NEXT I
     REM ******************** FIND SATURN'S COORDINATES *********************
     REM PSI -> Heliocentric Latitude
     REM LAMB -> Geocentric Ecliptic Longitude
     REM BETA -> Geocentric Ecliptic Latitude
     SINPSI = SIN(LP - OHM) * SIN(INCS)
     PSI = ATN(SINPSI / SQR(1 - SINPSI * SINPSI)): REM ArcSIN
     NUM = SIN(LP - OHM) * COS(INCS)
     DEN = COS(LP - OHM)
     LPQ = ATN(NUM / DEN)
     IF NUM * DEN < 0 THEN LPQ = LPQ + PI
     IF NUM < 0 THEN LPQ = LPQ + PI
     LPQ = LPQ + OHM
     RPQ = RP * COS(PSI)
     NUM = RE * SIN(LPQ - LE)
     DEN = RPQ - RE * COS(LPQ - LE)
     LAMB = ATN(NUM / DEN)
     IF NUM * DEN < 0 THEN LAMB = LAMB + PI
     IF NUM < 0 THEN LAMB = LAMB + PI
     LAMB = LAMB + LPQ
     BETA = RPQ * TAN(PSI) * SIN(LAMB - LPQ)
     BETA = ATN(BETA / (RE * SIN(LPQ - LE)))
     NUM = (SIN(LAMB) * COS(OBL)) - (TAN(BETA) * SIN(OBL))
     DEN = COS(LAMB)
     RA = ATN(NUM / DEN)
     IF NUM * DEN < 0 THEN RA = RA + PI
     IF NUM < 0 THEN RA = RA + PI
     SINDEC = SIN(BETA) * COS(OBL)
     SINDEC = SINDEC + COS(BETA) * SIN(OBL) * SIN(LAMB)
     DEC = ATN(SINDEC / SQR(1 - SINDEC * SINDEC)): REM ArcSIN
     REM **************** FIND INCLINATION OF RINGS *************************
     REM Use dot product of Earth-Saturn vector and Saturn's rotation axis
     TVA = (90 - 83.51) * P: REM Theta coordinate of Saturn's axis
     PVA = 40.27 * P: REM Phi coordinate of Saturn's axis
     TVC = (PI / 2) - DEC
     PVC = RA
     DOT1 = SIN(TVA) * COS(PVA) * SIN(TVC) * COS(PVC)
     DOT1 = DOT1 + SIN(TVA) * SIN(PVA) * SIN(TVC) * SIN(PVC)
     DOT1 = DOT1 + COS(TVA) * COS(TVC)
     INC = ATN(SQR(1 - DOT1 ^ 2) / DOT1): REM   ArcCOS
     IF INC > 0 THEN INC = (PI / 2) - INC ELSE INC = -(PI / 2) - INC
     REM ************* FIND INCLINATION OF IAPETUS' ORBIT *******************
     REM Use dot product of Earth-Saturn vector and Iapetus' orbit axis
     REM Vector B
     TVB = (90 - 75.6) * P: REM Theta coordinate of Iapetus' orbit axis (estimate)
     PVB = 21.34 * 2 * PI / 24: REM Phi coordinate of Iapetus' orbit axis (estimate)
     DOT2 = SIN(TVB) * COS(PVB) * SIN(TVC) * COS(PVC)
     DOT2 = DOT2 + SIN(TVB) * SIN(PVB) * SIN(TVC) * SIN(PVC)
     DOT2 = DOT2 + COS(TVB) * COS(TVC)
     INCI = ATN(SQR(1 - DOT2 ^ 2) / DOT2): REM   ArcCOS
     IF INCI > 0 THEN INCI = (PI / 2) - INCI ELSE INCI = -(PI / 2) - INCI
     REM ************* FIND ROTATION ANGLE OF IAPETUS' ORBIT ****************
     REM Use inclination of Iapetus' orbit with respect to ring plane
     REM Triple Product
     TRIP = SIN(TVC) * COS(PVC) * SIN(TVA) * SIN(PVA) * COS(TVB)
     TRIP = TRIP - SIN(TVC) * COS(PVC) * SIN(TVB) * SIN(PVB) * COS(TVA)
     TRIP = TRIP + SIN(TVC) * SIN(PVC) * SIN(TVB) * COS(PVB) * COS(TVA)
     TRIP = TRIP - SIN(TVC) * SIN(PVC) * SIN(TVA) * COS(PVA) * COS(TVB)
     TRIP = TRIP + COS(TVC) * SIN(TVA) * COS(PVA) * SIN(TVB) * SIN(PVB)
     TRIP = TRIP - COS(TVC) * SIN(TVB) * COS(PVB) * SIN(TVA) * SIN(PVA)
     GAM = -1 * ATN(TRIP / SQR(1 - TRIP * TRIP)): REM ArcSIN
    
     REM ********************************************************************
     REM *                                                                  *
     REM *                     Compute Moon Positions                       *
     REM *                                                                  *
     REM ********************************************************************
     FOR I = 1 TO NM - 1
     X(I) = -1 * SMA(I) * SIN(U(I)) / RS
     Y(I) = SMA(I) * COS(U(I)) * SIN(INC) / RS
     NEXT I
     REM ************************* Iapetus' Orbit ***************************
     TEMPX = -1 * SMA(8) * SIN(U(8)) / RS
     TEMPY = SMA(8) * COS(U(8)) * SIN(INCI) / RS
     X(8) = TEMPX * COS(GAM) + TEMPY * SIN(GAM): REM      Rotation
     Y(8) = -1 * TEMPX * SIN(GAM) + TEMPY * COS(GAM)
    
     REM ********************************************************************
     REM *                                                                  *
     REM *                          Show Results                            *
     REM *                                                                  *
     REM ********************************************************************
     CLS
     PRINT
     PRINT USING "      Date: ##/##/####   Time: ##:## UT"; NMONTH; NDAY; NYEAR; NHOUR; NMIN
     PRINT
     PRINT "    MOON          X         Y         U"
     PRINT "-----------------------------------------------"
     FOR I = 1 TO NM
     PRINT USING " \           \ ###.##    ###.##    ###.##!"; N$(I); X(I); Y(I); U(I) / P; CHR$(248)
     NEXT I
     PRINT
     PRINT "  X and Y are the relative coordinates of the moons as seen from Earth"
     PRINT "relative to Saturn's center and measured in Saturn radii.  A positive"
     PRINT "X value means that the moon is East of Saturn and a positive Y value means"
     PRINT "that the moon is North of Saturn.  U is the angle from inferior geocentric"
     PRINT "conjuction measured westward.": PRINT
     PRINT "Press <Enter> for more information."
     WHILE INKEY$ = "": WEND
     PRINT
     PRINT USING "                           Julian Date : ########.###"; JD#
     PRINT USING "             Right Ascension of Saturn : ###.## Hours"; RA * 24 / (2 * PI)
     PRINT USING "                 Declination of Saturn : ###.##!"; DEC / P; CHR$(248)
     PRINT USING "   Ring Inclination as seen from Earth : ###.##!"; -1 * INC / P; CHR$(248)
     PRINT USING "      Heliocentric Longitude of Saturn : ###.##!"; LP / P; CHR$(248)
     PRINT USING "       Heliocentric Longitude of Earth : ###.##!"; LE / P; CHR$(248)
     PRINT USING "                Sun-Saturn-Earth Angle : ###.##!"; II / P; CHR$(248)
     PRINT USING "     Distance between Saturn and Earth : ###.## AU = #### million miles"; DT; (DT * 93)
     PRINT USING "       Light time from Saturn to Earth : ###.## minutes"; DT * 8.28
     TEMP = 2 * ATN(TAN(165.6 * P / (2 * 3600)) / DT) * 3600 / P
     PRINT USING "                Angular Size of Saturn : ###.## arcsec"; TEMP
     PRINT USING "  Major Angular Size of Saturn's Rings : ###.## arcsec"; RS4 * TEMP / RS
     PRINT USING "  Minor Angular Size of Saturn's Rings : ###.## arcsec"; ABS(RS4 * TEMP * SIN(INC) / RS)
     PRINT
     PRINT "     SATELLITE    MAGNITUDE    ORBITAL RADIUS    ORBITAL PERIOD "
     FOR I = 1 TO NM
     PRINT USING "    \          \     ##.#        ####### km       ###.## days"; N$(I); MAG(I); SMA(I); PD#(I)
     NEXT I
     END

    

