#include "mconf.h"
#include "prec.h"
#include "ssystem.h"

#if LDOUBLE
#if MIEEE
long DTR[] = {0x3ff90000,0x8efa3512,0x94e9c8ae};
long RTD[] = {0x40040000,0xe52ee0d3,0x1e0fbdc3};
long RTS[] = {0x40100000,0xc96e3399,0x8d6bd5c8};
long STR[] = {0x3fed0000,0xa2ad2d97,0xfc7ce8e1};
long PI[] = {0x40000000,0xc90fdaa2,0x2168c235};
long J2000[] = {0x40140000,0x95a16400,0x00000000};
long B1950[] = {0x40140000,0x948409b1,0x26e978d5};
long J1900[] = {0x40140000,0x9366b000,0x00000000};
long B1900[] = {0x40140000,0x9366b140,0x83126e98};
long Jcentury[] = {0x400e0000,0x8ead0000,0x00000000};
long Jmillenium[] = {0x40110000,0xb2584000,0x00000000};
long Jtmillenium[] = {0x40140000,0xdeee5000,0x00000000};

/* Solar system barycentric velocity and position
 * state of Mercury, Venus, EMB, ..., Pluto, MOON, Sun
 * in the order dx/dt, x, dy/dt, y, dz/dt, z for each object.
 *
 * EMB is the arithmetic average of Earth and Moon, weighted by
 * their masses. The coordinates of the Moon variable are the
 * the solar system barycentric coordinates of the Moon
 * minus those of the Earth.
 */

/* Note, these particular numbers are derived from the heliocentric
 * planet states and barycentric Sun state given in the
 * documentation for the DE118.
 */

/* June 28.0, 1969 */
long JD0[] = {0x40140000,0x94f34200,0x00000000};

long yn0[3*6*NTOTAL] = {
0x3ff10000,0xd1bf69c8,0x1d23caa1,
0x3ff70000,0xc5b414b0,0xa6b903a1,
0x3fee0000,0xfa0c23bf,0x76086fc6,
0x3ffd0000,0xc3c90428,0x9a202d35,
0xbff10000,0xfa78c92e,0xc3fbfff5,
0x3fff0000,0xa3fe8130,0xc67cfbf8,
0x3ff60000,0xf30a6c32,0x006e947b,
0x3ffd0000,0xb87a1c70,0x756c6608,
0x3ff90000,0xcb9ca061,0x95de1888,
0xbffb0000,0xc22d40e6,0xc3c3dcab,
0x3ff80000,0xd3d49d18,0x9afea5a3,
0xbffb0000,0xb321d08e,0x4dc6f602,
0x3ff80000,0xb6ca5d1d,0xa0c51235,
0x3ffe0000,0x9b9d04c8,0x36c03017,
0x3ff80000,0xfddadce7,0x38a8008d,
0xbffd0000,0xb5daa0c7,0xc77aa9ef,
0x3ff70000,0xcdb2915a,0x7feb25b5,
0xbffc0000,0xcaffcd1a,0xc32be65e,
0x3ff90000,0x89e5e2d3,0xba33e259,
0x3ffb0000,0xdd9be1ca,0x0edb8ed2,
0x3ff50000,0xcc7fbf06,0xb36c6ad9,
0xbffe0000,0xed57274e,0x0452c885,
0x3ff40000,0xb1549434,0x330615d6,
0xbffd0000,0xcddf3248,0xb2029215,
0x3ff80000,0xed459271,0x3e183b31,
0xbffc0000,0x83090473,0xaef31309,
0x3ff10000,0xa8e16e0a,0x7fd1f107,
0xbfff0000,0xa9c2f259,0x9cc856cf,
0xbff30000,0xb87dc8a2,0xddcb49d3,
0xbffe0000,0x9af57883,0xa157914e,
0x3ff50000,0x83c5c9ff,0xfc36cbf4,
0xc0010000,0xac784756,0xb781da47,
0xbff70000,0xd5f84a08,0xafaa21ec,
0xbffe0000,0xc5301e97,0x0fd3f76e,
0xbff60000,0xb93260d3,0xe0333656,
0xbffc0000,0xcb6ea845,0xd512cfb5,
0xbff60000,0xcf0f0c37,0xe1cebe1d,
0x40010000,0xfe7d25e2,0x0433e5bf,
0x3ff70000,0x8f3e7e3a,0xa6fd29a5,
0x40010000,0x90409235,0xc80618c5,
0x3ff50000,0xfed27f49,0xbb1af2f2,
0x3fff0000,0xc295c458,0x6246bf64,
0x3ff20000,0xb364c57f,0x9e06eadc,
0xc0030000,0x9239d41a,0x777fe508,
0xbff60000,0xf6b8b08a,0x9edadeec,
0xbffe0000,0xf528453e,0x69eacf52,
0xbff50000,0xd886d7df,0xd1ec17c9,
0xbffc0000,0xa53191b6,0xc3d55283,
0x3ff60000,0xabdea800,0x0ef5eb62,
0xc0030000,0x82f00205,0xea5baf68,
0xbff50000,0xc83eb17c,0x8b2bedc4,
0xc0030000,0xbe165105,0xb8e3089f,
0xbff40000,0xb55c0ed6,0xa75d5e2b,
0xc0020000,0x9524664b,0x57754788,
0x3ff30000,0x93bb8bf5,0x336a2eb4,
0xc0030000,0xf394d962,0xb82386d6,
0xbff60000,0xce3d3655,0x239c5311,
0xbffe0000,0x8822b103,0x3b3b7a56,
0xbff50000,0x8d7b73e1,0xa29602a1,
0x40020000,0x90f45c75,0x995784e4,
0x3ff40000,0x9cf59311,0x6be6fee1,
0xbff40000,0xdb131709,0x9c4f23ef,
0xbff20000,0xb69d0810,0xb27a7a7b,
0xbff60000,0x821e2440,0x1cdeb2b0,
0xbff10000,0xb98cd542,0x03ee8f42,
0xbff50000,0x8dfc77e2,0x50340914,
0xbfe90000,0x984eab8f,0x62452954,
0x3ff70000,0x93eda1ac,0x9b54e4ec,
0x3fed0000,0xadda1eff,0x03a35753,
0x3ff40000,0xbd7c318d,0x6a4fbd7a,
0x3fec0000,0x95b26d4d,0x77dd8c9e,
0x3ff30000,0x8148e269,0xc41a9edf,
};

long JD1[] = {0x40140000,0x94f98200,0x00000000};

long yn1[3*6*NTOTAL] = {
0x3ff10000,0xfb3c55d2,0x55278a54,
0x3ffa0000,0x85d62851,0x9a64bdd7,
0xbff10000,0x8fd609d9,0x2204e94f,
0x3ffd0000,0xc5402f50,0x0bbb6c2b,
0xbff10000,0xcf2ea32a,0xf216e549,
0x3fff0000,0xa0c2efd4,0xfbaf4ce2,
0x3ff80000,0xbeb5f336,0x40886df2,
0xbffd0000,0xafdf9f2f,0x8d983689,
0xbff90000,0x932b132b,0xcc3a7c5d,
0xbffd0000,0x809bdbae,0x4bcdb18d,
0xbff80000,0xb13b173f,0xdfdd379b,
0xbffb0000,0xcb1a1bb4,0x4f55bfce,
0x3ff90000,0x985953db,0x82eab3ca,
0xbffd0000,0x89cd8b3f,0x343197c4,
0xbff70000,0xd7d365ee,0xa6d44665,
0xbffe0000,0x9dd6a78c,0x9e1111dc,
0xbff70000,0x87c0c263,0x23a03b24,
0xbffd0000,0x857b6dc5,0xee15890c,
0x3ff80000,0xd65c8456,0xea1ac32a,
0x3ffe0000,0xa4819326,0x94a61090,
0x3ff80000,0xa1f30ffb,0x97a700bf,
0xbffe0000,0xb888b4d1,0x946fc0a7,
0x3ff70000,0x8c73eb9c,0x69147b77,
0xbffd0000,0xa01223e3,0x9c022457,
0xbff80000,0xa8940b66,0x20d48403,
0xbfff0000,0x850e24e1,0xf496bc90,
0xbff70000,0xe7bf088a,0xcc517ef0,
0x3fff0000,0x937c9ce6,0x69ce9bb1,
0xbff60000,0xc2a998c3,0x3fab5f93,
0x3ffe0000,0x8e88bdda,0xf62bd218,
0x3ff70000,0x977b67c8,0x1ef614b1,
0xc0010000,0x8798774b,0xc28780bc,
0xbff70000,0xa5a960de,0xc57d3b60,
0xc0000000,0xc95fd196,0x1c3098d6,
0xbff60000,0x958b041b,0x7a341187,
0xbfff0000,0x9f844602,0x04f923ae,
0xbff70000,0x8b732e55,0xfa9e6a48,
0x40010000,0xced427f1,0xe9b57aff,
0x3ff60000,0xe9865539,0xe9868447,
0x40010000,0xc351f8f8,0xbda9d31a,
0x3ff50000,0xd93c56c5,0x69e93ae0,
0x40000000,0x8fa5434b,0x41aed405,
0x3ff40000,0x89090244,0xd772637e,
0xc0030000,0x911d5ec3,0x8daa2dc9,
0xbff60000,0xf4904e1e,0xed651b24,
0xc0000000,0x9d4e0cf2,0x405f8cb1,
0xbff50000,0xd7496afa,0xfee33074,
0xbffe0000,0xd2156d01,0xa39dfc58,
0x3ff60000,0xb04857d3,0x06f3b073,
0xc0020000,0xf4df7f7a,0x3d6b7339,
0xbff50000,0xbad5c7cb,0xfaf8f24f,
0xc0030000,0xc2d01d7f,0x6c9bf85a,
0xbff40000,0xaad14d46,0x9fd87652,
0xc0020000,0x99711c71,0xb4e90c57,
0x3ff30000,0xcf306e8c,0xb8b15242,
0xc0030000,0xf27faeba,0x577edbef,
0xbff60000,0xcdf48066,0xd7d1fbf0,
0xbfff0000,0xe519fb3c,0x126783ca,
0xbff50000,0x91cf207e,0xe8769652,
0x40020000,0x89f0a78e,0x76fd9bd8,
0xbff30000,0xf05699a1,0xefba6de3,
0xbff50000,0xd1e2c835,0x08de8bb0,
0xbff30000,0x921e1640,0x36920525,
0x3ff60000,0x8044820e,0x7d61e094,
0xbff20000,0xb2fd3253,0x62f8b6af,
0x3ff40000,0xfde1cbe5,0x5313ffcb,
0xbfec0000,0xe7121630,0x22b4a7ee,
0x3ff60000,0xf7b706b1,0x2130a8b2,
0x3fed0000,0x876d6d26,0xdebd4d9d,
0x3ff60000,0xac657192,0x250be68b,
0x3feb0000,0xf2eff140,0xd3d38300,
0x3ff50000,0x8dcddeff,0x22436430,
};

/* Speed of light.
 */
long C[] = {0x40060000,0xad2506a6,0x64a29667};
/* Earth's mass divided by Moon's mass
 */
long EMRAT[] = {0x40050000,0xa299e68a,0x0d349be0};

/* Gaussian gravitational constant */
long KG[] = {0x3ff90000,0x8ceb6a8d,0x35b4cd0f};

/* GM's of the solar system bodies
 * These are scaled such that GMsun = k^2
 * (k = Gaussian gravitational constant).
 */
long GMs[] = {
0x00000000,0x00000000,0x00000000,
0x3fdc0000,0xd80e5dff,0x79853690,
0x3fe00000,0xc71b4aac,0xb49825d0,
0x3fe00000,0xf44d93df,0xc30a6d51,
0x3fdd0000,0xd1ff1198,0x6f0cd540,
0x3fe90000,0x97af34c8,0xdaca4d10,
0x3fe70000,0xb5aa6b80,0x7d167bf0,
0x3fe40000,0xdd6abcd3,0x16eff4f0,
0x3fe50000,0x839b827f,0xefbe3fe0,
0x3fd80000,0xa02d3bee,0x86f1e570,
0x3fda0000,0xc050dde4,0xfaf09fde,
0x3ff30000,0x9b24aa0e,0x7caf3130,
0x3fd40000,0xc495060f,0xa2db6560,
0x3fd20000,0x901d7cf7,0x3ab0acd9,
0x3fd20000,0xb7bf3288,0x046e0f95,
0x3fcd0000,0xe69594be,0xc44de15b,
0x3fce0000,0xbb5988da,0xff7f471a,
};

/* Astronomical unit */
long AU[] = {0x40240000,0x8b52e969,0x10000000};
/* kilometers: */
long RADS[] = {0x40120000,0xa9ec0000,0x00000000};
long RADM[] = {0x40090000,0xd9400000,0x00000000};
long RADE[] = {0x400b0000,0xc7511eb8,0x51eb851f};
/* equatorial radius of Earth, in au */
long AE[] = {0x3ff00000,0xb2d33b79,0x342ee7e0};
long Je[] = {
0x3ff50000,0x8de708e3,0x2883d7bb,
0xbfec0000,0xaa74de23,0x61590b5f,
0xbfeb0000,0xd8172dc4,0x0883065a,
};
/* equatorial radius of Moon, in au */
long AM[] = {0x3fee0000,0xc2ea1fd7,0xcef2d0d0};
long Jm[] = {
0x3ff20000,0xd3f8789c,0xb385b2bf,
0x3fee0000,0xcb70f759,0x3b59010a,
0xbfe80000,0x9c1a93a1,0xe6df5968,
};
long Cnm[] = {
0x3fef0000,0xbb186dfd,0xc96a7465,
0x3ff00000,0x80ccc21e,0x96ad2e1c,
0x3fed0000,0xa40713a7,0xa4db3e1d,
0x3feb0000,0xc0bda701,0x66ca71bc,
0xbfed0000,0xf0d8d86b,0x0013b17c,
0xbfeb0000,0xc135799c,0x8cc7831b,
0xbfe70000,0xb79079cc,0x6b39bd7f,
0xbfe80000,0xa653a86d,0x83975fde,
};
long Snm[] = {
0x00000000,0x00000000,0x00000000,
0x3fed0000,0xbc43476e,0xd821952d,
0x3feb0000,0xe27babd9,0x2f842d1e,
0xbfe90000,0xb3815400,0x49692c9b,
0x3fec0000,0xc5cc86b7,0x94df47ea,
0xbfec0000,0xc19122c5,0x505e73b4,
0xbfea0000,0xd3c96bc0,0x1bf5f828,
0x3fe60000,0xf2410660,0x4261f10f,
};
long K2M[] = {0x3ff90000,0xb5fe7217,0xccdb3c62};
long LOVENO[] = {0x3ffd0000,0x99999999,0x9999999a};
long PHASE[] = {0x3ffa0000,0xa6b50e47,0xc9f6b735};
long PSLP1[] = {0x3ffc0000,0xeb7da643,0xab476c10};
long PSLPI[] = {0x40030000,0xda9299b4,0x0270fa49};
long PSLPIA[] = {0x40030000,0xda9299a0,0x00000000};
long PSLPIB[] = {0x3fe80000,0xa01387d2,0x49cbd8bb};
long JDEPOCH[] = {0x40140000,0x94f34200,0x00000000};
long LBET[] = {0x3ff40000,0xa597c822,0x2956c41b};
long LGAM[] = {0x3ff20000,0xef193d24,0x0a252d8e};
long LGAMBET[] = {0xbff30000,0xd3a2f3b1,0xbca77c09};
long CMRSQ[] = {0x3ffd0000,0xc8087523,0x40baa604};
long CMR2[] = {0x3fdc0000,0xe7ebcec2,0x9818a342};
long BMR2[] = {0x3fdc0000,0xe7d3db42,0xee092bd7};
long AMR2[] = {0x3fdc0000,0xe7c65182,0xb6ddf1f4};
#endif /* ldouble MIEEE */

#if IBMPC
/* Note, `XPD' is an optional 0 pad to make 12-byte numbers.
 * see mconf.h.
 */
short DTR[] = {0xc8ae,0x94e9,0x3512,0x8efa,0x3ff9, XPD};
short RTD[] = {0xbdc3,0x1e0f,0xe0d3,0xe52e,0x4004, XPD};
short RTS[] = {0xd5c8,0x8d6b,0x3399,0xc96e,0x4010, XPD};
short STR[] = {0xe8e1,0xfc7c,0x2d97,0xa2ad,0x3fed, XPD};
short PI[] = {0xc235,0x2168,0xdaa2,0xc90f,0x4000, XPD};
short J2000[] = {0x0000,0x0000,0x6400,0x95a1,0x4014, XPD};
short B1950[] = {0x78d5,0x26e9,0x09b1,0x9484,0x4014, XPD};
short J1900[] = {0x0000,0x0000,0xb000,0x9366,0x4014, XPD};
short B1900[] = {0x6e98,0x8312,0xb140,0x9366,0x4014, XPD};
short Jcentury[] = {0x0000,0x0000,0x0000,0x8ead,0x400e, XPD};
short Jmillenium[] = {0x0000,0x0000,0x4000,0xb258,0x4011, XPD};
short Jtmillenium[] = {0x0000,0x0000,0x5000,0xdeee,0x4014, XPD};

short JD0[] = {0x0000,0x0000,0x4200,0x94f3,0x4014, XPD};
short yn0[(sizeof( long double )/2)*6*NTOTAL] = {
0xcaa1,0x1d23,0x69c8,0xd1bf,0x3ff1, XPD
0x03a1,0xa6b9,0x14b0,0xc5b4,0x3ff7, XPD
0x6fc6,0x7608,0x23bf,0xfa0c,0x3fee, XPD
0x2d35,0x9a20,0x0428,0xc3c9,0x3ffd, XPD
0xfff5,0xc3fb,0xc92e,0xfa78,0xbff1, XPD
0xfbf8,0xc67c,0x8130,0xa3fe,0x3fff, XPD
0x947b,0x006e,0x6c32,0xf30a,0x3ff6, XPD
0x6608,0x756c,0x1c70,0xb87a,0x3ffd, XPD
0x1888,0x95de,0xa061,0xcb9c,0x3ff9, XPD
0xdcab,0xc3c3,0x40e6,0xc22d,0xbffb, XPD
0xa5a3,0x9afe,0x9d18,0xd3d4,0x3ff8, XPD
0xf602,0x4dc6,0xd08e,0xb321,0xbffb, XPD
0x1235,0xa0c5,0x5d1d,0xb6ca,0x3ff8, XPD
0x3017,0x36c0,0x04c8,0x9b9d,0x3ffe, XPD
0x008d,0x38a8,0xdce7,0xfdda,0x3ff8, XPD
0xa9ef,0xc77a,0xa0c7,0xb5da,0xbffd, XPD
0x25b5,0x7feb,0x915a,0xcdb2,0x3ff7, XPD
0xe65e,0xc32b,0xcd1a,0xcaff,0xbffc, XPD
0xe259,0xba33,0xe2d3,0x89e5,0x3ff9, XPD
0x8ed2,0x0edb,0xe1ca,0xdd9b,0x3ffb, XPD
0x6ad9,0xb36c,0xbf06,0xcc7f,0x3ff5, XPD
0xc885,0x0452,0x274e,0xed57,0xbffe, XPD
0x15d6,0x3306,0x9434,0xb154,0x3ff4, XPD
0x9215,0xb202,0x3248,0xcddf,0xbffd, XPD
0x3b31,0x3e18,0x9271,0xed45,0x3ff8, XPD
0x1309,0xaef3,0x0473,0x8309,0xbffc, XPD
0xf107,0x7fd1,0x6e0a,0xa8e1,0x3ff1, XPD
0x56cf,0x9cc8,0xf259,0xa9c2,0xbfff, XPD
0x49d3,0xddcb,0xc8a2,0xb87d,0xbff3, XPD
0x914e,0xa157,0x7883,0x9af5,0xbffe, XPD
0xcbf4,0xfc36,0xc9ff,0x83c5,0x3ff5, XPD
0xda47,0xb781,0x4756,0xac78,0xc001, XPD
0x21ec,0xafaa,0x4a08,0xd5f8,0xbff7, XPD
0xf76e,0x0fd3,0x1e97,0xc530,0xbffe, XPD
0x3656,0xe033,0x60d3,0xb932,0xbff6, XPD
0xcfb5,0xd512,0xa845,0xcb6e,0xbffc, XPD
0xbe1d,0xe1ce,0x0c37,0xcf0f,0xbff6, XPD
0xe5bf,0x0433,0x25e2,0xfe7d,0x4001, XPD
0x29a5,0xa6fd,0x7e3a,0x8f3e,0x3ff7, XPD
0x18c5,0xc806,0x9235,0x9040,0x4001, XPD
0xf2f2,0xbb1a,0x7f49,0xfed2,0x3ff5, XPD
0xbf64,0x6246,0xc458,0xc295,0x3fff, XPD
0xeadc,0x9e06,0xc57f,0xb364,0x3ff2, XPD
0xe508,0x777f,0xd41a,0x9239,0xc003, XPD
0xdeec,0x9eda,0xb08a,0xf6b8,0xbff6, XPD
0xcf52,0x69ea,0x453e,0xf528,0xbffe, XPD
0x17c9,0xd1ec,0xd7df,0xd886,0xbff5, XPD
0x5283,0xc3d5,0x91b6,0xa531,0xbffc, XPD
0xeb62,0x0ef5,0xa800,0xabde,0x3ff6, XPD
0xaf68,0xea5b,0x0205,0x82f0,0xc003, XPD
0xedc4,0x8b2b,0xb17c,0xc83e,0xbff5, XPD
0x089f,0xb8e3,0x5105,0xbe16,0xc003, XPD
0x5e2b,0xa75d,0x0ed6,0xb55c,0xbff4, XPD
0x4788,0x5775,0x664b,0x9524,0xc002, XPD
0x2eb4,0x336a,0x8bf5,0x93bb,0x3ff3, XPD
0x86d6,0xb823,0xd962,0xf394,0xc003, XPD
0x5311,0x239c,0x3655,0xce3d,0xbff6, XPD
0x7a56,0x3b3b,0xb103,0x8822,0xbffe, XPD
0x02a1,0xa296,0x73e1,0x8d7b,0xbff5, XPD
0x84e4,0x9957,0x5c75,0x90f4,0x4002, XPD
0xfee1,0x6be6,0x9311,0x9cf5,0x3ff4, XPD
0x23ef,0x9c4f,0x1709,0xdb13,0xbff4, XPD
0x7a7b,0xb27a,0x0810,0xb69d,0xbff2, XPD
0xb2b0,0x1cde,0x2440,0x821e,0xbff6, XPD
0x8f42,0x03ee,0xd542,0xb98c,0xbff1, XPD
0x0914,0x5034,0x77e2,0x8dfc,0xbff5, XPD
0x2954,0x6245,0xab8f,0x984e,0xbfe9, XPD
0xe4ec,0x9b54,0xa1ac,0x93ed,0x3ff7, XPD
0x5753,0x03a3,0x1eff,0xadda,0x3fed, XPD
0xbd7a,0x6a4f,0x318d,0xbd7c,0x3ff4, XPD
0x8c9e,0x77dd,0x6d4d,0x95b2,0x3fec, XPD
0x9edf,0xc41a,0xe269,0x8148,0x3ff3, XPD
};
short JD1[] = {0x0000,0x0000,0x8200,0x94f9,0x4014, XPD};
short yn1[(sizeof( long double )/2)*6*NTOTAL] = {
0x8a54,0x5527,0x55d2,0xfb3c,0x3ff1, XPD
0xbdd7,0x9a64,0x2851,0x85d6,0x3ffa, XPD
0xe94f,0x2204,0x09d9,0x8fd6,0xbff1, XPD
0x6c2b,0x0bbb,0x2f50,0xc540,0x3ffd, XPD
0xe549,0xf216,0xa32a,0xcf2e,0xbff1, XPD
0x4ce2,0xfbaf,0xefd4,0xa0c2,0x3fff, XPD
0x6df2,0x4088,0xf336,0xbeb5,0x3ff8, XPD
0x3689,0x8d98,0x9f2f,0xafdf,0xbffd, XPD
0x7c5d,0xcc3a,0x132b,0x932b,0xbff9, XPD
0xb18d,0x4bcd,0xdbae,0x809b,0xbffd, XPD
0x379b,0xdfdd,0x173f,0xb13b,0xbff8, XPD
0xbfce,0x4f55,0x1bb4,0xcb1a,0xbffb, XPD
0xb3ca,0x82ea,0x53db,0x9859,0x3ff9, XPD
0x97c4,0x3431,0x8b3f,0x89cd,0xbffd, XPD
0x4665,0xa6d4,0x65ee,0xd7d3,0xbff7, XPD
0x11dc,0x9e11,0xa78c,0x9dd6,0xbffe, XPD
0x3b24,0x23a0,0xc263,0x87c0,0xbff7, XPD
0x890c,0xee15,0x6dc5,0x857b,0xbffd, XPD
0xc32a,0xea1a,0x8456,0xd65c,0x3ff8, XPD
0x1090,0x94a6,0x9326,0xa481,0x3ffe, XPD
0x00bf,0x97a7,0x0ffb,0xa1f3,0x3ff8, XPD
0xc0a7,0x946f,0xb4d1,0xb888,0xbffe, XPD
0x7b77,0x6914,0xeb9c,0x8c73,0x3ff7, XPD
0x2457,0x9c02,0x23e3,0xa012,0xbffd, XPD
0x8403,0x20d4,0x0b66,0xa894,0xbff8, XPD
0xbc90,0xf496,0x24e1,0x850e,0xbfff, XPD
0x7ef0,0xcc51,0x088a,0xe7bf,0xbff7, XPD
0x9bb1,0x69ce,0x9ce6,0x937c,0x3fff, XPD
0x5f93,0x3fab,0x98c3,0xc2a9,0xbff6, XPD
0xd218,0xf62b,0xbdda,0x8e88,0x3ffe, XPD
0x14b1,0x1ef6,0x67c8,0x977b,0x3ff7, XPD
0x80bc,0xc287,0x774b,0x8798,0xc001, XPD
0x3b60,0xc57d,0x60de,0xa5a9,0xbff7, XPD
0x98d6,0x1c30,0xd196,0xc95f,0xc000, XPD
0x1187,0x7a34,0x041b,0x958b,0xbff6, XPD
0x23ae,0x04f9,0x4602,0x9f84,0xbfff, XPD
0x6a48,0xfa9e,0x2e55,0x8b73,0xbff7, XPD
0x7aff,0xe9b5,0x27f1,0xced4,0x4001, XPD
0x8447,0xe986,0x5539,0xe986,0x3ff6, XPD
0xd31a,0xbda9,0xf8f8,0xc351,0x4001, XPD
0x3ae0,0x69e9,0x56c5,0xd93c,0x3ff5, XPD
0xd405,0x41ae,0x434b,0x8fa5,0x4000, XPD
0x637e,0xd772,0x0244,0x8909,0x3ff4, XPD
0x2dc9,0x8daa,0x5ec3,0x911d,0xc003, XPD
0x1b24,0xed65,0x4e1e,0xf490,0xbff6, XPD
0x8cb1,0x405f,0x0cf2,0x9d4e,0xc000, XPD
0x3074,0xfee3,0x6afa,0xd749,0xbff5, XPD
0xfc58,0xa39d,0x6d01,0xd215,0xbffe, XPD
0xb073,0x06f3,0x57d3,0xb048,0x3ff6, XPD
0x7339,0x3d6b,0x7f7a,0xf4df,0xc002, XPD
0xf24f,0xfaf8,0xc7cb,0xbad5,0xbff5, XPD
0xf85a,0x6c9b,0x1d7f,0xc2d0,0xc003, XPD
0x7652,0x9fd8,0x4d46,0xaad1,0xbff4, XPD
0x0c57,0xb4e9,0x1c71,0x9971,0xc002, XPD
0x5242,0xb8b1,0x6e8c,0xcf30,0x3ff3, XPD
0xdbef,0x577e,0xaeba,0xf27f,0xc003, XPD
0xfbf0,0xd7d1,0x8066,0xcdf4,0xbff6, XPD
0x83ca,0x1267,0xfb3c,0xe519,0xbfff, XPD
0x9652,0xe876,0x207e,0x91cf,0xbff5, XPD
0x9bd8,0x76fd,0xa78e,0x89f0,0x4002, XPD
0x6de3,0xefba,0x99a1,0xf056,0xbff3, XPD
0x8bb0,0x08de,0xc835,0xd1e2,0xbff5, XPD
0x0525,0x3692,0x1640,0x921e,0xbff3, XPD
0xe094,0x7d61,0x820e,0x8044,0x3ff6, XPD
0xb6af,0x62f8,0x3253,0xb2fd,0xbff2, XPD
0xffcb,0x5313,0xcbe5,0xfde1,0x3ff4, XPD
0xa7ee,0x22b4,0x1630,0xe712,0xbfec, XPD
0xa8b2,0x2130,0x06b1,0xf7b7,0x3ff6, XPD
0x4d9d,0xdebd,0x6d26,0x876d,0x3fed, XPD
0xe68b,0x250b,0x7192,0xac65,0x3ff6, XPD
0x8300,0xd3d3,0xf140,0xf2ef,0x3feb, XPD
0x6430,0x2243,0xdeff,0x8dcd,0x3ff5, XPD
};

short C[] = {0x9667,0x64a2,0x06a6,0xad25,0x4006, XPD};
short EMRAT[] = {0x9be0,0x0d34,0xe68a,0xa299,0x4005, XPD};
short KG[] = {0xcd0f,0x35b4,0x6a8d,0x8ceb,0x3ff9, XPD};
short GMs[] = {
0x0000,0x0000,0x0000,0x0000,0x0000, XPD
0x3690,0x7985,0x5dff,0xd80e,0x3fdc, XPD
0x25d0,0xb498,0x4aac,0xc71b,0x3fe0, XPD
0x6d51,0xc30a,0x93df,0xf44d,0x3fe0, XPD /* Earth only */
0xd540,0x6f0c,0x1198,0xd1ff,0x3fdd, XPD
0x4d10,0xdaca,0x34c8,0x97af,0x3fe9, XPD
0x7bf0,0x7d16,0x6b80,0xb5aa,0x3fe7, XPD
0xf4f0,0x16ef,0xbcd3,0xdd6a,0x3fe4, XPD
0x3fe0,0xefbe,0x827f,0x839b,0x3fe5, XPD
0xe570,0x86f1,0x3bee,0xa02d,0x3fd8, XPD
0x9fde,0xfaf0,0xdde4,0xc050,0x3fda, XPD /* Moon */
0x3130,0x7caf,0xaa0e,0x9b24,0x3ff3, XPD /* Sun */
0x6560,0xa2db,0x060f,0xc495,0x3fd4, XPD
0xacd9,0x3ab0,0x7cf7,0x901d,0x3fd2, XPD
0x0f95,0x046e,0x3288,0xb7bf,0x3fd2, XPD
0xe15b,0xc44d,0x94be,0xe695,0x3fcd, XPD
0x471a,0xff7f,0x88da,0xbb59,0x3fce, XPD
};
short AU[] = {0x0000,0x1000,0xe969,0x8b52,0x4024, XPD};
short RADS[] = {0x0000,0x0000,0x0000,0xa9ec,0x4012, XPD};
short RADM[] = {0x0000,0x0000,0x0000,0xd940,0x4009, XPD};
short RADE[] = {0x851f,0x51eb,0x1eb8,0xc751,0x400b, XPD};
short Je[] = {
0xd7bb,0x2883,0x08e3,0x8de7,0x3ff5, XPD
0x0b5f,0x6159,0xde23,0xaa74,0xbfec, XPD
0x065a,0x0883,0x2dc4,0xd817,0xbfeb, XPD
};


short Jm[] = {
0xb2bf,0xb385,0x789c,0xd3f8,0x3ff2, XPD
0x010a,0x3b59,0xf759,0xcb70,0x3fee, XPD
0x5968,0xe6df,0x93a1,0x9c1a,0xbfe8, XPD
};
short Cnm[] = {
0x7465,0xc96a,0x6dfd,0xbb18,0x3fef, XPD
0x2e1c,0x96ad,0xc21e,0x80cc,0x3ff0, XPD
0x3e1d,0xa4db,0x13a7,0xa407,0x3fed, XPD
0x71bc,0x66ca,0xa701,0xc0bd,0x3feb, XPD
0xb17c,0x0013,0xd86b,0xf0d8,0xbfed, XPD
0x831b,0x8cc7,0x799c,0xc135,0xbfeb, XPD
0xbd7f,0x6b39,0x79cc,0xb790,0xbfe7, XPD
0x5fde,0x8397,0xa86d,0xa653,0xbfe8, XPD
};
short Snm[] = {
0x0000,0x0000,0x0000,0x0000,0x0000, XPD
0x952d,0xd821,0x476e,0xbc43,0x3fed, XPD
0x2d1e,0x2f84,0xabd9,0xe27b,0x3feb, XPD
0x2c9b,0x4969,0x5400,0xb381,0xbfe9, XPD
0x47ea,0x94df,0x86b7,0xc5cc,0x3fec, XPD
0x73b4,0x505e,0x22c5,0xc191,0xbfec, XPD
0xf828,0x1bf5,0x6bc0,0xd3c9,0xbfea, XPD
0xf10f,0x4261,0x0660,0xf241,0x3fe6, XPD
};
short K2M[] = {0x3c62,0xccdb,0x7217,0xb5fe,0x3ff9, XPD};
short LOVENO[] = {0x999a,0x9999,0x9999,0x9999,0x3ffd, XPD};
short PHASE[] = {0xb735,0xc9f6,0x0e47,0xa6b5,0x3ffa, XPD};
short PSLP1[] = {0x6c10,0xab47,0xa643,0xeb7d,0x3ffc, XPD};
short PSLPI[] = {0xfa49,0x0270,0x99b4,0xda92,0x4003, XPD};
short PSLPIA[] = {0x0000,0x0000,0x99a0,0xda92,0x4003, XPD};
short PSLPIB[] = {0xd8bb,0x49cb,0x87d2,0xa013,0x3fe8, XPD};
short JDEPOCH[] = {0x0000,0x0000,0x4200,0x94f3,0x4014, XPD};
short LBET[] = {0xc41b,0x2956,0xc822,0xa597,0x3ff4, XPD};
short LGAM[] = {0x2d8e,0x0a25,0x3d24,0xef19,0x3ff2, XPD};
short LGAMBET[] = {0x7c09,0xbca7,0xf3b1,0xd3a2,0xbff3, XPD};

short AE[] = {0xe7e0,0x342e,0x3b79,0xb2d3,0x3ff0, XPD};
short AM[] = {0xd0d0,0xcef2,0x1fd7,0xc2ea,0x3fee, XPD};
#define AMd 1.16178124180819699985E-5L

/*
#define CMRSQ 0.3906895261319410091L
#define LBETd 6.31686773468e-4L
#define LGAMd 2.28022183594e-4L
DOUBLE CMR2 = CMRSQ*AMd*AMd;
DOUBLE BMR2 = CMRSQ*AMd*AMd*(1.0L + LGAMd)/(1.0L + LBETd);
DOUBLE AMR2 = CMRSQ*AMd*AMd*(1.0L - LBETd * LGAMd)/(1.0L + LBETd);
*/
short CMRSQ[] = {0xa604,0x40ba,0x7523,0xc808,0x3ffd, XPD};
short CMR2[] = {0xa342,0x9818,0xcec2,0xe7eb,0x3fdc, XPD};
short BMR2[] = {0x2bd7,0xee09,0xdb42,0xe7d3,0x3fdc, XPD};
short AMR2[] = {0xf1f4,0xb6dd,0x5182,0xe7c6,0x3fdc, XPD};
#endif /* ldouble IBMPC */

#if UNK
/* For this case the values should all have an L at the end
 * for long double type.
 */
#include "ini118d.h"
#endif
#else /* not LDOUBLE: */

#include "ini118d.h"

int dummy(x)
register int x;
{
return(x);
}

#endif /* not LDOUBLE */
