;
; EMS system implemented by
;
; David Lindauer
;
; gclind01@ulkyvx.louisville.edu
;
; August, 1995 
;
; As part of the FREE-DOS project
;
; VM386.asm
;   Function: emulate 386 instructions that are trapped in V86 mode
;
;   At this point seg overrides on LIDT,LGDT,SIDT,SGDT are ignored
;
	.386p

include segs.asi
include vm86.asi
include vm386.asi

	public	emu386, userIDT, init386regs, emuIDT

SEG386	segment
	extrn GFTrapFrame : PROC, reflect : PROC, intframe2: PROC
SEG386	ends

SEG386DATA	segment
	extrn	EmuFlags : dword
emuIDT	dw	0
userIDT	dd	0
emuGDT	dw	0
userGDT	dd	0
userCR0	dd	0
userCR1	dd	0
userCR2	dd	0
userCR3	dd	0
SEG386DATA	ends

seg8086	segment
;
; Initialize the phantom registers with the current CPU state
;
init386regs	proc
	assume	cs:dgroup, es:dgroup	
	sidt	fword ptr [emuIDT]      ; Get the IDT
	sgdt	fword ptr [emuGDT]   	; Get the GDT
	mov	eax,CR0			; Get CR0
	mov	[userCR0],eax		;
	mov	eax,CR2			; Get CR2
	mov	[userCR2],eax		;
	mov	eax,CR3			; Get CR3
	mov	[userCR3],eax		;
	ret
init386regs	endp
seg8086	ends

SEG386	segment
;
; Prefixes we look for
;
prefixtabstart LABEL BYTE
	db	26h,2eh,36h,3eh,64h,65h,66h,67h,0f0h,0f2h,0f3h
prefixtabend	LABEL BYTE
PREFIXTABSIZE	EQU PrefixTabEnd - PrefixTabStart
;
; 2nd byte of 0F class opcodes that we emulate
;
OpTabStart	Label	Dword
	dd	1,6,20h,21h
OpTabEnd	label	dword
OPTABSIZE =	OpTabEnd - OpTabStart
;
; Routines corresponding to the second bytes
;
	align
OpRoutines	Label	Dword
	dd	dgroup:group7, dgroup:emu_clts
	dd	dgroup:emu_movtoCR, dgroup: emu_movfromCR
;
; The following table is dependent on the ABSOLUTE order things are
; pushed at entry to the emulator
;
stacktab	label	dword
	dd	-4,-12,-16,-8,20,0,-20,-24
;
; Group 7 functions we are emulating
;
g7tab	label	dword
	dd	dgroup:emu_sgdt,dgroup:emu_sidt
	dd	dgroup:emu_lgdt,dgroup:emu_lidt
;
; Report an Illegal opcode to the 8086 software
;
IllIns	proc
	add	esp,4		; Clear stack
illins2:
	call	intframe2	; Make a frame for the int 6
	mov	al,6		; Reflect the int 6
	call	reflect		;
	jmp	emu_exit	; Exit the emulator
IllIns	endp
;
; Get address for LGDT & cetera
;
getDTadr	proc
	bt	[EmuFlags],BOPSIZE	; Check size
	jc	gda4		; Branch if dword
	add	edx,2		; Else get a word address
	sub	eax,eax		;
	db	064h		; FS:
	lodsw			;
	jmp	short gdagot	; Got the address
gda4:
	add	edx,4		; Going to get a dword address
	db	064h		; FS:
	lodsd			;
gdagot:
	movzx	ebx,word ptr [GFDS]	; Always index off DS  bug!!!
	shl	ebx,4		; Make seg value physical
	add	eax,ebx		; Get the address in EAX
	ret
getDTadr	endp
;
; Get reg & CRreg for mov to & from CR
;
getr32CR	proc
	sub	eax,eax
	db	064h		; FS:
	lodsb			; Get MODRM byte
	inc	edx
	cmp	al,0c0h
	jc	illins		; Err if U2 bits not set
	mov	ebx,eax
	shr	ebx,3		; Get CR #
	lea	ebx,[userCR0+ebx*4]	; Get pointer to CR data
	and	eax,3		; Get	Reg
	mov	eax,[eax*4+stacktab]	; Get stack offset from table
	add	eax,ebp		; It's an offset from ebp
	ret
	
getr32CR	endp


;
; Clear the phantom TS bit
;
emu_clts	proc
	btr	dword ptr [userCR0],TS
	jmp	emu_end
emu_clts	endp
;
; Emulate an LGDT
;
emu_LGDT	proc
	call	getDTadr	; Get the address
	mov	bx,fs:[eax]	; Get length
	mov	[emuGDT],bx	; Save it
	mov	ebx,fs:[eax+2]	; Get physical address
	mov	[userGDT],ebx	; Save it
	jmp	emu_end
emu_LGDT	endp
;
; Emulate an LIDT
;
emu_LIDT	proc
	call	getDTadr	; Get the address
	mov	bx,fs:[eax]	; Get length
	mov	[emuIDT],bx	; Save it
	mov	ebx,fs:[eax+2]	; Get physical address
	mov	[userIDT],ebx	; Save it
	jmp	emu_end
emu_LIDT	endp
;
; Emulate SGDT
;
emu_SGDT	proc
	call	getDTadr	; Get the address
	mov	bx,[emuGDT]	; Get length
	mov	fs:[eax],bx	; Save it
	mov	ebx,[userGDT]	; Get physical address
	mov	fs:[eax],ebx	; Save it
	jmp	emu_end
emu_SGDT	endp
;
; Emulate SIDT
;
emu_SIDT	proc
	call	getDTadr	; Get the address
	mov	bx,[emuIDT]	; Get length
	mov	fs:[eax],bx	; Save it
	mov	ebx,[userIDT]	; Get physical address
	mov	fs:[eax],ebx	; Save it
	jmp	emu_end
emu_SIDT	endp
;
; Emulate move to & from CR regs
;
emu_movtoCR	proc
	call	getR32CR	; Get pointers to reg, CR reg
	mov	ecx,ss:[eax]	; get reg
	mov	[ebx],ecx	; save to CRREG
	jmp	emu_end
emu_movtoCR	endp
emu_movfromCR	proc
	call	getR32CR       ; Get pointers to reg, CR reg
	mov	ecx,[ebx]	; get CRREG
	mov	ss:[eax],ecx	; save to REG
	jmp	emu_end
emu_movfromCR	endp
;
; Group 7 emulator
;
group7	proc
	sub	eax,eax
	db	064h		; Get next byte
	lodsb			;
	push	eax
	and	al,0c7h		; See if has right MODRM byte
	cmp	al,6
	pop	eax
	jnz	Illins2		; Ill instruction if not
	shr	al,3  		; Get the NNN field
	and	al,7		;
	bt	eax,2		; See if greater than 3
	jc	Illins2		; Ill ins if so.  Note that SMSW and LMSW
				; aren't trapped, so we don't have
				; to worry about them
	jmp	[eax*4+g7tab]	; Go do the routine
group7	endp
	
;
; 386 emulator.  This hooks the Illegal Instruction trap.
; Note that we are using the exact same stack frame as in the main emulator
; so that we can use its routines... if this is changed VM86.ASI will have
; to be changed and stacktab (this module) will have to be changed.
;
emu386	proc
	push	ebp    			; Get EMU stack frame
	mov	ebp,esp
	push	eax			; Push regs.  Order is important
	push	ebx			;
	push	ecx			;
	push	edx			;
	push	esi			;
	push	edi			;
	mov	ax,DS386		; Set segs up reasonably
	mov	ds,ax                   ;
	mov	es,ax			;
	push	DSABS			; Point at 8086 data
	pop	fs			;
	mov	[EmuFlags],(1 SHL OPEMU); Clear flags & put us in emulator
	GETFRAME	GFEIP,GFCS,esi	; Get the code frame
	sub	edx,edx			; Bytes in instruction = 0
prefixlp:
	db	64h	; FS:		; Get a byte
	lodsb				;
	inc	edx			; Count it
	mov	ecx,PREFIXTABSIZE	; Length of prefix tab
	mov	edi,offset DGROUP:PrefixTabEnd-1; End of prefix tab
	std				; Direction = down
	repne	scasb			; Scan table for a match
	jnz	checkop			; No match, check opcode table
	bts	[EmuFlags],ecx		; Else set the bit corresponding
					; To that prefix and get the next byte
	jmp	prefixlp	

checkop:
	mov	ecx,OPTABSIZE	; Length of 2byte tab
	mov	edi,offset DGROUP:OpTabEnd-1; End of 2byte tab
	repne	scasb			; Scan table for a match
	jnz	IllIns2			; No match, ill ins
	shl	ecx,2            	; Make it a DWORD
	jmp	[ECX+ OpRoutines]	; Call the routine
emu_end:	
	RADD	GFEIP,dx		; Skip past instruction
emu_exit:
	pop	edi			; Pop regs
	pop	esi
	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	pop	ebp
	add	esp,4			; Get rid of error code
	btr	[EmuFlags],OPEMU	; Not in emulator any more
	iretd				; back to V86
emu386	endp
SEG386	ends
	end