// Copyright (C) 1998-1999 Scott Cutler
// Please see the "readme.txt" file for license details

#include "include.h"



XGLLINK uint32 XGLCALL gu3dfGetInfo(char *filename, XGL3dfInfo *info) {
	vlog("Called gu3dfGetInfo: filename=" << filename);

	ifstream f;
	int i, smalllod=1, largelod=1, w_aspect=1, h_aspect=1;
	char s[256], fmt[8];

	f.open(filename);
	if(!f.is_open()) {
		log("  Could not open " << filename << " in gu3dfGetInfo");
		return XGLFALSE;
	}

	for (i=0; i<11; i++) {
		f >> s;
		switch (i) {
		case 2:		strcpy(fmt, s);			break;
		case 5:		smalllod = atoi(s);		break;
		case 6:		largelod = atoi(s);		break;
		case 9:		w_aspect = atoi(s);		break;
		case 10:	h_aspect = atoi(s);		break;
		}
	}
	f.close();

	int slod, llod;

	switch (largelod) {
	case 256:	llod = XGLLOD_256;	break;
	case 128:	llod = XGLLOD_128;	break;
	case 64:	llod = XGLLOD_64;	break;
	case 32:	llod = XGLLOD_32;	break;
	case 16:	llod = XGLLOD_16;	break;
	case 8:		llod = XGLLOD_8;	break;
	case 4:		llod = XGLLOD_4;	break;
	case 2:		llod = XGLLOD_2;	break;
	case 1:		llod = XGLLOD_1;	break;
	default:	llod = XGLLOD_1;
	}

	switch (smalllod) {
	case 256:	slod = XGLLOD_256;	break;
	case 128:	slod = XGLLOD_128;	break;
	case 64:	slod = XGLLOD_64;	break;
	case 32:	slod = XGLLOD_32;	break;
	case 16:	slod = XGLLOD_16;	break;
	case 8:		slod = XGLLOD_8;	break;
	case 4:		slod = XGLLOD_4;	break;
	case 2:		slod = XGLLOD_2;	break;
	case 1:		slod = XGLLOD_1;	break;
	default:	slod = XGLLOD_1;
	}

	int width = largelod, height = largelod;

	info->aspect = getAspectRatio(w_aspect, h_aspect);
	switch (info->aspect) {
	case XGLASPECT_8x1:		height >>= 3;	break;
	case XGLASPECT_4x1:		height >>= 2;	break;
	case XGLASPECT_2x1:		height >>= 1;	break;
	case XGLASPECT_1x1:		break;
	case XGLASPECT_1x2:		width >>= 1;	break;
	case XGLASPECT_1x4:		width >>= 2;	break;
	case XGLASPECT_1x8:		width >>= 3;	break;
	}


	info->width =  width;
	info->height = height;
	info->smalllod = slod;
	info->largelod = llod;
	info->format = getTextureFormat(fmt);

//	info->palette

	info->data = 0;

	info->mem = getMemRequired(info, smalllod, largelod, w_aspect, h_aspect);


	vlog("  smalllod=" << smalllod);
	vlog("  largelod=" << largelod);
	vlog("  w_aspect=" << w_aspect);
	vlog("  h_aspect=" << h_aspect);
	vlog("  width=" << info->width);
	vlog("  height=" << info->height);
	vlog("  mem=" << info->mem);


	return XGLTRUE;
}


XGLLINK uint32 XGLCALL gu3dfLoad(char *filename, XGL3dfInfo *info) {
	vlog("Called gu3dfLoad");
	ifstream f;
	char s[51];

	f.open(filename, ios::binary);
	if(!f.is_open()) {
		log("  Could not open " << filename << " in gu3dfLoad");
		return XGLFALSE;
	}

	f >> s;

	f.read(info->data, info->mem);

	f.close();

	return XGLTRUE;
}


uint32 getMemRequired(XGL3dfInfo *info, uint32 smalllod, uint32 largelod, uint32 xaspect, uint32 yaspect) {
	uint32 pixels = 0;
	uint32 i;

	log(smalllod << " - " << largelod << " - " << xaspect << " - " << yaspect);

	for (i=smalllod; i<=largelod; i *= 2)
		pixels += i * i / (xaspect * yaspect);

	return (pixels * getBytesPerPixel(info->format));
}

