// Copyright (C) 1998-1999 Scott Cutler
// Please see the "readme.txt" file for license details

#include "include.h"


void ARGB8888toRGB565(uchar *d, uchar *s) {
	d[1] = (s[2] & 0xF8) | (s[1] >> 5);
	d[0] = ((s[1] << 3) & 0xE0) | (s[0] >> 3);
}

void RGBA8888toARGB8888(uchar *d, uchar *s) {
	d[3] = s[0];
	d[2] = s[3];
	d[1] = s[2];
	d[0] = s[1];
}

void ARGB8888toARGB1555(uchar *d, uchar *s) {
	d[1] = (s[3] & 0x10) | ((s[2] >> 1) & 0x7C) | (s[1] >> 6);
	d[0] = ((s[1] << 2) & 0xE0) | (s[0] >> 3);
}

void ARGB8888toARGB4444(uchar *d, uchar *s) {
	d[1] = (s[3] & 0xF0) | (s[2] >> 4);
	d[0] = (s[1] & 0xF0) | (s[0] >> 4);
}

void ARGB8888toRGB332(uchar *d, uchar *s) {
	d[0] = (s[2] & 0xE0) | ((s[1] >> 3) & 0x1C) | (s[0] >> 6);
}

void ARGB8888toARGB8332(uchar *d, uchar *s) {
	d[1] = s[3];
	d[0] = (s[2] & 0xE0) | ((s[1] >> 3) & 0x1C) | (s[0] >> 6);
}

void ARGB1555toRGB565(uchar *d, uchar *s) {
	d[1] = s[1] >> 1;
	d[0] = (s[1] << 7) | ((s[0] >> 1) & 0x60) | (s[0] & 0x1F);
}


void RGB555toRGB565(uchar *d, uchar *s) {
	d[1] = (s[1] << 1) | (s[0] >> 7);
	d[0] = ((s[0] << 1) & 0xC0) | (s[0] & 0x1F);
}

void RGB565toRGB565(uchar *d, uchar *s) {
	d[1] = s[1];
	d[0] = s[0];
}

void RGB565toRGB555(uchar *d, uchar *s) {
	d[1] = s[1] >> 1;
	d[0] = (s[1] << 7) | ((s[0] >> 1) & 0x60) | (s[0] & 0x1F);
}

void RGB565toARGB1555(uchar *d, uchar *s) {
	d[1] = s[1] >> 1;
	d[0] = (s[1] << 7) | ((s[0] >> 1) & 0x60) | (s[0] & 0x1F);
}

void AI44toARGB4444(uchar *d, uchar *s) {
	d[1] = (s[1] & 0xF0) | (s[0] & 0x0F);
	d[0] = ((s[0] & 0x0F) << 4) | (s[0] & 0x0F);
}

void AI88toARGB8888(uchar *d, uchar *s) {
	d[3] = s[1];
	d[2] = s[0];
	d[1] = s[0];
	d[0] = s[0];
}

void RGB332toRGB565(uchar *d, uchar *s) {
	d[1] = (s[0] & 0xE0) | ((s[0] >> 2) & 0x07);
	d[0] = ((s[0] << 3) & 0x18);
}

void YIQ422toRGB565(uchar *d, uchar *s) {
//	((short *)d)[0] = yiq_lut[s[0]];
	d[1] = 1;
	d[0] = 1;
}
